/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import java.util.ArrayList;
import java.util.List;
import org.catacombae.io.BasicReadableRandomAccessStream;
import org.catacombae.io.ReadableRandomAccessStream;

public class ReadableConcatenatedStream
extends BasicReadableRandomAccessStream {
    final List<Part> parts = new ArrayList<Part>();
    Part currentPart;
    int currentPartIndex;

    public ReadableConcatenatedStream(ReadableRandomAccessStream firstPart, long startOffset, long length) {
        this.currentPart = new Part(firstPart, startOffset, length);
        this.parts.add(this.currentPart);
        this.currentPartIndex = 0;
    }

    public void addPart(ReadableRandomAccessStream newFile, long off, long len) {
        Part newPart = new Part(newFile, off, len);
        this.parts.add(newPart);
    }

    public void seek(long pos) {
        long curPos = 0L;
        for (Part p : this.parts) {
            if (curPos + p.length > pos) {
                this.currentPart = p;
                this.currentPart.file.seek(this.currentPart.startOffset + (pos - curPos));
                break;
            }
            curPos += p.length;
        }
    }

    public int read(byte[] data, int pos, int len) {
        int bytesLeftToRead;
        long bytesLeftInFile;
        int bytesToRead;
        int res;
        int bytesRead = 0;
        while ((res = this.currentPart.file.read(data, pos + bytesRead, bytesToRead = (int)((bytesLeftInFile = this.currentPart.length - (this.currentPart.file.getFilePointer() - this.currentPart.startOffset)) < (long)(bytesLeftToRead = len - bytesRead) ? bytesLeftInFile : (long)bytesLeftToRead))) > 0) {
            if ((bytesRead += res) < len) {
                ++this.currentPartIndex;
                this.currentPart = this.parts.get(this.currentPartIndex);
                this.currentPart.file.seek(this.currentPart.startOffset);
                continue;
            }
            if (bytesRead == len) {
                return bytesRead;
            }
            throw new RuntimeException("Read more than I was supposed to! This can't happen.");
        }
        throw new RuntimeException("Error while reading.");
    }

    public long length() {
        long result = 0L;
        for (Part p : this.parts) {
            result += p.length;
        }
        return result;
    }

    public long getFilePointer() {
        long fp = 0L;
        for (int i = 0; i < this.currentPartIndex; ++i) {
            fp += this.parts.get((int)i).length;
        }
        Part currentPartLocal = this.parts.get(this.currentPartIndex);
        return fp += currentPartLocal.file.getFilePointer() + currentPartLocal.startOffset;
    }

    public void close() {
        for (Part p : this.parts) {
            p.file.close();
        }
    }

    static class Part {
        public final ReadableRandomAccessStream file;
        public final long startOffset;
        public final long length;

        public Part(ReadableRandomAccessStream file, long startOffset, long length) {
            this.file = file;
            this.startOffset = startOffset;
            this.length = length;
        }
    }
}

