/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.P11Key;
import com.github.kwart.jsign.pkcs11.P11SecretKeyFactory;
import com.github.kwart.jsign.pkcs11.P11Util;
import com.github.kwart.jsign.pkcs11.Session;
import com.github.kwart.jsign.pkcs11.Token;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import sun.nio.ch.DirectBuffer;
import sun.security.jca.JCAUtil;
import sun.security.pkcs11.wrapper.CK_GCM_PARAMS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11AEADCipher
extends CipherSpi {
    private static final int MODE_GCM = 10;
    private static final int GCM_DEFAULT_TAG_LEN = 16;
    private static final int GCM_DEFAULT_IV_LEN = 16;
    private static final String ALGO = "AES";
    private final Token token;
    private final long mechanism;
    private final int blockMode;
    private final int fixedKeySize;
    private Session session = null;
    private P11Key p11Key = null;
    private boolean initialized = false;
    private boolean encrypt = true;
    private byte[] iv = null;
    private int tagLen = -1;
    private SecureRandom random = JCAUtil.getSecureRandom();
    private ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
    private ByteArrayOutputStream aadBuffer = new ByteArrayOutputStream();
    private boolean updateCalled = false;
    private boolean requireReinit = false;
    private P11Key lastEncKey = null;
    private byte[] lastEncIv = null;

    P11AEADCipher(Token token, String algorithm, long mechanism) throws PKCS11Exception, NoSuchAlgorithmException {
        this.token = token;
        this.mechanism = mechanism;
        String[] algoParts = algorithm.split("/");
        if (algoParts.length != 3) {
            throw new ProviderException("Unsupported Transformation format: " + algorithm);
        }
        if (!algoParts[0].startsWith(ALGO)) {
            throw new ProviderException("Only support AES for AEAD cipher mode");
        }
        int index = algoParts[0].indexOf(95);
        this.fixedKeySize = index != -1 ? Integer.parseInt(algoParts[0].substring(index + 1)) >> 3 : -1;
        this.blockMode = this.parseMode(algoParts[1]);
        if (!algoParts[2].equals("NoPadding")) {
            throw new ProviderException("Only NoPadding is supported for AEAD cipher mode");
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Unsupported mode " + mode);
    }

    private int parseMode(String mode) throws NoSuchAlgorithmException {
        if (!(mode = mode.toUpperCase(Locale.ENGLISH)).equals("GCM")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
        int result = 10;
        return result;
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Unsupported padding " + padding);
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.doFinalLength(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.encrypt && this.iv == null && this.tagLen == -1) {
            switch (this.blockMode) {
                case 10: {
                    this.iv = new byte[16];
                    this.tagLen = 16;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode");
                }
            }
            this.random.nextBytes(this.iv);
        }
        try {
            GCMParameterSpec spec;
            String apAlgo;
            switch (this.blockMode) {
                case 10: {
                    apAlgo = "GCM";
                    spec = new GCMParameterSpec(this.tagLen << 3, this.iv);
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode");
                }
            }
            AlgorithmParameters params = AlgorithmParameters.getInstance(apAlgo);
            params.init(spec);
            return params;
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException("Could not encode parameters", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom sr) throws InvalidKeyException {
        if (opmode == 2) {
            throw new InvalidKeyException("Parameters required for decryption");
        }
        this.updateCalled = false;
        try {
            this.implInit(opmode, key, null, -1, sr);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("init() failed", e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opmode == 2 && params == null) {
            throw new InvalidAlgorithmParameterException("Parameters required for decryption");
        }
        this.updateCalled = false;
        byte[] ivValue = null;
        int tagLen = -1;
        if (params != null) {
            switch (this.blockMode) {
                case 10: {
                    if (!(params instanceof GCMParameterSpec)) {
                        throw new InvalidAlgorithmParameterException("Only GCMParameterSpec is supported");
                    }
                    ivValue = ((GCMParameterSpec)params).getIV();
                    tagLen = ((GCMParameterSpec)params).getTLen() >> 3;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode");
                }
            }
        }
        this.implInit(opmode, key, ivValue, tagLen, sr);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opmode == 2 && params == null) {
            throw new InvalidAlgorithmParameterException("Parameters required for decryption");
        }
        this.updateCalled = false;
        try {
            GCMParameterSpec paramSpec = null;
            if (params != null) {
                switch (this.blockMode) {
                    case 10: {
                        paramSpec = params.getParameterSpec(GCMParameterSpec.class);
                        break;
                    }
                    default: {
                        throw new ProviderException("Unsupported mode");
                    }
                }
            }
            this.engineInit(opmode, key, paramSpec, sr);
        }
        catch (InvalidParameterSpecException ex) {
            throw new InvalidAlgorithmParameterException(ex);
        }
    }

    private void implInit(int opmode, Key key, byte[] iv, int tagLen, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.reset(true);
        if (this.fixedKeySize != -1 && (key instanceof P11Key ? ((P11Key)key).length() >> 3 : key.getEncoded().length) != this.fixedKeySize) {
            throw new InvalidKeyException("Key size is invalid");
        }
        P11Key newKey = P11SecretKeyFactory.convertKey(this.token, key, ALGO);
        switch (opmode) {
            case 1: {
                this.encrypt = true;
                boolean bl = this.requireReinit = Arrays.equals(iv, this.lastEncIv) && newKey == this.lastEncKey;
                if (!this.requireReinit) break;
                throw new InvalidAlgorithmParameterException("Cannot reuse iv for GCM encryption");
            }
            case 2: {
                this.encrypt = false;
                this.requireReinit = false;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported mode: " + opmode);
            }
        }
        if (sr != null) {
            this.random = sr;
        }
        if (iv == null && tagLen == -1) {
            switch (this.blockMode) {
                case 10: {
                    iv = new byte[16];
                    this.random.nextBytes(iv);
                    tagLen = 16;
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode");
                }
            }
        }
        this.iv = iv;
        this.tagLen = tagLen;
        this.p11Key = newKey;
        try {
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not initialize cipher", e);
        }
    }

    private void cancelOperation() {
        block5: {
            int bufLen = this.doFinalLength(0);
            byte[] buffer = new byte[bufLen];
            byte[] in = this.dataBuffer.toByteArray();
            int inLen = in.length;
            try {
                if (this.encrypt) {
                    this.token.p11.C_Encrypt(this.session.id(), 0L, in, 0, inLen, 0L, buffer, 0, bufLen);
                } else {
                    this.token.p11.C_Decrypt(this.session.id(), 0L, in, 0, inLen, 0L, buffer, 0, bufLen);
                }
            }
            catch (PKCS11Exception e) {
                if (e.getErrorCode() == 145L) {
                    return;
                }
                if (!this.encrypt) break block5;
                throw new ProviderException("Cancel failed", e);
            }
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (this.initialized && this.aadBuffer.size() > 0) {
            this.reset(true);
        }
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.p11Key == null) {
            throw new ProviderException("Operation cannot be performed without calling engineInit first");
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        this.token.ensureValid();
        byte[] aad = this.aadBuffer.size() > 0 ? this.aadBuffer.toByteArray() : null;
        long p11KeyID = this.p11Key.getKeyID();
        try {
            CK_MECHANISM mechWithParams;
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            switch (this.blockMode) {
                case 10: {
                    mechWithParams = new CK_MECHANISM(this.mechanism, new CK_GCM_PARAMS(this.tagLen << 3, this.iv, aad));
                    break;
                }
                default: {
                    throw new ProviderException("Unsupported mode: " + this.blockMode);
                }
            }
            if (this.encrypt) {
                this.token.p11.C_EncryptInit(this.session.id(), mechWithParams, p11KeyID);
            } else {
                this.token.p11.C_DecryptInit(this.session.id(), mechWithParams, p11KeyID);
            }
        }
        catch (PKCS11Exception e) {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            throw e;
        }
        finally {
            this.dataBuffer.reset();
            this.aadBuffer.reset();
        }
        this.initialized = true;
    }

    private int doFinalLength(int inLen) {
        if (inLen < 0) {
            throw new ProviderException("Invalid negative input length");
        }
        int result = inLen + this.dataBuffer.size();
        if (this.encrypt) {
            result += this.tagLen;
        }
        return result;
    }

    private void reset(boolean doCancel) {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        try {
            if (this.session == null) {
                return;
            }
            if (doCancel && this.token.explicitCancel) {
                this.cancelOperation();
            }
        }
        finally {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            this.dataBuffer.reset();
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        this.updateCalled = true;
        int n = this.implUpdate(in, inOfs, inLen);
        return new byte[0];
    }

    @Override
    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException {
        this.updateCalled = true;
        this.implUpdate(in, inOfs, inLen);
        return 0;
    }

    @Override
    protected int engineUpdate(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException {
        this.updateCalled = true;
        this.implUpdate(inBuffer);
        return 0;
    }

    @Override
    protected synchronized void engineUpdateAAD(byte[] src, int srcOfs, int srcLen) throws IllegalStateException {
        if (src == null || srcOfs < 0 || srcOfs + srcLen > src.length) {
            throw new IllegalArgumentException("Invalid AAD");
        }
        if (this.requireReinit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        if (this.p11Key == null) {
            throw new IllegalStateException("Need to initialize Cipher first");
        }
        if (this.updateCalled) {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
        this.aadBuffer.write(src, srcOfs, srcLen);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer src) throws IllegalStateException {
        if (src == null) {
            throw new IllegalArgumentException("Invalid AAD");
        }
        byte[] srcBytes = new byte[src.remaining()];
        src.get(srcBytes);
        this.engineUpdateAAD(srcBytes, 0, srcBytes.length);
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        int minOutLen = this.doFinalLength(inLen);
        try {
            byte[] out = new byte[minOutLen];
            int n = this.engineDoFinal(in, inOfs, inLen, out, 0);
            byte[] byArray = P11Util.convert(out, 0, n);
            return byArray;
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
        finally {
            this.updateCalled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        try {
            int n = this.implDoFinal(in, inOfs, inLen, out, outOfs, out.length - outOfs);
            return n;
        }
        finally {
            this.updateCalled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        try {
            int n = this.implDoFinal(inBuffer, outBuffer);
            return n;
        }
        finally {
            this.updateCalled = false;
        }
    }

    private int implUpdate(byte[] in, int inOfs, int inLen) {
        if (inLen > 0) {
            this.updateCalled = true;
            try {
                this.ensureInitialized();
            }
            catch (PKCS11Exception e) {
                this.reset(false);
                throw new ProviderException("update() failed", e);
            }
            this.dataBuffer.write(in, inOfs, inLen);
        }
        return 0;
    }

    private int implUpdate(ByteBuffer inBuf) {
        int inLen = inBuf.remaining();
        if (inLen > 0) {
            try {
                this.ensureInitialized();
            }
            catch (PKCS11Exception e) {
                this.reset(false);
                throw new ProviderException("update() failed", e);
            }
            byte[] data = new byte[inLen];
            inBuf.get(data);
            this.dataBuffer.write(data, 0, data.length);
        }
        return 0;
    }

    private int implDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int requiredOutLen = this.doFinalLength(inLen);
        if (outLen < requiredOutLen) {
            throw new ShortBufferException();
        }
        boolean doCancel = true;
        try {
            this.ensureInitialized();
            if (this.dataBuffer.size() > 0) {
                if (in != null && inOfs > 0 && inLen > 0 && inOfs < in.length - inLen) {
                    this.dataBuffer.write(in, inOfs, inLen);
                }
                in = this.dataBuffer.toByteArray();
                inOfs = 0;
                inLen = in.length;
            }
            int k = 0;
            if (this.encrypt) {
                k = this.token.p11.C_Encrypt(this.session.id(), 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
                doCancel = false;
            } else {
                if (inLen == 0) {
                    int n = 0;
                    return n;
                }
                k = this.token.p11.C_Decrypt(this.session.id(), 0L, in, inOfs, inLen, 0L, out, outOfs, outLen);
                doCancel = false;
            }
            int n = k;
            return n;
        }
        catch (PKCS11Exception e) {
            doCancel = false;
            this.handleException(e);
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            if (this.encrypt) {
                this.lastEncKey = this.p11Key;
                this.lastEncIv = this.iv;
                this.requireReinit = true;
            }
            this.reset(doCancel);
        }
    }

    private int implDoFinal(ByteBuffer inBuffer, ByteBuffer outBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int inLen;
        int requiredOutLen;
        int outLen = outBuffer.remaining();
        if (outLen < (requiredOutLen = this.doFinalLength(inLen = inBuffer.remaining()))) {
            throw new ShortBufferException();
        }
        boolean doCancel = true;
        try {
            this.ensureInitialized();
            long inAddr = 0L;
            byte[] in = null;
            int inOfs = 0;
            if (this.dataBuffer.size() > 0) {
                if (inLen > 0) {
                    byte[] temp = new byte[inLen];
                    inBuffer.get(temp);
                    this.dataBuffer.write(temp, 0, temp.length);
                }
                in = this.dataBuffer.toByteArray();
                inOfs = 0;
                inLen = in.length;
            } else if (inBuffer instanceof DirectBuffer) {
                inAddr = ((DirectBuffer)((Object)inBuffer)).address();
                inOfs = inBuffer.position();
            } else if (inBuffer.hasArray()) {
                in = inBuffer.array();
                inOfs = inBuffer.position() + inBuffer.arrayOffset();
            } else {
                in = new byte[inLen];
                inBuffer.get(in);
            }
            long outAddr = 0L;
            byte[] outArray = null;
            int outOfs = 0;
            if (outBuffer instanceof DirectBuffer) {
                outAddr = ((DirectBuffer)((Object)outBuffer)).address();
                outOfs = outBuffer.position();
            } else if (outBuffer.hasArray()) {
                outArray = outBuffer.array();
                outOfs = outBuffer.position() + outBuffer.arrayOffset();
            } else {
                outArray = new byte[outLen];
            }
            int k = 0;
            if (this.encrypt) {
                k = this.token.p11.C_Encrypt(this.session.id(), inAddr, in, inOfs, inLen, outAddr, outArray, outOfs, outLen);
                doCancel = false;
            } else {
                if (inLen == 0) {
                    int n = 0;
                    return n;
                }
                k = this.token.p11.C_Decrypt(this.session.id(), inAddr, in, inOfs, inLen, outAddr, outArray, outOfs, outLen);
                doCancel = false;
            }
            outBuffer.position(outBuffer.position() + k);
            int n = k;
            return n;
        }
        catch (PKCS11Exception e) {
            doCancel = false;
            this.handleException(e);
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            if (this.encrypt) {
                this.lastEncKey = this.p11Key;
                this.lastEncIv = this.iv;
                this.requireReinit = true;
            }
            this.reset(doCancel);
        }
    }

    private void handleException(PKCS11Exception e) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        long errorCode = e.getErrorCode();
        if (errorCode == 336L) {
            throw (ShortBufferException)new ShortBufferException().initCause(e);
        }
        if (errorCode == 33L || errorCode == 65L) {
            throw (IllegalBlockSizeException)new IllegalBlockSizeException(e.toString()).initCause(e);
        }
        if (errorCode == 64L) {
            throw (BadPaddingException)new BadPaddingException(e.toString()).initCause(e);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        throw new UnsupportedOperationException("engineWrap()");
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        throw new UnsupportedOperationException("engineUnwrap()");
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n = P11SecretKeyFactory.convertKey(this.token, key, ALGO).length();
        return n;
    }
}

