/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwart.jsign.pkcs11;

import com.github.kwart.jsign.pkcs11.P11Key;
import com.github.kwart.jsign.pkcs11.P11KeyFactory;
import com.github.kwart.jsign.pkcs11.P11Util;
import com.github.kwart.jsign.pkcs11.Session;
import com.github.kwart.jsign.pkcs11.Token;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11DHKeyFactory
extends P11KeyFactory {
    P11DHKeyFactory(Token token, String algorithm) {
        super(token, algorithm);
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException {
        try {
            if (key instanceof DHPublicKey) {
                DHPublicKey dhKey = (DHPublicKey)key;
                DHParameterSpec params = dhKey.getParams();
                return this.generatePublic(dhKey.getY(), params.getP(), params.getG());
            }
            if ("X.509".equals(key.getFormat())) {
                try {
                    KeyFactory factory = this.implGetSoftwareFactory();
                    key = (PublicKey)factory.translateKey(key);
                    return this.implTranslatePublicKey(key);
                }
                catch (GeneralSecurityException e) {
                    throw new InvalidKeyException("Could not translate key", e);
                }
            }
            throw new InvalidKeyException("PublicKey must be instance of DHPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create DH public key", e);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        try {
            if (key instanceof DHPrivateKey) {
                DHPrivateKey dhKey = (DHPrivateKey)key;
                DHParameterSpec params = dhKey.getParams();
                return this.generatePrivate(dhKey.getX(), params.getP(), params.getG());
            }
            if ("PKCS#8".equals(key.getFormat())) {
                try {
                    KeyFactory factory = this.implGetSoftwareFactory();
                    key = (PrivateKey)factory.translateKey(key);
                    return this.implTranslatePrivateKey(key);
                }
                catch (GeneralSecurityException e) {
                    throw new InvalidKeyException("Could not translate key", e);
                }
            }
            throw new InvalidKeyException("PrivateKey must be instance of DHPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create DH private key", e);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                KeyFactory factory = this.implGetSoftwareFactory();
                PublicKey key = factory.generatePublic(keySpec);
                return this.implTranslatePublicKey(key);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not create DH public key", e);
            }
        }
        if (!(keySpec instanceof DHPublicKeySpec)) {
            throw new InvalidKeySpecException("Only DHPublicKeySpec and X509EncodedKeySpec supported for DH public keys");
        }
        try {
            DHPublicKeySpec ds = (DHPublicKeySpec)keySpec;
            return this.generatePublic(ds.getY(), ds.getP(), ds.getG());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create DH public key", e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                KeyFactory factory = this.implGetSoftwareFactory();
                PrivateKey key = factory.generatePrivate(keySpec);
                return this.implTranslatePrivateKey(key);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not create DH private key", e);
            }
        }
        if (!(keySpec instanceof DHPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only DHPrivateKeySpec and PKCS8EncodedKeySpec supported for DH private keys");
        }
        try {
            DHPrivateKeySpec ds = (DHPrivateKeySpec)keySpec;
            return this.generatePrivate(ds.getX(), ds.getP(), ds.getG());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create DH private key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(BigInteger y, BigInteger p, BigInteger g) throws PKCS11Exception {
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 2L), new CK_ATTRIBUTE(17L, y), new CK_ATTRIBUTE(304L, p), new CK_ATTRIBUTE(306L, g)};
        attributes = this.token.getAttributes("import", 2L, 2L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PublicKey publicKey = P11Key.publicKey(session, keyID, "DH", p.bitLength(), attributes);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger x, BigInteger p, BigInteger g) throws PKCS11Exception {
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 2L), new CK_ATTRIBUTE(17L, x), new CK_ATTRIBUTE(304L, p), new CK_ATTRIBUTE(306L, g)};
        attributes = this.token.getAttributes("import", 3L, 2L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PrivateKey privateKey = P11Key.privateKey(session, keyID, "DH", p.bitLength(), attributes);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends KeySpec> T implGetPublicKeySpec(P11Key key, Class<T> keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (DHPublicKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(306L)};
            long keyID = key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(session[0].id(), keyID, attributes);
            }
            finally {
                key.releaseKeyID();
            }
            DHPublicKeySpec spec = new DHPublicKeySpec(attributes[0].getBigInteger(), attributes[1].getBigInteger(), attributes[2].getBigInteger());
            return (T)((KeySpec)keySpec.cast(spec));
        }
        throw new InvalidKeySpecException("Only DHPublicKeySpec and X509EncodedKeySpec supported for DH public keys");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends KeySpec> T implGetPrivateKeySpec(P11Key key, Class<T> keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (DHPrivateKeySpec.class.isAssignableFrom(keySpec)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(306L)};
            long keyID = key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(session[0].id(), keyID, attributes);
            }
            finally {
                key.releaseKeyID();
            }
            DHPrivateKeySpec spec = new DHPrivateKeySpec(attributes[0].getBigInteger(), attributes[1].getBigInteger(), attributes[2].getBigInteger());
            return (T)((KeySpec)keySpec.cast(spec));
        }
        throw new InvalidKeySpecException("Only DHPrivateKeySpec and PKCS8EncodedKeySpec supported for DH private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return KeyFactory.getInstance("DH", P11Util.getSunJceProvider());
    }
}

