/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.PixelFactory;
import com.idrsolutions.pdf.color.shading.ShadingFactory;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;

public class RadialContext
implements PaintContext {
    GenericColorSpace shadingColorSpace;
    private float scaling = 1.0f;
    private final boolean[] isExtended;
    private final float x0;
    private final float x1;
    private final float y0;
    private final float y1;
    private final float r0;
    private final float r1;
    private final float t0;
    private float t1 = 1.0f;
    private final PDFFunction[] function;
    private float[] cx;
    private float[] cy;
    private float[] cr;
    private float[] crSquared;
    private Color[] circleColor;
    private int xstart;
    private int ystart;
    private int circleCount;
    private int lastMaxSize = -1;
    private final int pageHeight;
    private final int minX;
    private final float[] background;
    private final boolean colorsReversed;
    private final boolean isPrinting;
    private final int offX;
    private final int offY;
    float pdfX;
    float pdfY;

    public RadialContext(boolean isPrinting, int offX, int offY, int minX, int pHeight, float scaling, boolean[] isExtended, float[] domain, float[] coords, GenericColorSpace shadingColorSpace, boolean colorsReversed, float[] background, PDFFunction[] function) {
        this.offX = offX;
        this.offY = offY;
        this.isPrinting = isPrinting;
        this.pageHeight = pHeight;
        this.isExtended = isExtended;
        this.t0 = domain[0];
        this.t1 = domain[1];
        this.minX = minX;
        this.background = background;
        this.colorsReversed = colorsReversed;
        this.x0 = coords[0];
        this.x1 = coords[3];
        this.r0 = coords[2];
        this.y0 = coords[1];
        this.y1 = coords[4];
        this.r1 = coords[5];
        this.shadingColorSpace = shadingColorSpace;
        this.function = function;
        this.scaling = scaling;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xstart, int ystart, int w, int h) {
        int x;
        int y;
        int val;
        this.xstart = xstart;
        this.ystart = ystart;
        double dist0 = Math.sqrt((this.x0 - (float)xstart) * (this.x0 - (float)xstart) + (this.y0 - (float)ystart) * (this.y0 - (float)ystart));
        double temp = Math.sqrt((this.x0 - (float)(xstart + w)) * (this.x0 - (float)(xstart + w)) + (this.y0 - (float)ystart) * (this.y0 - (float)ystart));
        if (temp > dist0) {
            dist0 = temp;
        }
        if ((temp = Math.sqrt((this.x0 - (float)xstart) * (this.x0 - (float)xstart) + (this.y0 - (float)(ystart + h)) * (this.y0 - (float)(ystart + h)))) > dist0) {
            dist0 = temp;
        }
        if ((temp = Math.sqrt((this.x0 - (float)(xstart + w)) * (this.x0 - (float)(xstart + w)) + (this.y0 - (float)(ystart + h)) * (this.y0 - (float)(ystart + h)))) > dist0) {
            dist0 = temp;
        }
        double dist1 = Math.sqrt((this.x1 - (float)xstart) * (this.x1 - (float)xstart) + (this.y1 - (float)ystart) * (this.y1 - (float)ystart));
        temp = Math.sqrt((this.x1 - (float)(xstart + w)) * (this.x1 - (float)(xstart + w)) + (this.y1 - (float)ystart) * (this.y1 - (float)ystart));
        if (temp > dist1) {
            dist1 = temp;
        }
        if ((temp = Math.sqrt((this.x1 - (float)xstart) * (this.x1 - (float)xstart) + (this.y1 - (float)(ystart + h)) * (this.y1 - (float)(ystart + h)))) > dist1) {
            dist1 = temp;
        }
        if ((temp = Math.sqrt((this.x1 - (float)(xstart + w)) * (this.x1 - (float)(xstart + w)) + (this.y1 - (float)(ystart + h)) * (this.y1 - (float)(ystart + h)))) > dist1) {
            dist1 = temp;
        }
        if (dist1 > (double)(val = (int)dist0)) {
            val = (int)dist1;
        }
        this.initialiseCircles(val += 20);
        int[] data = new int[w * h * 4];
        if (this.background != null) {
            for (y = 0; y < h; ++y) {
                for (x = 0; x < w; ++x) {
                    this.shadingColorSpace.setColor(this.background, this.shadingColorSpace.getColorComponentCount());
                    Color c = (Color)((Object)this.shadingColorSpace.getColor());
                    int base = (y * w + x) * 4;
                    data[base] = c.getRed();
                    data[base + 1] = c.getGreen();
                    data[base + 2] = c.getBlue();
                    data[base + 3] = 255;
                }
            }
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                int i = this.calculateColor(x, y);
                if (i < 0) continue;
                this.setColor(w, data, y, x, i);
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    private void setColor(int w, int[] data, int y, int x, int i) {
        Color c = this.circleColor[i];
        int cr = c.getRed();
        int cg = c.getGreen();
        int cb = c.getBlue();
        int base = (y * w + x) * 4;
        data[base] = cr;
        data[base + 1] = cg;
        data[base + 2] = cb;
        data[base + 3] = 255;
    }

    private int calculateColor(float x, float y) {
        int j;
        block5: {
            float rSquared;
            int i;
            block6: {
                if (this.isPrinting) {
                    this.pdfX = this.scaling * (x + (float)this.xstart + (float)this.minX);
                    this.pdfY = this.scaling * ((float)this.pageHeight - (y + (float)this.ystart));
                } else {
                    this.pdfX = this.scaling * (x + (float)this.xstart + (float)this.minX);
                    this.pdfY = this.scaling * ((float)this.pageHeight - (y + (float)this.ystart));
                }
                float[] xy = PixelFactory.convertPhysicalToPDF(this.isPrinting, x, y, this.offX, this.offY, this.scaling, this.xstart, this.ystart, this.minX, this.pageHeight);
                this.pdfX = xy[0];
                this.pdfY = xy[1];
                j = -1;
                for (i = this.circleCount; i > 0; --i) {
                    rSquared = (this.pdfX - this.cx[i]) * (this.pdfX - this.cx[i]) + (this.pdfY - this.cy[i]) * (this.pdfY - this.cy[i]);
                    if (!(rSquared <= this.crSquared[i] && rSquared >= this.crSquared[i - 1]) && (!(rSquared >= this.crSquared[i]) || !(rSquared <= this.crSquared[i - 1]))) continue;
                    j = i;
                    break;
                }
                if (!(this.cr[0] < this.cr[1])) break block6;
                if (j != -1) break block5;
                for (i = 0; i < this.circleCount; ++i) {
                    rSquared = (this.pdfX - this.cx[i]) * (this.pdfX - this.cx[i]) + (this.pdfY - this.cy[i]) * (this.pdfY - this.cy[i]);
                    float nextRSquared = (this.pdfX - this.cx[i + 1]) * (this.pdfX - this.cx[i + 1]) + (this.pdfY - this.cy[i + 1]) * (this.pdfY - this.cy[i + 1]);
                    if (!(rSquared > this.crSquared[i]) || !(nextRSquared < this.crSquared[i + 1])) continue;
                    j = i;
                    break block5;
                }
                break block5;
            }
            for (i = this.circleCount; i > 0; --i) {
                rSquared = (this.pdfX - this.cx[i]) * (this.pdfX - this.cx[i]) + (this.pdfY - this.cy[i]) * (this.pdfY - this.cy[i]);
                float nextRSquared = (this.pdfX - this.cx[i - 1]) * (this.pdfX - this.cx[i - 1]) + (this.pdfY - this.cy[i - 1]) * (this.pdfY - this.cy[i - 1]);
                if (!(rSquared > this.crSquared[i]) || !(nextRSquared < this.crSquared[i - 1])) continue;
                j = i;
                break;
            }
        }
        return j;
    }

    private void initialiseCircles(int maxSize) {
        int count;
        Color[] ecircleColor;
        float[] erSquared;
        float[] er;
        float[] ey;
        float[] ex;
        float s;
        float t;
        if (maxSize < this.lastMaxSize && this.lastMaxSize > 0) {
            return;
        }
        this.lastMaxSize = maxSize;
        this.circleCount = 100;
        if (maxSize < 100) {
            this.circleCount = maxSize;
        }
        ++this.circleCount;
        this.cx = new float[this.circleCount];
        this.cy = new float[this.circleCount];
        this.cr = new float[this.circleCount];
        this.crSquared = new float[this.circleCount];
        this.circleColor = new Color[this.circleCount];
        --this.circleCount;
        float td = this.t1 - this.t0;
        float xd = this.x1 - this.x0;
        float yd = this.y1 - this.y0;
        float rd = this.r1 - this.r0;
        int i = 0;
        while (true) {
            t = (this.t1 - this.t0) * (float)i / (float)this.circleCount;
            s = (t - this.t0) / td;
            this.cx[i] = this.x0 + s * xd;
            this.cy[i] = this.y0 + s * yd;
            this.cr[i] = this.r0 + s * rd;
            this.crSquared[i] = this.cr[i] * this.cr[i];
            this.circleColor[i] = this.colorsReversed ? this.calculateColor(1.0f - t) : this.calculateColor(t);
            if (i == this.circleCount) break;
            ++i;
        }
        if (this.isExtended[0]) {
            i = 0;
            t = (this.t1 - this.t0) * (float)i / (float)this.circleCount;
            s = (t - this.t0) / td;
            if (this.cr[0] < this.cr[1]) {
                while (this.r0 + s * rd > 0.0f) {
                    t = (this.t1 - this.t0) * (float)(-i) / (float)this.circleCount;
                    s = (t - this.t0) / td;
                    ++i;
                }
            } else {
                while (this.r0 + s * rd < (float)maxSize) {
                    t = (this.t1 - this.t0) * (float)(-i) / (float)this.circleCount;
                    s = (t - this.t0) / td;
                    ++i;
                }
            }
            if (i != 0) {
                ex = new float[i];
                ey = new float[i];
                er = new float[i];
                erSquared = new float[i];
                ecircleColor = new Color[i];
                --i;
                count = 0;
                while (i >= 0) {
                    t = (this.t1 - this.t0) * (float)(-i) / (float)this.circleCount;
                    s = (t - this.t0) / td;
                    ex[count] = this.x0 + s * xd;
                    ey[count] = this.y0 + s * yd;
                    er[count] = this.r0 + s * rd;
                    erSquared[count] = er[count] * er[count];
                    ecircleColor[count] = this.circleColor[0];
                    ++count;
                    --i;
                }
                this.cx = RadialContext.concat(ex, this.cx);
                this.cy = RadialContext.concat(ey, this.cy);
                this.cr = RadialContext.concat(er, this.cr);
                this.crSquared = RadialContext.concat(erSquared, this.crSquared);
                this.circleColor = RadialContext.concat(ecircleColor, this.circleColor);
                this.circleCount = this.cx.length - 1;
            }
        }
        if (this.isExtended[1]) {
            i = this.circleCount + 1;
            if (this.cr[0] > this.cr[1]) {
                while (this.r0 + s * rd > 0.0f) {
                    t = (this.t1 - this.t0) * (float)i / (float)this.circleCount;
                    s = (t - this.t0) / td;
                    ++i;
                }
            } else {
                while (this.r0 + s * rd < (float)maxSize) {
                    t = (this.t1 - this.t0) * (float)i / (float)this.circleCount;
                    s = (t - this.t0) / td;
                    ++i;
                }
            }
            ex = new float[i - (this.circleCount + 1)];
            ey = new float[i - (this.circleCount + 1)];
            er = new float[i - (this.circleCount + 1)];
            erSquared = new float[i - (this.circleCount + 1)];
            ecircleColor = new Color[i - (this.circleCount + 1)];
            count = --i - (this.circleCount + 1);
            while (i > this.circleCount) {
                t = (this.t1 - this.t0) * (float)i / (float)this.circleCount;
                s = (t - this.t0) / td;
                ex[count] = this.x0 + s * xd;
                ey[count] = this.y0 + s * yd;
                er[count] = this.r0 + s * rd;
                erSquared[count] = er[count] * er[count];
                ecircleColor[count] = this.circleColor[this.circleCount];
                --count;
                --i;
            }
            this.cx = RadialContext.concat(this.cx, ex);
            this.cy = RadialContext.concat(this.cy, ey);
            this.cr = RadialContext.concat(this.cr, er);
            this.crSquared = RadialContext.concat(this.crSquared, erSquared);
            this.circleColor = RadialContext.concat(this.circleColor, ecircleColor);
            this.circleCount = this.cx.length - 1;
        }
    }

    private Color calculateColor(float val) {
        float[] colValues = ShadingFactory.applyFunctions(this.function, new float[]{val});
        this.shadingColorSpace.setColor(colValues, colValues.length);
        return (Color)((Object)this.shadingColorSpace.getColor());
    }

    private static float[] concat(float[] A, float[] B) {
        float[] C = new float[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }

    private static Color[] concat(Color[] A, Color[] B) {
        Color[] C = new Color[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }
}

