/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.CoonsPatch;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jpedal.color.GenericColorSpace;

public class TensorPatch
extends CoonsPatch {
    private final double[][] px = new double[4][4];
    private final double[][] py = new double[4][4];

    public TensorPatch(int colorCompCount, GenericColorSpace shadingColorSpace) {
        super(colorCompCount, shadingColorSpace);
    }

    @Override
    public void addPoint(double x, double y) {
        switch (this.pointsAdded) {
            case 0: {
                this.px[0][3] = x;
                this.py[0][3] = y;
                break;
            }
            case 1: {
                this.px[0][2] = x;
                this.py[0][2] = y;
                break;
            }
            case 2: {
                this.px[0][1] = x;
                this.py[0][1] = y;
                break;
            }
            case 3: {
                this.px[0][0] = x;
                this.py[0][0] = y;
                break;
            }
            case 4: {
                this.px[1][0] = x;
                this.py[1][0] = y;
                break;
            }
            case 5: {
                this.px[2][0] = x;
                this.py[2][0] = y;
                break;
            }
            case 6: {
                this.px[3][0] = x;
                this.py[3][0] = y;
                break;
            }
            case 7: {
                this.px[3][1] = x;
                this.py[3][1] = y;
                break;
            }
            case 8: {
                this.px[3][2] = x;
                this.py[3][2] = y;
                break;
            }
            case 9: {
                this.px[3][3] = x;
                this.py[3][3] = y;
                break;
            }
            case 10: {
                this.px[2][3] = x;
                this.py[2][3] = y;
                break;
            }
            case 11: {
                this.px[1][3] = x;
                this.py[1][3] = y;
                break;
            }
            case 12: {
                this.px[1][2] = x;
                this.py[1][2] = y;
                break;
            }
            case 13: {
                this.px[1][1] = x;
                this.py[1][1] = y;
                break;
            }
            case 14: {
                this.px[2][1] = x;
                this.py[2][1] = y;
                break;
            }
            case 15: {
                this.px[2][2] = x;
                this.py[2][2] = y;
            }
        }
        ++this.pointsAdded;
    }

    public static double BernsteinPolynomials(int axisPt, double t) {
        switch (axisPt) {
            case 0: {
                return Math.pow(1.0 - t, 3.0);
            }
            case 1: {
                return 3.0 * t * Math.pow(1.0 - t, 2.0);
            }
            case 2: {
                return Math.pow(3.0 * t, 2.0) * (1.0 - t);
            }
            case 3: {
                return Math.pow(t, 3.0);
            }
        }
        return t;
    }

    private double[] mapping(double u, double v) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                x += this.px[i][j] * TensorPatch.BernsteinPolynomials(i, u) * TensorPatch.BernsteinPolynomials(3 - j, v);
                y += this.py[i][j] * TensorPatch.BernsteinPolynomials(i, u) * TensorPatch.BernsteinPolynomials(3 - j, v);
            }
        }
        return new double[]{x, y};
    }

    private void initialiseShape() {
        this.patchShape = new GeneralPath();
        this.patchShape.moveTo((float)this.px[0][0], (float)this.py[0][0]);
        this.patchShape.curveTo((float)this.px[1][0], (float)this.py[1][0], (float)this.px[2][0], (float)this.py[2][0], (float)this.px[3][0], (float)this.py[3][0]);
        this.patchShape.curveTo((float)this.px[3][1], (float)this.py[3][1], (float)this.px[3][2], (float)this.py[3][2], (float)this.px[3][3], (float)this.py[3][3]);
        this.patchShape.curveTo((float)this.px[2][3], (float)this.py[2][3], (float)this.px[1][3], (float)this.py[1][3], (float)this.px[0][3], (float)this.py[0][3]);
        this.patchShape.curveTo((float)this.px[0][2], (float)this.py[0][2], (float)this.px[0][1], (float)this.py[0][1], (float)this.px[0][0], (float)this.py[0][0]);
    }

    @Override
    public void calculate() {
        int res;
        if (this.patchShape == null) {
            this.initialiseShape();
        }
        if ((res = (int)(30.0 * (this.patchShape.getBounds2D().getWidth() + this.patchShape.getBounds2D().getHeight()))) < 4) {
            res = 4;
        }
        if (res > 40) {
            res = 40;
        }
        double div = 1.0 / (double)res;
        this.checkCellBounds = res > 7;
        this.calculationPoints = new double[res + 1][res + 1][2];
        for (int x = 0; x < res + 1; ++x) {
            for (int y = 0; y < res + 1; ++y) {
                double[] m = this.mapping((double)x * div, (double)y * div);
                this.calculationPoints[x][y] = m;
            }
        }
        for (int i = 0; i < res; ++i) {
            for (int j = 0; j < res; ++j) {
                CoonsPatch.ColorShape shape = new CoonsPatch.ColorShape(this, i, j, this.calculateColor((double)i * div, (double)j * div));
                this.shapes.add(shape);
            }
        }
    }

    @Override
    public Rectangle2D getBounds2D() {
        if (this.patchShape == null) {
            this.initialiseShape();
        }
        return this.patchShape.getBounds2D();
    }
}

