/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.buffer.remaining();
        if (n3 == 0) {
            return -1;
        }
        if (n3 < n2) {
            this.buffer.get(byArray, n, n3);
            return n3;
        }
        this.buffer.get(byArray, n, n2);
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        int n = this.buffer.remaining();
        if (l < (long)n) {
            this.buffer.position(this.buffer.position() + n);
            return n;
        }
        this.buffer.position((int)((long)this.buffer.position() + l));
        return l;
    }

    @Override
    public int read() throws IOException {
        return this.buffer.get();
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public void mark(int n) {
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.reset();
    }
}

