/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.NameTree;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import java.io.IOException;

public class PDFDestination {
    public static final int XYZ = 0;
    public static final int FIT = 1;
    public static final int FITH = 2;
    public static final int FITV = 3;
    public static final int FITR = 4;
    public static final int FITB = 5;
    public static final int FITBH = 6;
    public static final int FITBV = 7;
    private int type;
    private PDFObject pageObj;
    private float left;
    private float right;
    private float top;
    private float bottom;
    private float zoom;

    protected PDFDestination(PDFObject pDFObject, int n) {
        this.pageObj = pDFObject;
        this.type = n;
    }

    public static PDFDestination getDestination(PDFObject pDFObject, PDFObject pDFObject2) throws IOException {
        if (pDFObject.getType() == 4) {
            pDFObject = PDFDestination.getDestFromName(pDFObject, pDFObject2);
        } else if (pDFObject.getType() == 3) {
            pDFObject = PDFDestination.getDestFromString(pDFObject, pDFObject2);
        }
        if (pDFObject == null || pDFObject.getType() != 5) {
            throw new PDFParseException("Can't create destination from: " + pDFObject);
        }
        PDFObject[] pDFObjectArray = pDFObject.getArray();
        PDFDestination pDFDestination = null;
        String string = pDFObjectArray[1].getStringValue();
        if (string.equals("XYZ")) {
            pDFDestination = new PDFDestination(pDFObjectArray[0], 0);
        } else if (string.equals("Fit")) {
            pDFDestination = new PDFDestination(pDFObjectArray[0], 1);
        } else if (string.equals("FitH")) {
            pDFDestination = new PDFDestination(pDFObjectArray[0], 2);
        } else if (string.equals("FitV")) {
            pDFDestination = new PDFDestination(pDFObjectArray[0], 3);
        } else if (string.equals("FitR")) {
            pDFDestination = new PDFDestination(pDFObjectArray[0], 4);
        } else if (string.equals("FitB")) {
            pDFDestination = new PDFDestination(pDFObjectArray[0], 5);
        } else if (string.equals("FitBH")) {
            pDFDestination = new PDFDestination(pDFObjectArray[0], 6);
        } else if (string.equals("FitBV")) {
            pDFDestination = new PDFDestination(pDFObjectArray[0], 7);
        } else {
            throw new PDFParseException("Unknown destination type: " + string);
        }
        switch (pDFDestination.getType()) {
            case 0: {
                pDFDestination.setLeft(pDFObjectArray[2].getFloatValue());
                pDFDestination.setTop(pDFObjectArray[3].getFloatValue());
                pDFDestination.setZoom(pDFObjectArray[4].getFloatValue());
                break;
            }
            case 2: {
                pDFDestination.setTop(pDFObjectArray[2].getFloatValue());
                break;
            }
            case 3: {
                pDFDestination.setLeft(pDFObjectArray[2].getFloatValue());
                break;
            }
            case 4: {
                pDFDestination.setLeft(pDFObjectArray[2].getFloatValue());
                pDFDestination.setBottom(pDFObjectArray[3].getFloatValue());
                pDFDestination.setRight(pDFObjectArray[4].getFloatValue());
                pDFDestination.setTop(pDFObjectArray[5].getFloatValue());
                break;
            }
            case 6: {
                pDFDestination.setTop(pDFObjectArray[2].getFloatValue());
                break;
            }
            case 7: {
                pDFDestination.setLeft(pDFObjectArray[2].getFloatValue());
            }
        }
        return pDFDestination;
    }

    public int getType() {
        return this.type;
    }

    public PDFObject getPage() {
        return this.pageObj;
    }

    public float getLeft() {
        return this.left;
    }

    public void setLeft(float f) {
        this.left = f;
    }

    public float getRight() {
        return this.right;
    }

    public void setRight(float f) {
        this.right = f;
    }

    public float getTop() {
        return this.top;
    }

    public void setTop(float f) {
        this.top = f;
    }

    public float getBottom() {
        return this.bottom;
    }

    public void setBottom(float f) {
        this.bottom = f;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float f) {
        this.zoom = f;
    }

    private static PDFObject getDestFromName(PDFObject pDFObject, PDFObject pDFObject2) throws IOException {
        PDFObject pDFObject3 = pDFObject2.getDictRef("Dests");
        if (pDFObject3 != null) {
            return pDFObject3.getDictRef(pDFObject.getStringValue());
        }
        return null;
    }

    private static PDFObject getDestFromString(PDFObject pDFObject, PDFObject pDFObject2) throws IOException {
        PDFObject pDFObject3;
        PDFObject pDFObject4 = pDFObject2.getDictRef("Names");
        if (pDFObject4 != null && (pDFObject3 = pDFObject4.getDictRef("Dests")) != null) {
            NameTree nameTree = new NameTree(pDFObject3);
            PDFObject pDFObject5 = nameTree.find(pDFObject.getStringValue());
            if (pDFObject5 != null && pDFObject5.getType() == 6) {
                pDFObject5 = pDFObject5.getDictRef("D");
            }
            return pDFObject5;
        }
        return null;
    }
}

