/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Cache;
import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.PDFXref;
import com.sun.pdfview.PDFXrefEntry;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import com.sun.pdfview.decode.PDFDecoder;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByPlatformException;
import com.sun.pdfview.decrypt.EncryptionUnsupportedByProductException;
import com.sun.pdfview.decrypt.IdentityDecrypter;
import com.sun.pdfview.decrypt.PDFAuthenticationFailureException;
import com.sun.pdfview.decrypt.PDFDecrypter;
import com.sun.pdfview.decrypt.PDFDecrypterFactory;
import com.sun.pdfview.decrypt.PDFPassword;
import com.sun.pdfview.decrypt.UnsupportedEncryptionException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class PDFFile {
    public static final int NUL_CHAR = 0;
    public static final int FF_CHAR = 12;
    private String versionString = "1.1";
    private int majorVersion = 1;
    private int minorVersion = 1;
    private static final String VERSION_COMMENT = "%PDF-";
    ByteBuffer fileBuf;
    PDFXrefEntry[] xrefEntries;
    PDFObject root = null;
    PDFObject encrypt = null;
    PDFObject info = null;
    Cache cache;
    private boolean printable = true;
    private boolean saveable = true;
    private PDFDecrypter defaultDecrypter = IdentityDecrypter.getInstance();
    private PDFObject fileIdentifier = null;

    public PDFFile(ByteBuffer byteBuffer) throws IOException {
        this(byteBuffer, null);
    }

    public PDFFile(ByteBuffer byteBuffer, PDFPassword pDFPassword) throws IOException {
        this.fileBuf = byteBuffer;
        this.cache = new Cache();
        this.parseFile(pDFPassword);
    }

    public boolean isPrintable() {
        return this.printable;
    }

    public boolean isSaveable() {
        return this.saveable;
    }

    public PDFObject getRoot() {
        return this.root;
    }

    public int getNumPages() {
        try {
            return this.root.getDictRef("Pages").getDictRef("Count").getIntValue();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getStringMetadata(String string) throws IOException {
        if (this.info != null) {
            PDFObject pDFObject = this.info.getDictRef(string);
            return pDFObject != null ? pDFObject.getTextStringValue() : null;
        }
        return null;
    }

    public Iterator<String> getMetadataKeys() throws IOException {
        if (this.info != null) {
            return this.info.getDictKeys();
        }
        return Collections.emptyList().iterator();
    }

    public synchronized PDFObject dereference(PDFXref pDFXref, PDFDecrypter pDFDecrypter) throws IOException {
        int n = pDFXref.getObjectNumber();
        if (n >= this.xrefEntries.length || n < 0) {
            return PDFObject.nullObj;
        }
        PDFXrefEntry pDFXrefEntry = this.xrefEntries[n];
        if (pDFXrefEntry == null || !pDFXrefEntry.resolves(pDFXref)) {
            return PDFObject.nullObj;
        }
        PDFObject pDFObject = pDFXrefEntry.getObject();
        if (pDFObject != null) {
            return pDFObject;
        }
        switch (pDFXrefEntry.getType()) {
            case OBJ_IN_BODY: {
                int n2 = pDFXrefEntry.getOffset();
                if (n2 < 0) {
                    return PDFObject.nullObj;
                }
                int n3 = this.fileBuf.position();
                this.fileBuf.position(n2);
                pDFObject = this.readObject(this.fileBuf, pDFXref.getObjectNumber(), pDFXref.getGeneration(), pDFDecrypter);
                if (pDFObject == null) {
                    pDFObject = PDFObject.nullObj;
                }
                pDFXrefEntry.setObject(pDFObject);
                this.fileBuf.position(n3);
                return pDFObject;
            }
            case OBJ_IN_STREAM: {
                PDFObject pDFObject2 = this.dereference(pDFXrefEntry.getStream(), this.getDefaultDecrypter());
                if (pDFObject2 == null || pDFObject2.getType() != 7 || !"ObjStm".equals(pDFObject2.getDictRef("Type").getStringValue())) {
                    throw new PDFParseException(pDFXrefEntry.getStream().getObjectNumber() + " is not an object stream, but was referenced in " + "the xref stream as one");
                }
                ByteBuffer byteBuffer = pDFObject2.getStreamBuffer();
                PDFXrefEntry pDFXrefEntry2 = this.xrefEntries[pDFXrefEntry.getStream().getObjectNumber()];
                int[] nArray = pDFXrefEntry2.getObjectIndexOffsets();
                if (nArray == null) {
                    nArray = new int[pDFObject2.getDictionary().get("N").getIntValue()];
                    int n4 = pDFObject2.getDictionary().get("First").getIntValue();
                    for (int i = 0; i < nArray.length; ++i) {
                        PDFObject pDFObject3 = this.readObject(byteBuffer, -1, -1, IdentityDecrypter.getInstance());
                        nArray[i] = n4 + this.readObject(byteBuffer, -1, -1, IdentityDecrypter.getInstance()).getIntValue();
                    }
                    pDFXrefEntry2.setObjectIndexOffsets(nArray);
                }
                if (pDFXrefEntry.getOffset() < 0 || pDFXrefEntry.getOffset() >= nArray.length) {
                    throw new PDFParseException("Xref references index that does not exist in stream");
                }
                byteBuffer.position(nArray[pDFXrefEntry.getOffset()]);
                pDFObject = this.readObject(byteBuffer, pDFXref.getObjectNumber(), pDFXref.getGeneration(), PDFDecoder.isEncrypted(pDFObject2) ? IdentityDecrypter.getInstance() : this.getDefaultDecrypter());
                if (pDFObject == null) {
                    pDFObject = PDFObject.nullObj;
                }
                pDFXrefEntry.setObject(pDFObject);
                return pDFObject;
            }
            case FREE: {
                return PDFObject.nullObj;
            }
        }
        throw new UnsupportedOperationException("Don't know how to handle xref type " + (Object)((Object)pDFXrefEntry.getType()));
    }

    public static boolean isWhiteSpace(int n) {
        switch (n) {
            case 0: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDelimiter(int n) {
        switch (n) {
            case 37: 
            case 40: 
            case 41: 
            case 47: 
            case 60: 
            case 62: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRegularCharacter(int n) {
        return !PDFFile.isWhiteSpace(n) && !PDFFile.isDelimiter(n);
    }

    private PDFObject readObject(ByteBuffer byteBuffer, int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        return this.readObject(byteBuffer, n, n2, false, pDFDecrypter);
    }

    private PDFObject readObject(ByteBuffer byteBuffer, int n, int n2, boolean bl, PDFDecrypter pDFDecrypter) throws IOException {
        PDFObject pDFObject = null;
        while (pDFObject == null) {
            int n3 = this.nextNonWhitespaceChar(byteBuffer);
            if (n3 == 60) {
                n3 = byteBuffer.get();
                if (n3 == 60) {
                    pDFObject = this.readDictionary(byteBuffer, n, n2, pDFDecrypter);
                    continue;
                }
                byteBuffer.position(byteBuffer.position() - 1);
                pDFObject = this.readHexString(byteBuffer, n, n2, pDFDecrypter);
                continue;
            }
            if (n3 == 40) {
                pDFObject = this.readLiteralString(byteBuffer, n, n2, pDFDecrypter);
                continue;
            }
            if (n3 == 91) {
                pDFObject = this.readArray(byteBuffer, n, n2, pDFDecrypter);
                continue;
            }
            if (n3 == 47) {
                pDFObject = this.readName(byteBuffer);
                continue;
            }
            if (n3 == 37) {
                this.readLine(byteBuffer);
                continue;
            }
            if (n3 >= 48 && n3 <= 57 || n3 == 45 || n3 == 43 || n3 == 46) {
                pDFObject = this.readNumber(byteBuffer, (char)n3);
                if (bl) continue;
                int n4 = byteBuffer.position();
                PDFObject pDFObject2 = this.readObject(byteBuffer, -1, -1, true, pDFDecrypter);
                if (pDFObject2 != null && pDFObject2.getType() == 2) {
                    PDFObject pDFObject3 = this.readObject(byteBuffer, -1, -1, true, pDFDecrypter);
                    if (pDFObject3 != null && pDFObject3.getType() == 9 && pDFObject3.getStringValue().equals("R")) {
                        PDFXref pDFXref = new PDFXref(pDFObject.getIntValue(), pDFObject2.getIntValue());
                        pDFObject = new PDFObject(this, pDFXref);
                        continue;
                    }
                    if (pDFObject3 != null && pDFObject3.getType() == 9 && pDFObject3.getStringValue().equals("obj")) {
                        pDFObject = this.readObjectDescription(byteBuffer, pDFObject.getIntValue(), pDFObject2.getIntValue(), pDFDecrypter);
                        continue;
                    }
                    byteBuffer.position(n4);
                    continue;
                }
                byteBuffer.position(n4);
                continue;
            }
            if (n3 >= 97 && n3 <= 122 || n3 >= 65 && n3 <= 90) {
                pDFObject = this.readKeyword(byteBuffer, (char)n3);
                continue;
            }
            byteBuffer.position(byteBuffer.position() - 1);
            break;
        }
        return pDFObject;
    }

    private int nextNonWhitespaceChar(ByteBuffer byteBuffer) {
        byte by;
        while (PDFFile.isWhiteSpace(by = byteBuffer.get())) {
        }
        return by;
    }

    private void consumeWhitespace(ByteBuffer byteBuffer) {
        this.nextNonWhitespaceChar(byteBuffer);
        byteBuffer.position(byteBuffer.position() - 1);
    }

    private boolean nextItemIs(ByteBuffer byteBuffer, String string) throws IOException {
        int n = this.nextNonWhitespaceChar(byteBuffer);
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0) {
                n = byteBuffer.get();
            }
            if (n == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void processVersion(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            this.majorVersion = Integer.parseInt(stringTokenizer.nextToken());
            this.minorVersion = Integer.parseInt(stringTokenizer.nextToken());
            this.versionString = string;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getVersionString() {
        return this.versionString;
    }

    private PDFObject readDictionary(ByteBuffer byteBuffer, int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        PDFObject pDFObject;
        HashMap<String, PDFObject> hashMap = new HashMap<String, PDFObject>();
        while ((pDFObject = this.readObject(byteBuffer, n, n2, pDFDecrypter)) != null) {
            if (pDFObject.getType() != 4) {
                throw new PDFParseException("First item in dictionary must be a /Name.  (Was " + pDFObject + ")");
            }
            PDFObject pDFObject2 = this.readObject(byteBuffer, n, n2, pDFDecrypter);
            if (pDFObject2 == null) continue;
            hashMap.put(pDFObject.getStringValue(), pDFObject2);
        }
        if (!this.nextItemIs(byteBuffer, ">>")) {
            throw new PDFParseException("End of dictionary wasn't '>>'");
        }
        return new PDFObject(this, 6, hashMap);
    }

    private int readHexDigit(ByteBuffer byteBuffer) throws IOException {
        int n = this.nextNonWhitespaceChar(byteBuffer);
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n -= 48;
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                n -= 87;
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                n -= 55;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    private int readHexPair(ByteBuffer byteBuffer) throws IOException {
        int n = this.readHexDigit(byteBuffer);
        if (n < 0) {
            byteBuffer.position(byteBuffer.position() - 1);
            return -1;
        }
        int n2 = this.readHexDigit(byteBuffer);
        if (n2 < 0) {
            byteBuffer.position(byteBuffer.position() - 1);
            return n << 4;
        }
        return (n << 4) + n2;
    }

    private PDFObject readHexString(ByteBuffer byteBuffer, int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n3 = this.readHexPair(byteBuffer)) >= 0) {
            stringBuffer.append((char)n3);
        }
        if (byteBuffer.get() != 62) {
            throw new PDFParseException("Bad character in Hex String");
        }
        return new PDFObject(this, 3, pDFDecrypter.decryptString(n, n2, stringBuffer.toString()));
    }

    private PDFObject readLiteralString(ByteBuffer byteBuffer, int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        int n3 = 1;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 > 0) {
            int n4 = byteBuffer.get() & 0xFF;
            if (n4 == 40) {
                ++n3;
            } else if (n4 == 41) {
                if (--n3 == 0) {
                    n4 = -1;
                    break;
                }
            } else if (n4 == 92) {
                n4 = byteBuffer.get() & 0xFF;
                if (n4 >= 48 && n4 < 56) {
                    int n5 = 0;
                    for (int i = 0; n4 >= 48 && n4 < 56 && i < 3; ++i) {
                        n5 = n5 * 8 + n4 - 48;
                        n4 = byteBuffer.get() & 0xFF;
                    }
                    byteBuffer.position(byteBuffer.position() - 1);
                    n4 = n5;
                } else if (n4 == 110) {
                    n4 = 10;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 98) {
                    n4 = 8;
                } else if (n4 == 102) {
                    n4 = 12;
                } else if (n4 == 13) {
                    n4 = byteBuffer.get() & 0xFF;
                    if (n4 != 10) {
                        byteBuffer.position(byteBuffer.position() - 1);
                    }
                    n4 = -1;
                } else if (n4 == 10) {
                    n4 = -1;
                }
            }
            if (n4 < 0) continue;
            stringBuffer.append((char)n4);
        }
        return new PDFObject(this, 3, pDFDecrypter.decryptString(n, n2, stringBuffer.toString()));
    }

    private String readLine(ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        while (byteBuffer.remaining() > 0) {
            char c = (char)byteBuffer.get();
            if (c == '\r') {
                char c2;
                if (byteBuffer.remaining() <= 0 || (c2 = (char)byteBuffer.get(byteBuffer.position())) != '\n') break;
                byteBuffer.get();
                break;
            }
            if (c == '\n') break;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private PDFObject readArray(ByteBuffer byteBuffer, int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        PDFObject pDFObject;
        ArrayList<PDFObject> arrayList = new ArrayList<PDFObject>();
        while ((pDFObject = this.readObject(byteBuffer, n, n2, pDFDecrypter)) != null) {
            arrayList.add(pDFObject);
        }
        if (byteBuffer.get() != 93) {
            throw new PDFParseException("Array should end with ']'");
        }
        PDFObject[] pDFObjectArray = new PDFObject[arrayList.size()];
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            pDFObjectArray[i] = (PDFObject)arrayList.get(i);
        }
        return new PDFObject(this, 5, pDFObjectArray);
    }

    private PDFObject readName(ByteBuffer byteBuffer) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while (PDFFile.isRegularCharacter(n = byteBuffer.get()) && (n >= 33 || n <= 126)) {
            if (n == 35 && this.majorVersion != 1 && this.minorVersion != 1) {
                int n2 = this.readHexPair(byteBuffer);
                if (n2 >= 0) {
                    n = n2;
                } else {
                    throw new PDFParseException("Bad #hex in /Name");
                }
            }
            stringBuffer.append((char)n);
        }
        byteBuffer.position(byteBuffer.position() - 1);
        return new PDFObject(this, 4, stringBuffer.toString());
    }

    private PDFObject readNumber(ByteBuffer byteBuffer, char c) throws IOException {
        double d;
        boolean bl = c == '-';
        boolean bl2 = c == '.';
        double d2 = bl2 ? 0.1 : 1.0;
        double d3 = d = c >= '0' && c <= '9' ? (double)(c - 48) : 0.0;
        while (true) {
            byte by;
            if ((by = byteBuffer.get()) == 46) {
                if (bl2) {
                    throw new PDFParseException("Can't have two '.' in a number");
                }
                bl2 = true;
                d2 = 0.1;
                continue;
            }
            if (by < 48 || by > 57) break;
            int n = by - 48;
            if (bl2) {
                d += (double)n * d2;
                d2 *= 0.1;
                continue;
            }
            d = d * 10.0 + (double)n;
        }
        byteBuffer.position(byteBuffer.position() - 1);
        if (bl) {
            d = -d;
        }
        return new PDFObject(this, 2, new Double(d));
    }

    private PDFObject readKeyword(ByteBuffer byteBuffer, char c) throws IOException {
        byte by;
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(c));
        while (PDFFile.isRegularCharacter(by = byteBuffer.get())) {
            stringBuffer.append((char)by);
        }
        byteBuffer.position(byteBuffer.position() - 1);
        return new PDFObject(this, 9, stringBuffer.toString());
    }

    private PDFObject readObjectDescription(ByteBuffer byteBuffer, int n, int n2, PDFDecrypter pDFDecrypter) throws IOException {
        Object object;
        long l = byteBuffer.position();
        PDFObject pDFObject = this.readObject(byteBuffer, n, n2, pDFDecrypter);
        PDFObject pDFObject2 = this.readObject(byteBuffer, n, n2, pDFDecrypter);
        if (pDFObject2.getType() != 9) {
            throw new PDFParseException("Expected 'stream' or 'endobj'");
        }
        if (pDFObject.getType() == 6 && pDFObject2.getStringValue().equals("stream")) {
            this.readLine(byteBuffer);
            object = this.readStream(byteBuffer, pDFObject);
            if (object == null) {
                object = ByteBuffer.allocate(0);
            }
            pDFObject.setStream((ByteBuffer)object);
            pDFObject2 = this.readObject(byteBuffer, n, n2, pDFDecrypter);
        }
        if ((object = pDFObject2.getStringValue()) == null || !((String)object).equals("endobj")) {
            System.out.println("WARNING: object at " + l + " didn't end with 'endobj'");
        }
        pDFObject.setObjectId(n, n2);
        return pDFObject;
    }

    private ByteBuffer readStream(ByteBuffer byteBuffer, PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2 = pDFObject.getDictRef("Length");
        int n = -1;
        if (pDFObject2 != null) {
            n = pDFObject2.getIntValue();
        }
        if (n < 0) {
            throw new PDFParseException("Unknown length for stream");
        }
        int n2 = byteBuffer.position();
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(n);
        byteBuffer.position(byteBuffer.position() + n);
        int n3 = byteBuffer.position();
        if (!this.nextItemIs(byteBuffer, "endstream")) {
            System.out.println("read " + n + " chars from " + n2 + " to " + n3);
            throw new PDFParseException("Stream ended inappropriately");
        }
        return byteBuffer2;
    }

    private void readTrailersAndXrefs(PDFPassword pDFPassword) throws IOException, PDFAuthenticationFailureException, EncryptionUnsupportedByProductException, EncryptionUnsupportedByPlatformException {
        PDFObject pDFObject;
        boolean bl = true;
        while (bl) {
            pDFObject = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance());
            if (pDFObject.getType() == 9 && "xref".equals(pDFObject.getStringValue())) {
                bl = this.readCrossrefTableAndTrailer(pDFPassword);
                continue;
            }
            if (this.isXrefStream(pDFObject)) {
                bl = this.readCrossrefStream(pDFObject, true);
                continue;
            }
            throw new PDFParseException("Expected xref table or xref stream, but found " + pDFObject);
        }
        if (this.root == null) {
            throw new PDFParseException("No /Root key found in trailer dictionary");
        }
        if (this.root.getDictRef("Version") != null) {
            this.processVersion(this.root.getDictRef("Version").getStringValue());
        }
        if (this.encrypt != null) {
            this.defaultDecrypter = PDFDecrypterFactory.createDecryptor(this.encrypt, this.fileIdentifier, pDFPassword);
            pDFObject = this.encrypt.getDictRef("P");
            if (pDFObject != null && !this.defaultDecrypter.isOwnerAuthorised()) {
                int n;
                int n2 = n = pDFObject != null ? pDFObject.getIntValue() : 0;
                if (pDFObject != null) {
                    this.printable = (n & 4) != 0;
                    this.saveable = (n & 0x10) != 0;
                }
            }
        }
        this.root.dereference();
    }

    private boolean isXrefStream(PDFObject pDFObject) throws IOException {
        return pDFObject.getType() == 7 && "XRef".equals(pDFObject.getDictRef("Type").getStringValue());
    }

    private boolean readCrossrefTableAndTrailer(PDFPassword pDFPassword) throws IOException {
        PDFObject pDFObject;
        while ((pDFObject = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance())).getType() == 2) {
            int n = pDFObject.getIntValue();
            PDFObject pDFObject2 = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance());
            if (pDFObject2.getType() != 2) {
                throw new PDFParseException("Expected number for length of xref table");
            }
            int n2 = pDFObject2.getIntValue();
            int n3 = n + n2;
            this.ensureXrefEntriesCapacity(n3 + 1);
            this.consumeWhitespace(this.fileBuf);
            byte[] byArray = new byte[20];
            for (int i = n; i < n3; ++i) {
                PDFXrefEntry pDFXrefEntry;
                this.fileBuf.get(byArray);
                if (this.xrefEntries[i] != null) continue;
                byte by = byArray[17];
                if (by == 110) {
                    int n4 = Integer.parseInt(new String(byArray, 0, 10));
                    int n5 = Integer.parseInt(new String(byArray, 11, 5));
                    PDFXref pDFXref = new PDFXref(i, n5);
                    pDFXrefEntry = PDFXrefEntry.toBodyObject(n5, n4);
                } else if (by == 102) {
                    pDFXrefEntry = PDFXrefEntry.forFreedObject();
                } else {
                    throw new PDFParseException("Unknown xref entry type: " + by);
                }
                this.xrefEntries[i] = pDFXrefEntry;
            }
        }
        if (pDFObject.getType() != 9 || !"trailer".equals(pDFObject.getStringValue())) {
            throw new PDFParseException("Expected to find trailer immediately after xref table, but found " + pDFObject + " instead");
        }
        PDFObject pDFObject3 = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance());
        if (pDFObject3.getType() != 6) {
            throw new PDFParseException("Expected dictionary after \"trailer\"");
        }
        return this.processTrailerDict(pDFObject3, false, true);
    }

    private boolean processTrailerDict(PDFObject pDFObject, boolean bl, boolean bl2) throws IOException {
        PDFObject pDFObject2;
        if (this.root == null) {
            this.root = pDFObject.getDictRef("Root");
            if (this.root != null) {
                this.root.setObjectId(-1, -1);
            }
        }
        if (this.fileIdentifier == null) {
            this.fileIdentifier = pDFObject.getDictRef("ID");
        }
        if (this.encrypt == null) {
            this.encrypt = pDFObject.getDictRef("Encrypt");
            if (this.encrypt != null) {
                this.encrypt.setObjectId(-1, -1);
            }
        }
        if (this.info == null) {
            this.info = pDFObject.getDictRef("Info");
            if (this.info != null) {
                if (!this.info.isIndirect()) {
                    throw new PDFParseException("Info in trailer must be an indirect reference");
                }
                this.info.setObjectId(-1, -1);
            }
        }
        if (!bl && (pDFObject2 = pDFObject.getDictRef("XRefStm")) != null) {
            this.fileBuf.position(pDFObject2.getIntValue());
            this.readCrossrefStream(null, false);
        }
        pDFObject2 = null;
        if (bl2 && (pDFObject2 = pDFObject.getDictRef("Prev")) != null) {
            this.fileBuf.position(pDFObject2.getIntValue());
        }
        return pDFObject2 != null;
    }

    private boolean readCrossrefStream(PDFObject pDFObject, boolean bl) throws IOException {
        if (pDFObject == null && !this.isXrefStream(pDFObject = this.readObject(this.fileBuf, -1, -1, IdentityDecrypter.getInstance()))) {
            throw new PDFParseException("Object found at offset for cross reference stream is not a cross reference stream");
        }
        int n = pDFObject.getDictRef("Size").getIntValue();
        this.ensureXrefEntriesCapacity(n);
        PDFObject[] pDFObjectArray = pDFObject.getDictRef("W").getArray();
        int[] nArray = new int[3];
        int n2 = 0;
        for (int i = 0; i < 3; ++i) {
            nArray[i] = pDFObjectArray[i].getIntValue();
            n2 += nArray[i];
        }
        PDFObject pDFObject2 = pDFObject.getDictRef("Index");
        PDFObject[] pDFObjectArray2 = pDFObject2 != null ? pDFObject2.getArray() : new PDFObject[]{new PDFObject(0), new PDFObject(n)};
        ByteBuffer byteBuffer = pDFObject.getStreamBuffer();
        for (int i = 0; i < pDFObjectArray2.length; i += 2) {
            int n3 = pDFObjectArray2[i].getIntValue();
            int n4 = n3 + pDFObjectArray2[i + 1].getIntValue();
            for (int j = n3; j < n4; ++j) {
                if (this.xrefEntries[j] == null) {
                    PDFXrefEntry.Type type = nArray[0] == 0 ? PDFXrefEntry.Type.OBJ_IN_BODY : PDFXrefEntry.Type.forTypeField(this.readInt(byteBuffer, nArray[0]));
                    int n5 = this.readInt(byteBuffer, nArray[1]);
                    int n6 = this.readInt(byteBuffer, nArray[2]);
                    this.xrefEntries[j] = type.makeXrefStreamEntry(n5, n6);
                    continue;
                }
                byteBuffer.position(byteBuffer.position() + n2);
            }
        }
        return this.processTrailerDict(pDFObject, true, bl);
    }

    private int readInt(ByteBuffer byteBuffer, int n) {
        int n2 = 0;
        while (n-- > 0) {
            int n3 = byteBuffer.get() & 0xFF;
            n2 = n2 << 8 | n3;
        }
        return n2;
    }

    private void ensureXrefEntriesCapacity(int n) {
        if (this.xrefEntries == null || this.xrefEntries.length < n) {
            PDFXrefEntry[] pDFXrefEntryArray = new PDFXrefEntry[n];
            if (this.xrefEntries != null) {
                System.arraycopy(this.xrefEntries, 0, pDFXrefEntryArray, 0, this.xrefEntries.length);
            }
            this.xrefEntries = pDFXrefEntryArray;
        }
    }

    private void parseFile(PDFPassword pDFPassword) throws IOException {
        this.fileBuf.rewind();
        String string = this.readLine(this.fileBuf);
        if (string.startsWith(VERSION_COMMENT)) {
            this.processVersion(string.substring(VERSION_COMMENT.length()));
        }
        this.fileBuf.rewind();
        this.fileBuf.position(this.fileBuf.limit() - 1);
        if (!this.backscan(this.fileBuf, "startxref")) {
            throw new PDFParseException("This may not be a PDF File");
        }
        int n = this.fileBuf.position();
        if (!PDFFile.isWhiteSpace(this.fileBuf.get())) {
            throw new PDFParseException("Found suspicious startxref without trialing whitespace");
        }
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)this.nextNonWhitespaceChar(this.fileBuf);
        while (c >= '0' && c <= '9') {
            stringBuilder.append(c);
            c = (char)this.fileBuf.get();
        }
        int n2 = Integer.parseInt(stringBuilder.toString());
        this.fileBuf.position(n2);
        try {
            this.readTrailersAndXrefs(pDFPassword);
        }
        catch (UnsupportedEncryptionException unsupportedEncryptionException) {
            throw new PDFParseException(unsupportedEncryptionException.getMessage(), unsupportedEncryptionException);
        }
    }

    private boolean backscan(ByteBuffer byteBuffer, String string) {
        byte[] byArray = new byte[32];
        if (string.length() * 2 > byArray.length) {
            throw new IllegalArgumentException("scanToken is too long - adjust buffer length");
        }
        int n = byteBuffer.position() - byArray.length;
        if (n < 0) {
            byArray = new byte[byteBuffer.position()];
            n = 0;
        }
        while (n >= 0) {
            byteBuffer.position(n);
            byteBuffer.get(byArray);
            String string2 = new String(byArray);
            int n2 = string2.lastIndexOf(string);
            if (n2 >= 0) {
                byteBuffer.position(n + n2 + string.length());
                return true;
            }
            int n3 = n - byArray.length + string.length() - 1;
            if (n3 < 0) {
                n = n == 0 ? -1 : n3;
                continue;
            }
            n = n3;
        }
        return false;
    }

    public OutlineNode getOutline() throws IOException {
        PDFObject pDFObject = this.root.getDictRef("Outlines");
        OutlineNode outlineNode = null;
        OutlineNode outlineNode2 = null;
        if (pDFObject != null) {
            Object object = pDFObject.getDictRef("First");
            outlineNode2 = outlineNode = new OutlineNode("<top>");
            while (object != null) {
                Object object2;
                PDFObject pDFObject2;
                String string = ((PDFObject)object).getDictRef("Title").getTextStringValue();
                OutlineNode outlineNode3 = new OutlineNode(string);
                outlineNode.add(outlineNode3);
                PDFAction pDFAction = null;
                PDFObject pDFObject3 = ((PDFObject)object).getDictRef("A");
                if (pDFObject3 != null) {
                    pDFAction = PDFAction.getAction(pDFObject3, this.getRoot());
                } else {
                    pDFObject2 = ((PDFObject)object).getDictRef("Dest");
                    if (pDFObject2 != null) {
                        try {
                            object2 = PDFDestination.getDestination(pDFObject2, this.getRoot());
                            pDFAction = new GoToAction((PDFDestination)object2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (pDFAction != null) {
                    outlineNode3.setAction(pDFAction);
                }
                if ((pDFObject2 = ((PDFObject)object).getDictRef("First")) != null) {
                    outlineNode = outlineNode3;
                    object = pDFObject2;
                    continue;
                }
                object2 = ((PDFObject)object).getDictRef("Next");
                while (object2 == null) {
                    object = ((PDFObject)object).getDictRef("Parent");
                    object2 = ((PDFObject)object).getDictRef("Next");
                    if ((outlineNode = (OutlineNode)outlineNode.getParent()) != null) continue;
                }
                object = object2;
            }
        }
        return outlineNode2;
    }

    public int getPageNumber(PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2;
        PDFObject pDFObject3;
        if (pDFObject.getType() == 5) {
            pDFObject = pDFObject.getAt(0);
        }
        if ((pDFObject3 = pDFObject.getDictRef("Type")) == null || !pDFObject3.getStringValue().equals("Page")) {
            return 0;
        }
        int n = 0;
        while ((pDFObject2 = pDFObject.getDictRef("Parent")) != null) {
            PDFObject[] pDFObjectArray = pDFObject2.getDictRef("Kids").getArray();
            for (int i = 0; i < pDFObjectArray.length && !pDFObjectArray[i].equals(pDFObject); ++i) {
                PDFObject pDFObject4 = pDFObjectArray[i].getDictRef("Count");
                if (pDFObject4 != null) {
                    n += pDFObject4.getIntValue();
                    continue;
                }
                ++n;
            }
            pDFObject = pDFObject2;
        }
        return n;
    }

    public PDFPage getPage(int n) {
        return this.getPage(n, false);
    }

    public PDFPage getPage(int n, boolean bl) {
        Integer n2 = new Integer(n);
        HashMap<String, PDFObject> hashMap = null;
        PDFObject pDFObject = null;
        boolean bl2 = false;
        PDFPage pDFPage = this.cache.getPage(n2);
        PDFParser pDFParser = this.cache.getPageParser(n2);
        if (pDFPage == null) {
            try {
                hashMap = new HashMap<String, PDFObject>();
                PDFObject pDFObject2 = this.root.getDictRef("Pages");
                pDFObject = this.findPage(pDFObject2, 0, n, hashMap);
                if (pDFObject == null) {
                    return null;
                }
                pDFPage = this.createPage(n, pDFObject);
                byte[] byArray = this.getContents(pDFObject);
                pDFParser = new PDFParser(pDFPage, byArray, hashMap);
                this.cache.addPage(n2, pDFPage, pDFParser);
            }
            catch (IOException iOException) {
                System.out.println("GetPage inner loop:");
                iOException.printStackTrace();
                return null;
            }
        }
        if (pDFParser != null && !pDFParser.isFinished()) {
            pDFParser.go(bl);
        }
        return pDFPage;
    }

    public void stop(int n) {
        PDFParser pDFParser = this.cache.getPageParser(new Integer(n));
        if (pDFParser != null) {
            pDFParser.stop();
        }
    }

    private byte[] getContents(PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2 = pDFObject.getDictRef("Contents");
        if (pDFObject2 == null) {
            throw new IOException("No page contents!");
        }
        PDFObject[] pDFObjectArray = pDFObject2.getArray();
        if (pDFObjectArray.length == 1) {
            return pDFObjectArray[0].getStream();
        }
        int n = 0;
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            byte[] byArray = pDFObjectArray[i].getStream();
            if (byArray == null) {
                throw new PDFParseException("No stream on content " + i + ": " + pDFObjectArray[i]);
            }
            n += byArray.length;
        }
        byte[] byArray = new byte[n];
        n = 0;
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            byte[] byArray2 = pDFObjectArray[i].getStream();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        return byArray;
    }

    private PDFPage createPage(int n, PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2;
        PDFObject pDFObject3;
        int n2 = 0;
        Rectangle2D rectangle2D = null;
        Rectangle2D rectangle2D2 = null;
        PDFObject pDFObject4 = this.getInheritedValue(pDFObject, "MediaBox");
        if (pDFObject4 != null) {
            rectangle2D = PDFFile.parseNormalisedRectangle(pDFObject4);
        }
        if ((pDFObject3 = this.getInheritedValue(pDFObject, "CropBox")) != null) {
            rectangle2D2 = PDFFile.parseNormalisedRectangle(pDFObject3);
        }
        if ((pDFObject2 = this.getInheritedValue(pDFObject, "Rotate")) != null) {
            n2 = pDFObject2.getIntValue();
        }
        Rectangle2D rectangle2D3 = rectangle2D2 == null ? rectangle2D : rectangle2D2;
        return new PDFPage(n, rectangle2D3, n2, this.cache);
    }

    private PDFObject findPage(PDFObject pDFObject, int n, int n2, Map<String, PDFObject> map) throws IOException {
        PDFObject pDFObject2;
        PDFObject pDFObject3 = pDFObject.getDictRef("Resources");
        if (pDFObject3 != null) {
            map.putAll(pDFObject3.getDictionary());
        }
        if ((pDFObject2 = pDFObject.getDictRef("Type")) != null && pDFObject2.getStringValue().equals("Page")) {
            return pDFObject;
        }
        PDFObject pDFObject4 = pDFObject.getDictRef("Kids");
        if (pDFObject4 != null) {
            PDFObject[] pDFObjectArray = pDFObject4.getArray();
            for (int i = 0; i < pDFObjectArray.length; ++i) {
                int n3 = 1;
                PDFObject pDFObject5 = pDFObjectArray[i].getDictRef("Count");
                if (pDFObject5 != null) {
                    n3 = pDFObject5.getIntValue();
                }
                if (n + n3 >= n2) {
                    return this.findPage(pDFObjectArray[i], n, n2, map);
                }
                n += n3;
            }
        }
        return null;
    }

    private PDFObject getInheritedValue(PDFObject pDFObject, String string) throws IOException {
        PDFObject pDFObject2 = pDFObject.getDictRef(string);
        if (pDFObject2 != null) {
            return pDFObject2;
        }
        PDFObject pDFObject3 = pDFObject.getDictRef("Parent");
        if (pDFObject3 != null) {
            return this.getInheritedValue(pDFObject3, string);
        }
        return null;
    }

    public static Rectangle2D parseNormalisedRectangle(PDFObject pDFObject) throws IOException {
        if (pDFObject != null) {
            if (pDFObject.getType() == 5) {
                PDFObject[] pDFObjectArray = pDFObject.getArray();
                if (pDFObjectArray.length == 4) {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    double d5 = pDFObjectArray[0].getDoubleValue();
                    double d6 = pDFObjectArray[1].getDoubleValue();
                    double d7 = pDFObjectArray[2].getDoubleValue();
                    double d8 = pDFObjectArray[3].getDoubleValue();
                    if (d5 < d7) {
                        d4 = d5;
                        d3 = d7;
                    } else {
                        d4 = d7;
                        d3 = d5;
                    }
                    if (d6 < d8) {
                        d2 = d6;
                        d = d8;
                    } else {
                        d2 = d8;
                        d = d6;
                    }
                    return new Rectangle2D.Double(d4, d2, Math.abs(d3 - d4), Math.abs(d - d2));
                }
                throw new PDFParseException("Rectangle definition didn't have 4 elements");
            }
            throw new PDFParseException("Rectangle definition not an array");
        }
        throw new PDFParseException("Rectangle not present");
    }

    public PDFDecrypter getDefaultDecrypter() {
        return this.defaultDecrypter;
    }
}

