/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.PDFStringUtil;
import com.sun.pdfview.PDFXref;
import com.sun.pdfview.decode.PDFDecoder;
import com.sun.pdfview.decrypt.IdentityDecrypter;
import com.sun.pdfview.decrypt.PDFDecrypter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PDFObject {
    public static final int INDIRECT = 0;
    public static final int BOOLEAN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int NAME = 4;
    public static final int ARRAY = 5;
    public static final int DICTIONARY = 6;
    public static final int STREAM = 7;
    public static final int NULL = 8;
    public static final int KEYWORD = 9;
    public static final int OBJ_NUM_EMBEDDED = -2;
    public static final int OBJ_NUM_TRAILER = -1;
    public static final PDFObject nullObj = new PDFObject(null, 8, null);
    private int type;
    private Object value;
    private ByteBuffer stream;
    private SoftReference decodedStream;
    private Set<String> decodedStreamFilterLimits = null;
    private PDFFile owner;
    private SoftReference cache;
    private int objNum = -2;
    private int objGen = -2;

    public PDFObject(PDFFile pDFFile, int n, Object object) {
        this.type = n;
        if (n == 4) {
            object = ((String)object).intern();
        } else if (n == 9 && object.equals("true")) {
            this.type = 1;
            object = Boolean.TRUE;
        } else if (n == 9 && object.equals("false")) {
            this.type = 1;
            object = Boolean.FALSE;
        }
        this.value = object;
        this.owner = pDFFile;
    }

    public PDFObject(Object object) throws PDFParseException {
        this.owner = null;
        this.value = object;
        if (object instanceof Double || object instanceof Integer) {
            this.type = 2;
        } else if (object instanceof String) {
            this.type = 4;
        } else if (object instanceof PDFObject[]) {
            this.type = 5;
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            PDFObject[] pDFObjectArray = new PDFObject[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                pDFObjectArray[i] = new PDFObject(objectArray[i]);
            }
            this.value = pDFObjectArray;
            this.type = 5;
        } else if (object instanceof HashMap) {
            this.type = 6;
        } else if (object instanceof Boolean) {
            this.type = 1;
        } else if (object instanceof PDFParser.Tok) {
            PDFParser.Tok tok = (PDFParser.Tok)object;
            if (tok.name.equals("true")) {
                this.value = Boolean.TRUE;
                this.type = 1;
            } else if (tok.name.equals("false")) {
                this.value = Boolean.FALSE;
                this.type = 1;
            } else {
                this.value = tok.name;
                this.type = 4;
            }
        } else {
            throw new PDFParseException("Bad type for raw PDFObject: " + object);
        }
    }

    public PDFObject(PDFFile pDFFile, PDFXref pDFXref) {
        this.type = 0;
        this.value = pDFXref;
        this.owner = pDFFile;
    }

    public int getType() throws IOException {
        if (this.type == 0) {
            return this.dereference().getType();
        }
        return this.type;
    }

    public void setStream(ByteBuffer byteBuffer) {
        this.type = 7;
        this.stream = byteBuffer;
    }

    public Object getCache() throws IOException {
        if (this.type == 0) {
            return this.dereference().getCache();
        }
        if (this.cache != null) {
            return this.cache.get();
        }
        return null;
    }

    public void setCache(Object object) throws IOException {
        if (this.type == 0) {
            this.dereference().setCache(object);
            return;
        }
        this.cache = new SoftReference<Object>(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getStream(Set<String> set) throws IOException {
        if (this.type == 0) {
            return this.dereference().getStream(set);
        }
        if (this.type == 7 && this.stream != null) {
            byte[] byArray = null;
            ByteBuffer byteBuffer = this.stream;
            synchronized (byteBuffer) {
                byte[] byArray2;
                ByteBuffer byteBuffer2 = this.decodeStream(set);
                if (byteBuffer2.hasArray() && byteBuffer2.arrayOffset() == 0 && (byArray2 = byteBuffer2.array()).length == byteBuffer2.remaining()) {
                    return byArray2;
                }
                byArray = new byte[byteBuffer2.remaining()];
                byteBuffer2.get(byArray);
                byteBuffer2.flip();
            }
            return byArray;
        }
        if (this.type == 3) {
            return PDFStringUtil.asBytes(this.getStringValue());
        }
        return null;
    }

    public byte[] getStream() throws IOException {
        return this.getStream(Collections.emptySet());
    }

    public ByteBuffer getStreamBuffer() throws IOException {
        return this.getStreamBuffer(Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getStreamBuffer(Set<String> set) throws IOException {
        if (this.type == 0) {
            return this.dereference().getStreamBuffer(set);
        }
        if (this.type == 7 && this.stream != null) {
            ByteBuffer byteBuffer = this.stream;
            synchronized (byteBuffer) {
                ByteBuffer byteBuffer2 = this.decodeStream(set);
                return byteBuffer2.duplicate();
            }
        }
        if (this.type == 3) {
            String string = this.getStringValue();
            return ByteBuffer.wrap(string.getBytes());
        }
        return null;
    }

    private ByteBuffer decodeStream(Set<String> set) throws IOException {
        ByteBuffer byteBuffer = null;
        if (this.decodedStream != null && set.equals(this.decodedStreamFilterLimits)) {
            byteBuffer = (ByteBuffer)this.decodedStream.get();
        }
        if (byteBuffer == null) {
            this.stream.rewind();
            byteBuffer = PDFDecoder.decodeStream(this, this.stream, set);
            this.decodedStreamFilterLimits = new HashSet<String>(set);
            this.decodedStream = new SoftReference<ByteBuffer>(byteBuffer);
        }
        return byteBuffer;
    }

    public int getIntValue() throws IOException {
        if (this.type == 0) {
            return this.dereference().getIntValue();
        }
        if (this.type == 2) {
            return ((Number)this.value).intValue();
        }
        return 0;
    }

    public float getFloatValue() throws IOException {
        if (this.type == 0) {
            return this.dereference().getFloatValue();
        }
        if (this.type == 2) {
            return ((Double)this.value).floatValue();
        }
        return 0.0f;
    }

    public double getDoubleValue() throws IOException {
        if (this.type == 0) {
            return this.dereference().getDoubleValue();
        }
        if (this.type == 2) {
            return ((Number)this.value).doubleValue();
        }
        return 0.0;
    }

    public String getStringValue() throws IOException {
        if (this.type == 0) {
            return this.dereference().getStringValue();
        }
        if (this.type == 3 || this.type == 4 || this.type == 9) {
            return (String)this.value;
        }
        return null;
    }

    public String getTextStringValue() throws IOException {
        return PDFStringUtil.asTextString(this.getStringValue());
    }

    public PDFObject[] getArray() throws IOException {
        if (this.type == 0) {
            return this.dereference().getArray();
        }
        if (this.type == 5) {
            PDFObject[] pDFObjectArray = (PDFObject[])this.value;
            return pDFObjectArray;
        }
        PDFObject[] pDFObjectArray = new PDFObject[]{this};
        return pDFObjectArray;
    }

    public boolean getBooleanValue() throws IOException {
        if (this.type == 0) {
            return this.dereference().getBooleanValue();
        }
        if (this.type == 1) {
            return this.value == Boolean.TRUE;
        }
        return false;
    }

    public PDFObject getAt(int n) throws IOException {
        if (this.type == 0) {
            return this.dereference().getAt(n);
        }
        if (this.type == 5) {
            PDFObject[] pDFObjectArray = (PDFObject[])this.value;
            return pDFObjectArray[n];
        }
        return null;
    }

    public Iterator getDictKeys() throws IOException {
        if (this.type == 0) {
            return this.dereference().getDictKeys();
        }
        if (this.type == 6 || this.type == 7) {
            return ((HashMap)this.value).keySet().iterator();
        }
        return new ArrayList().iterator();
    }

    public HashMap<String, PDFObject> getDictionary() throws IOException {
        if (this.type == 0) {
            return this.dereference().getDictionary();
        }
        if (this.type == 6 || this.type == 7) {
            return (HashMap)this.value;
        }
        return new HashMap<String, PDFObject>();
    }

    public PDFObject getDictRef(String string) throws IOException {
        if (this.type == 0) {
            return this.dereference().getDictRef(string);
        }
        if (this.type == 6 || this.type == 7) {
            string = string.intern();
            HashMap hashMap = (HashMap)this.value;
            PDFObject pDFObject = (PDFObject)hashMap.get(string.intern());
            return pDFObject;
        }
        return null;
    }

    public boolean isDictType(String string) throws IOException {
        if (this.type == 0) {
            return this.dereference().isDictType(string);
        }
        if (this.type != 6 && this.type != 7) {
            return false;
        }
        PDFObject pDFObject = this.getDictRef("Type");
        return pDFObject != null && pDFObject.getStringValue().equals(string);
    }

    public PDFDecrypter getDecrypter() {
        return this.owner != null ? this.owner.getDefaultDecrypter() : IdentityDecrypter.getInstance();
    }

    public void setObjectId(int n, int n2) {
        assert (n >= -1);
        assert (n2 >= -1);
        this.objNum = n;
        this.objGen = n2;
    }

    public int getObjNum() {
        return this.objNum;
    }

    public int getObjGen() {
        return this.objGen;
    }

    public String toString() {
        try {
            if (this.type == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Indirect to #" + ((PDFXref)this.value).getObjectNumber());
                try {
                    stringBuffer.append("\n" + this.dereference().toString());
                }
                catch (Throwable throwable) {
                    stringBuffer.append(throwable.toString());
                }
                return stringBuffer.toString();
            }
            if (this.type == 1) {
                return "Boolean: " + (this.getBooleanValue() ? "true" : "false");
            }
            if (this.type == 2) {
                return "Number: " + this.getDoubleValue();
            }
            if (this.type == 3) {
                return "String: " + this.getStringValue();
            }
            if (this.type == 4) {
                return "Name: /" + this.getStringValue();
            }
            if (this.type == 5) {
                return "Array, length=" + ((PDFObject[])this.value).length;
            }
            if (this.type == 6) {
                StringBuffer stringBuffer = new StringBuffer();
                PDFObject pDFObject = this.getDictRef("Type");
                if (pDFObject != null) {
                    stringBuffer.append(pDFObject.getStringValue());
                    pDFObject = this.getDictRef("Subtype");
                    if (pDFObject == null) {
                        pDFObject = this.getDictRef("S");
                    }
                    if (pDFObject != null) {
                        stringBuffer.append("/" + pDFObject.getStringValue());
                    }
                } else {
                    stringBuffer.append("Untyped");
                }
                stringBuffer.append(" dictionary. Keys:");
                HashMap hashMap = (HashMap)this.value;
                for (Map.Entry entry : hashMap.entrySet()) {
                    stringBuffer.append("\n   " + entry.getKey() + "  " + entry.getValue());
                }
                return stringBuffer.toString();
            }
            if (this.type == 7) {
                byte[] byArray = this.getStream();
                if (byArray == null) {
                    return "Broken stream";
                }
                return "Stream: [[" + new String(byArray, 0, byArray.length > 30 ? 30 : byArray.length) + "]]";
            }
            if (this.type == 8) {
                return "Null";
            }
            if (this.type == 9) {
                return "Keyword: " + this.getStringValue();
            }
            return "Whoops!  big error!  Unknown type";
        }
        catch (IOException iOException) {
            return "Caught an error: " + iOException;
        }
    }

    public PDFObject dereference() throws IOException {
        if (this.type == 0) {
            PDFObject pDFObject = null;
            if (this.cache != null) {
                pDFObject = (PDFObject)this.cache.get();
            }
            if (pDFObject == null || pDFObject.value == null) {
                if (this.owner == null) {
                    System.out.println("Bad seed (owner==null)!  Object=" + this);
                }
                pDFObject = this.owner.dereference((PDFXref)this.value, this.getDecrypter());
                this.cache = new SoftReference<PDFObject>(pDFObject);
            }
            return pDFObject;
        }
        return this;
    }

    public boolean isIndirect() {
        return this.type == 0;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (this.type == 0 && object instanceof PDFObject) {
            PDFObject pDFObject = (PDFObject)object;
            if (pDFObject.type == 0) {
                PDFXref pDFXref = (PDFXref)this.value;
                PDFXref pDFXref2 = (PDFXref)pDFObject.value;
                return pDFXref.getObjectNumber() == pDFXref2.getObjectNumber() && pDFXref.getGeneration() == pDFXref2.getGeneration();
            }
        }
        return false;
    }
}

