/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Flag;
import com.sun.pdfview.FullScreenWindow;
import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFPrintPage;
import com.sun.pdfview.PageChangeListener;
import com.sun.pdfview.PagePanel;
import com.sun.pdfview.ThumbPanel;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class PDFViewer
extends JFrame
implements KeyListener,
TreeSelectionListener,
PageChangeListener {
    public static final String TITLE = "SwingLabs PDF Viewer";
    PDFFile curFile;
    String docName;
    JSplitPane split;
    JScrollPane thumbscroll;
    ThumbPanel thumbs;
    PagePanel page;
    PagePanel fspp;
    int curpage = -1;
    JToggleButton fullScreenButton;
    JTextField pageField;
    FullScreenWindow fullScreen;
    OutlineNode outline = null;
    PageFormat pformat = PrinterJob.getPrinterJob().defaultPage();
    boolean doThumb = true;
    Flag docWaiter;
    PagePreparer pagePrep;
    JDialog olf;
    JMenu docMenu;
    Action openAction = new AbstractAction("Open..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doOpen();
        }
    };
    Action pageSetupAction = new AbstractAction("Page setup..."){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doPageSetup();
        }
    };
    Action printAction = new AbstractAction("Print...", this.getIcon("gfx/print.gif")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doPrint();
        }
    };
    Action closeAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doClose();
        }
    };
    Action quitAction = new AbstractAction("Quit"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doQuit();
        }
    };
    ZoomAction zoomInAction = new ZoomAction("Zoom in", this.getIcon("gfx/zoomin.gif"), 2.0);
    ZoomAction zoomOutAction = new ZoomAction("Zoom out", this.getIcon("gfx/zoomout.gif"), 0.5);
    Action zoomToolAction = new AbstractAction("", this.getIcon("gfx/zoom.gif")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doZoomTool();
        }
    };
    Action fitInWindowAction = new AbstractAction("Fit in window", this.getIcon("gfx/fit.gif")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doFitInWindow();
        }
    };
    ThumbAction thumbAction = new ThumbAction();
    Action fullScreenAction = new AbstractAction("Full screen", this.getIcon("gfx/fullscrn.gif")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doFullScreen((actionEvent.getModifiers() & 1) != 0);
        }
    };
    Action nextAction = new AbstractAction("Next", this.getIcon("gfx/next.gif")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doNext();
        }
    };
    Action firstAction = new AbstractAction("First", this.getIcon("gfx/first.gif")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doFirst();
        }
    };
    Action lastAction = new AbstractAction("Last", this.getIcon("gfx/last.gif")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doLast();
        }
    };
    Action prevAction = new AbstractAction("Prev", this.getIcon("gfx/prev.gif")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doPrev();
        }
    };
    FileFilter pdfFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".pdf");
        }

        @Override
        public String getDescription() {
            return "Choose a PDF file";
        }
    };
    private File prevDirChoice;
    PageBuilder pb = new PageBuilder();

    public Icon getIcon(String string) {
        ImageIcon imageIcon = null;
        URL uRL = null;
        try {
            uRL = this.getClass().getResource(string);
            imageIcon = new ImageIcon(uRL);
            if (imageIcon == null) {
                System.out.println("Couldn't find " + uRL);
            }
        }
        catch (Exception exception) {
            System.out.println("Couldn't find " + this.getClass().getName() + "/" + string);
            exception.printStackTrace();
        }
        return imageIcon;
    }

    public PDFViewer(boolean bl) {
        super(TITLE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PDFViewer.this.doQuit();
            }
        });
        this.doThumb = bl;
        this.init();
    }

    protected void init() {
        this.page = new PagePanel();
        this.page.addKeyListener(this);
        if (this.doThumb) {
            this.split = new JSplitPane(1);
            this.split.addPropertyChangeListener("dividerLocation", this.thumbAction);
            this.split.setOneTouchExpandable(true);
            this.thumbs = new ThumbPanel(null);
            this.thumbscroll = new JScrollPane(this.thumbs, 22, 31);
            this.split.setLeftComponent(this.thumbscroll);
            this.split.setRightComponent(this.page);
            this.getContentPane().add((Component)this.split, "Center");
        } else {
            this.getContentPane().add((Component)this.page, "Center");
        }
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        JButton jButton = new JButton(this.firstAction);
        jButton.setText("");
        jToolBar.add(jButton);
        jButton = new JButton(this.prevAction);
        jButton.setText("");
        jToolBar.add(jButton);
        this.pageField = new JTextField("-", 3);
        this.pageField.setMaximumSize(new Dimension(45, 32));
        this.pageField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PDFViewer.this.doPageTyped();
            }
        });
        jToolBar.add(this.pageField);
        jButton = new JButton(this.nextAction);
        jButton.setText("");
        jToolBar.add(jButton);
        jButton = new JButton(this.lastAction);
        jButton.setText("");
        jToolBar.add(jButton);
        jToolBar.add(Box.createHorizontalGlue());
        this.fullScreenButton = new JToggleButton(this.fullScreenAction);
        this.fullScreenButton.setText("");
        jToolBar.add(this.fullScreenButton);
        this.fullScreenButton.setEnabled(true);
        jToolBar.add(Box.createHorizontalGlue());
        ButtonGroup buttonGroup = new ButtonGroup();
        JToggleButton jToggleButton = new JToggleButton(this.zoomToolAction);
        jToggleButton.setText("");
        buttonGroup.add(jToggleButton);
        jToolBar.add(jToggleButton);
        jToggleButton = new JToggleButton(this.fitInWindowAction);
        jToggleButton.setText("");
        buttonGroup.add(jToggleButton);
        jToggleButton.setSelected(true);
        jToolBar.add(jToggleButton);
        jToolBar.add(Box.createHorizontalGlue());
        jButton = new JButton(this.printAction);
        jButton.setText("");
        jToolBar.add(jButton);
        this.getContentPane().add((Component)jToolBar, "North");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.add(this.openAction);
        jMenu.add(this.closeAction);
        jMenu.addSeparator();
        jMenu.add(this.pageSetupAction);
        jMenu.add(this.printAction);
        jMenu.addSeparator();
        jMenu.add(this.quitAction);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("View");
        JMenu jMenu3 = new JMenu("Zoom");
        jMenu3.add(this.zoomInAction);
        jMenu3.add(this.zoomOutAction);
        jMenu3.add(this.fitInWindowAction);
        jMenu3.setEnabled(false);
        jMenu2.add(jMenu3);
        jMenu2.add(this.fullScreenAction);
        if (this.doThumb) {
            jMenu2.addSeparator();
            jMenu2.add(this.thumbAction);
        }
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.setEnabling();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getWidth()) / 2;
        int n2 = (dimension.height - this.getHeight()) / 2;
        this.setLocation(n, n2);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setVisible(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PDFViewer.this.setVisible(true);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void gotoPage(int n) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.curFile.getNumPages()) {
            n = this.curFile.getNumPages() - 1;
        }
        this.forceGotoPage(n);
    }

    public void forceGotoPage(int n) {
        if (n <= 0) {
            n = 0;
        } else if (n >= this.curFile.getNumPages()) {
            n = this.curFile.getNumPages() - 1;
        }
        this.curpage = n;
        this.pageField.setText(String.valueOf(this.curpage + 1));
        PDFPage pDFPage = this.curFile.getPage(n + 1);
        if (this.fspp != null) {
            this.fspp.showPage(pDFPage);
            this.fspp.requestFocus();
        } else {
            this.page.showPage(pDFPage);
            this.page.requestFocus();
        }
        if (this.doThumb) {
            this.thumbs.pageShown(n);
        }
        if (this.pagePrep != null) {
            this.pagePrep.quit();
        }
        this.pagePrep = new PagePreparer(n);
        this.pagePrep.start();
        this.setEnabling();
    }

    public void setEnabling() {
        boolean bl;
        boolean bl2 = bl = this.curFile != null;
        boolean bl3 = this.fspp != null ? this.fspp.getPage() != null : this.page.getPage() != null;
        boolean bl4 = bl && this.curFile.isPrintable();
        this.pageField.setEnabled(bl);
        this.printAction.setEnabled(bl4);
        this.closeAction.setEnabled(bl);
        this.fullScreenAction.setEnabled(bl3);
        this.prevAction.setEnabled(bl3);
        this.nextAction.setEnabled(bl3);
        this.firstAction.setEnabled(bl);
        this.lastAction.setEnabled(bl);
        this.zoomToolAction.setEnabled(bl3);
        this.fitInWindowAction.setEnabled(bl3);
        this.zoomInAction.setEnabled(bl3);
        this.zoomOutAction.setEnabled(bl3);
    }

    public void openFile(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        int n = uRLConnection.getContentLength();
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 >= 0) {
            n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 <= 0) continue;
            n2 += n3;
        }
        if (n2 != n) {
            throw new IOException("Could not read all of URL file.");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.put(byArray);
        this.openPDFByteBuffer(byteBuffer, uRL.toString(), uRL.getFile());
    }

    public void openFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = randomAccessFile.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        this.openPDFByteBuffer(mappedByteBuffer, file.getPath(), file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFileUnMapped(File file) throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new FileInputStream(file));
            long l = file.length();
            if (l > Integer.MAX_VALUE) {
                throw new IOException("File too long to decode: " + file.getName());
            }
            int n = (int)l;
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 >= 0) {
                n3 = ((DataInputStream)filterInputStream).read(byArray, n2, n - n2);
                if (n3 <= 0) continue;
                n2 += n3;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n);
            byteBuffer.put(byArray);
            this.openPDFByteBuffer(byteBuffer, file.getPath(), file.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void openPDFByteBuffer(ByteBuffer byteBuffer, String string, String string2) {
        PDFFile pDFFile = null;
        try {
            pDFFile = new PDFFile(byteBuffer);
        }
        catch (IOException iOException) {
            this.openError(string + " doesn't appear to be a PDF file." + "\n: " + iOException.getMessage());
            return;
        }
        this.doClose();
        this.curFile = pDFFile;
        this.docName = string2;
        this.setTitle("SwingLabs PDF Viewer: " + this.docName);
        if (this.doThumb) {
            this.thumbs = new ThumbPanel(this.curFile);
            this.thumbs.addPageChangeListener(this);
            this.thumbscroll.getViewport().setView(this.thumbs);
            this.thumbscroll.getViewport().setBackground(Color.gray);
        }
        this.setEnabling();
        this.forceGotoPage(0);
        try {
            this.outline = this.curFile.getOutline();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.outline != null) {
            if (this.outline.getChildCount() > 0) {
                this.olf = new JDialog((Frame)this, "Outline");
                this.olf.setDefaultCloseOperation(0);
                this.olf.setLocation(this.getLocation());
                JTree jTree = new JTree(this.outline);
                jTree.setRootVisible(false);
                jTree.addTreeSelectionListener(this);
                JScrollPane jScrollPane = new JScrollPane(jTree);
                this.olf.getContentPane().add(jScrollPane);
                this.olf.pack();
                this.olf.setVisible(true);
            } else if (this.olf != null) {
                this.olf.setVisible(false);
                this.olf = null;
            }
        }
    }

    public void openError(String string) {
        JOptionPane.showMessageDialog(this.split, string, "Error opening file", 0);
    }

    public void doOpen() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(this.prevDirChoice);
            jFileChooser.setFileFilter(this.pdfFilter);
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                try {
                    this.prevDirChoice = jFileChooser.getSelectedFile();
                    this.openFile(jFileChooser.getSelectedFile());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.split, "Opening files from your local disk is not available\nfrom the Java Web Start version of this program.\n", "Error opening directory", 0);
            exception.printStackTrace();
        }
    }

    public void doOpen(String string) {
        try {
            URL uRL = new URL(string);
            this.openFile(new URL(string));
        }
        catch (IOException iOException) {
            try {
                this.openFile(new File(string));
            }
            catch (IOException iOException2) {
                Logger.getLogger(PDFViewer.class.getName()).log(Level.SEVERE, null, iOException2);
            }
        }
    }

    public void doPageSetup() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.pformat = printerJob.pageDialog(this.pformat);
    }

    public void doPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(this.docName);
        Book book = new Book();
        PDFPrintPage pDFPrintPage = new PDFPrintPage(this.curFile);
        book.append(pDFPrintPage, this.pformat, this.curFile.getNumPages());
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            new PrintThread(pDFPrintPage, printerJob).start();
        }
    }

    public void doClose() {
        if (this.thumbs != null) {
            this.thumbs.stop();
        }
        if (this.olf != null) {
            this.olf.setVisible(false);
            this.olf = null;
        }
        if (this.doThumb) {
            this.thumbs = new ThumbPanel(null);
            this.thumbscroll.getViewport().setView(this.thumbs);
        }
        this.setFullScreenMode(false, false);
        this.page.showPage(null);
        this.curFile = null;
        this.setTitle(TITLE);
        this.setEnabling();
    }

    public void doQuit() {
        this.doClose();
        this.dispose();
        System.exit(0);
    }

    public void doZoomTool() {
        if (this.fspp == null) {
            this.page.useZoomTool(true);
        }
    }

    public void doFitInWindow() {
        if (this.fspp == null) {
            this.page.useZoomTool(false);
            this.page.setClip(null);
        }
    }

    public void doThumbs(boolean bl) {
        if (bl) {
            this.split.setDividerLocation(this.thumbs.getPreferredSize().width + this.thumbscroll.getVerticalScrollBar().getWidth() + 4);
        } else {
            this.split.setDividerLocation(0);
        }
    }

    public void doFullScreen(boolean bl) {
        this.setFullScreenMode(this.fullScreen == null, bl);
    }

    public void doZoom(double d) {
    }

    public void doNext() {
        this.gotoPage(this.curpage + 1);
    }

    public void doPrev() {
        this.gotoPage(this.curpage - 1);
    }

    public void doFirst() {
        this.gotoPage(0);
    }

    public void doLast() {
        this.gotoPage(this.curFile.getNumPages() - 1);
    }

    public void doPageTyped() {
        int n = -1;
        try {
            n = Integer.parseInt(this.pageField.getText()) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n >= this.curFile.getNumPages()) {
            n = this.curFile.getNumPages() - 1;
        }
        if (n >= 0) {
            if (n != this.curpage) {
                this.gotoPage(n);
            }
        } else {
            this.pageField.setText(String.valueOf(this.curpage));
        }
    }

    public void setFullScreenMode(boolean bl, boolean bl2) {
        if (bl && this.fullScreen == null) {
            this.fullScreenAction.setEnabled(false);
            new Thread((Runnable)new PerformFullScreenMode(bl2), this.getClass().getName() + ".setFullScreenMode").start();
            this.fullScreenButton.setSelected(true);
        } else if (!bl && this.fullScreen != null) {
            this.fullScreen.close();
            this.fspp = null;
            this.fullScreen = null;
            this.gotoPage(this.curpage);
            this.fullScreenButton.setSelected(false);
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-noThumb")) {
                bl = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-help") || stringArray[i].equalsIgnoreCase("-h") || stringArray[i].equalsIgnoreCase("-?")) {
                System.out.println("java com.sun.awc.PDFViewer [flags] [file]");
                System.out.println("flags: [-noThumb] [-help or -h or -?]");
                System.exit(0);
                continue;
            }
            string = stringArray[i];
        }
        PDFViewer pDFViewer = new PDFViewer(bl);
        if (string != null) {
            pDFViewer.doOpen(string);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 37) {
            this.doPrev();
        } else if (n == 39) {
            this.doNext();
        } else if (n == 38) {
            this.doPrev();
        } else if (n == 40) {
            this.doNext();
        } else if (n == 36) {
            this.doFirst();
        } else if (n == 35) {
            this.doLast();
        } else if (n == 33) {
            this.doPrev();
        } else if (n == 34) {
            this.doNext();
        } else if (n == 32) {
            this.doNext();
        } else if (n == 27) {
            this.setFullScreenMode(false, false);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c >= '0' && c <= '9') {
            int n = c - 48;
            this.pb.keyTyped(n);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.isAddedPath()) {
            OutlineNode outlineNode = (OutlineNode)treeSelectionEvent.getPath().getLastPathComponent();
            if (outlineNode == null) {
                return;
            }
            try {
                PDFAction pDFAction = outlineNode.getAction();
                if (pDFAction == null) {
                    return;
                }
                if (pDFAction instanceof GoToAction) {
                    PDFDestination pDFDestination = ((GoToAction)pDFAction).getDestination();
                    if (pDFDestination == null) {
                        return;
                    }
                    PDFObject pDFObject = pDFDestination.getPage();
                    if (pDFObject == null) {
                        return;
                    }
                    int n = this.curFile.getPageNumber(pDFObject);
                    if (n >= 0) {
                        this.gotoPage(n);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class PageBuilder
    implements Runnable {
        int value = 0;
        long timeout;
        Thread anim;
        static final long TIMEOUT = 500L;

        PageBuilder() {
        }

        public synchronized void keyTyped(int n) {
            this.value = this.value * 10 + n;
            this.timeout = System.currentTimeMillis() + 500L;
            if (this.anim == null) {
                this.anim = new Thread(this);
                this.anim.setName(this.getClass().getName());
                this.anim.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l;
            long l2;
            PageBuilder pageBuilder = this;
            synchronized (pageBuilder) {
                l2 = System.currentTimeMillis();
                l = this.timeout;
            }
            while (l2 < l) {
                try {
                    Thread.sleep(this.timeout - l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pageBuilder = this;
                synchronized (pageBuilder) {
                    l2 = System.currentTimeMillis();
                    l = this.timeout;
                }
            }
            pageBuilder = this;
            synchronized (pageBuilder) {
                PDFViewer.this.gotoPage(this.value - 1);
                this.anim = null;
                this.value = 0;
            }
        }
    }

    class PerformFullScreenMode
    implements Runnable {
        boolean force;

        public PerformFullScreenMode(boolean bl) {
            this.force = bl;
        }

        @Override
        public void run() {
            PDFViewer.this.fspp = new PagePanel();
            PDFViewer.this.fspp.setBackground(Color.black);
            PDFViewer.this.page.showPage(null);
            PDFViewer.this.fullScreen = new FullScreenWindow(PDFViewer.this.fspp, this.force);
            PDFViewer.this.fspp.addKeyListener(PDFViewer.this);
            PDFViewer.this.gotoPage(PDFViewer.this.curpage);
            PDFViewer.this.fullScreenAction.setEnabled(true);
        }
    }

    class PrintThread
    extends Thread {
        PDFPrintPage ptPages;
        PrinterJob ptPjob;

        public PrintThread(PDFPrintPage pDFPrintPage, PrinterJob printerJob) {
            this.ptPages = pDFPrintPage;
            this.ptPjob = printerJob;
            this.setName(this.getClass().getName());
        }

        @Override
        public void run() {
            try {
                this.ptPages.show(this.ptPjob);
                this.ptPjob.print();
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(PDFViewer.this, "Printing Error: " + printerException.getMessage(), "Print Aborted", 0);
            }
            this.ptPages.hide();
        }
    }

    class PagePreparer
    extends Thread {
        int waitforPage;
        int prepPage;

        public PagePreparer(int n) {
            this.setDaemon(true);
            this.setName(this.getClass().getName());
            this.waitforPage = n;
            this.prepPage = n + 1;
        }

        public void quit() {
            this.waitforPage = -1;
        }

        @Override
        public void run() {
            PDFPage pDFPage;
            Dimension dimension = null;
            Rectangle2D rectangle2D = null;
            if (PDFViewer.this.fspp != null) {
                PDFViewer.this.fspp.waitForCurrentPage();
                dimension = PDFViewer.this.fspp.getCurSize();
                rectangle2D = PDFViewer.this.fspp.getCurClip();
            } else if (PDFViewer.this.page != null) {
                PDFViewer.this.page.waitForCurrentPage();
                dimension = PDFViewer.this.page.getCurSize();
                rectangle2D = PDFViewer.this.page.getCurClip();
            }
            if (this.waitforPage == PDFViewer.this.curpage && (pDFPage = PDFViewer.this.curFile.getPage(this.prepPage + 1, true)) != null && this.waitforPage == PDFViewer.this.curpage) {
                pDFPage.getImage(dimension.width, dimension.height, rectangle2D, null, true, true);
            }
        }
    }

    class ThumbAction
    extends AbstractAction
    implements PropertyChangeListener {
        boolean isOpen;

        public ThumbAction() {
            super("Hide thumbnails");
            this.isOpen = true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (n <= 1) {
                this.isOpen = false;
                this.putValue("ActionCommandKey", "Show thumbnails");
                this.putValue("Name", "Show thumbnails");
            } else {
                this.isOpen = true;
                this.putValue("ActionCommandKey", "Hide thumbnails");
                this.putValue("Name", "Hide thumbnails");
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doThumbs(!this.isOpen);
        }
    }

    class ZoomAction
    extends AbstractAction {
        double zoomfactor;

        public ZoomAction(String string, double d) {
            super(string);
            this.zoomfactor = 1.0;
            this.zoomfactor = d;
        }

        public ZoomAction(String string, Icon icon, double d) {
            super(string, icon);
            this.zoomfactor = 1.0;
            this.zoomfactor = d;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PDFViewer.this.doZoom(this.zoomfactor);
        }
    }
}

