/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.Flag;
import com.sun.pdfview.PDFPage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import javax.swing.JPanel;

public class PagePanel
extends JPanel
implements ImageObserver,
MouseListener,
MouseMotionListener {
    Image currentImage;
    PDFPage currentPage;
    AffineTransform currentXform;
    int offx;
    int offy;
    Rectangle2D clip;
    Rectangle2D prevClip;
    Dimension prevSize;
    Rectangle zoomRect;
    boolean useZoom = false;
    Flag flag = new Flag();
    int downx;
    int downy;

    public PagePanel() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public synchronized void showPage(PDFPage pDFPage) {
        if (this.currentPage != null && this.prevSize != null) {
            this.currentPage.stop(this.prevSize.width, this.prevSize.height, this.prevClip);
        }
        this.currentPage = pDFPage;
        if (pDFPage == null) {
            this.currentImage = null;
            this.clip = null;
            this.currentXform = null;
            this.repaint();
        } else {
            this.flag.clear();
            Dimension dimension = this.getSize();
            if (dimension.width + dimension.height == 0) {
                return;
            }
            Rectangle2D rectangle2D = this.clip;
            if (this.clip != null && this.currentXform != null) {
                rectangle2D = this.currentXform.createTransformedShape(this.clip).getBounds2D();
            }
            Dimension dimension2 = pDFPage.getUnstretchedSize(dimension.width, dimension.height, rectangle2D);
            this.currentImage = pDFPage.getImage(dimension2.width, dimension2.height, rectangle2D, this);
            this.currentXform = pDFPage.getInitialTransform(dimension2.width, dimension2.height, rectangle2D);
            try {
                this.currentXform = this.currentXform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                System.out.println("Error inverting page transform!");
                noninvertibleTransformException.printStackTrace();
            }
            this.prevClip = rectangle2D;
            this.prevSize = dimension2;
            this.repaint();
        }
    }

    public synchronized void flush() {
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.currentImage == null) {
            graphics.setColor(Color.black);
            graphics.drawString("No page selected", this.getWidth() / 2 - 30, this.getHeight() / 2);
        } else {
            int n = this.currentImage.getWidth(null);
            int n2 = this.currentImage.getHeight(null);
            this.offx = (dimension.width - n) / 2;
            this.offy = (dimension.height - n2) / 2;
            if (n == dimension.width && n2 <= dimension.height || n2 == dimension.height && n <= dimension.width) {
                graphics.drawImage(this.currentImage, this.offx, this.offy, this);
            } else {
                this.flush();
                if (this.currentPage != null) {
                    this.showPage(this.currentPage);
                }
                graphics.setColor(Color.red);
                graphics.drawLine(0, 0, this.getWidth(), this.getHeight());
                graphics.drawLine(0, this.getHeight(), this.getWidth(), 0);
            }
        }
        if (this.zoomRect != null) {
            graphics.setColor(Color.red);
            graphics.drawRect(this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height);
        }
    }

    public PDFPage getPage() {
        return this.currentPage;
    }

    public Dimension getCurSize() {
        return this.prevSize;
    }

    public Rectangle2D getCurClip() {
        return this.prevClip;
    }

    public void waitForCurrentPage() {
        this.flag.waitForFlag();
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Dimension dimension = this.getSize();
        if ((n & 0x28) != 0) {
            this.repaint(n2 + this.offx, n3 + this.offy, n4, n5);
        }
        if ((n & 0xE0) != 0) {
            this.flag.set();
            return false;
        }
        return true;
    }

    public void useZoomTool(boolean bl) {
        this.useZoom = bl;
    }

    public void setClip(Rectangle2D rectangle2D) {
        this.clip = rectangle2D;
        this.showPage(this.currentPage);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.downx = mouseEvent.getX();
        this.downy = mouseEvent.getY();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.useZoom || this.zoomRect == null || this.zoomRect.width == 0 || this.zoomRect.height == 0) {
            this.zoomRect = null;
            return;
        }
        this.setClip(new Rectangle2D.Double(this.zoomRect.x - this.offx, this.zoomRect.y - this.offy, this.zoomRect.width, this.zoomRect.height));
        this.zoomRect = null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.useZoom) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = Math.abs(n - this.downx);
            int n4 = Math.abs(n2 - this.downy);
            if ((mouseEvent.getModifiers() & 1) == 0) {
                float f = (float)n3 / (float)n4;
                float f2 = (float)this.getWidth() / (float)this.getHeight();
                if (f > f2) {
                    n4 = (int)((float)n3 / f2);
                } else {
                    n3 = (int)((float)n4 * f2);
                }
            }
            if (n < this.downx) {
                n = this.downx - n3;
            }
            if (n2 < this.downy) {
                n2 = this.downy - n4;
            }
            Rectangle rectangle = this.zoomRect;
            this.zoomRect = n3 < 5 || n4 < 5 ? null : new Rectangle(Math.min(this.downx, n), Math.min(this.downy, n2), n3, n4);
            if (this.zoomRect != null) {
                if (rectangle != null) {
                    rectangle.add(this.zoomRect);
                } else {
                    rectangle = new Rectangle(this.zoomRect);
                }
            }
            if (rectangle != null) {
                ++rectangle.width;
                ++rectangle.height;
            }
            if (rectangle != null) {
                this.repaint(rectangle);
            }
        }
    }
}

