/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decode.Predictor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class LZWDecode {
    ByteBuffer buf;
    int bytepos;
    int bitpos;
    byte[][] dict = new byte[4096][];
    int dictlen = 0;
    int bitspercode = 9;
    static int STOP = 257;
    static int CLEARDICT = 256;

    private LZWDecode(ByteBuffer byteBuffer) throws PDFParseException {
        for (int i = 0; i < 256; ++i) {
            this.dict[i] = new byte[1];
            this.dict[i][0] = (byte)i;
        }
        this.dictlen = 258;
        this.bitspercode = 9;
        this.buf = byteBuffer;
        this.bytepos = 0;
        this.bitpos = 0;
    }

    private void resetDict() {
        this.dictlen = 258;
        this.bitspercode = 9;
    }

    private int nextCode() {
        int n = this.bitspercode;
        int n2 = 0;
        if (this.bytepos >= this.buf.limit() - 1) {
            return -1;
        }
        while (n > 0) {
            byte by = this.buf.get(this.bytepos);
            int n3 = 8 - this.bitpos;
            if (n3 > n) {
                n3 = n;
            }
            n2 |= (by >> 8 - this.bitpos - n3 & 255 >> 8 - n3) << n - n3;
            n -= n3;
            this.bitpos += n3;
            if (this.bitpos < 8) continue;
            this.bitpos = 0;
            ++this.bytepos;
        }
        return n2;
    }

    private ByteBuffer decode() throws PDFParseException {
        int n = CLEARDICT;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (true) {
            byte[] byArray;
            int n2 = n;
            n = this.nextCode();
            if (n == -1) {
                throw new PDFParseException("Missed the stop code in LZWDecode!");
            }
            if (n == STOP) break;
            if (n == CLEARDICT) {
                this.resetDict();
                continue;
            }
            if (n2 == CLEARDICT) {
                byteArrayOutputStream.write(this.dict[n], 0, this.dict[n].length);
                continue;
            }
            if (n < this.dictlen) {
                byteArrayOutputStream.write(this.dict[n], 0, this.dict[n].length);
                byArray = new byte[this.dict[n2].length + 1];
                System.arraycopy(this.dict[n2], 0, byArray, 0, this.dict[n2].length);
                byArray[this.dict[n2].length] = this.dict[n][0];
                this.dict[this.dictlen++] = byArray;
            } else {
                byArray = new byte[this.dict[n2].length + 1];
                System.arraycopy(this.dict[n2], 0, byArray, 0, this.dict[n2].length);
                byArray[this.dict[n2].length] = byArray[0];
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                this.dict[this.dictlen++] = byArray;
            }
            if (this.dictlen < (1 << this.bitspercode) - 1 || this.bitspercode >= 12) continue;
            ++this.bitspercode;
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public static ByteBuffer decode(ByteBuffer byteBuffer, PDFObject pDFObject) throws IOException {
        Predictor predictor;
        LZWDecode lZWDecode = new LZWDecode(byteBuffer);
        ByteBuffer byteBuffer2 = lZWDecode.decode();
        if (pDFObject != null && pDFObject.getDictionary().containsKey("Predictor") && (predictor = Predictor.getPredictor(pDFObject)) != null) {
            byteBuffer2 = predictor.unpredict(byteBuffer2);
        }
        return byteBuffer2;
    }
}

