/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.decode.ASCII85Decode;
import com.sun.pdfview.decode.ASCIIHexDecode;
import com.sun.pdfview.decode.CCITTFaxDecode;
import com.sun.pdfview.decode.DCTDecode;
import com.sun.pdfview.decode.FlateDecode;
import com.sun.pdfview.decode.LZWDecode;
import com.sun.pdfview.decode.RunLengthDecode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PDFDecoder {
    private static final String FILTER_DCT = "DCT";
    private static final String FILTER_DCTDECODE = "DCTDecode";
    public static final Set<String> DCT_FILTERS = new HashSet<String>(Arrays.asList("DCT", "DCTDecode"));

    private PDFDecoder() {
    }

    public static boolean isLastFilter(PDFObject pDFObject, Set<String> set) throws IOException {
        PDFObject pDFObject2 = pDFObject.getDictRef("Filter");
        if (pDFObject2 == null) {
            return false;
        }
        if (pDFObject2.getType() == 4) {
            return set.contains(pDFObject2.getStringValue());
        }
        PDFObject[] pDFObjectArray = pDFObject2.getArray();
        return set.contains(pDFObjectArray[pDFObjectArray.length - 1].getStringValue());
    }

    public static ByteBuffer decodeStream(PDFObject pDFObject, ByteBuffer byteBuffer, Set<String> set) throws IOException {
        String string;
        boolean bl;
        PDFObject pDFObject2 = pDFObject.getDictRef("Filter");
        if (pDFObject2 == null) {
            return pDFObject.getDecrypter().decryptBuffer(null, pDFObject, byteBuffer);
        }
        FilterSpec filterSpec = new FilterSpec(pDFObject, pDFObject2);
        boolean bl2 = bl = filterSpec.ary.length != 0 && filterSpec.ary[0].getStringValue().equals("Crypt");
        if (!bl) {
            byteBuffer = pDFObject.getDecrypter().decryptBuffer(null, pDFObject, byteBuffer);
        }
        for (int i = 0; i < filterSpec.ary.length && !set.contains(string = filterSpec.ary[i].getStringValue()); ++i) {
            if (string == null) continue;
            if (string.equals("FlateDecode") || string.equals("Fl")) {
                byteBuffer = FlateDecode.decode(pDFObject, byteBuffer, filterSpec.params[i]);
                continue;
            }
            if (string.equals("LZWDecode") || string.equals("LZW")) {
                byteBuffer = LZWDecode.decode(byteBuffer, filterSpec.params[i]);
                continue;
            }
            if (string.equals("ASCII85Decode") || string.equals("A85")) {
                byteBuffer = ASCII85Decode.decode(byteBuffer, filterSpec.params[i]);
                continue;
            }
            if (string.equals("ASCIIHexDecode") || string.equals("AHx")) {
                byteBuffer = ASCIIHexDecode.decode(byteBuffer, filterSpec.params[i]);
                continue;
            }
            if (string.equals("RunLengthDecode") || string.equals("RL")) {
                byteBuffer = RunLengthDecode.decode(byteBuffer, filterSpec.params[i]);
                continue;
            }
            if (string.equals(FILTER_DCTDECODE) || string.equals(FILTER_DCT)) {
                byteBuffer = DCTDecode.decode(pDFObject, byteBuffer, filterSpec.params[i]);
                continue;
            }
            if (string.equals("CCITTFaxDecode") || string.equals("CCF")) {
                byteBuffer = CCITTFaxDecode.decode(pDFObject, byteBuffer, filterSpec.params[i]);
                continue;
            }
            if (string.equals("Crypt")) {
                String string2 = PDFDecoder.getCryptFilterName(filterSpec.params[i]);
                byteBuffer = pDFObject.getDecrypter().decryptBuffer(string2, null, byteBuffer);
                continue;
            }
            throw new PDFParseException("Unknown coding method:" + filterSpec.ary[i].getStringValue());
        }
        return byteBuffer;
    }

    private static String getCryptFilterName(PDFObject pDFObject) throws IOException {
        PDFObject pDFObject2;
        String string = "Identity";
        if (pDFObject != null && (pDFObject2 = pDFObject.getDictRef("Name")) != null && pDFObject2.getType() == 4) {
            string = pDFObject2.getStringValue();
        }
        return string;
    }

    public static boolean isEncrypted(PDFObject pDFObject) throws IOException {
        boolean bl;
        PDFObject pDFObject2 = pDFObject.getDictRef("Filter");
        if (pDFObject2 == null) {
            return pDFObject.getDecrypter().isEncryptionPresent();
        }
        FilterSpec filterSpec = new FilterSpec(pDFObject, pDFObject2);
        boolean bl2 = bl = filterSpec.ary.length != 0 && filterSpec.ary[0].getStringValue().equals("Crypt");
        if (!bl) {
            return pDFObject.getDecrypter().isEncryptionPresent();
        }
        String string = PDFDecoder.getCryptFilterName(filterSpec.params[0]);
        return pDFObject.getDecrypter().isEncryptionPresent(string);
    }

    private static class FilterSpec {
        PDFObject[] ary;
        PDFObject[] params;

        private FilterSpec(PDFObject pDFObject, PDFObject pDFObject2) throws IOException {
            if (pDFObject2.getType() == 4) {
                this.ary = new PDFObject[1];
                this.ary[0] = pDFObject2;
                this.params = new PDFObject[1];
                this.params[0] = pDFObject.getDictRef("DecodeParms");
            } else {
                this.ary = pDFObject2.getArray();
                PDFObject pDFObject3 = pDFObject.getDictRef("DecodeParms");
                this.params = pDFObject3 != null ? pDFObject3.getArray() : new PDFObject[this.ary.length];
            }
        }
    }
}

