/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFParser;
import com.sun.pdfview.font.PDFFont;
import com.sun.pdfview.font.PDFFontDescriptor;
import com.sun.pdfview.font.PDFGlyph;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Type3Font
extends PDFFont {
    HashMap<String, PDFObject> rsrc = new HashMap();
    Map charProcs;
    Rectangle2D bbox;
    AffineTransform at;
    float[] widths;
    int firstChar;
    int lastChar;

    public Type3Font(String string, PDFObject pDFObject, HashMap<String, PDFObject> hashMap, PDFFontDescriptor pDFFontDescriptor) throws IOException {
        super(string, pDFFontDescriptor);
        if (hashMap != null) {
            this.rsrc.putAll(hashMap);
        }
        PDFObject pDFObject2 = pDFObject.getDictRef("FontMatrix");
        float[] fArray = new float[6];
        for (int i = 0; i < 6; ++i) {
            fArray[i] = pDFObject2.getAt(i).getFloatValue();
        }
        this.at = new AffineTransform(fArray);
        float f = fArray[0] + fArray[2];
        PDFObject pDFObject3 = pDFObject.getDictRef("Resources");
        if (pDFObject3 != null) {
            this.rsrc.putAll(pDFObject3.getDictionary());
        }
        this.charProcs = pDFObject.getDictRef("CharProcs").getDictionary();
        this.bbox = PDFFile.parseNormalisedRectangle(pDFObject.getDictRef("FontBBox"));
        if (this.bbox.isEmpty()) {
            this.bbox = null;
        }
        PDFObject[] pDFObjectArray = pDFObject.getDictRef("Widths").getArray();
        this.widths = new float[pDFObjectArray.length];
        for (int i = 0; i < pDFObjectArray.length; ++i) {
            this.widths[i] = pDFObjectArray[i].getFloatValue();
        }
        this.firstChar = pDFObject.getDictRef("FirstChar").getIntValue();
        this.lastChar = pDFObject.getDictRef("LastChar").getIntValue();
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    @Override
    protected PDFGlyph getGlyph(char c, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Glyph name required for Type3 font!Source character: " + c);
        }
        PDFObject pDFObject = (PDFObject)this.charProcs.get(string);
        if (pDFObject == null) {
            return new PDFGlyph(c, string, new GeneralPath(), new Point2D.Float(0.0f, 0.0f));
        }
        try {
            PDFPage pDFPage = new PDFPage(this.bbox, 0);
            pDFPage.addXform(this.at);
            PDFParser pDFParser = new PDFParser(pDFPage, pDFObject.getStream(), this.rsrc);
            pDFParser.go(true);
            float f = this.widths[c - this.firstChar];
            Point2D point2D = new Point2D.Float(f, 0.0f);
            point2D = this.at.transform(point2D, null);
            return new PDFGlyph(c, string, pDFPage, point2D);
        }
        catch (IOException iOException) {
            System.out.println("IOException in Type3 font: " + iOException);
            iOException.printStackTrace();
            return null;
        }
    }
}

