/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.Glyf;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class GlyfCompound
extends Glyf {
    private static final int ARG_1_AND_2_ARE_WORDS = 1;
    private static final int ARGS_ARE_XY_VALUES = 2;
    private static final int ROUND_XY_TO_GRID = 4;
    private static final int WE_HAVE_A_SCALE = 8;
    private static final int MORE_COMPONENTS = 32;
    private static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final int WE_HAVE_A_TWO_BY_TWO = 128;
    private static final int WE_HAVE_INSTRUCTIONS = 256;
    private static final int USE_MY_METRICS = 512;
    private static final int OVERLAP_COMPOUND = 1024;
    private GlyfComponent[] components;
    private byte[] instructions;

    protected GlyfCompound() {
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        ArrayList<GlyfComponent> arrayList = new ArrayList<GlyfComponent>();
        GlyfComponent glyfComponent = null;
        boolean bl = false;
        do {
            glyfComponent = new GlyfComponent();
            glyfComponent.flags = byteBuffer.getShort();
            glyfComponent.glyphIndex = byteBuffer.getShort();
            if ((glyfComponent.flags & 1) != 0 && (glyfComponent.flags & 2) != 0) {
                glyfComponent.e = byteBuffer.getShort();
                glyfComponent.f = byteBuffer.getShort();
            } else if ((glyfComponent.flags & 1) == 0 && (glyfComponent.flags & 2) != 0) {
                glyfComponent.e = byteBuffer.get();
                glyfComponent.f = byteBuffer.get();
            } else if ((glyfComponent.flags & 1) != 0 && (glyfComponent.flags & 2) == 0) {
                glyfComponent.compoundPoint = byteBuffer.getShort();
                glyfComponent.componentPoint = byteBuffer.getShort();
            } else {
                glyfComponent.compoundPoint = byteBuffer.get();
                glyfComponent.componentPoint = byteBuffer.get();
            }
            if ((glyfComponent.flags & 8) != 0) {
                glyfComponent.d = glyfComponent.a = (float)byteBuffer.getShort() / 16384.0f;
            } else if ((glyfComponent.flags & 0x40) != 0) {
                glyfComponent.a = (float)byteBuffer.getShort() / 16384.0f;
                glyfComponent.d = (float)byteBuffer.getShort() / 16384.0f;
            } else if ((glyfComponent.flags & 0x80) != 0) {
                glyfComponent.a = (float)byteBuffer.getShort() / 16384.0f;
                glyfComponent.b = (float)byteBuffer.getShort() / 16384.0f;
                glyfComponent.c = (float)byteBuffer.getShort() / 16384.0f;
                glyfComponent.d = (float)byteBuffer.getShort() / 16384.0f;
            }
            if ((glyfComponent.flags & 0x100) != 0) {
                bl = true;
            }
            arrayList.add(glyfComponent);
        } while ((glyfComponent.flags & 0x20) != 0);
        GlyfComponent[] glyfComponentArray = new GlyfComponent[arrayList.size()];
        arrayList.toArray(glyfComponentArray);
        this.setComponents(glyfComponentArray);
        byte[] byArray = null;
        if (bl) {
            short s = byteBuffer.getShort();
            byArray = new byte[s];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = byteBuffer.get();
            }
        } else {
            byArray = new byte[]{};
        }
        this.setInstructions(byArray);
    }

    @Override
    public ByteBuffer getData() {
        ByteBuffer byteBuffer = super.getData();
        return byteBuffer;
    }

    @Override
    public short getLength() {
        short s = super.getLength();
        return s;
    }

    public int getNumComponents() {
        return this.components.length;
    }

    public short getFlag(int n) {
        return this.components[n].flags;
    }

    public short getGlyphIndex(int n) {
        return this.components[n].glyphIndex;
    }

    public double[] getTransform(int n) {
        GlyfComponent glyfComponent = this.components[n];
        float f = Math.max(Math.abs(glyfComponent.a), Math.abs(glyfComponent.b));
        if (Math.abs(Math.abs(glyfComponent.a) - Math.abs(glyfComponent.c)) < 0.0f) {
            f *= 2.0f;
        }
        float f2 = Math.max(Math.abs(glyfComponent.c), Math.abs(glyfComponent.d));
        if (Math.abs(Math.abs(glyfComponent.c) - Math.abs(glyfComponent.d)) < 0.0f) {
            f2 *= 2.0f;
        }
        float f3 = f * glyfComponent.e;
        float f4 = f2 * glyfComponent.f;
        return new double[]{glyfComponent.a, glyfComponent.b, glyfComponent.c, glyfComponent.d, f3, f4};
    }

    public int getCompoundPoint(int n) {
        return this.components[n].compoundPoint;
    }

    public int getComponentPoint(int n) {
        return this.components[n].componentPoint;
    }

    public boolean argsAreWords(int n) {
        return (this.getFlag(n) & 1) != 0;
    }

    public boolean argsAreXYValues(int n) {
        return (this.getFlag(n) & 2) != 0;
    }

    public boolean roundXYToGrid(int n) {
        return (this.getFlag(n) & 4) != 0;
    }

    public boolean hasAScale(int n) {
        return (this.getFlag(n) & 8) != 0;
    }

    protected boolean moreComponents(int n) {
        return (this.getFlag(n) & 0x20) != 0;
    }

    protected boolean hasXYScale(int n) {
        return (this.getFlag(n) & 0x40) != 0;
    }

    protected boolean hasTwoByTwo(int n) {
        return (this.getFlag(n) & 0x80) != 0;
    }

    protected boolean hasInstructions(int n) {
        return (this.getFlag(n) & 0x100) != 0;
    }

    public boolean useMetrics(int n) {
        return (this.getFlag(n) & 0x200) != 0;
    }

    public boolean overlapCompound(int n) {
        return (this.getFlag(n) & 0x400) != 0;
    }

    void setComponents(GlyfComponent[] glyfComponentArray) {
        this.components = glyfComponentArray;
    }

    public short getNumInstructions() {
        return (short)this.instructions.length;
    }

    public byte getInstruction(int n) {
        return this.instructions[n];
    }

    protected void setInstructions(byte[] byArray) {
        this.instructions = byArray;
    }

    class GlyfComponent {
        short flags;
        short glyphIndex;
        int compoundPoint;
        int componentPoint;
        float a = 1.0f;
        float b = 0.0f;
        float c = 0.0f;
        float d = 1.0f;
        float e = 0.0f;
        float f = 0.0f;

        GlyfComponent() {
        }
    }
}

