/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.font.ttf;

import com.sun.pdfview.font.ttf.TrueTypeTable;
import java.nio.ByteBuffer;

public class PostTable
extends TrueTypeTable {
    private int format;
    private int italicAngle;
    private short underlinePosition;
    private short underlineThickness;
    private short isFixedPitch;
    private int minMemType42;
    private int maxMemType42;
    private int minMemType1;
    private int maxMemType1;
    private PostMap nameMap = new PostMap();

    protected PostTable() {
        super(1886352244);
    }

    public short getGlyphNameIndex(String string) {
        return this.nameMap.getCharIndex(string);
    }

    public String getGlyphName(char c) {
        return this.nameMap.getCharName(c);
    }

    @Override
    public ByteBuffer getData() {
        int n = this.getLength();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putInt(this.getFormat());
        byteBuffer.putInt(this.getItalicAngle());
        byteBuffer.putShort(this.getUnderlinePosition());
        byteBuffer.putShort(this.getUnderlineThickness());
        byteBuffer.putShort(this.getIsFixedPitch());
        byteBuffer.putShort((short)0);
        byteBuffer.putInt(this.getMinMemType42());
        byteBuffer.putInt(this.getMaxMemType42());
        byteBuffer.putInt(this.getMinMemType1());
        byteBuffer.putInt(this.getMaxMemType1());
        byteBuffer.put(this.nameMap.getData());
        byteBuffer.flip();
        return byteBuffer;
    }

    @Override
    public void setData(ByteBuffer byteBuffer) {
        this.setFormat(byteBuffer.getInt());
        this.setItalicAngle(byteBuffer.getInt());
        this.setUnderlinePosition(byteBuffer.getShort());
        this.setUnderlineThickness(byteBuffer.getShort());
        this.setIsFixedPitch(byteBuffer.getShort());
        byteBuffer.getShort();
        this.setMinMemType42(byteBuffer.getInt());
        this.setMaxMemType42(byteBuffer.getInt());
        this.setMinMemType1(byteBuffer.getInt());
        this.setMaxMemType1(byteBuffer.getInt());
        switch (this.format) {
            case 65536: {
                this.nameMap = new PostMapFormat0();
                break;
            }
            case 131072: {
                this.nameMap = new PostMapFormat2();
                break;
            }
            case 196608: {
                this.nameMap = new PostMap();
                break;
            }
            default: {
                this.nameMap = new PostMap();
                System.out.println("Unknown post map type: " + Integer.toHexString(this.format));
            }
        }
        this.nameMap.setData(byteBuffer);
    }

    @Override
    public int getLength() {
        int n = 32;
        if (this.nameMap != null) {
            n += this.nameMap.getLength();
        }
        return n;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public int getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(int n) {
        this.italicAngle = n;
    }

    public short getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlinePosition(short s) {
        this.underlinePosition = s;
    }

    public short getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setUnderlineThickness(short s) {
        this.underlineThickness = s;
    }

    public short getIsFixedPitch() {
        return this.isFixedPitch;
    }

    public void setIsFixedPitch(short s) {
        this.isFixedPitch = s;
    }

    public int getMinMemType42() {
        return this.minMemType42;
    }

    public void setMinMemType42(int n) {
        this.minMemType42 = n;
    }

    public int getMaxMemType42() {
        return this.maxMemType42;
    }

    public void setMaxMemType42(int n) {
        this.maxMemType42 = n;
    }

    public int getMinMemType1() {
        return this.minMemType1;
    }

    public void setMinMemType1(int n) {
        this.minMemType1 = n;
    }

    public int getMaxMemType1() {
        return this.maxMemType1;
    }

    public void setMaxMemType1(int n) {
        this.maxMemType1 = n;
    }

    class PostMapFormat2
    extends PostMapFormat0 {
        short[] glyphNameIndex;
        String[] glyphNames;

        PostMapFormat2() {
        }

        @Override
        short getCharIndex(String string) {
            int n;
            short s = -1;
            for (n = 0; n < this.glyphNames.length; ++n) {
                if (!string.equals(this.glyphNames[n])) continue;
                s = (short)(this.stdNames.length + n);
                break;
            }
            if (s == -1) {
                s = super.getCharIndex(string);
            }
            for (n = 0; n < this.glyphNameIndex.length; ++n) {
                if (this.glyphNameIndex[n] != s) continue;
                return (short)n;
            }
            return 0;
        }

        @Override
        String getCharName(char c) {
            if (c >= this.stdNames.length) {
                return this.glyphNames[c - this.stdNames.length];
            }
            return super.getCharName(c);
        }

        @Override
        int getLength() {
            int n = 2 + 2 * this.glyphNameIndex.length;
            for (int i = 0; i < this.glyphNames.length; ++i) {
                n += this.glyphNames[i].length() + 1;
            }
            return n;
        }

        @Override
        ByteBuffer getData() {
            int n;
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
            byteBuffer.putShort((short)this.glyphNameIndex.length);
            for (n = 0; n < this.glyphNameIndex.length; ++n) {
                byteBuffer.putShort(this.glyphNameIndex[n]);
            }
            for (n = 0; n < this.glyphNames.length; ++n) {
                byteBuffer.put((byte)this.glyphNames[n].length());
                byteBuffer.put(this.glyphNames[n].getBytes());
            }
            byteBuffer.flip();
            return byteBuffer;
        }

        @Override
        void setData(ByteBuffer byteBuffer) {
            int n;
            int n2 = byteBuffer.getShort();
            this.glyphNameIndex = new short[n2];
            int n3 = 257;
            for (n = 0; n < n2; ++n) {
                this.glyphNameIndex[n] = byteBuffer.getShort();
                if (this.glyphNameIndex[n] <= n3) continue;
                n3 = this.glyphNameIndex[n];
            }
            this.glyphNames = new String[n3 -= 257];
            for (n = 0; n < n3; ++n) {
                byte by = byteBuffer.get();
                byte[] byArray = new byte[by];
                byteBuffer.get(byArray);
                this.glyphNames[n] = new String(byArray);
            }
        }
    }

    class PostMapFormat0
    extends PostMap {
        protected final String[] stdNames;

        PostMapFormat0() {
            this.stdNames = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "ackslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
        }

        @Override
        short getCharIndex(String string) {
            for (int i = 0; i < this.stdNames.length; ++i) {
                if (!string.equals(this.stdNames[i])) continue;
                return (short)i;
            }
            return 0;
        }

        @Override
        String getCharName(char c) {
            return this.stdNames[c];
        }

        @Override
        int getLength() {
            return 0;
        }

        @Override
        ByteBuffer getData() {
            return ByteBuffer.allocate(0);
        }

        @Override
        void setData(ByteBuffer byteBuffer) {
        }
    }

    class PostMap {
        PostMap() {
        }

        short getCharIndex(String string) {
            return 0;
        }

        String getCharName(char c) {
            return null;
        }

        int getLength() {
            return 0;
        }

        ByteBuffer getData() {
            return ByteBuffer.allocate(0);
        }

        void setData(ByteBuffer byteBuffer) {
        }
    }
}

