/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.function;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.PDFFunction;
import java.io.IOException;

public class FunctionType2
extends PDFFunction {
    private float[] c0 = new float[]{0.0f};
    private float[] c1 = new float[]{1.0f};
    private float n;

    public FunctionType2() {
        super(2);
    }

    @Override
    protected void parse(PDFObject pDFObject) throws IOException {
        Object[] objectArray;
        Object object;
        PDFObject pDFObject2 = pDFObject.getDictRef("N");
        if (pDFObject2 == null) {
            throw new PDFParseException("Exponent required for function type 2!");
        }
        this.setN(pDFObject2.getFloatValue());
        PDFObject pDFObject3 = pDFObject.getDictRef("C0");
        if (pDFObject3 != null) {
            object = pDFObject3.getArray();
            objectArray = new float[((PDFObject[])object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                objectArray[i] = ((PDFObject)object[i]).getFloatValue();
            }
            this.setC0((float[])objectArray);
        }
        if ((object = pDFObject.getDictRef("C1")) != null) {
            objectArray = ((PDFObject)object).getArray();
            float[] fArray = new float[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                fArray[i] = objectArray[i].getFloatValue();
            }
            this.setC1(fArray);
        }
    }

    @Override
    protected void doFunction(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray[n];
        for (int i = 0; i < this.getNumOutputs(); ++i) {
            fArray2[i + n2] = this.getC0(i) + (float)(Math.pow(f, this.getN()) * (double)(this.getC1(i) - this.getC0(i)));
        }
    }

    public float getN() {
        return this.n;
    }

    protected void setN(float f) {
        this.n = f;
    }

    public float getC0(int n) {
        return this.c0[n];
    }

    protected void setC0(float[] fArray) {
        this.c0 = fArray;
    }

    public float getC1(int n) {
        return this.c1[n];
    }

    protected void setC1(float[] fArray) {
        this.c1 = fArray;
    }
}

