/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.function;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.FunctionType0;
import com.sun.pdfview.function.PDFFunction;
import java.io.IOException;

public class FunctionType3
extends PDFFunction {
    private PDFFunction[] functions;
    private float[] bounds;
    private float[] encode;

    protected FunctionType3() {
        super(3);
    }

    @Override
    protected void parse(PDFObject pDFObject) throws IOException {
        int n;
        if (this.getNumInputs() != 1) {
            throw new PDFParseException("Type 3 function only accepts a single input, so Domain should have just 2 elements");
        }
        PDFObject pDFObject2 = pDFObject.getDictRef("Functions");
        if (pDFObject2 == null) {
            throw new PDFParseException("Functions required for function type 3!");
        }
        PDFObject[] pDFObjectArray = pDFObject2.getArray();
        this.functions = new PDFFunction[pDFObjectArray.length];
        for (n = 0; n < pDFObjectArray.length; ++n) {
            this.functions[n] = PDFFunction.getFunction(pDFObjectArray[n]);
        }
        n = this.functions.length;
        PDFObject pDFObject3 = pDFObject.getDictRef("Domain");
        if (pDFObject3 == null) {
            throw new PDFParseException("domain required for function type 3!");
        }
        PDFObject pDFObject4 = pDFObject.getDictRef("Bounds");
        if (pDFObject4 == null) {
            throw new PDFParseException("Bounds required for function type 3!");
        }
        PDFObject[] pDFObjectArray2 = pDFObject4.getArray();
        if (pDFObjectArray2.length != n - 1) {
            throw new PDFParseException("Bounds array length " + pDFObjectArray2.length + " should be " + (n - 1) + " with functions array length " + this.functions.length);
        }
        this.bounds = new float[pDFObjectArray2.length];
        for (int i = 0; i < pDFObjectArray2.length; ++i) {
            this.bounds[i] = pDFObjectArray2[i].getFloatValue();
        }
        PDFObject pDFObject5 = pDFObject.getDictRef("Encode");
        if (pDFObject5 == null) {
            throw new PDFParseException("Encode required for function type 3!");
        }
        PDFObject[] pDFObjectArray3 = pDFObject5.getArray();
        if (pDFObjectArray3.length != 2 * n) {
            throw new PDFParseException("There should be " + 2 * n + " values in Encode for the given number of functions.");
        }
        this.encode = new float[pDFObjectArray3.length];
        for (int i = 0; i < pDFObjectArray3.length; ++i) {
            this.encode[i] = pDFObjectArray3[i].getFloatValue();
        }
    }

    @Override
    protected void doFunction(float[] fArray, int n, float[] fArray2, int n2) {
        int n3;
        float f = fArray[n];
        for (n3 = 0; n3 < this.bounds.length && f >= this.bounds[n3]; ++n3) {
        }
        float f2 = n3 == 0 ? this.getDomain(0) : this.bounds[n3 - 1];
        float f3 = n3 == this.bounds.length ? this.getDomain(1) : this.bounds[n3];
        float f4 = FunctionType0.interpolate(f, f2, f3, this.encode[n3 * 2], this.encode[n3 * 2 + 1]);
        float[] fArray3 = new float[]{f4};
        this.functions[n3].calculate(fArray3, 0, fArray2, n2);
    }
}

