/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Locale;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.JSignEncryptor;
import net.sf.jsignpdf.SignResultListener;
import net.sf.jsignpdf.types.CertificationLevel;
import net.sf.jsignpdf.types.HashAlgorithm;
import net.sf.jsignpdf.types.PDFEncryption;
import net.sf.jsignpdf.types.PrintRight;
import net.sf.jsignpdf.types.RenderMode;
import net.sf.jsignpdf.types.ServerAuthentication;
import net.sf.jsignpdf.utils.PropertyProvider;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.crypto.CryptoException;

public class BasicSignerOptions {
    protected final PropertyProvider props = PropertyProvider.getInstance();
    protected final JSignEncryptor encryptor = new JSignEncryptor();
    private String propertiesFilePath;
    private String ksType;
    private String ksFile;
    private char[] ksPasswd;
    private String keyAlias;
    private int keyIndex = 0;
    private char[] keyPasswd;
    private String inFile;
    private String outFile;
    private String signerName;
    private String reason;
    private String location;
    private String contact;
    private SignResultListener listener;
    private boolean append = Constants.DEFVAL_APPEND;
    private boolean advanced;
    private PDFEncryption pdfEncryption;
    private char[] pdfOwnerPwd;
    private char[] pdfUserPwd;
    private String pdfEncryptionCertFile;
    private CertificationLevel certLevel;
    private HashAlgorithm hashAlgorithm;
    protected boolean storePasswords;
    private PrintRight rightPrinting;
    private boolean rightCopy;
    private boolean rightAssembly;
    private boolean rightFillIn;
    private boolean rightScreanReaders;
    private boolean rightModifyAnnotations;
    private boolean rightModifyContents;
    private boolean visible;
    private int page = 1;
    private float positionLLX = 0.0f;
    private float positionLLY = 0.0f;
    private float positionURX = 100.0f;
    private float positionURY = 100.0f;
    private float bgImgScale = -1.0f;
    private RenderMode renderMode;
    private String l2Text;
    private String l4Text;
    private float l2TextFontSize = 10.0f;
    private String imgPath;
    private String bgImgPath;
    private boolean acro6Layers = true;
    private boolean timestamp;
    private String tsaUrl;
    private ServerAuthentication tsaServerAuthn;
    private String tsaUser;
    private String tsaPasswd;
    private String tsaCertFileType;
    private String tsaCertFile;
    private String tsaCertFilePwd;
    private String tsaPolicy;
    private String tsaHashAlg;
    private boolean ocspEnabled;
    private String ocspServerUrl;
    private boolean crlEnabled;
    private Proxy.Type proxyType;
    private String proxyHost;
    private int proxyPort;
    private String[] cmdLine;

    public void loadOptions() {
        boolean tmpPasswords;
        if (this.propertiesFilePath != null) {
            this.props.loadProperties(this.propertiesFilePath);
        }
        this.setKsType(this.props.getProperty("keystore.type"));
        this.setAdvanced(this.props.getAsBool("view.advanced"));
        this.setKsFile(this.props.getProperty("keystore.file"));
        this.setKeyAlias(this.props.getProperty("keystore.alias"));
        this.setKeyIndex(this.props.getAsInt("keystore.keyIndex", 0));
        this.setInFile(this.props.getProperty("inpdf.file"));
        this.setOutFile(this.props.getProperty("outpdf.file"));
        this.setReason(this.props.getProperty("signature.reason"));
        this.setLocation(this.props.getProperty("signature.location"));
        this.setContact(this.props.getProperty("signature.contact"));
        this.setAppend(this.props.getAsBool("signature.append"));
        this.setPdfEncryption(this.props.getProperty("pdf.encryption"));
        if (this.pdfEncryption == null && this.props.getAsBool("inpdf.encrypted")) {
            this.setPdfEncryption(PDFEncryption.PASSWORD);
            this.props.removeProperty("inpdf.encrypted");
        }
        this.setPdfEncryptionCertFile(this.props.getProperty("pdf.encryption.publicKeyFile"));
        this.setCertLevel(this.props.getProperty("certification.level"));
        this.setHashAlgorithm(this.props.getProperty("hash.algorithm"));
        this.setRightPrinting(this.props.getProperty("right.printing"));
        this.setRightCopy(this.props.getAsBool("right.copy"));
        this.setRightAssembly(this.props.getAsBool("right.assembly"));
        this.setRightFillIn(this.props.getAsBool("right.fillIn"));
        this.setRightScreanReaders(this.props.getAsBool("right.screenReaders"));
        this.setRightModifyAnnotations(this.props.getAsBool("right.modify.annotations"));
        this.setRightModifyContents(this.props.getAsBool("right.modify.contents"));
        this.setVisible(this.props.getAsBool("visibleSignature.enabled"));
        this.setPage(this.props.getAsInt("visibleSignature.page", 1));
        this.setPositionLLX(this.props.getAsFloat("visibleSignature.llx", 0.0f));
        this.setPositionLLY(this.props.getAsFloat("visibleSignature.lly", 0.0f));
        this.setPositionURX(this.props.getAsFloat("visibleSignature.urx", 100.0f));
        this.setPositionURY(this.props.getAsFloat("visibleSignature.ury", 100.0f));
        this.setBgImgScale(this.props.getAsFloat("visibleSignature.bgScale", -1.0f));
        this.setRenderMode(this.props.getProperty("visibleSignature.render"));
        this.setL2Text(this.props.getPropNullSensitive("visibleSignature.l2text"));
        this.setL2TextFontSize(this.props.getAsFloat("visibleSignature.l2textFontSize", 10.0f));
        this.setL4Text(this.props.getPropNullSensitive("visibleSignature.l4text"));
        this.setImgPath(this.props.getProperty("visibleSignature.img"));
        this.setBgImgPath(this.props.getProperty("visibleSignature.bgImg"));
        this.setAcro6Layers(!this.props.exists("visibleSignature.acro6layers") || this.props.getAsBool("visibleSignature.acro6layers"));
        this.setTimestamp(this.props.getAsBool("tsa.enabled"));
        this.setTsaUrl(this.props.getProperty("tsa.url"));
        this.setTsaUser(this.props.getProperty("tsa.user"));
        this.setTsaServerAuthn(this.props.getProperty("tsa.serverAuthn"));
        if (this.tsaServerAuthn == null && StringUtils.isNotEmpty(this.tsaUser)) {
            this.setTsaServerAuthn(ServerAuthentication.PASSWORD);
        }
        this.setTsaCertFileType(this.props.getProperty("tsa.cert.file.type"));
        this.setTsaCertFile(this.props.getProperty("tsa.cert.file"));
        this.setTsaPolicy(this.props.getProperty("tsa.policy"));
        this.setTsaHashAlg(this.props.getProperty("tsa.hash.algorithm"));
        this.setOcspEnabled(this.props.getAsBool("ocsp.enabled"));
        this.setOcspServerUrl(this.props.getProperty("ocsp.serverUrl"));
        this.setCrlEnabled(this.props.getAsBool("crl.enabled"));
        this.setProxyType(this.props.getProperty("proxy.type"));
        this.setProxyHost(this.props.getProperty("proxy.host"));
        this.setProxyPort(this.props.getAsInt("proxy.port", 80));
        this.storePasswords = this.props.getAsBool("store.passwords");
        String tmpHome = this.getDecrypted("enc.home");
        boolean bl = tmpPasswords = this.storePasswords && Constants.USER_HOME != null && Constants.USER_HOME.equals(tmpHome);
        if (tmpPasswords) {
            this.setKsPasswd(this.getDecrypted("enc.keystorePwd"));
            this.setKeyPasswd(this.getDecrypted("enc.keyPwd"));
            this.setPdfOwnerPwd(this.getDecrypted("enc.pdfOwnerPwd"));
            this.setPdfUserPwd(this.getDecrypted("enc.pdfUserPwd"));
            this.setTsaPasswd(this.getDecrypted("enc.tsa.passwd"));
            this.setTsaCertFilePwd(this.getDecrypted("enc.tsa.cert.file"));
        }
    }

    public void storeOptions() {
        this.props.setProperty("keystore.type", this.getKsType());
        this.props.setProperty("view.advanced", this.isAdvanced());
        this.props.setProperty("keystore.file", this.getKsFile());
        this.props.setProperty("keystore.alias", this.getKeyAlias());
        this.props.setProperty("keystore.keyIndex", this.getKeyIndex());
        this.props.setProperty("inpdf.file", this.getInFile());
        this.props.setProperty("outpdf.file", this.getOutFile());
        this.props.setProperty("signature.reason", this.getReason());
        this.props.setProperty("signature.location", this.getLocation());
        this.props.setProperty("signature.contact", this.getContact());
        this.props.setProperty("signature.append", this.isAppend());
        this.props.setProperty("pdf.encryption", this.getPdfEncryption().name());
        this.props.setProperty("pdf.encryption.publicKeyFile", this.getPdfEncryptionCertFile());
        this.props.setProperty("certification.level", this.getCertLevel().name());
        this.props.setProperty("hash.algorithm", this.getHashAlgorithm().name());
        this.props.setProperty("right.printing", this.getRightPrinting().name());
        this.props.setProperty("right.copy", this.isRightCopy());
        this.props.setProperty("right.assembly", this.isRightAssembly());
        this.props.setProperty("right.fillIn", this.isRightFillIn());
        this.props.setProperty("right.screenReaders", this.isRightScreanReaders());
        this.props.setProperty("right.modify.annotations", this.isRightModifyAnnotations());
        this.props.setProperty("right.modify.contents", this.isRightModifyContents());
        this.props.setProperty("visibleSignature.enabled", this.isVisible());
        this.props.setProperty("visibleSignature.page", this.getPage());
        this.props.setProperty("visibleSignature.llx", this.getPositionLLX());
        this.props.setProperty("visibleSignature.lly", this.getPositionLLY());
        this.props.setProperty("visibleSignature.urx", this.getPositionURX());
        this.props.setProperty("visibleSignature.ury", this.getPositionURY());
        this.props.setProperty("visibleSignature.bgScale", this.getBgImgScale());
        this.props.setProperty("visibleSignature.render", this.getRenderMode().name());
        this.props.setPropNullSensitive("visibleSignature.l2text", this.getL2Text());
        this.props.setProperty("visibleSignature.l2textFontSize", this.getL2TextFontSize());
        this.props.setPropNullSensitive("visibleSignature.l4text", this.getL4Text());
        this.props.setProperty("visibleSignature.img", this.getImgPath());
        this.props.setProperty("visibleSignature.bgImg", this.getBgImgPath());
        this.props.setProperty("visibleSignature.acro6layers", this.isAcro6Layers());
        this.props.setProperty("tsa.enabled", this.isTimestamp());
        this.props.setProperty("tsa.url", this.getTsaUrl());
        this.props.setProperty("tsa.user", this.getTsaUser());
        this.props.setProperty("tsa.cert.file.type", this.getTsaCertFileType());
        this.props.setProperty("tsa.cert.file", this.getTsaCertFile());
        this.props.setProperty("tsa.serverAuthn", this.getTsaServerAuthn().name());
        this.props.setProperty("tsa.policy", this.getTsaPolicy());
        this.props.setProperty("tsa.hash.algorithm", this.getTsaHashAlg());
        this.props.setProperty("ocsp.enabled", this.isOcspEnabled());
        this.props.setProperty("ocsp.serverUrl", this.getOcspServerUrl());
        this.props.setProperty("crl.enabled", this.isCrlEnabled());
        this.props.setProperty("proxy.type", this.getProxyType().name());
        this.props.setProperty("proxy.host", this.getProxyHost());
        this.props.setProperty("proxy.port", this.getProxyPort());
        this.props.setProperty("store.passwords", this.isStorePasswords());
        this.setEncrypted("enc.home", Constants.USER_HOME);
        if (this.isStorePasswords()) {
            this.setEncrypted("enc.keystorePwd", new String(this.getKsPasswd()));
            this.setEncrypted("enc.keyPwd", new String(this.getKeyPasswd()));
            this.setEncrypted("enc.pdfOwnerPwd", new String(this.getPdfOwnerPwd()));
            this.setEncrypted("enc.pdfUserPwd", new String(this.getPdfUserPwd()));
            this.setEncrypted("enc.tsa.passwd", this.getTsaPasswd());
            this.setEncrypted("enc.tsa.cert.file", this.getTsaCertFilePwd());
        } else {
            this.props.removeProperty("enc.keystorePwd");
            this.props.removeProperty("enc.keyPwd");
            this.props.removeProperty("enc.pdfOwnerPwd");
            this.props.removeProperty("enc.pdfUserPwd");
            this.props.removeProperty("enc.tsa.passwd");
            this.props.removeProperty("enc.tsa.cert.file");
        }
        if (this.propertiesFilePath != null) {
            this.props.saveProperties(this.propertiesFilePath);
        } else {
            this.props.saveDefault();
        }
    }

    public void loadCmdLine() throws Exception {
    }

    protected void fireSignerFinishedEvent(Throwable aResult) {
        if (this.listener != null) {
            this.listener.signerFinishedEvent(aResult);
        }
    }

    private String charArrToStr(char[] aCharArr) {
        return aCharArr == null ? "" : new String(aCharArr);
    }

    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    public void setPropertiesFilePath(String propertiesFilePath) {
        this.propertiesFilePath = propertiesFilePath;
    }

    public String getKsType() {
        return this.ksType;
    }

    public void setKsType(String ksType) {
        this.ksType = ksType;
    }

    public String getKsFile() {
        return this.ksFile;
    }

    public void setKsFile(String ksFile) {
        this.ksFile = ksFile;
    }

    public char[] getKsPasswd() {
        return this.ksPasswd;
    }

    public String getKsPasswdStr() {
        return this.charArrToStr(this.ksPasswd);
    }

    public void setKsPasswd(char[] passwd) {
        this.ksPasswd = passwd;
    }

    public void setKsPasswd(String aPasswd) {
        this.setKsPasswd(aPasswd == null ? null : aPasswd.toCharArray());
    }

    public String getInFile() {
        return this.inFile;
    }

    public void setInFile(String inFile) {
        this.inFile = inFile;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public String getOutFileX() {
        String tmpOut = StringUtils.defaultIfBlank(this.outFile, null);
        if (tmpOut == null) {
            String tmpExtension = "";
            String tmpNameBase = StringUtils.defaultIfBlank(this.getInFile(), null);
            if (tmpNameBase == null) {
                tmpOut = "signed.pdf";
            } else {
                if (tmpNameBase.toLowerCase().endsWith(".pdf")) {
                    int tmpBaseLen = tmpNameBase.length() - 4;
                    tmpExtension = tmpNameBase.substring(tmpBaseLen);
                    tmpNameBase = tmpNameBase.substring(0, tmpBaseLen);
                }
                tmpOut = tmpNameBase + "_signed" + tmpExtension;
            }
        }
        return tmpOut;
    }

    public void setOutFile(String outFile) {
        this.outFile = outFile;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public SignResultListener getListener() {
        return this.listener;
    }

    public void setListener(SignResultListener listener) {
        this.listener = listener;
    }

    public char[] getKeyPasswd() {
        return this.keyPasswd;
    }

    public char[] getKeyPasswdX() {
        if (this.keyPasswd != null && this.keyPasswd.length == 0) {
            this.keyPasswd = null;
        }
        return this.advanced && this.keyPasswd != null ? this.keyPasswd : this.ksPasswd;
    }

    public String getKeyPasswdStr() {
        return this.charArrToStr(this.keyPasswd);
    }

    public void setKeyPasswd(char[] keyPasswd) {
        this.keyPasswd = keyPasswd;
    }

    public void setKeyPasswd(String aPasswd) {
        this.setKeyPasswd(aPasswd == null ? null : aPasswd.toCharArray());
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public String getKeyAliasX() {
        return this.advanced ? this.keyAlias : null;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public int getKeyIndexX() {
        return this.advanced ? this.keyIndex : 0;
    }

    public void setKeyIndex(int anIndex) {
        this.keyIndex = anIndex;
        if (this.keyIndex < 0) {
            this.keyIndex = 0;
        }
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isAppendX() {
        return this.getPdfEncryption() == PDFEncryption.NONE && (!Constants.DEFVAL_APPEND && this.advanced && this.append || Constants.DEFVAL_APPEND && (this.append || !this.advanced));
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public PDFEncryption getPdfEncryption() {
        if (this.pdfEncryption == null) {
            this.pdfEncryption = PDFEncryption.NONE;
        }
        return this.pdfEncryption;
    }

    public void setPdfEncryption(PDFEncryption pdfEncryption) {
        this.pdfEncryption = pdfEncryption;
    }

    public void setPdfEncryption(String aValue) {
        PDFEncryption enumInstance = null;
        if (aValue != null) {
            try {
                enumInstance = PDFEncryption.valueOf(aValue.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setPdfEncryption(enumInstance);
    }

    public char[] getPdfOwnerPwd() {
        return this.pdfOwnerPwd;
    }

    public String getPdfOwnerPwdStr() {
        return this.charArrToStr(this.pdfOwnerPwd);
    }

    public String getPdfOwnerPwdStrX() {
        return this.charArrToStr(this.advanced ? this.pdfOwnerPwd : null);
    }

    public void setPdfOwnerPwd(char[] pdfOwnerPwd) {
        this.pdfOwnerPwd = pdfOwnerPwd;
    }

    public String getPdfEncryptionCertFile() {
        return this.pdfEncryptionCertFile;
    }

    public void setPdfEncryptionCertFile(String pdfEncryptionCertFile) {
        this.pdfEncryptionCertFile = pdfEncryptionCertFile;
    }

    public void setPdfOwnerPwd(String aPasswd) {
        this.setPdfOwnerPwd(aPasswd == null ? null : aPasswd.toCharArray());
    }

    public char[] getPdfUserPwd() {
        return this.pdfUserPwd;
    }

    public String getPdfUserPwdStr() {
        return this.charArrToStr(this.pdfUserPwd);
    }

    public void setPdfUserPwd(char[] pdfUserPwd) {
        this.pdfUserPwd = pdfUserPwd;
    }

    public void setPdfUserPwd(String aPasswd) {
        this.setPdfUserPwd(aPasswd == null ? null : aPasswd.toCharArray());
    }

    public CertificationLevel getCertLevel() {
        if (this.certLevel == null) {
            this.certLevel = CertificationLevel.NOT_CERTIFIED;
        }
        return this.certLevel;
    }

    public CertificationLevel getCertLevelX() {
        return this.advanced ? this.getCertLevel() : CertificationLevel.NOT_CERTIFIED;
    }

    public void setCertLevel(CertificationLevel aCertLevel) {
        this.certLevel = aCertLevel;
    }

    public void setCertLevel(String aValue) {
        CertificationLevel certLevel = null;
        if (aValue != null) {
            try {
                certLevel = CertificationLevel.valueOf(aValue.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setCertLevel(certLevel);
    }

    public boolean isRightCopy() {
        return this.rightCopy;
    }

    public void setRightCopy(boolean rightCopy) {
        this.rightCopy = rightCopy;
    }

    public boolean isRightAssembly() {
        return this.rightAssembly;
    }

    public void setRightAssembly(boolean rightAssembly) {
        this.rightAssembly = rightAssembly;
    }

    public boolean isRightFillIn() {
        return this.rightFillIn;
    }

    public void setRightFillIn(boolean rightFillIn) {
        this.rightFillIn = rightFillIn;
    }

    public boolean isRightScreanReaders() {
        return this.rightScreanReaders;
    }

    public void setRightScreanReaders(boolean rightScreanReaders) {
        this.rightScreanReaders = rightScreanReaders;
    }

    public boolean isRightModifyAnnotations() {
        return this.rightModifyAnnotations;
    }

    public void setRightModifyAnnotations(boolean rightModifyAnnotations) {
        this.rightModifyAnnotations = rightModifyAnnotations;
    }

    public boolean isRightModifyContents() {
        return this.rightModifyContents;
    }

    public void setRightModifyContents(boolean rightModifyContents) {
        this.rightModifyContents = rightModifyContents;
    }

    public PrintRight getRightPrinting() {
        if (this.rightPrinting == null) {
            this.rightPrinting = PrintRight.ALLOW_PRINTING;
        }
        return this.rightPrinting;
    }

    public void setRightPrinting(PrintRight rightPrinting) {
        this.rightPrinting = rightPrinting;
    }

    public void setRightPrinting(String aValue) {
        PrintRight printRight = null;
        if (aValue != null) {
            try {
                printRight = PrintRight.valueOf(aValue.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setRightPrinting(printRight);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int aPage) {
        this.page = aPage;
    }

    public float getPositionLLX() {
        return this.positionLLX;
    }

    public void setPositionLLX(float positionLLX) {
        this.positionLLX = positionLLX;
    }

    public float getPositionLLY() {
        return this.positionLLY;
    }

    public void setPositionLLY(float positionLLY) {
        this.positionLLY = positionLLY;
    }

    public float getPositionURX() {
        return this.positionURX;
    }

    public void setPositionURX(float positionURX) {
        this.positionURX = positionURX;
    }

    public float getPositionURY() {
        return this.positionURY;
    }

    public void setPositionURY(float positionURY) {
        this.positionURY = positionURY;
    }

    public float getBgImgScale() {
        return this.bgImgScale;
    }

    public void setBgImgScale(float bgImgScale) {
        this.bgImgScale = bgImgScale;
    }

    public RenderMode getRenderMode() {
        if (this.renderMode == null) {
            this.renderMode = RenderMode.DESCRIPTION_ONLY;
        }
        return this.renderMode;
    }

    public void setRenderMode(RenderMode renderMode) {
        this.renderMode = renderMode;
    }

    public void setRenderMode(String aValue) {
        RenderMode renderMode = null;
        if (aValue != null) {
            try {
                renderMode = RenderMode.valueOf(aValue.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setRenderMode(renderMode);
    }

    public String getL2Text() {
        return this.l2Text;
    }

    public void setL2Text(String text) {
        this.l2Text = text;
    }

    public String getL4Text() {
        return this.l4Text;
    }

    public void setL4Text(String text) {
        this.l4Text = text;
    }

    public String getImgPath() {
        this.imgPath = StringUtils.defaultIfBlank(this.imgPath, null);
        return this.imgPath;
    }

    public void setImgPath(String imgPath) {
        this.imgPath = imgPath;
    }

    public String getBgImgPath() {
        this.bgImgPath = StringUtils.defaultIfBlank(this.bgImgPath, null);
        return this.bgImgPath;
    }

    public void setBgImgPath(String bgImgPath) {
        this.bgImgPath = bgImgPath;
    }

    public float getL2TextFontSize() {
        if (this.l2TextFontSize <= 0.0f) {
            this.l2TextFontSize = 10.0f;
        }
        return this.l2TextFontSize;
    }

    public void setL2TextFontSize(float textFontSize) {
        this.l2TextFontSize = textFontSize;
    }

    public boolean isAcro6Layers() {
        return this.acro6Layers;
    }

    public void setAcro6Layers(boolean acro6Layers) {
        this.acro6Layers = acro6Layers;
    }

    protected String getDecrypted(String aProperty) {
        try {
            return this.encryptor.decryptString(this.props.getProperty(aProperty));
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void setEncrypted(String aProperty, String aValue) {
        try {
            this.props.setProperty(aProperty, this.encryptor.encryptString(aValue));
        }
        catch (CryptoException e) {
            e.printStackTrace();
            this.props.removeProperty(aProperty);
        }
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public boolean isTimestampX() {
        return this.advanced && this.timestamp;
    }

    public void setTimestamp(boolean timestamp) {
        this.timestamp = timestamp;
    }

    public String getTsaUrl() {
        return this.tsaUrl;
    }

    public void setTsaUrl(String tsaUrl) {
        this.tsaUrl = tsaUrl;
    }

    public String getTsaUser() {
        return this.tsaUser;
    }

    public void setTsaUser(String tsaUser) {
        this.tsaUser = tsaUser;
    }

    public ServerAuthentication getTsaServerAuthn() {
        if (this.tsaServerAuthn == null) {
            this.tsaServerAuthn = ServerAuthentication.NONE;
        }
        return this.tsaServerAuthn;
    }

    public void setTsaServerAuthn(ServerAuthentication tsaServerAuthn) {
        this.tsaServerAuthn = tsaServerAuthn;
    }

    public void setTsaServerAuthn(String aValue) {
        ServerAuthentication enumInstance = null;
        if (aValue != null) {
            try {
                enumInstance = ServerAuthentication.valueOf(aValue.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setTsaServerAuthn(enumInstance);
    }

    public String getTsaCertFileType() {
        return this.tsaCertFileType;
    }

    public void setTsaCertFileType(String tsaCertFileType) {
        this.tsaCertFileType = tsaCertFileType;
    }

    public String getTsaCertFile() {
        return this.tsaCertFile;
    }

    public void setTsaCertFile(String tsaCertFile) {
        this.tsaCertFile = tsaCertFile;
    }

    public String getTsaCertFilePwd() {
        return this.tsaCertFilePwd;
    }

    public void setTsaCertFilePwd(String tsaCertFilePwd) {
        this.tsaCertFilePwd = tsaCertFilePwd;
    }

    public String getTsaPolicy() {
        return this.tsaPolicy;
    }

    public void setTsaPolicy(String tsaPolicy) {
        this.tsaPolicy = tsaPolicy;
    }

    public String getTsaHashAlg() {
        return this.tsaHashAlg;
    }

    public String getTsaHashAlgWithFallback() {
        return StringUtils.defaultIfBlank(this.tsaHashAlg, Constants.DEFVAL_TSA_HASH_ALG);
    }

    public void setTsaHashAlg(String tsaHashAlg) {
        this.tsaHashAlg = tsaHashAlg;
    }

    public String getTsaPasswd() {
        return this.tsaPasswd;
    }

    public void setTsaPasswd(String tsaPasswd) {
        this.tsaPasswd = tsaPasswd;
    }

    public boolean isOcspEnabled() {
        return this.ocspEnabled;
    }

    public boolean isOcspEnabledX() {
        return this.advanced && this.ocspEnabled;
    }

    public void setOcspEnabled(boolean ocspEnabled) {
        this.ocspEnabled = ocspEnabled;
    }

    public String getOcspServerUrl() {
        return this.ocspServerUrl;
    }

    public void setOcspServerUrl(String ocspServerUrl) {
        this.ocspServerUrl = ocspServerUrl;
    }

    public boolean isStorePasswords() {
        return this.storePasswords;
    }

    public void setStorePasswords(boolean storePasswords) {
        this.storePasswords = storePasswords;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public boolean isCrlEnabled() {
        return this.crlEnabled;
    }

    public boolean isCrlEnabledX() {
        return this.advanced && this.crlEnabled;
    }

    public void setCrlEnabled(boolean crlEnabled) {
        this.crlEnabled = crlEnabled;
    }

    public HashAlgorithm getHashAlgorithm() {
        if (this.hashAlgorithm == null) {
            this.hashAlgorithm = Constants.DEFVAL_HASH_ALGORITHM;
        }
        return this.hashAlgorithm;
    }

    public HashAlgorithm getHashAlgorithmX() {
        if (!this.advanced) {
            return Constants.DEFVAL_HASH_ALGORITHM;
        }
        return this.getHashAlgorithm();
    }

    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public void setHashAlgorithm(String aValue) {
        HashAlgorithm hashAlg = null;
        if (StringUtils.isNotEmpty(aValue)) {
            try {
                hashAlg = HashAlgorithm.valueOf(aValue.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setHashAlgorithm(hashAlg);
    }

    public Proxy.Type getProxyType() {
        if (this.proxyType == null) {
            this.proxyType = Constants.DEFVAL_PROXY_TYPE;
        }
        return this.proxyType;
    }

    public void setProxyType(Proxy.Type proxyType) {
        this.proxyType = proxyType;
    }

    public void setProxyType(String aValue) {
        Proxy.Type proxy = null;
        if (StringUtils.isNotEmpty(aValue)) {
            try {
                proxy = Proxy.Type.valueOf(aValue.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setProxyType(proxy);
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Proxy createProxy() {
        Proxy tmpResult = Proxy.NO_PROXY;
        if (this.isAdvanced() && this.getProxyType() != Proxy.Type.DIRECT) {
            tmpResult = new Proxy(this.getProxyType(), new InetSocketAddress(this.getProxyHost(), this.getProxyPort()));
        }
        return tmpResult;
    }

    protected String[] getCmdLine() {
        return this.cmdLine;
    }

    protected void setCmdLine(String[] cmdLine) {
        this.cmdLine = cmdLine;
    }
}

