/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.net.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.types.CertificationLevel;
import net.sf.jsignpdf.types.HashAlgorithm;
import net.sf.jsignpdf.types.PDFEncryption;
import net.sf.jsignpdf.types.PrintRight;
import net.sf.jsignpdf.types.RenderMode;
import net.sf.jsignpdf.types.ServerAuthentication;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SignerOptionsFromCmdLine
extends BasicSignerOptions {
    static final Options OPTS = new Options();
    private String outPrefix;
    private String outSuffix = "_signed";
    private String outPath;
    private String[] files;
    private boolean printHelp = true;
    private boolean printVersion;
    private boolean listKeyStores;
    private boolean listKeys;
    private boolean gui;

    @Override
    public void loadCmdLine() throws ParseException {
        String[] cmdLine = this.getCmdLine();
        if (cmdLine == null) {
            return;
        }
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(OPTS, cmdLine);
        if (line.hasOption("lpf")) {
            if (!line.hasOption("lp")) {
                this.props.clear();
            }
            this.props.loadProperties(line.getOptionValue("lpf"));
        }
        this.setAdvanced(true);
        if (line.hasOption("lp") || line.hasOption("lpf")) {
            this.loadOptions();
        }
        if (line.hasOption("q")) {
            Constants.LOGGER.setLevel(Level.OFF);
            Logger.getGlobal().setLevel(Level.OFF);
        }
        this.setFiles(line.getArgs());
        this.setPrintHelp(line.hasOption("h"));
        this.setPrintVersion(line.hasOption("v"));
        this.setListKeyStores(line.hasOption("lkt"));
        this.setListKeys(line.hasOption("lk"));
        if (line.hasOption("kst")) {
            this.setKsType(line.getOptionValue("kst"));
        }
        if (line.hasOption("ksf")) {
            this.setKsFile(line.getOptionValue("ksf"));
        }
        if (line.hasOption("ksp")) {
            this.setKsPasswd(line.getOptionValue("ksp"));
        }
        if (line.hasOption("ka")) {
            this.setKeyAlias(line.getOptionValue("ka"));
        }
        if (line.hasOption("ki")) {
            this.setKeyIndex(this.getInt(line.getParsedOptionValue("ki"), this.getKeyIndex()));
        }
        if (line.hasOption("kp")) {
            this.setKeyPasswd(line.getOptionValue("kp"));
        }
        if (line.hasOption("d")) {
            this.setOutPath(line.getOptionValue("d"));
        }
        if (line.hasOption("op")) {
            this.setOutPrefix(line.getOptionValue("op"));
        }
        if (line.hasOption("os")) {
            this.setOutSuffix(line.getOptionValue("os"));
        }
        if (line.hasOption("sn")) {
            this.setSignerName(line.getOptionValue("sn"));
        }
        if (line.hasOption("r")) {
            this.setReason(line.getOptionValue("r"));
        }
        if (line.hasOption("l")) {
            this.setLocation(line.getOptionValue("l"));
        }
        if (line.hasOption("c")) {
            this.setContact(line.getOptionValue("c"));
        }
        this.setAppend(line.hasOption("a"));
        if (line.hasOption("cl")) {
            this.setCertLevel(line.getOptionValue("cl"));
        }
        if (line.hasOption("ha")) {
            this.setHashAlgorithm(line.getOptionValue("ha"));
        }
        if (line.hasOption("e")) {
            this.setPdfEncryption(PDFEncryption.PASSWORD);
        }
        if (line.hasOption("pe")) {
            this.setPdfEncryption(line.getOptionValue("pe"));
        }
        if (line.hasOption("opwd")) {
            this.setPdfOwnerPwd(line.getOptionValue("opwd"));
        }
        if (line.hasOption("upwd")) {
            this.setPdfUserPwd(line.getOptionValue("upwd"));
        }
        if (line.hasOption("ec")) {
            this.setPdfEncryptionCertFile(line.getOptionValue("ec"));
        }
        if (line.hasOption("pr")) {
            this.setRightPrinting(line.getOptionValue("pr"));
        }
        this.setRightCopy(!line.hasOption("disable-copy"));
        this.setRightAssembly(!line.hasOption("disable-assembly"));
        this.setRightFillIn(!line.hasOption("disable-fill"));
        this.setRightScreanReaders(!line.hasOption("disable-screen-readers"));
        this.setRightModifyAnnotations(!line.hasOption("disable-modify-annotations"));
        this.setRightModifyContents(!line.hasOption("disable-modify-content"));
        if (line.hasOption("V")) {
            this.setVisible(true);
        }
        if (line.hasOption("pg")) {
            this.setPage(this.getInt(line.getParsedOptionValue("pg"), this.getPage()));
        }
        if (line.hasOption("llx")) {
            this.setPositionLLX(this.getFloat(line.getParsedOptionValue("llx"), this.getPositionLLX()));
        }
        if (line.hasOption("lly")) {
            this.setPositionLLY(this.getFloat(line.getParsedOptionValue("lly"), this.getPositionLLY()));
        }
        if (line.hasOption("urx")) {
            this.setPositionURX(this.getFloat(line.getParsedOptionValue("urx"), this.getPositionURX()));
        }
        if (line.hasOption("ury")) {
            this.setPositionURY(this.getFloat(line.getParsedOptionValue("ury"), this.getPositionURY()));
        }
        if (line.hasOption("bg-scale")) {
            this.setBgImgScale(this.getFloat(line.getParsedOptionValue("bg-scale"), this.getBgImgScale()));
        }
        if (line.hasOption("render-mode")) {
            this.setRenderMode(line.getOptionValue("render-mode"));
        }
        if (line.hasOption("l2-text")) {
            this.setL2Text(line.getOptionValue("l2-text"));
        }
        if (line.hasOption("fs")) {
            this.setL2TextFontSize(this.getFloat(line.getParsedOptionValue("fs"), this.getL2TextFontSize()));
        }
        if (line.hasOption("l4-text")) {
            this.setL4Text(line.getOptionValue("l4-text"));
        }
        if (line.hasOption("img-path")) {
            this.setImgPath(line.getOptionValue("img-path"));
        }
        if (line.hasOption("bg-path")) {
            this.setBgImgPath(line.getOptionValue("bg-path"));
        }
        this.setAcro6Layers(!line.hasOption("disable-acrobat6-layer-mode"));
        if (line.hasOption("ts")) {
            this.setTimestamp(true);
            this.setTsaUrl(line.getOptionValue("ts"));
        }
        if (line.hasOption("ta")) {
            this.setTsaServerAuthn(line.getOptionValue("ta"));
        }
        if (line.hasOption("tsct")) {
            this.setTsaCertFileType(line.getOptionValue("tsct"));
        }
        if (line.hasOption("tscf")) {
            this.setTsaCertFile(line.getOptionValue("tscf"));
        }
        if (line.hasOption("tscp")) {
            this.setTsaCertFilePwd(line.getOptionValue("tscp"));
        }
        if (line.hasOption("tsu")) {
            this.setTsaUser(line.getOptionValue("tsu"));
        }
        if (line.hasOption("tsp")) {
            this.setTsaPasswd(line.getOptionValue("tsp"));
        }
        if (line.hasOption("tsa-policy-oid")) {
            this.setTsaPolicy(line.getOptionValue("tsa-policy-oid"));
        }
        if (line.hasOption("tsh")) {
            this.setTsaHashAlg(line.getOptionValue("tsh"));
        }
        if (line.hasOption("ocsp")) {
            this.setOcspEnabled(true);
        }
        if (line.hasOption("ocsp-server-url")) {
            this.setOcspServerUrl(line.getOptionValue("ocsp-server-url"));
        }
        if (line.hasOption("crl")) {
            this.setCrlEnabled(true);
        }
        if (line.hasOption("proxy-type")) {
            this.setProxyType(line.getOptionValue("proxy-type"));
        }
        if (line.hasOption("proxy-host")) {
            this.setProxyHost(line.getOptionValue("proxy-host"));
        }
        if (line.hasOption("proxy-port")) {
            this.setProxyPort(this.getInt(line.getParsedOptionValue("proxy-port"), this.getProxyPort()));
        }
        this.setGui(line.hasOption("gui"));
        if (ArrayUtils.isNotEmpty(this.files)) {
            this.setInFile(this.files[0]);
        }
    }

    private int getInt(Object aVal, int aDefVal) {
        if (aVal instanceof Number) {
            return ((Number)aVal).intValue();
        }
        return aDefVal;
    }

    private float getFloat(Object aVal, float aDefVal) {
        if (aVal instanceof Number) {
            return ((Number)aVal).floatValue();
        }
        return aDefVal;
    }

    public String getOutPrefix() {
        if (this.outPrefix == null) {
            this.outPrefix = "";
        }
        return this.outPrefix;
    }

    private static String getEnumValues(Enum<?>[] aEnumVals) {
        StringBuilder tmpResult = new StringBuilder();
        boolean tmpFirst = true;
        for (Enum<?> tmpEnu : aEnumVals) {
            if (tmpFirst) {
                tmpFirst = false;
            } else {
                tmpResult.append(", ");
            }
            tmpResult.append(tmpEnu.name());
        }
        return tmpResult.toString();
    }

    public void setOutPrefix(String outPrefix) {
        this.outPrefix = outPrefix;
    }

    public String getOutSuffix() {
        if (this.outSuffix == null) {
            this.outSuffix = "";
        }
        return this.outSuffix;
    }

    public void setOutSuffix(String outSuffix) {
        this.outSuffix = outSuffix;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public boolean isPrintHelp() {
        return this.printHelp;
    }

    public void setPrintHelp(boolean printHelp) {
        this.printHelp = printHelp;
    }

    public boolean isPrintVersion() {
        return this.printVersion;
    }

    public void setPrintVersion(boolean printVersion) {
        this.printVersion = printVersion;
    }

    public boolean isListKeyStores() {
        return this.listKeyStores;
    }

    public void setListKeyStores(boolean listKeyStores) {
        this.listKeyStores = listKeyStores;
    }

    public boolean isListKeys() {
        return this.listKeys;
    }

    public void setListKeys(boolean listKeys) {
        this.listKeys = listKeys;
    }

    public String getOutPath() {
        String tmpResult;
        if (StringUtils.isEmpty(this.outPath)) {
            tmpResult = "./";
        } else {
            tmpResult = this.outPath.replaceAll("\\\\", "/");
            if (!tmpResult.endsWith("/")) {
                tmpResult = tmpResult + "/";
            }
        }
        return tmpResult;
    }

    public void setOutPath(String outPath) {
        this.outPath = outPath;
    }

    public boolean isGui() {
        return this.gui;
    }

    public void setGui(boolean gui) {
        this.gui = gui;
    }

    static {
        OptionBuilder.withLongOpt("help");
        OptionBuilder.create();
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription(Constants.RES.get("hlp.help"));
        OPTS.addOption(OptionBuilder.create("h"));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription(Constants.RES.get("hlp.version"));
        OPTS.addOption(OptionBuilder.create("v"));
        OptionBuilder.withLongOpt("load-properties");
        OptionBuilder.withDescription(Constants.RES.get("hlp.loadProperties"));
        OPTS.addOption(OptionBuilder.create("lp"));
        OptionBuilder.withLongOpt("load-properties-file");
        OptionBuilder.withDescription(Constants.RES.get("hlp.loadPropertiesFile"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OPTS.addOption(OptionBuilder.create("lpf"));
        OptionBuilder.withLongOpt("list-keystore-types");
        OptionBuilder.withDescription(Constants.RES.get("hlp.listKsTypes"));
        OPTS.addOption(OptionBuilder.create("lkt"));
        OptionBuilder.withLongOpt("list-keys");
        OptionBuilder.withDescription(Constants.RES.get("hlp.listKeys"));
        OPTS.addOption(OptionBuilder.create("lk"));
        OptionBuilder.withLongOpt("keystore-type");
        OptionBuilder.withDescription(Constants.RES.get("hlp.ksType"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("type");
        OPTS.addOption(OptionBuilder.create("kst"));
        OptionBuilder.withLongOpt("keystore-file");
        OptionBuilder.withDescription(Constants.RES.get("hlp.ksFile"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OPTS.addOption(OptionBuilder.create("ksf"));
        OptionBuilder.withLongOpt("keystore-password");
        OptionBuilder.withDescription(Constants.RES.get("hlp.ksPwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("password");
        OPTS.addOption(OptionBuilder.create("ksp"));
        OptionBuilder.withLongOpt("key-alias");
        OptionBuilder.withDescription(Constants.RES.get("hlp.keyAlias"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("alias");
        OPTS.addOption(OptionBuilder.create("ka"));
        OptionBuilder.withLongOpt("key-index");
        OptionBuilder.withDescription(Constants.RES.get("hlp.keyIndex"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("index");
        OPTS.addOption(OptionBuilder.create("ki"));
        OptionBuilder.withLongOpt("key-password");
        OptionBuilder.withDescription(Constants.RES.get("hlp.keyPwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("password");
        OPTS.addOption(OptionBuilder.create("kp"));
        OptionBuilder.withLongOpt("out-directory");
        OptionBuilder.withDescription(Constants.RES.get("hlp.outPath"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("path");
        OPTS.addOption(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("out-prefix");
        OptionBuilder.withDescription(Constants.RES.get("hlp.outPrefix"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("prefix");
        OPTS.addOption(OptionBuilder.create("op"));
        OptionBuilder.withLongOpt("out-suffix");
        OptionBuilder.withDescription(Constants.RES.get("hlp.outSuffix"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("suffix");
        OPTS.addOption(OptionBuilder.create("os"));
        OptionBuilder.withLongOpt("signer-name");
        OptionBuilder.withDescription(Constants.RES.get("hlp.signerName"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("signer");
        OPTS.addOption(OptionBuilder.create("sn"));
        OptionBuilder.withLongOpt("reason");
        OptionBuilder.withDescription(Constants.RES.get("hlp.reason"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("reason");
        OPTS.addOption(OptionBuilder.create("r"));
        OptionBuilder.withLongOpt("location");
        OptionBuilder.withDescription(Constants.RES.get("hlp.location"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("location");
        OPTS.addOption(OptionBuilder.create("l"));
        OptionBuilder.withLongOpt("contact");
        OptionBuilder.withDescription(Constants.RES.get("hlp.contact"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("contact");
        OPTS.addOption(OptionBuilder.create("c"));
        OptionBuilder.withLongOpt("append");
        OptionBuilder.withDescription(Constants.RES.get("hlp.append"));
        OPTS.addOption(OptionBuilder.create("a"));
        OptionBuilder.withLongOpt("certification-level");
        OptionBuilder.withDescription(Constants.RES.get("hlp.certLevel", SignerOptionsFromCmdLine.getEnumValues(CertificationLevel.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("level");
        OPTS.addOption(OptionBuilder.create("cl"));
        OptionBuilder.withLongOpt("hash-algorithm");
        OptionBuilder.withDescription(Constants.RES.get("hlp.hashAlgorithm", SignerOptionsFromCmdLine.getEnumValues(HashAlgorithm.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("algorithm");
        OPTS.addOption(OptionBuilder.create("ha"));
        OptionBuilder.withLongOpt("quiet");
        OptionBuilder.withDescription(Constants.RES.get("hlp.quiet"));
        OPTS.addOption(OptionBuilder.create("q"));
        OptionBuilder.withLongOpt("encrypted");
        OptionBuilder.withDescription(Constants.RES.get("hlp.encrypted"));
        OPTS.addOption(OptionBuilder.create("e"));
        OptionBuilder.withLongOpt("encryption");
        OptionBuilder.withDescription(Constants.RES.get("hlp.encryption", SignerOptionsFromCmdLine.getEnumValues(PDFEncryption.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("mode");
        OPTS.addOption(OptionBuilder.create("pe"));
        OptionBuilder.withLongOpt("owner-password");
        OptionBuilder.withDescription(Constants.RES.get("hlp.ownerpwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("password");
        OPTS.addOption(OptionBuilder.create("opwd"));
        OptionBuilder.withLongOpt("user-password");
        OptionBuilder.withDescription(Constants.RES.get("hlp.userpwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("password");
        OPTS.addOption(OptionBuilder.create("upwd"));
        OptionBuilder.withLongOpt("encryption-certificate");
        OptionBuilder.withDescription(Constants.RES.get("hlp.encCert"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OPTS.addOption(OptionBuilder.create("ec"));
        OptionBuilder.withLongOpt("print-right");
        OptionBuilder.withDescription(Constants.RES.get("hlp.printRight", SignerOptionsFromCmdLine.getEnumValues(PrintRight.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("right");
        OPTS.addOption(OptionBuilder.create("pr"));
        OptionBuilder.withLongOpt("disable-copy");
        OptionBuilder.withDescription(Constants.RES.get("hlp.disableCopy"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("disable-assembly");
        OptionBuilder.withDescription(Constants.RES.get("hlp.disableAssembly"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("disable-fill");
        OptionBuilder.withDescription(Constants.RES.get("hlp.disableFill"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("disable-screen-readers");
        OptionBuilder.withDescription(Constants.RES.get("hlp.disableScrRead"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("disable-modify-annotations");
        OptionBuilder.withDescription(Constants.RES.get("hlp.disableAnnot"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("disable-modify-content");
        OptionBuilder.withDescription(Constants.RES.get("hlp.disableContent"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("visible-signature");
        OptionBuilder.withDescription(Constants.RES.get("hlp.visible"));
        OPTS.addOption(OptionBuilder.create("V"));
        OptionBuilder.withLongOpt("page");
        OptionBuilder.withDescription(Constants.RES.get("hlp.page"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("pageNumber");
        OPTS.addOption(OptionBuilder.create("pg"));
        OptionBuilder.withDescription(Constants.RES.get("hlp.posLLX"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("position");
        OPTS.addOption(OptionBuilder.create("llx"));
        OptionBuilder.withDescription(Constants.RES.get("hlp.posLLY"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("position");
        OPTS.addOption(OptionBuilder.create("lly"));
        OptionBuilder.withDescription(Constants.RES.get("hlp.posURX"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("position");
        OPTS.addOption(OptionBuilder.create("urx"));
        OptionBuilder.withDescription(Constants.RES.get("hlp.posURY"));
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("position");
        OPTS.addOption(OptionBuilder.create("ury"));
        OptionBuilder.withDescription(Constants.RES.get("hlp.imgPath"));
        OptionBuilder.withLongOpt("img-path");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.bgPath"));
        OptionBuilder.withLongOpt("bg-path");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.bgScale"));
        OptionBuilder.withLongOpt("bg-scale");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("scale");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.disableAcro6Layers"));
        OptionBuilder.withLongOpt("disable-acrobat6-layer-mode");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.renderMode", SignerOptionsFromCmdLine.getEnumValues(RenderMode.values())));
        OptionBuilder.withLongOpt("render-mode");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("mode");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.l2Text"));
        OptionBuilder.withLongOpt("l2-text");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("text");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.l2TextFontSize", String.valueOf(10.0f)));
        OptionBuilder.withLongOpt("font-size");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("size");
        OPTS.addOption(OptionBuilder.create("fs"));
        OptionBuilder.withDescription(Constants.RES.get("hlp.l4Text"));
        OptionBuilder.withLongOpt("l4-text");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("text");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("tsa-server-url");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaUrl"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("URL");
        OPTS.addOption(OptionBuilder.create("ts"));
        OptionBuilder.withLongOpt("tsa-authentication");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaAuthn", SignerOptionsFromCmdLine.getEnumValues(ServerAuthentication.values())));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("method");
        OPTS.addOption(OptionBuilder.create("ta"));
        OptionBuilder.withLongOpt("tsa-cert-file-type");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaCertFileType"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("ks-type");
        OPTS.addOption(OptionBuilder.create("tsct"));
        OptionBuilder.withLongOpt("tsa-cert-file");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaCertFile"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("file");
        OPTS.addOption(OptionBuilder.create("tscf"));
        OptionBuilder.withLongOpt("tsa-cert-password");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaCertPasswd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("password");
        OPTS.addOption(OptionBuilder.create("tscp"));
        OptionBuilder.withLongOpt("tsa-user");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaUser"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("username");
        OPTS.addOption(OptionBuilder.create("tsu"));
        OptionBuilder.withLongOpt("tsa-password");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaPwd"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("password");
        OPTS.addOption(OptionBuilder.create("tsp"));
        OptionBuilder.withLongOpt("tsa-policy-oid");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaPolicy"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("policyOID");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("tsa-hash-algorithm");
        OptionBuilder.withDescription(Constants.RES.get("hlp.tsaHashAlg", Constants.DEFVAL_TSA_HASH_ALG));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("algorithm");
        OPTS.addOption(OptionBuilder.create("tsh"));
        OptionBuilder.withLongOpt("ocsp");
        OptionBuilder.withDescription(Constants.RES.get("hlp.ocsp"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("ocsp-server-url");
        OptionBuilder.withDescription(Constants.RES.get("hlp.ocspServerUrl"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("responderUrl");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("crl");
        OptionBuilder.withDescription(Constants.RES.get("hlp.crl"));
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.proxyType", Constants.DEFVAL_PROXY_TYPE.name(), SignerOptionsFromCmdLine.getEnumValues(Proxy.Type.values())));
        OptionBuilder.withLongOpt("proxy-type");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("type");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.proxyHost"));
        OptionBuilder.withLongOpt("proxy-host");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("hostname");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withDescription(Constants.RES.get("hlp.proxyPort", String.valueOf(80)));
        OptionBuilder.withLongOpt("proxy-port");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Number.class);
        OptionBuilder.withArgName("port");
        OPTS.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("gui");
        OptionBuilder.withDescription(Constants.RES.get("hlp.gui"));
        OPTS.addOption(OptionBuilder.create());
    }
}

