/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jsignpdf.BasicSignerOptions;
import net.sf.jsignpdf.Constants;
import net.sf.jsignpdf.PdfExtraInfo;
import net.sf.jsignpdf.SignerFileChooser;
import net.sf.jsignpdf.preview.Pdf2Image;
import net.sf.jsignpdf.preview.SelectionImage;
import net.sf.jsignpdf.types.PageInfo;
import net.sf.jsignpdf.types.RelRect;
import net.sf.jsignpdf.types.RenderMode;
import net.sf.jsignpdf.utils.ConvertUtils;
import net.sf.jsignpdf.utils.GuiUtils;
import org.apache.commons.lang3.StringUtils;

public class VisibleSignatureDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private BasicSignerOptions options;
    private SignerFileChooser fc;
    private PdfExtraInfo extraInfo;
    private Pdf2Image p2i;
    private SelectionImage selectionImage = new SelectionImage();
    private int numberOfPages = -1;
    private PageInfo pdfPageInfo;
    private boolean previewListenerDisabled;
    private JButton btnBgImgPathBrowse;
    private JButton btnClose;
    private JButton btnImgPathBrowse;
    private JButton btnNext;
    private JButton btnPreview;
    private JButton btnPreviewClose;
    private JButton btnPrevious;
    private JComboBox cbDisplayMode;
    private JCheckBox chkbAcro6Layers;
    private JCheckBox chkbL2TextDefault;
    private JCheckBox chkbL4TextDefault;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblBgImgPath;
    private JLabel lblBgImgScale;
    private JLabel lblDisplayMode;
    private JLabel lblImgPath;
    private JLabel lblL2Text;
    private JLabel lblL2TextFontSize;
    private JLabel lblL4Text;
    private JLabel lblPage;
    private JLabel lblPageBounds;
    private JLabel lblPosLLX;
    private JLabel lblPosLLXBounds;
    private JLabel lblPosLLY;
    private JLabel lblPosLLYBounds;
    private JLabel lblPosURX;
    private JLabel lblPosURY;
    private JLabel lblPosition;
    private JLabel lblSettings;
    private JDialog previewDialog;
    private JTextArea taL2Text;
    private JTextField tfBgImgPath;
    private JTextField tfBgImgScale;
    private JTextField tfImgPath;
    private JTextField tfL2TextFontSize;
    private JTextField tfL4Text;
    private JTextField tfPage;
    private JTextField tfPosLLX;
    private JTextField tfPosLLY;
    private JTextField tfPosURX;
    private JTextField tfPosURY;

    public VisibleSignatureDialog(Frame parent, boolean modal, BasicSignerOptions anOptions, SignerFileChooser aFC) {
        super(parent, modal);
        this.options = anOptions;
        this.fc = aFC;
        this.p2i = new Pdf2Image(this.options);
        this.initComponents();
        this.translateLabels();
        this.tfPage.getDocument().addDocumentListener(new PageNrDocumentListener());
        this.selectionImage.getRelRect().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (VisibleSignatureDialog.this.previewListenerDisabled) {
                    return;
                }
                RelRect tmpRect = VisibleSignatureDialog.this.selectionImage.getRelRect();
                if (VisibleSignatureDialog.this.pdfPageInfo == null || !tmpRect.isValid()) {
                    return;
                }
                Float[] coords = tmpRect.getCoords();
                VisibleSignatureDialog.this.tfPosLLX.setText(String.valueOf(coords[0].floatValue() * VisibleSignatureDialog.this.pdfPageInfo.getWidth()));
                VisibleSignatureDialog.this.tfPosLLY.setText(String.valueOf(coords[1].floatValue() * VisibleSignatureDialog.this.pdfPageInfo.getHeight()));
                VisibleSignatureDialog.this.tfPosURX.setText(String.valueOf(coords[2].floatValue() * VisibleSignatureDialog.this.pdfPageInfo.getWidth()));
                VisibleSignatureDialog.this.tfPosURY.setText(String.valueOf(coords[3].floatValue() * VisibleSignatureDialog.this.pdfPageInfo.getHeight()));
            }
        });
        this.cbDisplayMode.setModel(new DefaultComboBoxModel<RenderMode>(RenderMode.values()));
        this.extraInfo = new PdfExtraInfo(anOptions);
        this.previewDialog.add((Component)this.selectionImage, "Center");
        this.previewDialog.setModal(true);
        this.previewDialog.getRootPane().setDefaultButton(this.btnPreviewClose);
        GuiUtils.resizeAndCenter(this.previewDialog);
        this.getRootPane().setDefaultButton(this.btnClose);
    }

    protected void pageNrChanged() {
        if (this.numberOfPages < 1) {
            return;
        }
        Integer tmpPageNr = ConvertUtils.toInteger(this.tfPage.getText());
        if (tmpPageNr != null) {
            if (tmpPageNr <= 0 || tmpPageNr > this.numberOfPages) {
                tmpPageNr = this.numberOfPages;
            }
            this.pdfPageInfo = this.extraInfo.getPageInfo(tmpPageNr);
        }
        if (this.switchBounds(this.pdfPageInfo != null)) {
            this.lblPosLLYBounds.setText("0.0 - " + this.pdfPageInfo.getHeight());
            this.lblPosLLXBounds.setText("0.0 - " + this.pdfPageInfo.getWidth());
        }
    }

    private void translateLabels() {
        this.setTitle(Constants.RES.get("gui.vs.title"));
        this.setLabelAndMnemonic(this.lblPosition, "gui.vs.position.label");
        this.setLabelAndMnemonic(this.lblPage, "gui.vs.page.label");
        this.setLabelAndMnemonic(this.lblPosLLX, "gui.vs.llx.label");
        this.setLabelAndMnemonic(this.lblPosLLY, "gui.vs.lly.label");
        this.setLabelAndMnemonic(this.lblPosURX, "gui.vs.urx.label");
        this.setLabelAndMnemonic(this.lblPosURY, "gui.vs.ury.label");
        this.setLabelAndMnemonic(this.lblBgImgScale, "gui.vs.bgImgScale.label");
        this.setLabelAndMnemonic(this.btnPreview, "gui.vs.preview.button");
        this.setLabelAndMnemonic(this.lblSettings, "gui.vs.settings.label");
        this.setLabelAndMnemonic(this.chkbAcro6Layers, "gui.vs.acro6layers.checkbox");
        this.setLabelAndMnemonic(this.lblDisplayMode, "gui.vs.renderMode.label");
        this.setLabelAndMnemonic(this.lblL2Text, "gui.vs.l2Text.label");
        this.setLabelAndMnemonic(this.lblL2TextFontSize, "gui.vs.l2TextFontSize.label");
        this.setLabelAndMnemonic(this.lblL4Text, "gui.vs.l4Text.label");
        this.setLabelAndMnemonic(this.lblImgPath, "gui.vs.imgPath.label");
        this.setLabelAndMnemonic(this.lblBgImgPath, "gui.vs.bgImgPath.label");
        this.setLabelAndMnemonic(this.chkbL2TextDefault, "gui.vs.default.checkbox");
        this.setLabelAndMnemonic(this.chkbL4TextDefault, "gui.vs.default.checkbox");
        this.setLabelAndMnemonic(this.btnBgImgPathBrowse, "gui.vs.browse.button");
        this.setLabelAndMnemonic(this.btnImgPathBrowse, "gui.vs.browse.button");
        this.setLabelAndMnemonic(this.btnClose, "gui.vs.close.button");
        this.setLabelAndMnemonic(this.btnPreviewClose, "gui.vs.close.button");
        this.previewDialog.setTitle(Constants.RES.get("gui.preview.title"));
        this.setToolTip(this.tfPage, "gui.vs.page.tooltip");
        this.setToolTip(this.tfPosLLX, "gui.vs.llx.tooltip");
        this.setToolTip(this.tfPosLLY, "gui.vs.lly.tooltip");
        this.setToolTip(this.tfPosURX, "gui.vs.urx.tooltip");
        this.setToolTip(this.tfPosURY, "gui.vs.ury.tooltip");
        this.setToolTip(this.tfBgImgScale, "gui.vs.bgImgScale.tooltip");
    }

    private void updateFromOptions() {
        this.tfPage.setText(ConvertUtils.toString(this.options.getPage()));
        this.tfPosLLX.setText(ConvertUtils.toString(this.options.getPositionLLX()));
        this.tfPosLLY.setText(ConvertUtils.toString(this.options.getPositionLLY()));
        this.tfPosURX.setText(ConvertUtils.toString(this.options.getPositionURX()));
        this.tfPosURY.setText(ConvertUtils.toString(this.options.getPositionURY()));
        this.tfBgImgScale.setText(ConvertUtils.toString(this.options.getBgImgScale()));
        this.cbDisplayMode.setSelectedItem((Object)this.options.getRenderMode());
        this.taL2Text.setText(this.options.getL2Text());
        this.chkbL2TextDefault.setSelected(this.options.getL2Text() == null);
        this.tfL2TextFontSize.setText(ConvertUtils.toString(this.options.getL2TextFontSize()));
        this.tfL4Text.setText(this.options.getL4Text());
        this.chkbL4TextDefault.setSelected(this.options.getL4Text() == null);
        this.tfImgPath.setText(this.options.getImgPath());
        this.tfBgImgPath.setText(this.options.getBgImgPath());
        this.chkbAcro6Layers.setSelected(this.options.isAcro6Layers());
        this.chkbL2TextDefaultActionPerformed(null);
        this.chkbL4TextDefaultActionPerformed(null);
    }

    private void storeToOptions() {
        this.options.setPage(ConvertUtils.toInt(this.tfPage.getText(), 1));
        this.options.setPositionLLX(ConvertUtils.toFloat(this.tfPosLLX.getText(), 0.0f));
        this.options.setPositionLLY(ConvertUtils.toFloat(this.tfPosLLY.getText(), 0.0f));
        this.options.setPositionURX(ConvertUtils.toFloat(this.tfPosURX.getText(), 100.0f));
        this.options.setPositionURY(ConvertUtils.toFloat(this.tfPosURY.getText(), 100.0f));
        this.options.setBgImgScale(ConvertUtils.toFloat(this.tfBgImgScale.getText(), -1.0f));
        this.options.setRenderMode((RenderMode)((Object)this.cbDisplayMode.getSelectedItem()));
        this.options.setL2Text(this.chkbL2TextDefault.isSelected() ? null : StringUtils.defaultString(this.taL2Text.getText(), ""));
        this.options.setL2TextFontSize(ConvertUtils.toFloat(this.tfL2TextFontSize.getText(), 10.0f));
        this.options.setL4Text(this.chkbL4TextDefault.isSelected() ? null : StringUtils.defaultString(this.tfL4Text.getText(), ""));
        this.options.setImgPath(this.tfImgPath.getText());
        this.options.setBgImgPath(this.tfBgImgPath.getText());
        this.options.setAcro6Layers(this.chkbAcro6Layers.isSelected());
        this.updateFromOptions();
    }

    private void setLabelAndMnemonic(JComponent aComponent, String aKey) {
        Constants.RES.setLabelAndMnemonic(aComponent, aKey);
    }

    private void setToolTip(JComponent aComponent, String aKey) {
        aComponent.setToolTipText(Constants.RES.get(aKey));
    }

    private boolean switchBounds(boolean aVisible) {
        this.lblPosLLXBounds.setVisible(aVisible);
        this.lblPosLLYBounds.setVisible(aVisible);
        this.btnPreview.setEnabled(aVisible);
        return aVisible;
    }

    private void switchImage() {
        boolean tmpEnabled = RenderMode.GRAPHIC_AND_DESCRIPTION.equals(this.cbDisplayMode.getSelectedItem());
        this.tfImgPath.setEnabled(tmpEnabled);
        this.btnImgPathBrowse.setEnabled(tmpEnabled);
    }

    private void readPdfInfo() {
        this.numberOfPages = this.extraInfo.getNumberOfPages();
        this.tfPage.setEnabled(this.numberOfPages != 1);
        this.lblPageBounds.setVisible(this.numberOfPages > 0);
        this.switchBounds(false);
        if (this.numberOfPages > 0) {
            this.lblPageBounds.setText("1 - " + this.numberOfPages);
        }
        this.pageNrChanged();
    }

    private void initComponents() {
        this.previewDialog = new JDialog();
        this.jPanel1 = new JPanel();
        this.btnPreviewClose = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.lblPosition = new JLabel();
        this.lblPage = new JLabel();
        this.tfPage = new JTextField();
        this.lblPosLLX = new JLabel();
        this.tfPosLLX = new JTextField();
        this.lblPosLLY = new JLabel();
        this.tfPosLLY = new JTextField();
        this.lblPosURX = new JLabel();
        this.tfPosURX = new JTextField();
        this.lblPosURY = new JLabel();
        this.tfPosURY = new JTextField();
        this.lblSettings = new JLabel();
        this.lblDisplayMode = new JLabel();
        this.cbDisplayMode = new JComboBox();
        this.chkbL2TextDefault = new JCheckBox();
        this.lblL4Text = new JLabel();
        this.tfL4Text = new JTextField();
        this.chkbL4TextDefault = new JCheckBox();
        this.lblImgPath = new JLabel();
        this.tfImgPath = new JTextField();
        this.btnImgPathBrowse = new JButton();
        this.lblBgImgPath = new JLabel();
        this.tfBgImgPath = new JTextField();
        this.btnBgImgPathBrowse = new JButton();
        this.lblBgImgScale = new JLabel();
        this.tfBgImgScale = new JTextField();
        this.btnClose = new JButton();
        this.lblPageBounds = new JLabel();
        this.lblPosLLXBounds = new JLabel();
        this.lblPosLLYBounds = new JLabel();
        this.lblL2Text = new JLabel();
        this.lblL2TextFontSize = new JLabel();
        this.tfL2TextFontSize = new JTextField();
        this.btnPreview = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.taL2Text = new JTextArea();
        this.chkbAcro6Layers = new JCheckBox();
        this.previewDialog.setModal(true);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnPreviewClose.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/back16.png")));
        this.btnPreviewClose.setText("Close");
        this.btnPreviewClose.setMinimumSize(new Dimension(50, 20));
        this.btnPreviewClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.btnPreviewCloseActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnPreviewClose, gridBagConstraints);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/prev16.png")));
        this.btnPrevious.setMinimumSize(new Dimension(50, 20));
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.btnPreviousActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnPrevious, gridBagConstraints);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/next16.png")));
        this.btnNext.setMinimumSize(new Dimension(50, 20));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.btnNextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnNext, gridBagConstraints);
        this.previewDialog.getContentPane().add((Component)this.jPanel1, "Last");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                VisibleSignatureDialog.this.formComponentHidden(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                VisibleSignatureDialog.this.formComponentShown(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblPosition.setText("Position");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.getContentPane().add((Component)this.lblPosition, gridBagConstraints);
        this.lblPage.setLabelFor(this.lblPage);
        this.lblPage.setText("Page");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblPage, gridBagConstraints);
        this.tfPage.setHorizontalAlignment(4);
        this.tfPage.setText("1");
        this.tfPage.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfPage, gridBagConstraints);
        this.lblPosLLX.setLabelFor(this.tfPosLLX);
        this.lblPosLLX.setText("Lower Left X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblPosLLX, gridBagConstraints);
        this.tfPosLLX.setHorizontalAlignment(4);
        this.tfPosLLX.setText("0.0");
        this.tfPosLLX.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfPosLLX, gridBagConstraints);
        this.lblPosLLY.setLabelFor(this.tfPosLLY);
        this.lblPosLLY.setText("Lower Left Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblPosLLY, gridBagConstraints);
        this.tfPosLLY.setHorizontalAlignment(4);
        this.tfPosLLY.setText("0.0");
        this.tfPosLLY.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfPosLLY, gridBagConstraints);
        this.lblPosURX.setLabelFor(this.tfPosURX);
        this.lblPosURX.setText("Upper Right X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblPosURX, gridBagConstraints);
        this.tfPosURX.setHorizontalAlignment(4);
        this.tfPosURX.setText("100.0");
        this.tfPosURX.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfPosURX, gridBagConstraints);
        this.lblPosURY.setLabelFor(this.tfPosURY);
        this.lblPosURY.setText("Upper Right Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblPosURY, gridBagConstraints);
        this.tfPosURY.setHorizontalAlignment(4);
        this.tfPosURY.setText("100.0");
        this.tfPosURY.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfPosURY, gridBagConstraints);
        this.lblSettings.setText("Settings");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.getContentPane().add((Component)this.lblSettings, gridBagConstraints);
        this.lblDisplayMode.setLabelFor(this.cbDisplayMode);
        this.lblDisplayMode.setText("Display");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblDisplayMode, gridBagConstraints);
        this.cbDisplayMode.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbDisplayMode.setMinimumSize(new Dimension(200, 20));
        this.cbDisplayMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.cbDisplayModeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.cbDisplayMode, gridBagConstraints);
        this.chkbL2TextDefault.setText("Default");
        this.chkbL2TextDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkbL2TextDefault.setMargin(new Insets(0, 0, 0, 0));
        this.chkbL2TextDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.chkbL2TextDefaultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.getContentPane().add((Component)this.chkbL2TextDefault, gridBagConstraints);
        this.lblL4Text.setLabelFor(this.tfL4Text);
        this.lblL4Text.setText("Status text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblL4Text, gridBagConstraints);
        this.tfL4Text.setMinimumSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfL4Text, gridBagConstraints);
        this.chkbL4TextDefault.setText("Default");
        this.chkbL4TextDefault.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkbL4TextDefault.setMargin(new Insets(0, 0, 0, 0));
        this.chkbL4TextDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.chkbL4TextDefaultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.getContentPane().add((Component)this.chkbL4TextDefault, gridBagConstraints);
        this.lblImgPath.setLabelFor(this.tfImgPath);
        this.lblImgPath.setText("Image");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblImgPath, gridBagConstraints);
        this.tfImgPath.setMinimumSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfImgPath, gridBagConstraints);
        this.btnImgPathBrowse.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/fileopen16.png")));
        this.btnImgPathBrowse.setText("Browse");
        this.btnImgPathBrowse.setHorizontalAlignment(10);
        this.btnImgPathBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.btnImgPathBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.getContentPane().add((Component)this.btnImgPathBrowse, gridBagConstraints);
        this.lblBgImgPath.setLabelFor(this.tfBgImgPath);
        this.lblBgImgPath.setText("Background image");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblBgImgPath, gridBagConstraints);
        this.tfBgImgPath.setMinimumSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfBgImgPath, gridBagConstraints);
        this.btnBgImgPathBrowse.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/fileopen16.png")));
        this.btnBgImgPathBrowse.setText("Browse");
        this.btnBgImgPathBrowse.setHorizontalAlignment(10);
        this.btnBgImgPathBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.btnBgImgPathBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.getContentPane().add((Component)this.btnBgImgPathBrowse, gridBagConstraints);
        this.lblBgImgScale.setLabelFor(this.tfBgImgScale);
        this.lblBgImgScale.setText("Background image scale");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblBgImgScale, gridBagConstraints);
        this.tfBgImgScale.setHorizontalAlignment(4);
        this.tfBgImgScale.setText("-1.0");
        this.tfBgImgScale.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfBgImgScale, gridBagConstraints);
        this.btnClose.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/back16.png")));
        this.btnClose.setText("Close");
        this.btnClose.setHorizontalAlignment(10);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.btnCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 2, 5, 2);
        this.getContentPane().add((Component)this.btnClose, gridBagConstraints);
        this.lblPageBounds.setText("1 - 10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.lblPageBounds, gridBagConstraints);
        this.lblPosLLXBounds.setText("0.0 - 20.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.lblPosLLXBounds, gridBagConstraints);
        this.lblPosLLYBounds.setText("0.0 - 20.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.lblPosLLYBounds, gridBagConstraints);
        this.lblL2Text.setLabelFor(this.taL2Text);
        this.lblL2Text.setText("Signature text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblL2Text, gridBagConstraints);
        this.lblL2TextFontSize.setLabelFor(this.tfL2TextFontSize);
        this.lblL2TextFontSize.setText("Signature text size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.lblL2TextFontSize, gridBagConstraints);
        this.tfL2TextFontSize.setHorizontalAlignment(4);
        this.tfL2TextFontSize.setText("10.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.tfL2TextFontSize, gridBagConstraints);
        this.btnPreview.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jsignpdf/preview16.png")));
        this.btnPreview.setText("Preview");
        this.btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.btnPreviewActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.btnPreview, gridBagConstraints);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setMinimumSize(new Dimension(24, 48));
        this.taL2Text.setColumns(20);
        this.taL2Text.setRows(5);
        this.jScrollPane1.setViewportView(this.taL2Text);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.chkbAcro6Layers.setSelected(true);
        this.chkbAcro6Layers.setText("Acrobat 6 layer mode");
        this.chkbAcro6Layers.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkbAcro6Layers.setMargin(new Insets(0, 0, 0, 0));
        this.chkbAcro6Layers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisibleSignatureDialog.this.chkbAcro6LayersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.chkbAcro6Layers, gridBagConstraints);
        this.pack();
    }

    private void chkbAcro6LayersActionPerformed(ActionEvent evt) {
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        this.tfPage.setText(String.valueOf(ConvertUtils.toInt(this.tfPage.getText(), 2) - 1));
        this.btnPreviewActionPerformed(evt);
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.tfPage.setText(String.valueOf(ConvertUtils.toInt(this.tfPage.getText(), 0) + 1));
        this.btnPreviewActionPerformed(evt);
    }

    private void btnPreviewCloseActionPerformed(ActionEvent evt) {
        this.previewDialog.setVisible(false);
    }

    private void btnPreviewActionPerformed(ActionEvent evt) {
        Integer pageNr = ConvertUtils.toInteger(this.tfPage.getText());
        if (pageNr != null) {
            BufferedImage buffImg;
            this.btnPrevious.setEnabled(pageNr > 1);
            this.btnNext.setEnabled(pageNr < this.numberOfPages);
            if (pageNr <= 0 || pageNr > this.numberOfPages) {
                pageNr = this.numberOfPages;
            }
            if ((buffImg = this.p2i.getImageForPage(pageNr)) != null) {
                RelRect tmpRect = this.selectionImage.getRelRect();
                this.previewListenerDisabled = true;
                try {
                    Float[] coords = tmpRect.getCoords();
                    coords[0] = Float.valueOf(Float.parseFloat(this.tfPosLLX.getText()) / this.pdfPageInfo.getWidth());
                    coords[1] = Float.valueOf(Float.parseFloat(this.tfPosLLY.getText()) / this.pdfPageInfo.getHeight());
                    coords[2] = Float.valueOf(Float.parseFloat(this.tfPosURX.getText()) / this.pdfPageInfo.getWidth());
                    coords[3] = Float.valueOf(Float.parseFloat(this.tfPosURY.getText()) / this.pdfPageInfo.getHeight());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.selectionImage.setImage(buffImg);
                this.previewListenerDisabled = false;
                this.previewDialog.setVisible(true);
            } else {
                JOptionPane.showMessageDialog(this, Constants.RES.get("error.vs.previewFailed"), "Error", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this, Constants.RES.get("error.vs.pageNotANumber"), "Error", 2);
        }
    }

    private void btnBgImgPathBrowseActionPerformed(ActionEvent evt) {
        this.fc.showFileChooser(this.tfBgImgPath, null, 0);
    }

    private void btnImgPathBrowseActionPerformed(ActionEvent evt) {
        this.fc.showFileChooser(this.tfImgPath, null, 0);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void chkbL4TextDefaultActionPerformed(ActionEvent evt) {
        this.tfL4Text.setEnabled(!this.chkbL4TextDefault.isSelected());
    }

    private void chkbL2TextDefaultActionPerformed(ActionEvent evt) {
        this.taL2Text.setEnabled(!this.chkbL2TextDefault.isSelected());
    }

    private void formComponentHidden(ComponentEvent evt) {
        this.storeToOptions();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.updateFromOptions();
        this.readPdfInfo();
        this.switchImage();
    }

    private void cbDisplayModeActionPerformed(ActionEvent evt) {
        this.switchImage();
    }

    class PageNrDocumentListener
    implements DocumentListener {
        PageNrDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            VisibleSignatureDialog.this.pageNrChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            VisibleSignatureDialog.this.pageNrChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            VisibleSignatureDialog.this.pageNrChanged();
        }
    }
}

