/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsignpdf.types;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsignpdf.types.PdfVersion;

public enum HashAlgorithm {
    SHA1("SHA-1", PdfVersion.PDF_1_3),
    SHA256("SHA-256", PdfVersion.PDF_1_6),
    SHA384("SHA-384", PdfVersion.PDF_1_7),
    SHA512("SHA-512", PdfVersion.PDF_1_7),
    RIPEMD160("RIPEMD160", PdfVersion.PDF_1_7);

    private final PdfVersion pdfVersion;
    private final String algorithmName;

    private HashAlgorithm(String aName, PdfVersion aVersion) {
        this.algorithmName = aName;
        this.pdfVersion = aVersion;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public PdfVersion getPdfVersion() {
        return this.pdfVersion;
    }

    public String toStringWithPdfVersion() {
        return this.algorithmName + " (" + this.pdfVersion.getVersionName() + ")";
    }

    public static String valuesWithPdfVersionAsString() {
        return Stream.of(HashAlgorithm.values()).map(ha -> ha.toStringWithPdfVersion()).collect(Collectors.joining(", "));
    }
}

