/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.utils.LogWriter;

public class CalRGBColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4569336292751894930L;
    private int r;
    private int g;
    private int b;
    private static final double[][] xyzrgb = new double[][]{{3.240449, -1.537136, -0.498531}, {-0.969265, 1.876011, 0.041556}, {0.055643, -0.204026, 1.057229}};
    private float lastC = -255.0f;
    private float lastI = -255.0f;
    private float lastE = -255.0f;

    public CalRGBColorSpace(float[] whitepoint, float[] blackpoint, float[] matrix, float[] gamma) {
        this.cs = ColorSpace.getInstance(1001);
        this.setCIEValues(whitepoint, blackpoint, null, matrix, gamma);
        this.value = 1008872003;
    }

    @Override
    public final BufferedImage dataToRGB(byte[] data, int width, int height) {
        BufferedImage image;
        block3: {
            DataBufferByte db = new DataBufferByte(data, data.length);
            int size = width * height;
            try {
                for (int i = 0; i < size * 3; i += 3) {
                    float cl = data[i] & 0xFF;
                    float ca = data[i + 1] & 0xFF;
                    float cb = data[i + 2] & 0xFF;
                    this.convertToRGB(cl, ca, cb);
                    ((DataBuffer)db).setElem(i, this.r);
                    ((DataBuffer)db).setElem(i + 1, this.g);
                    ((DataBuffer)db).setElem(i + 2, this.b);
                }
                int[] bands = new int[]{0, 1, 2};
                image = new BufferedImage(width, height, 1);
                WritableRaster raster = Raster.createInterleavedRaster(db, width, height, width * 3, 3, bands, null);
                image.setData(raster);
            }
            catch (Exception ee) {
                image = null;
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + ee);
            }
        }
        return image;
    }

    @Override
    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues, items);
    }

    @Override
    public final void reset() {
        this.lastC = -255.0f;
        this.lastI = -255.0f;
        this.lastE = -255.0f;
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.currentColor = new PdfColor(0, 0, 0);
    }

    @Override
    public final void setColor(float[] number_values, int items) {
        float[] A = new float[]{1.0f, 1.0f, 1.0f};
        if (items == 3) {
            for (int i = 0; i < items; ++i) {
                A[i] = number_values[i];
                if (!(A[i] > 1.0f)) continue;
                return;
            }
            this.convertToRGB(A[0], A[1], A[2]);
            this.currentColor = new PdfColor(this.r, this.g, this.b);
        } else if (items == 1 && this.getIndexedMap() != null) {
            int ptr = (int)(number_values[0] * 3.0f);
            byte[] cmap = this.getIndexedMap();
            A[0] = (float)(cmap[ptr] & 0xFF) / 255.0f;
            A[1] = (float)(cmap[ptr + 1] & 0xFF) / 255.0f;
            A[2] = (float)(cmap[ptr + 2] & 0xFF) / 255.0f;
            this.convertToRGB(A[0], A[1], A[2]);
            this.currentColor = new PdfColor(this.r, this.g, this.b);
        }
    }

    private final void convertToRGB(float C, float I, float E) {
        if (this.lastC != C || this.lastI != I || this.lastE != E) {
            double ag = Math.pow(C, this.G[0]);
            double bg = Math.pow(I, this.G[1]);
            double cg = Math.pow(E, this.G[2]);
            double X = (double)this.Ma[0] * ag + (double)this.Ma[3] * bg + (double)this.Ma[6] * cg;
            double Y = (double)this.Ma[1] * ag + (double)this.Ma[4] * bg + (double)this.Ma[7] * cg;
            double Z = (double)this.Ma[2] * ag + (double)this.Ma[5] * bg + (double)this.Ma[8] * cg;
            double rawR = xyzrgb[0][0] * X + xyzrgb[0][1] * Y + xyzrgb[0][2] * Z;
            double rawG = xyzrgb[1][0] * X + xyzrgb[1][1] * Y + xyzrgb[1][2] * Z;
            double rawB = xyzrgb[2][0] * X + xyzrgb[2][1] * Y + xyzrgb[2][2] * Z;
            double kr = 1.0 / (xyzrgb[0][0] * (double)this.W[0] + xyzrgb[0][1] * (double)this.W[1] + xyzrgb[0][2] * (double)this.W[2]);
            double kg = 1.0 / (xyzrgb[1][0] * (double)this.W[0] + xyzrgb[1][1] * (double)this.W[1] + xyzrgb[1][2] * (double)this.W[2]);
            double kb = 1.0 / (xyzrgb[2][0] * (double)this.W[0] + xyzrgb[2][1] * (double)this.W[1] + xyzrgb[2][2] * (double)this.W[2]);
            this.r = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(rawR * kr), 0.5));
            this.g = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(rawG * kg), 0.5));
            this.b = (int)(255.0 * Math.pow(CalRGBColorSpace.clip(rawB * kb), 0.5));
            this.lastC = C;
            this.lastI = I;
            this.lastE = E;
        }
    }

    private static double clip(double v) {
        if (v > 1.0) {
            return 1.0;
        }
        return v;
    }
}

