/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.util.Map;
import org.jpedal.color.CalGrayColorSpace;
import org.jpedal.color.CalRGBColorSpace;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceNColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.ICCColorSpace;
import org.jpedal.color.LabColorSpace;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.color.SeparationColorSpace;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class ColorspaceFactory {
    private ColorspaceFactory() {
    }

    public static final GenericColorSpace getColorSpaceInstance(PdfObjectReader currentPdfFile, PdfObject colorSpace, Map colorspacesObjects) {
        String key = colorSpace.getStatus() == 0 ? colorSpace.getObjectRefAsString() : new String(colorSpace.getUnresolvedData());
        GenericColorSpace col = null;
        Object cachedValue = colorspacesObjects.get(key);
        if (cachedValue != null) {
            col = (GenericColorSpace)cachedValue;
            col.reset();
        }
        if (col == null && (col = ColorspaceFactory.getColorSpaceInstance(currentPdfFile, colorSpace)).getID() == 1247168582) {
            colorspacesObjects.put(key, col);
        }
        return col;
    }

    public static final GenericColorSpace getColorSpaceInstance(PdfObjectReader currentPdfFile, PdfObject colorSpace) {
        currentPdfFile.checkResolved(colorSpace);
        int ID = colorSpace.getParameterConstant(2087749783);
        if (ID == 320678171) {
            ID = 1498837125;
        }
        boolean isIndexed = false;
        int size = 0;
        byte[] lookup = null;
        int rawID = -1;
        if (ID == 895578984 || ID == 25) {
            isIndexed = true;
            size = colorSpace.getInt(960901492);
            lookup = colorSpace.getDictionary(1060856191).getDecodedStream();
            colorSpace = colorSpace.getDictionary(895578984);
            rawID = ID = colorSpace.getParameterConstant(2087749783);
        }
        GenericColorSpace currentColorData = ColorspaceFactory.getColorspace(currentPdfFile, colorSpace, ID);
        if (isIndexed) {
            if (rawID == 1247168582 && lookup.length < 3) {
                currentColorData = new DeviceGrayColorSpace();
            }
            currentColorData.setIndex(lookup, size);
        }
        currentColorData.setAlternateColorSpace(colorSpace.getParameterConstant(2054519176));
        return currentColorData;
    }

    private static GenericColorSpace getColorspace(PdfObjectReader currentPdfFile, PdfObject colorSpace, int ID) {
        GenericColorSpace currentColorData = new DeviceRGBColorSpace();
        switch (ID) {
            case -2073385820: {
                currentColorData = new SeparationColorSpace(currentPdfFile, colorSpace);
                break;
            }
            case 960981604: {
                currentColorData = new DeviceNColorSpace(currentPdfFile, colorSpace);
                break;
            }
            case 1568372915: {
                currentColorData = new DeviceGrayColorSpace();
                break;
            }
            case 1498837125: {
                currentColorData = new DeviceCMYKColorSpace();
                break;
            }
            case 391471749: {
                currentColorData = ColorspaceFactory.getCalGrayColorspace(colorSpace);
                break;
            }
            case 1008872003: {
                currentColorData = ColorspaceFactory.getCalRGBColorspace(colorSpace);
                break;
            }
            case 1847602: {
                currentColorData = ColorspaceFactory.getLabColorspace(colorSpace);
                break;
            }
            case 1247168582: {
                currentColorData = ColorspaceFactory.getICCColorspace(colorSpace);
                break;
            }
            case 1146450818: {
                currentColorData = new PatternColorSpace(currentPdfFile);
            }
        }
        return currentColorData;
    }

    private static GenericColorSpace getICCColorspace(PdfObject colorSpace) {
        GenericColorSpace currentColorData = new DeviceRGBColorSpace();
        int alt = colorSpace.getParameterConstant(2054519176);
        if (alt != 1568372915) {
            currentColorData = new ICCColorSpace(colorSpace);
        }
        if (alt == 1498837125 && currentColorData.isInvalid()) {
            currentColorData = new DeviceCMYKColorSpace();
        }
        return currentColorData;
    }

    private static GenericColorSpace getLabColorspace(PdfObject colorSpace) {
        float[] R = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
        float[] W = new float[]{0.0f, 1.0f, 0.0f};
        float[] B = new float[]{0.0f, 0.0f, 0.0f};
        float[] blackpointArray = colorSpace.getFloatArray(1886161824);
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float[] rangeArray = colorSpace.getFloatArray(826160983);
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (blackpointArray != null) {
            B = blackpointArray;
        }
        if (rangeArray != null) {
            R = rangeArray;
        }
        return new LabColorSpace(W, B, R);
    }

    private static GenericColorSpace getCalRGBColorspace(PdfObject colorSpace) {
        float[] W = new float[]{0.0f, 1.0f, 0.0f};
        float[] B = new float[]{0.0f, 0.0f, 0.0f};
        float[] G = new float[]{1.0f, 1.0f, 1.0f};
        float[] Ma = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        float[] gammaArray = colorSpace.getFloatArray(826096968);
        float[] blackpointArray = colorSpace.getFloatArray(1886161824);
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float[] matrixArray = colorSpace.getFloatArray(1145198201);
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (blackpointArray != null) {
            B = blackpointArray;
        }
        if (gammaArray != null) {
            G = gammaArray;
        }
        if (matrixArray != null) {
            Ma = matrixArray;
        }
        return new CalRGBColorSpace(W, B, Ma, G);
    }

    private static GenericColorSpace getCalGrayColorspace(PdfObject colorSpace) {
        float[] W = new float[]{0.0f, 1.0f, 0.0f};
        float[] B = new float[]{0.0f, 0.0f, 0.0f};
        float[] G = new float[]{1.0f, 1.0f, 1.0f};
        float[] gammaArray = null;
        float[] blackpointArray = colorSpace.getFloatArray(1886161824);
        float[] whitepointArray = colorSpace.getFloatArray(2021497500);
        float rawGamma = colorSpace.getFloatNumber(826096968);
        if (rawGamma != -1.0f) {
            gammaArray = new float[]{rawGamma};
        }
        if (whitepointArray != null) {
            W = whitepointArray;
        }
        if (blackpointArray != null) {
            B = blackpointArray;
        }
        if (gammaArray != null) {
            G = gammaArray;
        }
        return new CalGrayColorSpace(W, B, G);
    }
}

