/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;

public class RotatedTexturePaint
implements PdfPaint {
    DynamicVectorRenderer patternOnTile = null;
    private float[][] matrix;
    private float xStep;
    private float yStep;
    private float offsetXOnCanvas;
    private float offsetYOnCanvas;
    private float tileXoffset;
    private float tileYoffset;
    private AffineTransform imageScale;
    boolean cacheToTile;
    boolean isSideways;
    boolean isSkewed = false;
    boolean isUpsideDown = false;
    boolean isRotated;
    boolean debug = false;
    BufferedImage img;
    PdfObject patternObj = null;

    public RotatedTexturePaint(boolean isSideways, float[][] rawMatrix, PdfObject patternObj, boolean cacheToTile, DynamicVectorRenderer patternOnTile, float[][] matrix, float xStep, float yStep, float offsetXOnCanvas, float offsetYOnCanvas, AffineTransform imageScale) {
        this.patternObj = patternObj;
        this.isSideways = isSideways;
        this.isSkewed = rawMatrix != null && rawMatrix[0][0] > 0.0f && rawMatrix[0][1] < 0.0f && rawMatrix[1][0] > 0.0f && rawMatrix[1][1] > 0.0f;
        this.cacheToTile = cacheToTile;
        this.patternOnTile = patternOnTile;
        this.matrix = matrix;
        this.xStep = xStep;
        this.yStep = yStep;
        this.offsetXOnCanvas = offsetXOnCanvas;
        this.offsetYOnCanvas = offsetYOnCanvas;
        this.imageScale = imageScale;
        if (this.debug) {
            System.out.println("=======PatternObj=" + patternObj.getObjectRefAsString());
            System.out.println("isSideways=" + isSideways + " isSkewed=" + this.isSkewed);
            System.out.println("cacheToTile=" + cacheToTile);
            System.out.println("patternOnTile=" + patternOnTile);
            System.out.println("xStep=" + xStep + " yStep=" + yStep);
            System.out.println("offsetXOnCanvas=" + offsetXOnCanvas + " offsetYOnCanvas=" + offsetYOnCanvas);
            System.out.println("imageScale=" + imageScale);
            Matrix.show(matrix);
        }
        if (matrix[0][0] != 0.0f && matrix[1][1] != 0.0f) {
            this.tileXoffset = xStep * matrix[0][1];
            this.tileYoffset = Math.abs(yStep * matrix[1][0]);
            if (this.debug) {
                System.out.println("set tileXoffset=" + this.tileXoffset + " tileYoffset=" + this.tileYoffset);
            }
        }
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle db, Rectangle2D ub, AffineTransform xform, RenderingHints hints) {
        TexturePaint rotatedPaint;
        block57: {
            int tileH;
            int tileW;
            float offY;
            float offX;
            float rotatedHeight;
            float rotatedWidth;
            Graphics2D debugG2 = null;
            AffineTransform debugAf2 = null;
            int w = (int)ub.getWidth();
            int h = (int)ub.getHeight();
            if (this.debug) {
                System.out.println("area to fill w=" + w + " h=" + h);
            }
            BufferedImage wholeImage = new BufferedImage(w, h, 2);
            Graphics2D g2 = wholeImage.createGraphics();
            AffineTransform defaultAf2 = g2.getTransform();
            if (this.debug) {
                this.img = new BufferedImage(1000, 1000, 1);
                debugG2 = this.img.createGraphics();
                debugG2.translate(ub.getX(), ub.getY());
                debugG2.setPaint(Color.GREEN);
                for (int i = -1000; i < 1000; i += 50) {
                    debugG2.drawLine(-1000, i, 1000, i);
                    debugG2.drawLine(i, -1000, i, 1000);
                }
                debugG2.setPaint(Color.WHITE);
                debugG2.drawRect(0, 0, (int)ub.getWidth(), (int)ub.getHeight());
                debugAf2 = debugG2.getTransform();
            }
            if (this.isSkewed) {
                rotatedWidth = this.xStep * this.matrix[0][0] + this.yStep * this.matrix[1][0];
                rotatedHeight = this.yStep * this.matrix[1][1] - this.xStep * this.matrix[0][1];
            } else {
                rotatedWidth = this.xStep * this.matrix[0][0] - this.yStep * this.matrix[1][0];
                rotatedHeight = this.matrix[1][1] > 0.0f && this.matrix[0][1] > 0.0f ? this.yStep * this.matrix[1][1] : -(this.yStep * this.matrix[1][1]) - this.xStep * this.matrix[0][1];
            }
            float shapeW = ub.getBounds().width;
            float shapeH = ub.getBounds().height;
            int numberOfRows = (int)(shapeH / rotatedHeight);
            if (this.debug) {
                System.out.println(numberOfRows + " shapeW=" + shapeW + " shapeH=" + shapeH + " rotatedWidth=" + rotatedWidth + " rotatedHeight=" + rotatedHeight);
            }
            if (numberOfRows > 1) {
                offX = shapeW - rotatedHeight * (float)numberOfRows;
                offY = 5.0f - (shapeH - rotatedWidth * (float)numberOfRows);
                if (this.debug) {
                    System.out.println("Multiple Rows OffsetX=" + offX + " offsetY=" + offY + " numberOfRows" + numberOfRows + " rotatedWidth=" + rotatedWidth + " shapeH=" + shapeH);
                }
            } else if (rotatedHeight > shapeW) {
                offX = rotatedHeight - shapeW;
                offY = shapeH - rotatedWidth;
                if (this.debug) {
                    System.out.println("rotatedHeight>shapeW OffsetX=" + offX + " offsetY=" + offY);
                }
            } else {
                offX = shapeH - rotatedHeight;
                offY = shapeW - rotatedWidth;
                if (this.debug) {
                    System.out.println("general case OffsetX=" + offX + " offsetY=" + offY);
                }
            }
            Rectangle actualTileRect = this.patternOnTile.getOccupiedArea().getBounds();
            int patternXOffsetOnTile = 0;
            int patternYOffsetOnTile = 0;
            if (actualTileRect.x < 0) {
                tileW = actualTileRect.width - actualTileRect.x;
                patternXOffsetOnTile = actualTileRect.x;
            } else {
                tileW = actualTileRect.width + actualTileRect.x;
            }
            if (actualTileRect.y < 0) {
                tileH = actualTileRect.height - actualTileRect.y;
                patternYOffsetOnTile = actualTileRect.y;
            } else {
                tileH = actualTileRect.height + actualTileRect.y;
            }
            BufferedImage tileImg = null;
            if (this.isSideways) {
                this.imageScale = new AffineTransform();
                this.imageScale.scale(-1.0, 1.0);
                this.imageScale.translate(-((double)this.offsetXOnCanvas / xform.getScaleX()), 0.0);
                if (this.debug) {
                    System.out.println("isSideWay imageScale=" + this.imageScale);
                }
            } else if (this.matrix[0][0] >= 0.0f && this.matrix[1][0] >= 0.0f && this.matrix[0][1] <= 0.0f && this.matrix[1][1] >= 0.0f) {
                this.imageScale = new AffineTransform();
                this.imageScale.scale(-1.0, -1.0);
                if (!this.isSkewed) {
                    this.imageScale.translate(0.0, this.patternOnTile.getOccupiedArea().height - this.patternOnTile.getOccupiedArea().y);
                } else {
                    this.imageScale.translate(0.0, -(this.patternOnTile.getOccupiedArea().height - this.patternOnTile.getOccupiedArea().y));
                }
                if (this.debug) {
                    System.out.println("LHS fit imageScale=" + this.imageScale);
                }
            } else if (this.matrix[0][0] >= 0.0f && this.matrix[1][0] <= 0.0f && this.matrix[0][1] >= 0.0f && this.matrix[1][1] >= 0.0f) {
                this.imageScale = new AffineTransform();
                this.imageScale.rotate(1.5707963267948966);
                this.imageScale.translate(-224.0, -227.0);
            }
            if (ub.getBounds().width < this.patternOnTile.getOccupiedArea().width && ub.getBounds().height < this.patternOnTile.getOccupiedArea().height) {
                double contextTranslateY;
                double contextTranslateX;
                if (this.isSideways) {
                    contextTranslateX = -g2.getTransform().getTranslateX() - (double)(this.offsetXOnCanvas - (float)db.width);
                    contextTranslateY = -g2.getTransform().getTranslateY() + (double)(this.tileYoffset - this.offsetYOnCanvas);
                    g2.translate(contextTranslateX, contextTranslateY);
                    if (this.debug) {
                        System.out.println("isSideways translate=" + contextTranslateX + ' ' + contextTranslateY);
                        debugG2.translate(contextTranslateX, contextTranslateY);
                    }
                } else {
                    contextTranslateX = (float)tileW - offX + 5.0f;
                    contextTranslateY = -g2.getTransform().getTranslateY() + (double)(this.tileYoffset - this.offsetYOnCanvas);
                    g2.translate(contextTranslateX, contextTranslateY);
                    if (this.debug) {
                        System.out.println("translate=" + contextTranslateX + ' ' + contextTranslateY);
                        debugG2.translate(contextTranslateX, contextTranslateY);
                    }
                }
                this.patternOnTile.setG2(g2);
                this.patternOnTile.paint(null, this.imageScale, null);
                if (this.debug) {
                    this.patternOnTile.setG2(debugG2);
                    this.patternOnTile.paint(null, this.imageScale, null);
                }
            } else {
                if (this.cacheToTile) {
                    if (this.debug) {
                        System.out.println("cached to tile size " + tileW + ' ' + tileH + ' ' + this.xStep + ' ' + this.yStep);
                    }
                    tileImg = new BufferedImage(tileW, tileH, 2);
                    Graphics2D tileG2 = tileImg.createGraphics();
                    tileG2.translate(-patternXOffsetOnTile, -patternYOffsetOnTile);
                    this.patternOnTile.setG2(tileG2);
                    this.patternOnTile.paint(null, null, null);
                }
                float maxYY = (float)h + this.yStep + this.offsetYOnCanvas;
                if (this.cacheToTile) {
                    maxYY += (float)(tileImg.getHeight() * 2);
                    if (this.debug) {
                        System.out.println("adjust maxYY to " + maxYY);
                    }
                }
                float startX = 0.0f;
                for (float y = 0.0f; y < maxYY; y += this.offsetYOnCanvas) {
                    float startY = -this.tileYoffset - this.tileYoffset;
                    for (float x = -this.offsetXOnCanvas; x < (float)w + this.xStep + this.offsetXOnCanvas; x += this.offsetXOnCanvas) {
                        g2.translate(offX + x + startX, offY + y + startY);
                        if (this.debug) {
                            debugG2.translate(offX + x + startX, offY + y + startY);
                        }
                        if (this.cacheToTile) {
                            AffineTransform tileAff = new AffineTransform();
                            tileAff.scale(1.0, -1.0);
                            tileAff.translate(0.0, tileImg.getHeight());
                            ColorSpaceConvertor.drawImage(g2, tileImg, tileAff, null);
                            if (this.debug) {
                                ColorSpaceConvertor.drawImage(debugG2, tileImg, tileAff, null);
                            }
                        } else {
                            Rectangle tileSize = this.patternOnTile.getOccupiedArea();
                            float currentTileX = offX + x + startX;
                            float currentTileY = offY + y + startY - this.offsetYOnCanvas;
                            float[] originalPoint = new float[]{currentTileX, currentTileY, currentTileX + (float)tileSize.width, currentTileY + (float)tileSize.height};
                            float[] transformPoint = new float[originalPoint.length];
                            AffineTransform ubPosition = new AffineTransform();
                            ubPosition.translate(ub.getX(), ub.getY());
                            ubPosition.transform(originalPoint, 0, transformPoint, 0, 2);
                            Rectangle2D.Float testArea = new Rectangle2D.Float(transformPoint[0], transformPoint[1], (float)tileSize.getWidth() + this.tileXoffset, (float)tileSize.getHeight() + this.tileYoffset);
                            this.patternOnTile.setG2(g2);
                            if (ub.intersects(testArea) || this.matrix[0][0] >= 0.0f && this.matrix[1][0] <= 0.0f && this.matrix[0][1] >= 0.0f && this.matrix[1][1] >= 0.0f) {
                                this.patternOnTile.paint(null, this.imageScale, null);
                                if (this.debug) {
                                    this.patternOnTile.setG2(debugG2);
                                    this.patternOnTile.paint(null, this.imageScale, null);
                                }
                            } else if (this.debug) {
                                debugG2.setTransform(new AffineTransform());
                                debugG2.setPaint(Color.ORANGE);
                                debugG2.fill(testArea);
                            }
                            if (this.debug) {
                                debugG2.setTransform(new AffineTransform());
                                debugG2.setPaint(Color.WHITE);
                                debugG2.draw(testArea);
                            }
                        }
                        g2.setTransform(defaultAf2);
                        if (this.debug) {
                            debugG2.setTransform(debugAf2);
                        }
                        if (this.isSkewed) {
                            startY -= this.tileYoffset;
                            continue;
                        }
                        startY += this.tileYoffset;
                    }
                    startX -= this.tileXoffset;
                }
            }
            Rectangle rect = ub.getBounds();
            rotatedPaint = new TexturePaint(wholeImage, ub.getBounds());
            if (this.debug) {
                String path;
                block56: {
                    debugG2.setPaint(Color.BLUE);
                    debugG2.setTransform(new AffineTransform());
                    debugG2.draw(ub);
                    path = "/Users/markee/Desktop/Cases/";
                    try {
                        ImageIO.write((RenderedImage)wholeImage, "PNG", new File(path + "wholeImage-" + this.patternObj.getObjectRefAsString() + '-' + rect.x + '-' + rect.y + ".png"));
                        ImageIO.write((RenderedImage)this.img, "PNG", new File(path + "Pattern-" + this.patternObj.getObjectRefAsString() + '-' + rect.x + '-' + rect.y + ".png"));
                    }
                    catch (IOException e) {
                        if (!LogWriter.isOutput()) break block56;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                if (tileImg != null) {
                    BufferedImage img2 = new BufferedImage(1000, 1000, 1);
                    Graphics2D debugG3 = img2.createGraphics();
                    debugG3.setPaint(Color.CYAN);
                    debugG3.fill(ub);
                    debugG3.setPaint(Color.RED);
                    debugG3.draw(ub);
                    debugG3.drawImage(wholeImage, rect.x, rect.y, rect.width, rect.height, null);
                    try {
                        ImageIO.write((RenderedImage)img2, "PNG", new File(path + "PatternOrig-" + this.patternObj.getObjectRefAsString() + '-' + rect.x + '-' + rect.y + "-wholeImage.png"));
                    }
                    catch (IOException e) {
                        if (!LogWriter.isOutput()) break block57;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            }
        }
        return rotatedPaint.createContext(cm, db, ub, xform, new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
    }

    @Override
    public void setScaling(double cropX, double cropH, float scaling, float textX, float textY) {
    }

    @Override
    public boolean isPattern() {
        return false;
    }

    @Override
    public int getRGB() {
        return 0;
    }

    @Override
    public int getTransparency() {
        return 0;
    }

    @Override
    public void setRenderingType(int createHtml) {
    }
}

