/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfFileInformation;

public class ShowDocumentProperties {
    private String user_dir = System.getProperty("user.dir");
    private static String test_file = "/mnt/win_d/sample.pdf";

    public ShowDocumentProperties(String file_name) {
        String separator = System.getProperty("file.separator");
        if (!this.user_dir.endsWith(separator)) {
            this.user_dir = this.user_dir + separator;
        }
        PdfDecoder decode_pdf = null;
        try {
            decode_pdf = new PdfDecoder(false);
            System.out.println("Opening file :" + file_name);
            decode_pdf.openPdfFile(file_name);
        }
        catch (Exception e) {
            System.err.println("3.Exception " + e + " in pdf code");
        }
        if (decode_pdf.isEncrypted() && !decode_pdf.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at Viewer for code sample to handle such files");
            System.out.println("Or get support/consultancy");
        }
        PdfFileInformation currentFileInformation = decode_pdf.getFileInformationData();
        String[] values = currentFileInformation.getFieldValues();
        String[] fields = PdfFileInformation.getFieldNames();
        int count = fields.length;
        System.out.println("Fields");
        System.out.println("======");
        for (int i = 0; i < count; ++i) {
            System.out.println(fields[i] + " = " + values[i]);
        }
        System.out.println("\nMetadata");
        System.out.println("======");
        System.out.println(currentFileInformation.getFileXMLMetaData());
        decode_pdf.closePdfFile();
    }

    public static void main(String[] args) {
        System.out.println("Simple demo to extract pdf file properties");
        String file_name = test_file;
        if (args.length != 1) {
            System.out.println("Default test file used");
        } else {
            file_name = args[0];
            System.out.println("File :" + file_name);
        }
        File pdf_file = new File(file_name);
        if (!pdf_file.exists()) {
            System.out.println("File " + file_name + " not found");
        } else {
            new ShowDocumentProperties(file_name);
        }
    }
}

