/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.io.File;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.SwingGUI;

public class MultiViewListener
implements InternalFrameListener {
    Object pageScaling = null;
    Object pageRotation = null;
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;

    public MultiViewListener(PdfDecoder decode_pdf, SwingGUI currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        this.currentGUI.setBackNavigationButtonsEnabled(false);
        this.currentGUI.setForwardNavigationButtonsEnabled(false);
        this.currentGUI.resetPageNav();
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        this.decode_pdf.flushObjectValues(true);
        this.decode_pdf.closePdfFile();
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        this.currentGUI.setPdfDecoder(this.decode_pdf);
        this.currentCommands.setPdfDecoder(this.decode_pdf);
        int page = this.decode_pdf.getlastPageDecoded();
        this.commonValues.setPageCount(this.decode_pdf.getPageCount());
        this.commonValues.setCurrentPage(page);
        String fileName = this.decode_pdf.getFileName();
        if (fileName != null) {
            this.commonValues.setSelectedFile(fileName);
            File file = new File(fileName);
            this.commonValues.setInputDir(file.getParent());
            this.commonValues.setFileSize(file.length() >> 10);
        }
        this.commonValues.setPDF(this.currentCommands.isPDF());
        this.commonValues.setMultiTiff(this.currentGUI.isMultiPageTiff());
        if (this.pageScaling != null) {
            this.currentGUI.setSelectedComboItem(252, this.pageScaling.toString());
        }
        if (this.pageRotation != null) {
            this.currentGUI.setSelectedComboItem(251, this.pageRotation.toString());
        }
        this.currentGUI.setPageNumber();
        this.decode_pdf.updateUI();
        this.currentGUI.removeSearchWindow(false);
        this.currentGUI.hideRedundentNavButtons();
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        if (this.pageScaling != null) {
            this.pageScaling = this.currentGUI.getSelectedComboItem(252);
        }
        if (this.pageRotation != null) {
            this.pageRotation = this.currentGUI.getSelectedComboItem(251);
        }
    }

    public void setPageProperties(Object rotation, Object scaling) {
        this.pageRotation = rotation;
        this.pageScaling = scaling;
    }
}

