/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.util.Stack;
import java.util.StringTokenizer;
import org.jpedal.examples.viewer.utils.PropertiesFile;

public class RecentDocuments {
    int noOfRecentDocs;
    PropertiesFile properties;
    private Stack previousFiles = new Stack();
    private Stack nextFiles = new Stack();

    public RecentDocuments(int noOfRecentDocs, PropertiesFile properties) {
        this.noOfRecentDocs = noOfRecentDocs;
        this.properties = properties;
    }

    static String getShortenedFileName(String fileNameToAdd) {
        int maxChars = 30;
        if (fileNameToAdd.length() <= 30) {
            return fileNameToAdd;
        }
        StringTokenizer st = new StringTokenizer(fileNameToAdd, "\\/");
        int noOfTokens = st.countTokens();
        if (noOfTokens == 1) {
            return fileNameToAdd.substring(0, 30);
        }
        String[] arrayedFile = new String[noOfTokens];
        for (int i = 0; i < noOfTokens; ++i) {
            arrayedFile[i] = st.nextToken();
        }
        String filePathBody = fileNameToAdd.substring(arrayedFile[0].length(), fileNameToAdd.length() - arrayedFile[noOfTokens - 1].length());
        StringBuilder sb = new StringBuilder(filePathBody);
        for (int i = noOfTokens - 2; i > 0; --i) {
            int start = sb.lastIndexOf(arrayedFile[i]);
            int end = start + arrayedFile[i].length();
            sb.replace(start, end, "...");
            if (sb.toString().length() <= 30) break;
        }
        return arrayedFile[0] + sb + arrayedFile[noOfTokens - 1];
    }

    public String getPreviousDocument() {
        String fileToOpen = null;
        if (this.previousFiles.size() > 1) {
            this.nextFiles.push(this.previousFiles.pop());
            fileToOpen = (String)this.previousFiles.pop();
        }
        return fileToOpen;
    }

    public String getNextDocument() {
        String fileToOpen = null;
        if (!this.nextFiles.isEmpty()) {
            fileToOpen = (String)this.nextFiles.pop();
        }
        return fileToOpen;
    }

    public void addToFileList(String selectedFile) {
        this.previousFiles.push(selectedFile);
    }
}

