/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.MultiViewTransferHandler;
import org.jpedal.examples.viewer.gui.SingleViewTransferHandler;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.viewer.gui.popups.TipOfTheDay;
import org.jpedal.examples.viewer.gui.swing.SearchList;
import org.jpedal.examples.viewer.gui.swing.SwingMouseListener;
import org.jpedal.examples.viewer.gui.swing.SwingSearchWindow;
import org.jpedal.examples.viewer.gui.swing.SwingThumbnailPanel;
import org.jpedal.examples.viewer.utils.Printer;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.FontMappings;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.raw.OutlineObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Node;

public class Viewer {
    public static boolean showMessages = true;
    protected Values commonValues = new Values();
    protected Printer currentPrinter = new Printer();
    protected PdfDecoder decode_pdf = new PdfDecoder(true);
    protected GUIThumbnailPanel thumbnails = new SwingThumbnailPanel(this.commonValues, this.decode_pdf);
    private PropertiesFile properties = new PropertiesFile();
    public SwingGUI currentGUI = new SwingGUI(this.decode_pdf, this.commonValues, this.thumbnails, this.properties);
    private GUISearchWindow searchFrame = new SwingSearchWindow(this.currentGUI);
    protected Commands currentCommands = new Commands(this.commonValues, this.currentGUI, this.decode_pdf, this.thumbnails, this.properties, this.searchFrame, this.currentPrinter);
    protected GUIMouseHandler mouseHandler = new SwingMouseListener(this.decode_pdf, this.currentGUI, this.commonValues, this.currentCommands);
    protected String[] scalingValues;
    private boolean isSetup;
    public static final String PREFERENCES_DEFAULT = "jar:/org/jpedal/examples/viewer/res/preferences/Default.xml";
    public static final String PREFERENCES_NO_GUI = "jar:/org/jpedal/examples/viewer/res/preferences/NoGUI.xml";
    public static final String PREFERENCES_NO_SIDE_BAR = "jar:/org/jpedal/examples/viewer/res/preferences/NoSideTabOrTopButtons.xml";
    public static final String PREFERENCES_OPEN_AND_NAV_ONLY = "jar:/org/jpedal/examples/viewer/res/preferences/OpenAndNavOnly.xml";
    public static final String PREFERENCES_PDFHELP = "jar:/org/jpedal/examples/viewer/res/preferences/PDFHelp.xml";
    public static final String PREFERENCES_BEAN = "jar:/org/jpedal/examples/viewer/res/preferences/Bean.xml";
    public static boolean exitOnClose = true;
    private static String rawFile = "";
    public static String file = "";

    public SwingGUI getSwingGUI() {
        return this.currentGUI;
    }

    public void openDefaultFile(String defaultFile) {
        String memFlag;
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (Commands.hires || hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (defaultFile != null) {
            File testExists = new File(defaultFile);
            boolean isURL = false;
            if (defaultFile.startsWith("http:") || defaultFile.startsWith("jar:") || defaultFile.startsWith("file:")) {
                LogWriter.writeLog("Opening http connection");
                isURL = true;
            }
            if (!isURL && !testExists.exists()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!isURL && testExists.isDirectory()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setFileSize(testExists.length() >> 10);
                this.commonValues.setSelectedFile(defaultFile);
                this.currentGUI.setViewerTitle(null);
                String page = System.getProperty("org.jpedal.page");
                String bookmark = System.getProperty("org.jpedal.bookmark");
                if (page != null && !isURL) {
                    try {
                        int pageNum = Integer.parseInt(page);
                        if (pageNum < 1) {
                            pageNum = -1;
                            System.err.println(page + " must be 1 or larger. Opening on page 1");
                            LogWriter.writeLog(page + " must be 1 or larger. Opening on page 1");
                        }
                        if (pageNum != -1) {
                            this.openFile(testExists, pageNum);
                        }
                    }
                    catch (Exception e) {
                        System.err.println(page + "is not a valid number for a page number. Opening on page 1");
                        LogWriter.writeLog(page + "is not a valid number for a page number. Opening on page 1");
                    }
                } else if (bookmark != null) {
                    this.openFile(testExists, bookmark);
                } else {
                    try {
                        this.currentCommands.openFile(defaultFile);
                    }
                    catch (PdfException pdfException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void openDefaultFileAtPage(String defaultFile, int page) {
        String memFlag;
        String hiresFlag = System.getProperty("org.jpedal.hires");
        if (Commands.hires || hiresFlag != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((memFlag = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.resetToDefault();
        }
        this.commonValues.maxViewY = 0;
        if (defaultFile != null) {
            File testExists = new File(defaultFile);
            boolean isURL = false;
            if (defaultFile.startsWith("http:") || defaultFile.startsWith("jar:")) {
                LogWriter.writeLog("Opening http connection");
                isURL = true;
            }
            if (!isURL && !testExists.exists()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerdoesNotExist.message"));
            } else if (!isURL && testExists.isDirectory()) {
                this.currentGUI.showMessageDialog(defaultFile + '\n' + Messages.getMessage("PdfViewerFileIsDirectory.message"));
            } else {
                this.commonValues.setSelectedFile(defaultFile);
                this.commonValues.setFileSize(testExists.length() >> 10);
                this.currentGUI.setViewerTitle(null);
                this.openFile(testExists, page);
            }
        }
    }

    public Viewer() {
        PdfDecoder.showErrorMessages = true;
        String prefFile = System.getProperty("org.jpedal.Viewer.Prefs");
        if (prefFile != null) {
            this.properties.loadProperties(prefFile);
        } else {
            this.properties.loadProperties();
        }
    }

    public Viewer(int modeOfOperation) {
        PdfDecoder.showErrorMessages = true;
        String prefFile = System.getProperty("org.jpedal.Viewer.Prefs");
        if (prefFile != null) {
            this.properties.loadProperties(prefFile);
        } else {
            this.properties.loadProperties();
        }
        this.commonValues.setModeOfOperation(modeOfOperation);
    }

    public Viewer(String prefs) {
        PdfDecoder.showErrorMessages = true;
        try {
            this.properties.loadProperties(prefs);
        }
        catch (Exception e) {
            System.err.println("Specified Preferrences file not found at " + prefs + ". If this file is within a jar ensure filename has jar: at the begining.");
            System.exit(1);
        }
    }

    public Viewer(Container rootContainer, String preferencesPath) {
        PdfDecoder.showErrorMessages = true;
        if (preferencesPath != null && preferencesPath.length() > 0) {
            try {
                this.properties.loadProperties(preferencesPath);
            }
            catch (Exception e) {
                System.err.println("Specified Preferrences file not found at " + preferencesPath + ". If this file is within a jar ensure filename has jar: at the begining.");
                System.exit(1);
            }
        } else {
            this.properties.loadProperties();
        }
        this.setRootContainer(rootContainer);
    }

    public void addPageChangeListener(DocumentListener docListener) {
        if (this.currentGUI != null) {
            this.currentGUI.addPageChangeListener(docListener);
        }
    }

    public void setRootContainer(Container rootContainer) {
        String customWindowSize;
        JPanel temp;
        if (rootContainer == null) {
            throw new RuntimeException("Null containers not allowed.");
        }
        Container c = rootContainer;
        if (rootContainer instanceof JTabbedPane) {
            temp = new JPanel(new BorderLayout());
            rootContainer.add(temp);
            c = temp;
        } else if (rootContainer instanceof JScrollPane) {
            temp = new JPanel(new BorderLayout());
            ((JScrollPane)rootContainer).getViewport().add(temp);
            c = temp;
        } else if (rootContainer instanceof JSplitPane) {
            throw new RuntimeException("To add the viewer to a split pane please pass through either JSplitPane.getLeftComponent() or JSplitPane.getRightComponent()");
        }
        if (!(rootContainer instanceof JFrame)) {
            c.setLayout(new BorderLayout());
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int width = d.width / 2;
        int height = d.height / 2;
        if (width < 700) {
            width = 700;
        }
        if ((customWindowSize = System.getProperty("org.jpedal.startWindowSize")) != null) {
            StringTokenizer values = new StringTokenizer(customWindowSize, "x");
            System.out.println(values.countTokens());
            if (values.countTokens() != 2) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300");
            }
            try {
                width = Integer.parseInt(values.nextToken().trim());
                height = Integer.parseInt(values.nextToken().trim());
            }
            catch (Exception ee) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300");
            }
        }
        c.setPreferredSize(new Dimension(width, height));
        this.currentGUI.setFrame(c);
    }

    public void loadProperties(String props) {
        this.properties.loadProperties(props);
    }

    public void loadProperties(InputStream is) {
        this.properties.loadProperties(is);
    }

    public void setupViewer() {
        boolean showFirstTimePopup;
        String searchType;
        String flag = System.getProperty("org.jpedal.suppressViewerPopups");
        boolean suppressViewerPopups = false;
        if (flag != null && flag.toLowerCase().equals("true")) {
            suppressViewerPopups = true;
        }
        if ((searchType = this.properties.getValue("searchWindowType")) != null && searchType.length() != 0) {
            int type = Integer.parseInt(searchType);
            this.searchFrame.setStyle(type);
        } else {
            this.searchFrame.setStyle(SwingSearchWindow.SEARCH_MENU_BAR);
        }
        this.currentGUI.setSearchFrame(this.searchFrame);
        String setThumbnail = System.getProperty("org.jpedal.thumbnail");
        if (setThumbnail != null) {
            if (setThumbnail.equals("true")) {
                this.thumbnails.setThumbnailsEnabled(true);
            } else if (setThumbnail.equals("false")) {
                this.thumbnails.setThumbnailsEnabled(false);
            }
        } else {
            this.thumbnails.setThumbnailsEnabled(true);
        }
        String customBundle = System.getProperty("org.jpedal.bundleLocation");
        if (customBundle != null) {
            BufferedReader input_stream = null;
            ClassLoader loader = Messages.class.getClassLoader();
            String fileName = customBundle.replaceAll("\\.", "/") + '_' + Locale.getDefault().getLanguage() + ".properties";
            try {
                input_stream = new BufferedReader(new InputStreamReader(loader.getResourceAsStream(fileName)));
                input_stream.close();
            }
            catch (Exception ee) {
                Locale.setDefault(new Locale("en", "EN"));
                this.currentGUI.showMessageDialog("No locale file " + fileName + " has been defined for this Locale - using English as Default\n Format is path, using '.' as break ie org.jpedal.international.messages");
            }
            ResourceBundle rb = ResourceBundle.getBundle(customBundle);
            this.init(rb);
        } else {
            this.init(null);
        }
        this.currentGUI.init(this.scalingValues, this.currentCommands, this.currentPrinter);
        this.mouseHandler.setupMouse();
        if (this.searchFrame.getStyle() == SwingSearchWindow.SEARCH_TABBED_PANE) {
            this.currentGUI.searchInTab(this.searchFrame);
        }
        this.decode_pdf.getDynamicRenderer().setMessageFrame(this.currentGUI.getFrame());
        String propValue = this.properties.getValue("showfirsttimepopup");
        boolean bl = showFirstTimePopup = !suppressViewerPopups && propValue.length() > 0 && propValue.equals("true");
        if (showFirstTimePopup) {
            this.currentGUI.showFirstTimePopup();
            this.properties.setValue("showfirsttimepopup", "false");
        } else if (!suppressViewerPopups) {
            propValue = this.properties.getValue("showrhinomessage");
        }
        if (!suppressViewerPopups && JAIHelper.isJAIused()) {
            propValue = this.properties.getValue("showddmessage");
            if (this.properties != null && propValue.length() > 0 && propValue.equals("true")) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.JAIWarning") + Messages.getMessage("PdfViewer.JAIWarning1") + Messages.getMessage("PdfViewer.JAIWarning2") + Messages.getMessage("PdfViewer.JAIWarning3") + Messages.getMessage("PdfViewer.JAIWarning4"));
                this.properties.setValue("showddmessage", "false");
            }
        }
        if (!suppressViewerPopups) {
            boolean showItextMessage;
            propValue = this.properties.getValue("showitextmessage");
            boolean bl2 = showItextMessage = propValue.length() > 0 && propValue.equals("true");
            if (!this.commonValues.isItextOnClasspath() && showItextMessage) {
                this.properties.setValue("showitextmessage", "false");
            }
        }
        if (this.currentGUI.isSingle()) {
            SingleViewTransferHandler singleViewTransferHandler = new SingleViewTransferHandler(this.commonValues, this.thumbnails, this.currentGUI, this.currentCommands);
            this.decode_pdf.setTransferHandler(singleViewTransferHandler);
        } else {
            MultiViewTransferHandler multiViewTransferHandler = new MultiViewTransferHandler(this.commonValues, this.thumbnails, this.currentGUI, this.currentCommands);
            this.currentGUI.getMultiViewerFrames().setTransferHandler(multiViewTransferHandler);
        }
        boolean wasUpdateAvailable = false;
        propValue = this.properties.getValue("displaytipsonstartup");
        if (!suppressViewerPopups && !wasUpdateAvailable && propValue.length() > 0 && propValue.equals("true")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TipOfTheDay tipOfTheDay = new TipOfTheDay(Viewer.this.currentGUI.getFrame(), "/org/jpedal/examples/viewer/res/tips", Viewer.this.properties);
                    tipOfTheDay.setVisible(true);
                }
            });
        }
        this.isSetup = true;
    }

    protected void init(ResourceBundle bundle) {
        if (bundle == null) {
            try {
                Messages.setBundle(ResourceBundle.getBundle("org.jpedal.international.messages"));
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " loading resource bundle.\nAlso check you have a file in org.jpedal.international.messages to support Locale=" + Locale.getDefault());
            }
        } else {
            try {
                Messages.setBundle(bundle);
            }
            catch (Exception ee) {
                LogWriter.writeLog("Exception with bundle " + bundle);
                ee.printStackTrace();
            }
        }
        this.scalingValues = new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25%", "50%", "75%", "100%", "125%", "150%", "200%", "250%", "500%", "750%", "1000%"};
        if (SwingUtilities.isEventDispatchThread()) {
            this.decode_pdf.setDisplayView(1, 2);
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    Viewer.this.decode_pdf.setDisplayView(1, 2);
                }
            };
            SwingUtilities.invokeLater(doPaintComponent);
        }
        this.decode_pdf.addExternalHandler(this.currentGUI, 4);
        PdfDecoder.init(true);
        this.decode_pdf.setExtractionMode(0, 1.0f);
        FontMappings.setFontReplacements();
    }

    protected void createSwingMenu(boolean includeAll) {
        this.currentGUI.createMainMenu(includeAll);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " setting look and feel");
        }
        Viewer current = new Viewer();
        current.setupViewer();
        if (args.length > 0) {
            current.openDefaultFile(args[0]);
        } else if (current.properties.getValue("openLastDocument").toLowerCase().equals("true") && current.properties.getRecentDocuments() != null && current.properties.getRecentDocuments().length > 1) {
            int lastPageViewed = Integer.parseInt(current.properties.getValue("lastDocumentPage"));
            if (lastPageViewed < 0) {
                lastPageViewed = 1;
            }
            current.openDefaultFileAtPage(current.properties.getRecentDocuments()[0], lastPageViewed);
        }
    }

    private void openFile(File file, String bookmark) {
        try {
            boolean fileCanBeOpened = this.currentCommands.openUpFile(file.getCanonicalPath());
            String bookmarkPage = null;
            int page = -1;
            if (this.decode_pdf.getOutlineAsXML() != null) {
                Node rootNode = this.decode_pdf.getOutlineAsXML().getFirstChild();
                if (rootNode != null) {
                    bookmarkPage = this.currentGUI.getBookmark(bookmark);
                }
                if (bookmarkPage != null) {
                    page = Integer.parseInt(bookmarkPage);
                }
            }
            if (bookmarkPage == null && (bookmarkPage = this.decode_pdf.getIO().convertNameToRef(bookmark)) != null) {
                OutlineObject namedDest = new OutlineObject(bookmarkPage);
                this.decode_pdf.getIO().readObject(namedDest);
                if (fileCanBeOpened) {
                    this.currentCommands.processPage();
                }
                this.decode_pdf.getFormRenderer().getActionHandler().gotoDest(namedDest, 3, 339034948);
            }
            if (bookmarkPage == null) {
                throw new PdfException("Unknown bookmark " + bookmark);
            }
            if (page > -1) {
                this.commonValues.setCurrentPage(page);
                if (fileCanBeOpened) {
                    this.currentCommands.processPage();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " processing file");
            Values.setProcessing(false);
        }
    }

    private void openFile(File file, int page) {
        try {
            boolean fileCanBeOpened = this.currentCommands.openUpFile(file.getCanonicalPath());
            this.commonValues.setCurrentPage(page);
            if (fileCanBeOpened) {
                this.currentCommands.processPage();
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e + " processing file");
            Values.setProcessing(false);
        }
    }

    public Object executeCommand(int commandID, Object[] args) {
        if (!this.isSetup) {
            throw new RuntimeException("You must call viewer.setupViewer(); before you call any commands");
        }
        return this.currentCommands.executeCommand(commandID, args);
    }

    public SearchList getSearchResults() {
        return this.currentCommands.getSearchList();
    }

    public boolean isProcessing() {
        return Values.isProcessing();
    }

    public boolean isExecutingCommand() {
        return this.currentCommands.isExecutingCommand();
    }

    public void addExternalHandler(Object newHandler, int type) {
        this.decode_pdf.addExternalHandler(newHandler, type);
    }

    public void dispose() {
        this.commonValues = null;
        this.currentPrinter = null;
        if (this.thumbnails != null) {
            this.thumbnails.dispose();
        }
        this.thumbnails = null;
        this.properties.dispose();
        this.properties = null;
        if (this.currentGUI != null) {
            this.currentGUI.dispose();
        }
        this.currentGUI = null;
        this.searchFrame = null;
        this.currentCommands = null;
        this.mouseHandler = null;
        this.scalingValues = null;
        if (this.decode_pdf != null) {
            this.decode_pdf.dispose();
        }
        this.decode_pdf = null;
        Messages.dispose();
    }
}

