/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.popups;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.JViewport;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.gui.CheckNode;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;
import org.w3c.dom.NodeList;

public class SwingProperties
extends JPanel {
    private static final long serialVersionUID = 310781187885328136L;
    Map reverseMessage = new HashMap();
    String[] menuTabs = new String[]{"ShowMenubar", "ShowButtons", "ShowDisplayoptions", "ShowNavigationbar", "ShowSidetabbar"};
    String propertiesLocation = "";
    PropertiesFile properties = null;
    JDialog propertiesDialog;
    JButton confirm = new JButton("OK");
    JButton cancel = new JButton("Cancel");
    JTabbedPane tabs = new JTabbedPane();
    JTextField resolution;
    JComboBox searchStyle;
    JCheckBox border;
    JCheckBox downloadWindow;
    JCheckBox HiResPrint;
    JCheckBox constantTabs;
    JCheckBox enhancedViewer;
    JCheckBox enhancedFacing;
    JCheckBox thumbnailScroll;
    JCheckBox enhancedGUI;
    JCheckBox rightClick;
    JCheckBox scrollwheelZoom;
    JCheckBox update = new JCheckBox(Messages.getMessage("PdfPreferences.CheckForUpdate"));
    JTextField maxMultiViewers;
    JTextField pageInsets;
    JLabel pageInsetsText;
    JTextField windowTitle;
    JLabel windowTitleText;
    JTextField iconLocation;
    JLabel iconLocationText;
    JTextField printerBlacklist;
    JLabel printerBlacklistText;
    JComboBox defaultPrinter;
    JLabel defaultPrinterText;
    JComboBox defaultPagesize;
    JLabel defaultPagesizeText;
    JTextField defaultDPI;
    JLabel defaultDPIText;
    JTextField sideTabLength;
    JLabel sideTabLengthText;
    JCheckBox useHinting;
    JCheckBox autoScroll;
    JCheckBox confirmClose;
    JCheckBox openLastDoc;
    JComboBox pageLayout = new JComboBox<String>(new String[]{"Single Page", "Continuous", "Continuous Facing", "Facing", "PageFlow"});
    JComboBox voiceSelect;
    JPanel highlightBoxColor = new JPanel();
    JPanel highlightTextColor = new JPanel();
    JPanel viewBGColor = new JPanel();
    JPanel pdfDecoderBackground = new JPanel();
    JPanel foreGroundColor = new JPanel();
    JCheckBox invertHighlight = new JCheckBox("Highlight Inverts Page");
    JCheckBox replaceDocTextCol = new JCheckBox("Replace Document Text Colors");
    JCheckBox replaceDisplayBGCol = new JCheckBox("Replace Display Background Color");
    JCheckBox changeTextAndLineArt = new JCheckBox("Change Color of Text and Line art");
    JCheckBox showMouseSelectionBox = new JCheckBox("Show Mouse Selection Box");
    JTextField highlightComposite = new JTextField(String.valueOf(PdfDecoder.highlightComposite));
    private Container parent;
    private boolean preferencesSetup = false;
    private JButton clearHistory;
    private JLabel historyClearedLabel;
    KeyListener numericalKeyListener = new KeyListener(){
        boolean consume = false;

        @Override
        public void keyPressed(KeyEvent e) {
            this.consume = false;
            if (!(e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyCode() == 8 && e.getKeyCode() == 127)) {
                this.consume = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.consume) {
                e.consume();
            }
        }
    };

    public void showPreferenceWindow(SwingGUI swingGUI) {
        this.propertiesDialog = this.parent instanceof JFrame ? new JDialog((JFrame)this.parent) : new JDialog();
        this.propertiesDialog.setModal(true);
        if (!this.preferencesSetup) {
            this.preferencesSetup = true;
            this.createPreferenceWindow(swingGUI);
        }
        if (this.properties.getValue("readOnly").toLowerCase().equals("true")) {
            JOptionPane.showMessageDialog(this, "You do not have permission alter jPedal properties.\nAccess to the properties window has therefore been disabled.", "Can not write to properties file", 1);
        }
        if (this.properties.isReadOnly()) {
            JOptionPane.showMessageDialog(this, "Current properties file is read only.\nAny alteration can only be saved as another properties file.", "Properties file is read only", 1);
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        this.propertiesDialog.setLocationRelativeTo(this.parent);
        this.propertiesDialog.setVisible(true);
    }

    private void saveGUIPreferences(SwingGUI gui) {
        Component[] components = this.tabs.getComponents();
        for (int i = 0; i != components.length; ++i) {
            if (!(components[i] instanceof JPanel)) continue;
            Component[] panelComponets = ((JPanel)components[i]).getComponents();
            for (int j = 0; j != panelComponets.length; ++j) {
                if (panelComponets[j] instanceof JScrollPane) {
                    Component[] scrollComponents = ((JScrollPane)panelComponets[j]).getComponents();
                    for (int k = 0; k != scrollComponents.length; ++k) {
                        if (!(scrollComponents[k] instanceof JViewport)) continue;
                        Component[] viewportComponents = ((JViewport)scrollComponents[k]).getComponents();
                        for (int l = 0; l != viewportComponents.length; ++l) {
                            JTree tree;
                            CheckNode root;
                            if (!(viewportComponents[l] instanceof JTree) || (root = (CheckNode)(tree = (JTree)viewportComponents[l]).getModel().getRoot()).getChildCount() <= 0) continue;
                            this.saveMenuPreferencesChildren(root, gui);
                        }
                    }
                }
                if (!(panelComponets[j] instanceof JButton)) continue;
                JButton tempButton = (JButton)panelComponets[j];
                String value = (String)this.reverseMessage.get(tempButton.getText().substring((Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ').length()));
                if (tempButton.getText().startsWith(Messages.getMessage("PdfCustomGui.HideGuiSection") + ' ')) {
                    this.properties.setValue(value, "true");
                    gui.alterProperty(value, true);
                    continue;
                }
                this.properties.setValue(value, "false");
                gui.alterProperty(value, false);
            }
        }
    }

    private void saveMenuPreferencesChildren(CheckNode root, SwingGUI gui) {
        for (int i = 0; i != root.getChildCount(); ++i) {
            CheckNode node = (CheckNode)root.getChildAt(i);
            String value = (String)this.reverseMessage.get(node.getText());
            if (node.isSelected()) {
                this.properties.setValue(value, "true");
                gui.alterProperty(value, true);
            } else {
                this.properties.setValue(value, "false");
                gui.alterProperty(value, false);
            }
            if (node.getChildCount() <= 0) continue;
            this.saveMenuPreferencesChildren(node, gui);
        }
    }

    private void createPreferenceWindow(final SwingGUI gui) {
        this.properties = gui.getProperties();
        this.propertiesLocation = gui.getPropertiesFileLocation();
        this.propertiesDialog.setTitle(Messages.getMessage("PdfPreferences.windowTitle"));
        this.update.setToolTipText(Messages.getMessage("PdfPreferences.update.toolTip"));
        this.invertHighlight.setText(Messages.getMessage("PdfPreferences.InvertHighlight"));
        this.showMouseSelectionBox.setText(Messages.getMessage("PdfPreferences.ShowSelectionBow"));
        this.invertHighlight.setToolTipText(Messages.getMessage("PdfPreferences.invertHighlight.toolTip"));
        this.showMouseSelectionBox.setToolTipText(Messages.getMessage("PdfPreferences.showMouseSelection.toolTip"));
        this.highlightBoxColor.setToolTipText(Messages.getMessage("PdfPreferences.highlightBox.toolTip"));
        this.highlightTextColor.setToolTipText(Messages.getMessage("PdfPreferences.highlightText.toolTip"));
        String propValue = this.properties.getValue("resolution");
        this.resolution = propValue.length() > 0 ? new JTextField(propValue) : new JTextField(72);
        this.resolution.setToolTipText(Messages.getMessage("PdfPreferences.resolutionInput.toolTip"));
        propValue = this.properties.getValue("maxmultiviewers");
        this.maxMultiViewers = propValue.length() > 0 ? new JTextField(propValue) : new JTextField(20);
        this.maxMultiViewers.setToolTipText(Messages.getMessage("PdfPreferences.maxMultiViewer.toolTip"));
        this.searchStyle = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")});
        this.searchStyle.setToolTipText(Messages.getMessage("PdfPreferences.searchStyle.toolTip"));
        this.pageLayout = new JComboBox<String>(new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")});
        this.pageLayout.setToolTipText(Messages.getMessage("PdfPreferences.pageLayout.toolTip"));
        this.pageInsetsText = new JLabel(Messages.getMessage("PdfViewerViewMenu.pageInsets"));
        this.pageInsets = new JTextField();
        this.pageInsets.setToolTipText(Messages.getMessage("PdfPreferences.pageInsets.toolTip"));
        this.windowTitleText = new JLabel(Messages.getMessage("PdfCustomGui.windowTitle"));
        this.windowTitle = new JTextField();
        this.windowTitle.setToolTipText(Messages.getMessage("PdfPreferences.windowTitle.toolTip"));
        this.iconLocationText = new JLabel(Messages.getMessage("PdfViewerViewMenu.iconLocation"));
        this.iconLocation = new JTextField();
        this.iconLocation.setToolTipText(Messages.getMessage("PdfPreferences.iconLocation.toolTip"));
        this.defaultDPIText = new JLabel(Messages.getMessage("PdfViewerPrint.defaultDPI"));
        this.defaultDPI = new JTextField();
        this.defaultDPI.setToolTipText(Messages.getMessage("PdfPreferences.defaultDPI.toolTip"));
        this.sideTabLengthText = new JLabel(Messages.getMessage("PdfCustomGui.SideTabLength"));
        this.sideTabLength = new JTextField();
        this.sideTabLength.setToolTipText(Messages.getMessage("PdfPreferences.sideTabLength.toolTip"));
        this.useHinting = new JCheckBox(Messages.getMessage("PdfCustomGui.useHinting"));
        this.useHinting.setToolTipText(Messages.getMessage("PdfPreferences.useHinting.toolTip"));
        this.autoScroll = new JCheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        this.autoScroll.setToolTipText("Set if autoscroll should be enabled / disabled");
        this.confirmClose = new JCheckBox(Messages.getMessage("PfdViewerViewMenuConfirmClose.text"));
        this.confirmClose.setToolTipText("Set if we should confirm closing the viewer");
        this.openLastDoc = new JCheckBox(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.text"));
        this.openLastDoc.setToolTipText("Set if last document should be opened upon start up");
        this.border = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        this.border.setToolTipText("Set if we should display a border for the page");
        this.downloadWindow = new JCheckBox(Messages.getMessage("PageLayoutViewMenu.DownloadWindow_Show"));
        this.downloadWindow.setToolTipText("Set if the download window should be displayed");
        this.HiResPrint = new JCheckBox(Messages.getMessage("Printing.HiRes"));
        this.HiResPrint.setToolTipText("Set if hi res printing should be enabled / disabled");
        this.constantTabs = new JCheckBox(Messages.getMessage("PdfCustomGui.consistentTabs"));
        this.constantTabs.setToolTipText("Set to keep sidetabs consistant between files");
        this.enhancedViewer = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedViewer"));
        this.enhancedViewer.setToolTipText("Set to use enahnced viewer mode");
        this.enhancedFacing = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedFacing"));
        this.enhancedFacing.setToolTipText("Set to turn facing mode to page turn mode");
        this.thumbnailScroll = new JCheckBox(Messages.getMessage("PdfCustomGui.thumbnailScroll"));
        this.thumbnailScroll.setToolTipText("Set to show thumbnail whilst scrolling");
        this.enhancedGUI = new JCheckBox(Messages.getMessage("PdfCustomGui.enhancedGUI"));
        this.enhancedGUI.setToolTipText("Set to enabled the enhanced gui");
        this.rightClick = new JCheckBox(Messages.getMessage("PdfCustomGui.allowRightClick"));
        this.rightClick.setToolTipText("Set to enable / disable the right click functionality");
        this.scrollwheelZoom = new JCheckBox(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom"));
        this.scrollwheelZoom.setToolTipText("Set to enable zooming when scrolling with ctrl pressed");
        this.historyClearedLabel = new JLabel(Messages.getMessage("PageLayoutViewMenu.HistoryCleared"));
        this.historyClearedLabel.setForeground(Color.red);
        this.historyClearedLabel.setVisible(false);
        this.clearHistory = new JButton(Messages.getMessage("PageLayoutViewMenu.ClearHistory"));
        this.clearHistory.setToolTipText("Clears the history of previous files");
        this.clearHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.clearRecentDocuments();
                SwingWorker searcher = new SwingWorker(){

                    @Override
                    public Object construct() {
                        for (int i = 0; i < 6; ++i) {
                            SwingProperties.this.historyClearedLabel.setVisible(!SwingProperties.this.historyClearedLabel.isVisible());
                            try {
                                Thread.sleep(300L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        return null;
                    }
                };
                searcher.start();
            }
        });
        JButton save = new JButton(Messages.getMessage("PdfPreferences.SaveAs"));
        save.setToolTipText("Save preferences in a new file");
        JButton reset = new JButton(Messages.getMessage("PdfPreferences.ResetToDefault"));
        reset.setToolTipText("Reset  and save preferences to program defaults");
        this.propertiesDialog.getContentPane().setLayout(new BorderLayout());
        this.propertiesDialog.getContentPane().add((Component)this, "Center");
        this.propertiesDialog.pack();
        if (DecoderOptions.isRunningOnMac) {
            this.propertiesDialog.setSize(600, 475);
        } else {
            this.propertiesDialog.setSize(550, 450);
        }
        this.confirm.setText(Messages.getMessage("PdfPreferences.OK"));
        this.cancel.setText(Messages.getMessage("PdfPreferences.Cancel"));
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingProperties.this.setPreferences(gui);
                if (Viewer.showMessages) {
                    JOptionPane.showMessageDialog(null, Messages.getMessage("PdfPreferences.savedTo") + SwingProperties.this.propertiesLocation + '\n' + Messages.getMessage("PdfPreferences.restart"), "Restart Jpedal", 1);
                }
                SwingProperties.this.propertiesDialog.setVisible(false);
            }
        });
        this.confirm.setToolTipText("Save the preferences in the current loaded preferences file");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingProperties.this.propertiesDialog.setVisible(false);
            }
        });
        this.cancel.setToolTipText("Leave preferences window without saving changes");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String lastProperties = gui.getPropertiesFileLocation();
                JFileChooser fileChooser = new JFileChooser();
                int i = fileChooser.showSaveDialog(SwingProperties.this.propertiesDialog);
                if (i != 1 && i != -1 && i == 0) {
                    File f = fileChooser.getSelectedFile();
                    if (f.exists()) {
                        f.delete();
                    }
                    gui.setPropertiesFileLocation(f.getAbsolutePath());
                    SwingProperties.this.setPreferences(gui);
                }
                gui.setPropertiesFileLocation(lastProperties);
            }
        });
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.reset"), "Reset to Default", 0);
                if (result == 0) {
                    String lastProperties = gui.getPropertiesFileLocation();
                    File f = new File(lastProperties);
                    if (f.exists()) {
                        f.delete();
                    }
                    gui.getProperties().loadProperties(lastProperties);
                    if (Viewer.showMessages) {
                        JOptionPane.showMessageDialog(SwingProperties.this.propertiesDialog, Messages.getMessage("PdfPreferences.restart"));
                    }
                    SwingProperties.this.propertiesDialog.setVisible(false);
                }
            }
        });
        this.highlightComposite.addKeyListener(new KeyListener(){
            boolean consume = false;

            @Override
            public void keyPressed(KeyEvent e) {
                this.consume = false;
                if (!(!((JTextField)e.getSource()).getText().contains(".") || e.getKeyChar() != '.' || e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyCode() == 8 && e.getKeyCode() == 127)) {
                    this.consume = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.consume) {
                    e.consume();
                }
            }
        });
        this.highlightComposite.setToolTipText("Set the transparency of the highlight");
        this.resolution.addKeyListener(this.numericalKeyListener);
        this.maxMultiViewers.addKeyListener(this.numericalKeyListener);
        this.setLayout(new BorderLayout());
        JPanel toolbar = new JPanel();
        BoxLayout layout = new BoxLayout(toolbar, 1);
        toolbar.setLayout(layout);
        this.add((Component)new ButtonBarPanel(toolbar), "Center");
        toolbar.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        Dimension dimension = new Dimension(5, 40);
        Box.Filler filler = new Box.Filler(dimension, dimension, dimension);
        this.confirm.setPreferredSize(this.cancel.getPreferredSize());
        if (this.properties.isReadOnly()) {
            this.confirm.setEnabled(false);
        } else {
            this.confirm.setEnabled(true);
        }
        buttonPanel.add(reset);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.confirm);
        buttonPanel.add(save);
        this.getRootPane().setDefaultButton(this.confirm);
        buttonPanel.add(filler);
        buttonPanel.add(this.cancel);
        buttonPanel.add(filler);
        buttonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        this.add((Component)buttonPanel, "South");
    }

    public void setPreferences(SwingGUI gui) {
        int borderStyle = 0;
        int pageMode = this.pageLayout.getSelectedIndex() + 1;
        if (pageMode < 1 || pageMode > 5) {
            pageMode = 1;
        }
        if (this.border.isSelected()) {
            borderStyle = 1;
        }
        int hBox = this.highlightBoxColor.getBackground().getRGB();
        int hText = this.highlightTextColor.getBackground().getRGB();
        int vbg = this.viewBGColor.getBackground().getRGB();
        int pbg = this.pdfDecoderBackground.getBackground().getRGB();
        int vfg = this.foreGroundColor.getBackground().getRGB();
        boolean changeTL = this.changeTextAndLineArt.isSelected();
        boolean isInvert = this.invertHighlight.isSelected();
        boolean replaceTextColors = this.replaceDocTextCol.isSelected();
        boolean replacePdfDisplayBackground = this.replaceDisplayBGCol.isSelected();
        boolean isBoxShown = this.showMouseSelectionBox.isSelected();
        this.properties.setValue("borderType", String.valueOf(borderStyle));
        this.properties.setValue("useHinting", String.valueOf(this.useHinting.isSelected()));
        this.properties.setValue("pageMode", String.valueOf(pageMode));
        this.properties.setValue("pageInsets", String.valueOf(this.pageInsets.getText()));
        this.properties.setValue("windowTitle", String.valueOf(this.windowTitle.getText()));
        String loc = this.iconLocation.getText();
        if (!loc.endsWith("/") && !loc.endsWith("\\")) {
            loc = loc + '/';
        }
        this.properties.setValue("iconLocation", String.valueOf(loc));
        this.properties.setValue("sideTabBarCollapseLength", String.valueOf(this.sideTabLength.getText()));
        this.properties.setValue("autoScroll", String.valueOf(this.autoScroll.isSelected()));
        this.properties.setValue("confirmClose", String.valueOf(this.confirmClose.isSelected()));
        this.properties.setValue("openLastDocument", String.valueOf(this.openLastDoc.isSelected()));
        this.properties.setValue("resolution", String.valueOf(this.resolution.getText()));
        this.properties.setValue("searchWindowType", String.valueOf(this.searchStyle.getSelectedIndex()));
        this.properties.setValue("automaticupdate", String.valueOf(this.update.isSelected()));
        this.properties.setValue("maxmultiviewers", String.valueOf(this.maxMultiViewers.getText()));
        this.properties.setValue("showDownloadWindow", String.valueOf(this.downloadWindow.isSelected()));
        this.properties.setValue("useHiResPrinting", String.valueOf(this.HiResPrint.isSelected()));
        this.properties.setValue("consistentTabBar", String.valueOf(this.constantTabs.isSelected()));
        this.properties.setValue("highlightComposite", String.valueOf(this.highlightComposite.getText()));
        this.properties.setValue("highlightBoxColor", String.valueOf(hBox));
        this.properties.setValue("highlightTextColor", String.valueOf(hText));
        this.properties.setValue("vbgColor", String.valueOf(vbg));
        this.properties.setValue("pdfDisplayBackground", String.valueOf(pbg));
        this.properties.setValue("vfgColor", String.valueOf(vfg));
        this.properties.setValue("replaceDocumentTextColors", String.valueOf(replaceTextColors));
        this.properties.setValue("replacePdfDisplayBackground", String.valueOf(replacePdfDisplayBackground));
        this.properties.setValue("changeTextAndLineart", String.valueOf(changeTL));
        this.properties.setValue("invertHighlights", String.valueOf(isInvert));
        this.properties.setValue("showMouseSelectionBox", String.valueOf(isBoxShown));
        this.properties.setValue("allowRightClick", String.valueOf(this.rightClick.isSelected()));
        this.properties.setValue("allowScrollwheelZoom", String.valueOf(this.scrollwheelZoom.isSelected()));
        this.properties.setValue("enhancedViewerMode", String.valueOf(this.enhancedViewer.isSelected()));
        this.properties.setValue("enhancedFacingMode", String.valueOf(this.enhancedFacing.isSelected()));
        this.properties.setValue("previewOnSingleScroll", String.valueOf(this.thumbnailScroll.isSelected()));
        this.properties.setValue("enhancedGUI", String.valueOf(this.enhancedGUI.isSelected()));
        this.properties.setValue("printerBlacklist", String.valueOf(this.printerBlacklist.getText()));
        if (((String)this.defaultPrinter.getSelectedItem()).startsWith("System Default")) {
            this.properties.setValue("defaultPrinter", "");
        } else {
            this.properties.setValue("defaultPrinter", String.valueOf(this.defaultPrinter.getSelectedItem()));
        }
        this.properties.setValue("defaultDPI", String.valueOf(this.defaultDPI.getText()));
        this.properties.setValue("defaultPagesize", String.valueOf(this.defaultPagesize.getSelectedItem()));
        this.saveGUIPreferences(gui);
    }

    public void setParent(Container parent) {
        this.parent = parent;
    }

    public void dispose() {
        this.removeAll();
        this.reverseMessage = null;
        this.menuTabs = null;
        this.propertiesLocation = null;
        if (this.propertiesDialog != null) {
            this.propertiesDialog.removeAll();
        }
        this.propertiesDialog = null;
        this.confirm = null;
        this.cancel = null;
        if (this.tabs != null) {
            this.tabs.removeAll();
        }
        this.tabs = null;
        this.resolution = null;
        this.searchStyle = null;
        this.border = null;
        this.downloadWindow = null;
        this.HiResPrint = null;
        this.constantTabs = null;
        this.enhancedViewer = null;
        this.enhancedFacing = null;
        this.thumbnailScroll = null;
        this.enhancedGUI = null;
        this.rightClick = null;
        this.scrollwheelZoom = null;
        this.update = null;
        this.maxMultiViewers = null;
        this.pageInsets = null;
        this.pageInsetsText = null;
        this.windowTitle = null;
        this.windowTitleText = null;
        this.iconLocation = null;
        this.iconLocationText = null;
        this.printerBlacklist = null;
        this.printerBlacklistText = null;
        this.defaultPrinter = null;
        this.defaultPrinterText = null;
        this.defaultPagesize = null;
        this.defaultPagesizeText = null;
        this.defaultDPI = null;
        this.defaultDPIText = null;
        this.sideTabLength = null;
        this.sideTabLengthText = null;
        this.useHinting = null;
        this.autoScroll = null;
        this.confirmClose = null;
        this.openLastDoc = null;
        this.pageLayout = null;
        if (this.highlightBoxColor != null) {
            this.highlightBoxColor.removeAll();
        }
        this.highlightBoxColor = null;
        if (this.highlightTextColor != null) {
            this.highlightTextColor.removeAll();
        }
        this.highlightTextColor = null;
        if (this.viewBGColor != null) {
            this.viewBGColor.removeAll();
        }
        this.viewBGColor = null;
        if (this.pdfDecoderBackground != null) {
            this.pdfDecoderBackground.removeAll();
        }
        this.pdfDecoderBackground = null;
        if (this.foreGroundColor != null) {
            this.foreGroundColor.removeAll();
        }
        this.foreGroundColor = null;
        if (this.invertHighlight != null) {
            this.invertHighlight.removeAll();
        }
        this.invertHighlight = null;
        if (this.replaceDocTextCol != null) {
            this.replaceDocTextCol.removeAll();
        }
        this.replaceDocTextCol = null;
        if (this.replaceDisplayBGCol != null) {
            this.replaceDisplayBGCol.removeAll();
        }
        this.replaceDisplayBGCol = null;
        if (this.changeTextAndLineArt != null) {
            this.changeTextAndLineArt.removeAll();
        }
        this.changeTextAndLineArt = null;
        this.showMouseSelectionBox = null;
        if (this.highlightComposite != null) {
            this.highlightComposite.removeAll();
        }
        this.highlightComposite = null;
        if (this.propertiesDialog != null) {
            this.propertiesDialog.removeAll();
        }
        this.parent = null;
        this.clearHistory = null;
        this.historyClearedLabel = null;
    }

    private static boolean hasFreetts() {
        return false;
    }

    class ButtonBarPanel
    extends JPanel {
        private static final long serialVersionUID = 4270546965081614451L;
        private Component currentComponent;

        public ButtonBarPanel(JPanel toolbar) {
            this.setLayout(new BorderLayout());
            JScrollPane jsp = new JScrollPane();
            jsp.getViewport().add(toolbar);
            jsp.setHorizontalScrollBarPolicy(31);
            jsp.setVerticalScrollBarPolicy(22);
            this.add((Component)jsp, "West");
            ButtonGroup group = new ButtonGroup();
            this.addButton(Messages.getMessage("PdfPreferences.GeneralTitle"), "/org/jpedal/examples/viewer/res/display.png", this.createGeneralSettings(), toolbar, group);
            this.addButton(Messages.getMessage("PdfPreferences.PageDisplayTitle"), "/org/jpedal/examples/viewer/res/pagedisplay.png", this.createPageDisplaySettings(), toolbar, group);
            this.addButton(Messages.getMessage("PdfPreferences.InterfaceTitle"), "/org/jpedal/examples/viewer/res/interface.png", this.createInterfaceSettings(), toolbar, group);
        }

        private JPanel makePanel(String title) {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel topLeft = new JLabel(title);
            topLeft.setFont(topLeft.getFont().deriveFont(1));
            topLeft.setOpaque(true);
            topLeft.setBackground(panel.getBackground().brighter());
            JPanel topbar = new JPanel(new BorderLayout());
            topbar.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            topbar.setFont(topbar.getFont().deriveFont(1));
            topbar.setOpaque(true);
            topbar.setBackground(panel.getBackground().brighter());
            topbar.add((Component)topLeft, "West");
            panel.add((Component)topbar, "North");
            panel.setPreferredSize(new Dimension(400, 300));
            panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            return panel;
        }

        private JPanel createGeneralSettings() {
            String propValue = SwingProperties.this.properties.getValue("resolution");
            if (propValue.length() > 0) {
                SwingProperties.this.resolution.setText(propValue);
            }
            if ((propValue = SwingProperties.this.properties.getValue("useHinting")).length() > 0 && propValue.equals("true")) {
                SwingProperties.this.useHinting.setSelected(true);
            } else {
                SwingProperties.this.useHinting.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("autoScroll");
            if (propValue.equals("true")) {
                SwingProperties.this.autoScroll.setSelected(true);
            } else {
                SwingProperties.this.autoScroll.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("confirmClose");
            if (propValue.equals("true")) {
                SwingProperties.this.confirmClose.setSelected(true);
            } else {
                SwingProperties.this.confirmClose.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("automaticupdate");
            if (propValue.equals("true")) {
                SwingProperties.this.update.setSelected(true);
            } else {
                SwingProperties.this.update.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("openLastDocument");
            if (propValue.equals("true")) {
                SwingProperties.this.openLastDoc.setSelected(true);
            } else {
                SwingProperties.this.openLastDoc.setSelected(false);
            }
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            JPanel pane = new JPanel();
            JScrollPane scroll = new JScrollPane(pane);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label.setFont(label.getFont().deriveFont(1));
            pane.add((Component)label, c);
            ++c.gridy;
            c.insets = new Insets(10, 0, 0, 5);
            c.gridx = 0;
            JLabel label2 = new JLabel(Messages.getMessage("PdfViewerViewMenu.Resolution"));
            label2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)label2, c);
            c.insets = new Insets(10, 0, 0, 0);
            c.weightx = 1.0;
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.resolution, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.useHinting.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.useHinting.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.useHinting, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.autoScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.autoScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.autoScroll, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.confirmClose.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.confirmClose.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.confirmClose, c);
            ++c.gridy;
            c.insets = new Insets(15, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label3 = new JLabel(Messages.getMessage("PdfPreferences.StartUp"));
            label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label3.setFont(label3.getFont().deriveFont(1));
            pane.add((Component)label3, c);
            ++c.gridy;
            c.insets = new Insets(10, 0, 0, 0);
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.update.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.update.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.update, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.openLastDoc.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.openLastDoc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.openLastDoc, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            JPanel clearHistoryPanel = new JPanel();
            clearHistoryPanel.setLayout(new BoxLayout(clearHistoryPanel, 0));
            clearHistoryPanel.add(SwingProperties.this.clearHistory);
            clearHistoryPanel.add(Box.createHorizontalGlue());
            clearHistoryPanel.add(SwingProperties.this.historyClearedLabel);
            clearHistoryPanel.add(Box.createHorizontalGlue());
            pane.add((Component)clearHistoryPanel, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.gridx = 0;
            pane.add(Box.createVerticalGlue(), c);
            panel.add((Component)scroll, "Center");
            return panel;
        }

        private JPanel createPageDisplaySettings() {
            String propValue = SwingProperties.this.properties.getValue("enhancedViewerMode");
            if (propValue.length() > 0 && propValue.equals("true")) {
                SwingProperties.this.enhancedViewer.setSelected(true);
            } else {
                SwingProperties.this.enhancedViewer.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("borderType");
            if (propValue.length() > 0) {
                if (Integer.parseInt(propValue) == 1) {
                    SwingProperties.this.border.setSelected(true);
                } else {
                    SwingProperties.this.border.setSelected(false);
                }
            }
            if ((propValue = SwingProperties.this.properties.getValue("pageInsets")) != null && propValue.length() != 0) {
                SwingProperties.this.pageInsets.setText(propValue);
            } else {
                SwingProperties.this.pageInsets.setText("25");
            }
            propValue = SwingProperties.this.properties.getValue("pageMode");
            if (propValue.length() > 0) {
                int mode = Integer.parseInt(propValue);
                if (mode < 1 || mode > 5) {
                    mode = 1;
                }
                SwingProperties.this.pageLayout.setSelectedIndex(mode - 1);
            }
            if ((propValue = SwingProperties.this.properties.getValue("enhancedFacingMode")).length() > 0 && propValue.equals("true")) {
                SwingProperties.this.enhancedFacing.setSelected(true);
            } else {
                SwingProperties.this.enhancedFacing.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("previewOnSingleScroll");
            if (propValue.length() > 0 && propValue.equals("true")) {
                SwingProperties.this.thumbnailScroll.setSelected(true);
            } else {
                SwingProperties.this.thumbnailScroll.setSelected(false);
            }
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.PageDisplayTitle"));
            JPanel pane = new JPanel();
            JScrollPane scroll = new JScrollPane(pane);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            c.gridy = 0;
            JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralSection"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label.setFont(label.getFont().deriveFont(1));
            pane.add((Component)label, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.enhancedViewer.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedViewer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.enhancedViewer, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.border.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.border.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.border, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 2;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.pageInsetsText, c);
            c.gridwidth = 2;
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.pageInsets, c);
            ++c.gridy;
            c.insets = new Insets(15, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label2 = new JLabel(Messages.getMessage("PdfPreferences.DisplayModes"));
            label2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label2.setFont(label2.getFont().deriveFont(1));
            pane.add((Component)label2, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label1 = new JLabel(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
            label1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)label1, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.weightx = 1.0;
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.pageLayout, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.thumbnailScroll.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.thumbnailScroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.thumbnailScroll, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.gridx = 0;
            pane.add(Box.createVerticalGlue(), c);
            panel.add((Component)scroll, "Center");
            return panel;
        }

        private JPanel createInterfaceSettings() {
            String propValue = SwingProperties.this.properties.getValue("enhancedGUI");
            if (propValue.length() > 0 && propValue.equals("true")) {
                SwingProperties.this.enhancedGUI.setSelected(true);
            } else {
                SwingProperties.this.enhancedGUI.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("allowRightClick");
            if (propValue.length() > 0 && propValue.equals("true")) {
                SwingProperties.this.rightClick.setSelected(true);
            } else {
                SwingProperties.this.rightClick.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("allowScrollwheelZoom");
            if (propValue.length() > 0 && propValue.equals("true")) {
                SwingProperties.this.scrollwheelZoom.setSelected(true);
            } else {
                SwingProperties.this.scrollwheelZoom.setSelected(false);
            }
            propValue = SwingProperties.this.properties.getValue("windowTitle");
            if (propValue != null && propValue.length() != 0) {
                SwingProperties.this.windowTitle.setText(propValue);
            }
            if ((propValue = SwingProperties.this.properties.getValue("iconLocation")) != null && propValue.length() != 0) {
                SwingProperties.this.iconLocation.setText(propValue);
            } else {
                SwingProperties.this.iconLocation.setText("/org/jpedal/examples/viewer/res/");
            }
            propValue = SwingProperties.this.properties.getValue("searchWindowType");
            if (propValue.length() > 0) {
                SwingProperties.this.searchStyle.setSelectedIndex(Integer.parseInt(propValue));
            } else {
                SwingProperties.this.searchStyle.setSelectedIndex(0);
            }
            propValue = SwingProperties.this.properties.getValue("maxmultiviewers");
            if (propValue != null && propValue.length() > 0) {
                SwingProperties.this.maxMultiViewers.setText(propValue);
            }
            if ((propValue = SwingProperties.this.properties.getValue("sideTabBarCollapseLength")) != null && propValue.length() != 0) {
                SwingProperties.this.sideTabLength.setText(propValue);
            } else {
                SwingProperties.this.sideTabLength.setText("30");
            }
            propValue = SwingProperties.this.properties.getValue("consistentTabBar");
            if (propValue.length() > 0 && propValue.equals("true")) {
                SwingProperties.this.constantTabs.setSelected(true);
            } else {
                SwingProperties.this.constantTabs.setSelected(false);
            }
            String showBox = SwingProperties.this.properties.getValue("showMouseSelectionBox");
            if (showBox.length() > 0 && showBox.toLowerCase().equals("true")) {
                SwingProperties.this.showMouseSelectionBox.setSelected(true);
            } else {
                SwingProperties.this.showMouseSelectionBox.setSelected(false);
            }
            JPanel panel = this.makePanel(Messages.getMessage("PdfPreferences.InterfaceTitle"));
            JTabbedPane tabs = new JTabbedPane();
            JPanel pane = new JPanel();
            JScrollPane scroll = new JScrollPane(pane);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            pane.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridwidth = 1;
            c.gridy = 0;
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label.setFont(label.getFont().deriveFont(1));
            pane.add((Component)label, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridx = 0;
            c.gridwidth = 2;
            SwingProperties.this.enhancedGUI.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.enhancedGUI.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.enhancedGUI, c);
            ++c.gridy;
            c.insets = new Insets(3, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.windowTitleText, c);
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.windowTitle, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            pane.add((Component)SwingProperties.this.iconLocationText, c);
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.iconLocation, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridx = 0;
            JLabel label5 = new JLabel(Messages.getMessage("PageLayoutViewMenu.SearchLayout"));
            label5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)label5, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.weightx = 1.0;
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.searchStyle, c);
            ++c.gridy;
            c.insets = new Insets(15, 0, 0, 5);
            c.gridwidth = 1;
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label1 = new JLabel(Messages.getMessage("PdfPreferences.SideTab"));
            label1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label1.setFont(label1.getFont().deriveFont(1));
            pane.add((Component)label1, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 1;
            c.gridx = 0;
            SwingProperties.this.sideTabLengthText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.sideTabLengthText, c);
            c.insets = new Insets(5, 0, 0, 0);
            c.weightx = 1.0;
            c.gridx = 1;
            pane.add((Component)SwingProperties.this.sideTabLength, c);
            ++c.gridy;
            c.insets = new Insets(5, 0, 0, 0);
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.constantTabs.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.constantTabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane.add((Component)SwingProperties.this.constantTabs, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.gridx = 0;
            pane.add(Box.createVerticalGlue(), c);
            tabs.add(Messages.getMessage("PdfPreferences.AppearanceTab"), scroll);
            JPanel pane2 = new JPanel();
            JScrollPane scroll2 = new JScrollPane(pane2);
            scroll2.setBorder(BorderFactory.createEmptyBorder());
            pane2.setLayout(new GridBagLayout());
            c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridwidth = 1;
            c.gridy = 0;
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label3 = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            label3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label3.setFont(label3.getFont().deriveFont(1));
            pane2.add((Component)label3, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.rightClick.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.rightClick.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane2.add((Component)SwingProperties.this.rightClick, c);
            ++c.gridy;
            c.gridwidth = 2;
            c.gridx = 0;
            SwingProperties.this.scrollwheelZoom.setMargin(new Insets(0, 0, 0, 0));
            SwingProperties.this.scrollwheelZoom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            pane2.add((Component)SwingProperties.this.scrollwheelZoom, c);
            ++c.gridy;
            c.insets = new Insets(0, 0, 0, 5);
            c.gridwidth = 1;
            c.gridx = 0;
            pane2.add((Component)SwingProperties.this.showMouseSelectionBox, c);
            ++c.gridy;
            c.weighty = 1.0;
            c.gridx = 0;
            pane2.add(Box.createVerticalGlue(), c);
            tabs.add(Messages.getMessage("PdfPreferences.Mouse"), scroll2);
            JPanel pane3 = new JPanel();
            JScrollPane scroll3 = new JScrollPane(pane3);
            scroll3.setBorder(BorderFactory.createEmptyBorder());
            pane3.setLayout(new GridBagLayout());
            c = new GridBagConstraints();
            c.fill = 1;
            c.insets = new Insets(5, 0, 0, 5);
            c.gridwidth = 1;
            c.gridy = 0;
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            JLabel label6 = new JLabel(Messages.getMessage("PdfPreferences.GeneralTitle"));
            label6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            label6.setFont(label6.getFont().deriveFont(1));
            pane3.add((Component)label6, c);
            panel.add((Component)tabs, "Center");
            return panel;
        }

        private void addMenuToTree(int tab, NodeList nodes, CheckNode top, List previous) {
            for (int i = 0; i != nodes.getLength(); ++i) {
                String name;
                if (i >= nodes.getLength() || (name = nodes.item(i).getNodeName()).startsWith("#")) continue;
                CheckNode newLeaf = new CheckNode(Messages.getMessage("PdfCustomGui." + name));
                newLeaf.setEnabled(true);
                SwingProperties.this.reverseMessage.put(Messages.getMessage("PdfCustomGui." + name), name);
                String propValue = SwingProperties.this.properties.getValue(name);
                if (propValue.length() > 0 && propValue.equals("true")) {
                    newLeaf.setSelected(true);
                } else {
                    newLeaf.setSelected(false);
                }
                if (nodes.item(i).hasChildNodes()) {
                    previous.add(top);
                    top.add(newLeaf);
                    this.addMenuToTree(tab, nodes.item(i).getChildNodes(), newLeaf, previous);
                    continue;
                }
                top.add(newLeaf);
            }
        }

        private void show(Component component) {
            if (this.currentComponent != null) {
                this.remove(this.currentComponent);
            }
            this.currentComponent = component;
            this.add("Center", this.currentComponent);
            this.revalidate();
            this.repaint();
        }

        private void addButton(String title, String iconUrl, final Component component, JPanel bar, ButtonGroup group) {
            AbstractAction action = new AbstractAction(title, new ImageIcon(this.getClass().getResource(iconUrl))){
                private static final long serialVersionUID = -8952528314596587694L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonBarPanel.this.show(component);
                }
            };
            JToggleButton button = new JToggleButton(action);
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setContentAreaFilled(false);
            if (DecoderOptions.isRunningOnMac) {
                button.setHorizontalAlignment(2);
            }
            button.setAlignmentX(0.5f);
            bar.add(button);
            group.add(button);
            if (group.getSelection() == null) {
                button.setSelected(true);
                this.show(component);
            }
        }
    }
}

