/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.swing.SwingMouseFunctionality;

public class SwingMousePanMode
implements SwingMouseFunctionality {
    private Point currentPoint;
    private PdfDecoder decode_pdf;
    private Rectangle currentView;

    public SwingMousePanMode(PdfDecoder decode_pdf) {
        this.decode_pdf = decode_pdf;
    }

    public void setupMouse() {
        SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        this.decode_pdf.setCursor(gui.getCursor(1));
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        if (arg0.getButton() == 1 || arg0.getButton() == 0) {
            this.currentPoint = arg0.getPoint();
            this.currentView = this.decode_pdf.getVisibleRect();
            SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
            this.decode_pdf.setCursor(gui.getCursor(2));
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        SwingGUI gui = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        this.decode_pdf.setCursor(gui.getCursor(1));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            Point newPoint = e.getPoint();
            int diffX = this.currentPoint.x - newPoint.x;
            int diffY = this.currentPoint.y - newPoint.y;
            Rectangle view = this.currentView;
            view.x += diffX;
            view.y += diffY;
            if (!view.contains(this.decode_pdf.getVisibleRect())) {
                this.decode_pdf.scrollRectToVisible(view);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

