/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.PdfDecoder;
import org.jpedal.ThumbnailDecoder;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Object;

public class SwingThumbnailPanel
extends JScrollPane
implements GUIThumbnailPanel {
    private static final long serialVersionUID = 3160861494248549900L;
    static final boolean debugThumbnails = false;
    SwingWorker worker = null;
    JPanel panel = new JPanel();
    private ThumbPainter painter = new ThumbPainter();
    private boolean showThumbnailsdefault;
    private boolean showThumbnails = this.showThumbnailsdefault = true;
    public boolean interrupt = false;
    public boolean drawing;
    public boolean generateOtherVisibleThumbnails = false;
    public ThumbnailDecoder thumbDecoder;
    private JButton[] pageButton;
    private BufferedImage[] images;
    private boolean[] buttonDrawn;
    private boolean[] isLandscape;
    private int[] pageHeight;
    private static final int thumbH = 100;
    private static final int thumbW = 70;
    Values commonValues;
    final PdfDecoder decode_pdf;
    boolean isExtractor = false;
    private int lastPage = -1;

    public SwingThumbnailPanel(Values commonValues, final PdfDecoder decode_pdf) {
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.commonValues = commonValues;
        this.decode_pdf = decode_pdf;
        this.thumbDecoder = new ThumbnailDecoder(decode_pdf);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!SwingThumbnailPanel.this.isExtractor) {
                    if (SwingThumbnailPanel.this.drawing) {
                        SwingThumbnailPanel.this.terminateDrawing();
                    }
                    decode_pdf.waitForDecodingToFinish();
                    if (decode_pdf.isOpen()) {
                        SwingThumbnailPanel.this.drawThumbnails();
                    }
                }
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    @Override
    public void generateOtherThumbnails(String[] imageFiles, Vector_Object thumbnailsStored) {
        this.drawing = true;
        this.getViewport().removeAll();
        this.panel.removeAll();
        int pages = imageFiles.length;
        this.getViewport().add(this.panel);
        this.panel.setLayout(new GridLayout(pages, 1, 0, 10));
        for (int i = 0; i < pages; ++i) {
            try {
                BufferedImage page;
                if (imageFiles[i] == null) continue;
                Object cachedThumbnail = thumbnailsStored.elementAt(i);
                this.decode_pdf.waitForDecodingToFinish();
                if (cachedThumbnail == null) {
                    page = ImageIO.read(new File(imageFiles[i]));
                    thumbnailsStored.addElement(page);
                } else {
                    page = (BufferedImage)cachedThumbnail;
                }
                if (page == null) continue;
                int w = page.getWidth();
                int h = page.getHeight();
                Graphics2D g2 = (Graphics2D)page.getGraphics();
                g2.setColor(Color.black);
                g2.draw(new Rectangle(0, 0, w - 1, h - 1));
                ImageIcon pageIcon = h > w ? new ImageIcon(page.getScaledInstance(-1, 100, 2)) : new ImageIcon(page.getScaledInstance(100, -1, 2));
                this.pageButton[i].setIcon(pageIcon);
                this.pageButton[i].setVisible(true);
                this.buttonDrawn[i] = true;
                this.panel.add(this.pageButton[i]);
                continue;
            }
            catch (Exception e) {
                LogWriter.writeLog("Exception " + e + " loading " + imageFiles[i]);
            }
        }
        this.drawing = false;
        this.panel.setVisible(true);
    }

    @Override
    public synchronized void generateOtherVisibleThumbnails(final int currentPage) {
        try {
            this.generateOtherVisibleThumbnails = true;
            if (currentPage == -1 || currentPage == this.lastPage || this.pageButton == null) {
                return;
            }
            this.lastPage = currentPage;
            int count = this.decode_pdf.getPageCount();
            for (int i1 = 0; i1 < count; ++i1) {
                if (!this.generateOtherVisibleThumbnails) {
                    return;
                }
                if (i1 == currentPage - 1 || i1 >= this.pageButton.length) continue;
                this.pageButton[i1].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            if (currentPage - 1 < this.pageButton.length) {
                Rectangle rect;
                if (count > 1 && currentPage > 0) {
                    this.pageButton[currentPage - 1].setBorder(BorderFactory.createLineBorder(Color.red));
                }
                if (!(rect = this.panel.getVisibleRect()).contains(this.pageButton[currentPage - 1].getLocation())) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        Rectangle vis = new Rectangle(this.pageButton[currentPage - 1].getLocation().x, this.pageButton[currentPage - 1].getLocation().y, this.pageButton[currentPage - 1].getBounds().width, this.pageButton[currentPage - 1].getBounds().height);
                        this.panel.scrollRectToVisible(vis);
                    } else {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                if (!SwingThumbnailPanel.this.generateOtherVisibleThumbnails) {
                                    return;
                                }
                                Rectangle vis = new Rectangle(((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[currentPage - 1].getLocation().x, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[currentPage - 1].getLocation().y, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[currentPage - 1].getBounds().width, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[currentPage - 1].getBounds().height);
                                if (!SwingThumbnailPanel.this.generateOtherVisibleThumbnails) {
                                    return;
                                }
                                SwingThumbnailPanel.this.panel.scrollRectToVisible(vis);
                            }
                        });
                    }
                }
            }
            if (!this.generateOtherVisibleThumbnails) {
                return;
            }
            if (this.drawing) {
                this.terminateDrawing();
            }
            if (!this.generateOtherVisibleThumbnails) {
                return;
            }
            this.drawThumbnails();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void drawThumbnails() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.decode_pdf.isLoadingLinearizedPDF()) {
            return;
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        this.worker = new SwingWorker(){

            @Override
            public Object construct() {
                SwingThumbnailPanel.this.drawing = true;
                try {
                    Rectangle rect = SwingThumbnailPanel.this.panel.getVisibleRect();
                    int pages = SwingThumbnailPanel.this.decode_pdf.getPageCount();
                    for (int i = 0; i < pages; ++i) {
                        SwingThumbnailPanel.this.decode_pdf.waitForDecodingToFinish();
                        if (SwingThumbnailPanel.this.interrupt) {
                            i = pages;
                            continue;
                        }
                        if (SwingThumbnailPanel.this.buttonDrawn == null || SwingThumbnailPanel.this.pageButton == null || rect == null || SwingThumbnailPanel.this.buttonDrawn[i] || SwingThumbnailPanel.this.pageButton[i] == null || !rect.intersects(SwingThumbnailPanel.this.pageButton[i].getBounds())) continue;
                        int h = 100;
                        if (SwingThumbnailPanel.this.isLandscape[i]) {
                            h = 70;
                        }
                        BufferedImage page = SwingThumbnailPanel.this.thumbDecoder.getPageAsThumbnail(i + 1, h);
                        if (SwingThumbnailPanel.this.interrupt) continue;
                        SwingThumbnailPanel.this.createThumbnail(page, i + 1, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingThumbnailPanel.this.interrupt = false;
                SwingThumbnailPanel.this.drawing = false;
                return null;
            }
        };
        this.worker.start();
    }

    private static BufferedImage createBlankThumbnail(int w, int h) {
        BufferedImage blank = new BufferedImage(w + 1, h + 1, 1);
        Graphics2D g2 = (Graphics2D)blank.getGraphics();
        g2.setColor(Color.white);
        g2.fill(new Rectangle(0, 0, w, h));
        g2.setColor(Color.black);
        g2.draw(new Rectangle(0, 0, w, h));
        g2.drawLine(0, 0, w, h);
        g2.drawLine(0, h, w, 0);
        return blank;
    }

    public BufferedImage getThumbnail(int page) {
        if (this.pageButton == null || this.pageButton[page] == null) {
            return null;
        }
        return (BufferedImage)((ImageIcon)this.pageButton[page].getIcon()).getImage();
    }

    @Override
    public synchronized BufferedImage getImage(int page) {
        if (this.images == null || this.images[--page] == null) {
            if (page > -1) {
                BufferedImage image;
                int h = 100;
                if (this.isLandscape[page]) {
                    h = 70;
                }
                this.images[page] = image = this.thumbDecoder.getPageAsThumbnail(page + 1, h);
                return image;
            }
            return null;
        }
        return this.images[page];
    }

    private void createThumbnail(BufferedImage page, int i, boolean highLightThumbnail) {
        --i;
        if (page != null) {
            Graphics2D g2 = (Graphics2D)page.getGraphics();
            g2.setColor(Color.black);
            g2.draw(new Rectangle(0, 0, page.getWidth() - 1, page.getHeight() - 1));
            final ImageIcon pageIcon = new ImageIcon(page);
            if (SwingUtilities.isEventDispatchThread()) {
                this.pageButton[i].setIcon(pageIcon);
                this.buttonDrawn[i] = true;
            } else {
                final int ii = i;
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        SwingThumbnailPanel.this.pageButton[ii].setIcon(pageIcon);
                        ((SwingThumbnailPanel)SwingThumbnailPanel.this).buttonDrawn[ii] = true;
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        }
    }

    @Override
    public void setupThumbnails(int pages, int[] pageUsed, int pageCount) {
        this.isExtractor = true;
        this.lastPage = -1;
        Font textFont = new Font("Serif", 0, 12);
        this.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage blankPortrait = SwingThumbnailPanel.createBlankThumbnail(70, 100);
        ImageIcon portrait = new ImageIcon(blankPortrait.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[pages];
        this.pageHeight = new int[pages];
        this.pageButton = new JButton[pages];
        this.images = new BufferedImage[pages];
        this.buttonDrawn = new boolean[pages];
        for (int i = 0; i < pages; ++i) {
            int page = i + 1;
            this.pageButton[i] = pageCount < 2 ? new JButton(String.valueOf(page), portrait) : new JButton(String.valueOf(page) + " ( Page " + pageUsed[i] + " )", portrait);
            this.isLandscape[i] = false;
            this.pageHeight[i] = 100;
            this.pageButton[i].setVerticalTextPosition(3);
            this.pageButton[i].setHorizontalTextPosition(0);
            if (i == 0 && pages > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i].setFont(textFont);
        }
    }

    @Override
    public void resetHighlightedThumbnail(int item) {
        if (this.pageButton != null) {
            int pages = this.pageButton.length;
            for (int i = 0; i < pages; ++i) {
                if (i == item) {
                    this.pageButton[i].setBorder(BorderFactory.createLineBorder(Color.red));
                    continue;
                }
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
        }
    }

    @Override
    public void setupThumbnails(int pages, Font textFont, String message, PdfPageData pageData) {
        this.lastPage = -1;
        this.getViewport().removeAll();
        this.panel.removeAll();
        this.getViewport().add(this.panel);
        this.panel.setLayout(new GridLayout(pages, 1, 0, 10));
        this.panel.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage blankPortrait = SwingThumbnailPanel.createBlankThumbnail(70, 100);
        BufferedImage blankLandscape = SwingThumbnailPanel.createBlankThumbnail(100, 70);
        ImageIcon landscape = new ImageIcon(blankLandscape.getScaledInstance(-1, 70, 4));
        ImageIcon portrait = new ImageIcon(blankPortrait.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[pages];
        this.pageHeight = new int[pages];
        this.pageButton = new JButton[pages];
        this.images = new BufferedImage[pages];
        this.buttonDrawn = new boolean[pages];
        for (int i = 0; i < pages; ++i) {
            ImageIcon usedPortrait;
            ImageIcon usedLandscape;
            int ph;
            int page = i + 1;
            int cropWidth = pageData.getCropBoxWidth(page);
            int cropHeight = pageData.getCropBoxHeight(page);
            int rotation = pageData.getRotation(page);
            if (rotation == 0 | rotation == 180) {
                ph = pageData.getMediaBoxHeight(page);
                usedLandscape = landscape;
                usedPortrait = portrait;
            } else {
                ph = pageData.getMediaBoxWidth(page);
                usedLandscape = portrait;
                usedPortrait = landscape;
            }
            if (cropWidth > cropHeight) {
                this.pageButton[i] = new JButton(message + ' ' + page, usedLandscape);
                this.isLandscape[i] = true;
                this.pageHeight[i] = ph;
            } else {
                this.pageButton[i] = new JButton(message + ' ' + page, usedPortrait);
                this.isLandscape[i] = false;
                this.pageHeight[i] = ph;
            }
            this.pageButton[i].setVerticalTextPosition(3);
            this.pageButton[i].setHorizontalTextPosition(0);
            if (i == 0 && pages > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i].setFont(textFont);
            this.panel.add((Component)this.pageButton[i], "Center");
        }
    }

    @Override
    public Object[] getButtons() {
        return this.pageButton;
    }

    @Override
    public void setThumbnailsEnabled(boolean newValue) {
        this.showThumbnailsdefault = newValue;
        this.showThumbnails = newValue;
    }

    @Override
    public boolean isShownOnscreen() {
        return this.showThumbnails;
    }

    @Override
    public void resetToDefault() {
        this.showThumbnails = this.showThumbnailsdefault;
    }

    @Override
    public void setIsDisplayedOnscreen(boolean b) {
        this.showThumbnails = b;
    }

    @Override
    public void addComponentListener() {
        this.panel.addComponentListener(this.painter);
    }

    @Override
    public void removeAllListeners() {
        this.panel.removeComponentListener(this.painter);
        Object[] buttons = this.getButtons();
        if (buttons != null) {
            for (Object button : buttons) {
                ActionListener[] l;
                for (ActionListener aL : l = ((JButton)button).getActionListeners()) {
                    ((JButton)button).removeActionListener(aL);
                }
            }
        }
    }

    @Override
    public void terminateDrawing() {
        this.generateOtherVisibleThumbnails = false;
        if (this.drawing) {
            this.interrupt = true;
            while (this.drawing) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.interrupt = false;
        }
    }

    @Override
    public void refreshDisplay() {
        this.validate();
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.worker = null;
        if (this.panel != null) {
            this.panel.removeAll();
        }
        this.panel = null;
        this.painter = null;
        this.thumbDecoder = null;
        this.pageButton = null;
        this.buttonDrawn = null;
        this.isLandscape = null;
        this.pageHeight = null;
        this.images = null;
    }

    private class ThumbPainter
    extends ComponentAdapter {
        boolean requestMade = false;
        Timer trapMultipleMoves = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!ThumbPainter.this.requestMade) {
                    ThumbPainter.this.requestMade = true;
                    if (!Values.isProcessing()) {
                        if (SwingThumbnailPanel.this.drawing) {
                            SwingThumbnailPanel.this.terminateDrawing();
                        }
                        ThumbPainter.this.requestMade = false;
                        SwingThumbnailPanel.this.drawThumbnails();
                    }
                }
            }
        });

        private ThumbPainter() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.trapMultipleMoves.isRunning()) {
                this.trapMultipleMoves.stop();
            }
            this.trapMultipleMoves.setRepeats(false);
            this.trapMultipleMoves.start();
        }
    }
}

