/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.Name;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;

public class NameWriter
extends Name
implements FontTableWriter {
    private static final long serialVersionUID = -962145337573257284L;
    String[] strings = new String[7];

    public NameWriter(PdfFont currentFontData, PdfJavaGlyphs glyphs, String name) {
        name = name.replaceAll("[.,<>*#]", "-");
        this.strings[0] = currentFontData.getCopyright() != null ? currentFontData.getCopyright() : "No copyright information found.";
        this.strings[1] = name;
        switch (glyphs.style) {
            case 0: {
                this.strings[2] = "Roman";
                break;
            }
            case 1: {
                this.strings[2] = "Bold";
                break;
            }
            case 2: {
                this.strings[2] = "Italic";
                break;
            }
            default: {
                this.strings[2] = "Roman";
            }
        }
        this.strings[3] = "JPedal PDF2HTML " + name + ' ' + new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(Calendar.getInstance().getTime());
        this.strings[4] = name;
        this.strings[5] = "Version 1.0";
        this.strings[6] = name;
    }

    @Override
    public byte[] writeTable() throws IOException {
        byte[] s;
        int i;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(FontWriter.setNextUint16(0));
        bos.write(FontWriter.setNextUint16(14));
        bos.write(FontWriter.setNextUint16(174));
        int offset = 0;
        for (i = 0; i < 7; ++i) {
            bos.write(FontWriter.setNextUint16(1));
            bos.write(FontWriter.setNextUint16(0));
            bos.write(FontWriter.setNextUint16(0));
            bos.write(FontWriter.setNextUint16(i));
            bos.write(FontWriter.setNextUint16(this.strings[i].length()));
            bos.write(FontWriter.setNextUint16(offset));
            offset += this.strings[i].length();
        }
        for (i = 0; i < 7; ++i) {
            bos.write(FontWriter.setNextUint16(3));
            bos.write(FontWriter.setNextUint16(1));
            bos.write(FontWriter.setNextUint16(1033));
            bos.write(FontWriter.setNextUint16(i));
            bos.write(FontWriter.setNextUint16(this.strings[i].length() * 2));
            bos.write(FontWriter.setNextUint16(offset));
            offset += this.strings[i].length() * 2;
        }
        for (i = 0; i < 7; ++i) {
            for (byte value : s = this.strings[i].getBytes("US-ASCII")) {
                bos.write(FontWriter.setNextUint8(value));
            }
        }
        for (i = 0; i < 7; ++i) {
            for (byte value : s = this.strings[i].getBytes("UTF-16BE")) {
                bos.write(FontWriter.setNextUint8(value));
            }
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    @Override
    public int getIntValue(int key) {
        int value = 0;
        switch (key) {
            default: 
        }
        return value;
    }
}

