/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import org.jpedal.function.PDFFunction;
import org.jpedal.function.PDFGenericFunction;

public class PDFSampled
extends PDFGenericFunction
implements PDFFunction {
    private static final long serialVersionUID = -2510153148040368247L;
    private int[] size;
    private float[] samples;
    int returnValues;

    public PDFSampled(byte[] stream, int bits, float[] domain, float[] range, float[] encode, float[] decode, int[] size) {
        super(domain, range);
        int count;
        int byteReached;
        int count2;
        int ii;
        int defaultSize;
        this.size = size;
        int bitsPerSample = bits;
        if (encode != null) {
            this.encode = encode;
        } else {
            defaultSize = size.length;
            this.encode = new float[defaultSize * 2];
            for (ii = 0; ii < defaultSize; ++ii) {
                this.encode[ii * 2 + 1] = size[ii] - 1;
            }
        }
        if (decode != null) {
            this.decode = decode;
        } else {
            defaultSize = range.length;
            this.decode = new float[defaultSize];
            System.arraycopy(range, 0, this.decode, 0, defaultSize);
        }
        if (bitsPerSample == 8) {
            count2 = stream.length;
            this.samples = new float[count2];
            for (ii = 0; ii < count2; ++ii) {
                this.samples[ii] = (float)(stream[ii] & 0xFF) / 256.0f;
            }
        } else if (bitsPerSample == 4) {
            count2 = stream.length * 2;
            this.samples = new float[count2];
            byteReached = 0;
            for (int ii2 = 0; ii2 < count2; ii2 += 2) {
                this.samples[ii2] = (float)((stream[byteReached] & 0xF0) >> 4) / 16.0f;
                this.samples[ii2 + 1] = (float)(stream[byteReached] & 0xF) / 16.0f;
                ++byteReached;
            }
        } else if (bitsPerSample == 2) {
            count2 = stream.length * 4;
            this.samples = new float[count2];
            byteReached = 0;
            for (int ii3 = 0; ii3 < count2; ii3 += 4) {
                this.samples[ii3] = (float)((stream[byteReached] & 0xC0) >> 6) / 4.0f;
                this.samples[ii3 + 1] = (float)((stream[byteReached] & 0x30) >> 4) / 4.0f;
                this.samples[ii3 + 2] = (float)((stream[byteReached] & 0xC) >> 2) / 4.0f;
                this.samples[ii3 + 3] = (float)(stream[byteReached] & 3) / 4.0f;
                ++byteReached;
            }
        } else if (bitsPerSample == 1) {
            count2 = stream.length * 8;
            this.samples = new float[count2];
            byteReached = 0;
            for (int ii4 = 0; ii4 < count2; ii4 += 8) {
                this.samples[ii4] = (float)((stream[byteReached] & 0x80) >> 7) / 2.0f;
                this.samples[ii4 + 1] = (float)((stream[byteReached] & 0x40) >> 6) / 2.0f;
                this.samples[ii4 + 2] = (float)((stream[byteReached] & 0x20) >> 5) / 2.0f;
                this.samples[ii4 + 3] = (float)((stream[byteReached] & 0x10) >> 4) / 2.0f;
                this.samples[ii4 + 4] = (float)((stream[byteReached] & 8) >> 3) / 2.0f;
                this.samples[ii4 + 5] = (float)((stream[byteReached] & 4) >> 2) / 2.0f;
                this.samples[ii4 + 6] = (float)((stream[byteReached] & 2) >> 1) / 2.0f;
                this.samples[ii4 + 7] = (float)(stream[byteReached] & 1) / 2.0f;
                ++byteReached;
            }
        } else if (bitsPerSample == 12) {
            int samplesPerByte = 16 / bitsPerSample;
            count = stream.length * samplesPerByte * 2;
            this.samples = new float[count];
            int byteReached2 = 0;
            int bitsLeft = 0;
            int maxSize = (2 << bitsPerSample) - 1;
            for (int ii5 = 0; ii5 < count; ++ii5) {
                for (int jj = 0; jj < samplesPerByte; ++jj) {
                    this.samples[ii5] = (((stream[byteReached2] << 8) + stream[byteReached2] & maxSize << 16 - jj * bitsPerSample) >> 16 - bitsPerSample) / maxSize;
                }
                while (bitsLeft > 16) {
                    byteReached2 += 2;
                    bitsLeft -= 16;
                }
            }
        } else {
            int bytes = bitsPerSample / 8;
            count = stream.length / bytes;
            this.samples = new float[count];
            int byteReached3 = 0;
            long maxSize = 1L;
            if (bitsPerSample == 16) {
                maxSize = 65536L;
            } else if (bitsPerSample == 24) {
                maxSize = 0x1000000L;
            } else if (bitsPerSample == 32) {
                maxSize = 0x19990000L;
            }
            for (int ii6 = 0; ii6 < count; ++ii6) {
                long val = 0L;
                for (int aa = 0; aa < bytes; ++aa) {
                    val += (long)((stream[byteReached3 + aa] & 0xFF) << 8 * (bytes - aa - 1));
                }
                this.samples[ii6] = (float)val / (float)maxSize;
                byteReached3 += bytes;
            }
        }
        this.returnValues = range.length / 2;
    }

    @Override
    public float[] computeStitch(float[] subinput) {
        return this.compute(subinput);
    }

    @Override
    public float[] compute(float[] input) {
        float[] result = new float[this.returnValues];
        int n = this.range.length / 2;
        int m = this.domain.length / 2;
        if (n < m) {
            int size = input.length;
            float[] reversed = new float[size];
            for (int ii = 0; ii < size; ++ii) {
                reversed[size - ii - 1] = input[ii];
            }
            input = reversed;
        }
        float[] e = new float[m * 2];
        float[] x = input;
        for (int i = 0; i < m; ++i) {
            int j;
            e[i * 2] = this.encodeInput(x[i], i);
            if (n == m) {
                result[i] = this.decodeSample(e[i * 2], i, n, 0);
                continue;
            }
            if (m < n) {
                for (j = 0; j < n; ++j) {
                    result[j] = this.decodeSample(e[i * 2], j, n, j);
                }
                continue;
            }
            if (n >= m) continue;
            for (j = 0; j < n; ++j) {
                result[j] = this.decodeSample(e[i * 2], j, n, j);
            }
        }
        return result;
    }

    private float encodeInput(float value, int point) {
        value = PDFSampled.min(PDFSampled.max(value, this.domain[point * 2]), this.domain[point * 2 + 1]);
        value = PDFSampled.interpolate(value, this.domain[point * 2], this.domain[point * 2 + 1], this.encode[point * 2], this.encode[point * 2 + 1]);
        value = PDFSampled.min(PDFSampled.max(value, 0.0f), this.size[point] - 1);
        return value;
    }

    private float decodeSample(float value, int j, int n, int modifier) {
        int sample = (int)value;
        if (value - (float)((int)value) > 0.0f) {
            sample = (int)value + 1;
        }
        float frac1 = (float)sample - value;
        float frac0 = 1.0f - frac1;
        int lower = (int)value * n + modifier;
        int upper = sample * n + modifier;
        float output = frac1 * this.samples[lower] + frac0 * this.samples[upper];
        output = PDFSampled.interpolate(output, 0.0f, 1.0f, this.decode[j * 2], this.decode[j * 2 + 1]);
        output = PDFSampled.min(PDFSampled.max(output, this.range[j * 2]), this.range[j * 2 + 1]);
        return output;
    }
}

