/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import org.jpedal.gui.ImagePanel;
import org.jpedal.utils.LogWriter;

public class ShowGUIMessage {
    private static Container contentPane = null;
    private static boolean outputMessages = false;

    public static final void showGUIMessage(String user_message, JTextPane messages, String title) {
        messages.setEditable(false);
        JPanel display = new JPanel();
        JScrollPane display_scroll_pane = new JScrollPane();
        display_scroll_pane.setHorizontalScrollBarPolicy(31);
        display_scroll_pane.getViewport().add(messages);
        display.setLayout(new BorderLayout());
        display.add((Component)display_scroll_pane, "Center");
        if (user_message != null) {
            display.add((Component)new JLabel("<HTML><BODY><I>" + user_message + "</I></BODY></HTML>", 0), "South");
        }
        messages.setEditable(false);
        display.setPreferredSize(new Dimension(300, 200));
        JOptionPane.showConfirmDialog(contentPane, display, title, -1, -1);
    }

    public static final void showGUIMessage(String user_message, JLabel messages, String title) {
        JPanel display = new JPanel();
        display.setLayout(new BorderLayout());
        display.add((Component)messages, "Center");
        if (user_message != null) {
            display.add((Component)new JLabel(user_message, 0), "South");
        }
        JOptionPane.showConfirmDialog(contentPane, display, title, -1, -1);
        contentPane.setVisible(true);
    }

    public static final void setParentFrame(JFrame main_frame) {
        contentPane = main_frame;
    }

    public static final void showstaticGUIMessage(StringBuffer message, String title) {
        JTextArea text_pane = new JTextArea();
        text_pane.setEditable(false);
        text_pane.setWrapStyleWord(true);
        text_pane.append("  " + message + "  ");
        JPanel display = new JPanel();
        display.setLayout(new BorderLayout());
        display.add((Component)text_pane, "Center");
        int width = (int)text_pane.getSize().getWidth();
        int height = (int)text_pane.getSize().getHeight();
        display.setSize(new Dimension(width + 10, height + 10));
        JOptionPane.showConfirmDialog(contentPane, display, title, -1, -1);
    }

    public static final void setClientDisplay() {
        outputMessages = true;
    }

    public static final void showGUIMessage(String user_message, ImageIcon image, String title) {
        JPanel display = new JPanel();
        display.setLayout(new BorderLayout());
        JLabel message_component = new JLabel(image);
        display.add((Component)message_component, "Center");
        if (user_message != null) {
            display.add((Component)new JLabel(user_message), "South");
        }
        int width = (int)message_component.getSize().getWidth();
        int height = (int)message_component.getSize().getHeight();
        display.setSize(new Dimension(width + 10, height + 10));
        int type = -1;
        int display_type = -1;
        JOptionPane.showConfirmDialog(contentPane, display, title, type, display_type);
    }

    public static final void showGUIMessage(String user_message, BufferedImage image, String title) {
        if (image == null) {
            return;
        }
        ImagePanel display = new ImagePanel(image);
        display.setLayout(new BorderLayout());
        if (user_message != null) {
            display.add((Component)new JLabel(user_message), "South");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        display.setSize(new Dimension(width + 10, height + 10));
        JOptionPane.showConfirmDialog(contentPane, display, title, -1, -1);
    }

    public static final void showGUIMessage(String file_name, String title, String dummy) {
        BufferedImage image = null;
        try {
            FileInputStream in = new FileInputStream(file_name);
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " getting image");
        }
        if (image != null) {
            JPanel display = new JPanel();
            JScrollPane display_scroll_pane = new JScrollPane();
            display_scroll_pane.setHorizontalScrollBarPolicy(31);
            display.setLayout(new BorderLayout());
            display.add((Component)display_scroll_pane, "Center");
            display.setPreferredSize(new Dimension(300, 200));
            JOptionPane.showConfirmDialog(contentPane, display, title, -1, -1);
        }
    }

    public static final void showGUIMessage(String message_string, String title) {
        if (outputMessages) {
            String output_string = "<HTML><BODY><CENTER><FONT COLOR=black>";
            StringTokenizer lines = new StringTokenizer(message_string, "\n");
            while (lines.hasMoreTokens()) {
                output_string = output_string + lines.nextToken() + "</FONT></CENTER><CENTER><FONT COLOR=black>";
            }
            output_string = output_string + "</FONT></CENTER></BODY></HTML>";
            JLabel text_message = new JLabel(output_string);
            text_message.setBackground(Color.white);
            ShowGUIMessage.showGUIMessage(null, text_message, title);
        }
    }

    public static final void showGUIMessage(StringBuffer message, String title) {
        ShowGUIMessage.showGUIMessage(message.toString(), title);
    }
}

