/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class JAIHelper {
    private static boolean JAI_TESTED;
    private static boolean useJAI;
    private static boolean isJAIFound;

    public static void confirmJAIOnClasspath() {
        block5: {
            if (JAI_TESTED) {
                return;
            }
            JAI_TESTED = true;
            if (useJAI) {
                try {
                    Class.forName("javax.media.jai.JAI");
                    isJAIFound = true;
                }
                catch (ClassNotFoundException e) {
                    if (!PdfDecoder.showErrorMessages) break block5;
                    String message = Messages.getMessage("PdfViewer.JAINotOnClasspathWarning") + Messages.getMessage("PdfViewer.JAINotOnClasspathWarning1") + Messages.getMessage("PdfViewer.JAINotOnClasspathWarning2");
                    if (message.contains("PdfViewer")) {
                        message = "We recommend you add JAI to classpath";
                    }
                    JEditorPane p = new JEditorPane("text/html", message);
                    p.setEditable(false);
                    p.setOpaque(false);
                    p.addHyperlinkListener(new HyperlinkListener(){

                        @Override
                        public void hyperlinkUpdate(HyperlinkEvent e) {
                            block4: {
                                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                                    try {
                                        BrowserLauncher.openURL("http://java.sun.com/products/java-media/jai/current.html");
                                    }
                                    catch (IOException e1) {
                                        if (PdfDecoder.showErrorMessages) {
                                            JOptionPane.showMessageDialog(null, Messages.getMessage("PdfViewer.ErrorWebsite"));
                                        }
                                        if (!LogWriter.isOutput()) break block4;
                                        LogWriter.writeLog("Exception: " + e1.getMessage());
                                    }
                                }
                            }
                        }
                    });
                    if (!PdfDecoder.showErrorMessages) break block5;
                    JOptionPane.showMessageDialog(null, p);
                }
            }
        }
    }

    public static boolean isJAIused() {
        return useJAI;
    }

    public static boolean isJAIOnClasspath() {
        String classpath;
        if (!isJAIFound && (classpath = System.getProperty("java.class.path")).contains("jai")) {
            isJAIFound = true;
        }
        return isJAIFound;
    }

    public static void useJAI(boolean use) {
        useJAI = use;
        JAI_TESTED = false;
    }

    static {
        useJAI = false;
        isJAIFound = false;
        String JAIflag = System.getProperty("org.jpedal.jai");
        if (JAIflag != null && JAIflag.toLowerCase().equals("true")) {
            useJAI = true;
        }
    }
}

