/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.LinearizedHintTable;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFilteredReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.EncryptionObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.StreamObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.Sorts;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_boolean;

public class PdfFileReader {
    private static final int UNSET = -1;
    private static final int COMPRESSED = 1;
    private static final int LEGACY = 2;
    private int newCacheSize = -1;
    private LinearizedHintTable linHintTable;
    private boolean refTableInvalid = false;
    private static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    private byte[] lastCompressedStream = null;
    private Map lastOffsetStart;
    private Map lastOffsetEnd;
    private PdfObject compressedObj;
    private int lastFirst = -1;
    private int lastCompressedID = -1;
    private PdfObject linearObj;
    private Certificate certificate;
    private PrivateKey key;
    private PdfObject infoObject = null;
    private byte[] ID = null;
    PdfObject encyptionObj = null;
    private static final String pattern = "obj";
    private Vector_Int xref = new Vector_Int(100);
    private DecryptionFactory decryption = null;
    private byte[] encryptionPassword = null;
    private static final byte[] oldPattern = new byte[]{120, 114, 101, 102};
    private static final byte[] EOFpattern = new byte[]{37, 37, 69, 79, 70};
    private static final byte[] trailerpattern = new byte[]{116, 114, 97, 105, 108, 101, 114};
    private RandomAccessBuffer pdf_datafile = null;
    private static final byte[] endObj = new byte[]{32, 111, 98, 106};
    private static final byte[] lengthString = new byte[]{47, 76, 101, 110, 103, 116, 104};
    private static final byte[] startStream = new byte[]{115, 116, 114, 101, 97, 109};
    private Vector_Int offset = new Vector_Int(2000);
    private Vector_boolean isCompressed = new Vector_boolean(2000);
    private Vector_Int generation = new Vector_Int(2000);
    public static int alwaysCacheInMemory = 16384;
    private long eof;
    private int[] ObjLengthTable;

    public PdfObject getInfoObject() {
        return this.infoObject;
    }

    public void setCacheSize(int miniumumCacheSize) {
        this.newCacheSize = miniumumCacheSize;
    }

    public void init(RandomAccessBuffer pdf_datafile) {
        block2: {
            this.pdf_datafile = pdf_datafile;
            try {
                this.eof = pdf_datafile.length();
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    public final void readObject(PdfObject pdfObject) {
        if (pdfObject.isDataExternal() && this.linHintTable != null) {
            this.readExternalObject(pdfObject);
        } else {
            byte[] raw;
            String objectRef = pdfObject.getObjectRefAsString();
            boolean debug = false;
            boolean isCompressed = this.isCompressed(objectRef);
            pdfObject.setCompressedStream(isCompressed);
            if (isCompressed) {
                raw = this.readCompressedObject(pdfObject, objectRef);
            } else {
                this.movePointer(objectRef);
                if (objectRef.charAt(0) == '<') {
                    raw = this.readObjectData(-1, pdfObject);
                } else {
                    int pointer = objectRef.indexOf(32);
                    int id = Integer.parseInt(objectRef.substring(0, pointer));
                    if (this.ObjLengthTable == null || this.refTableInvalid) {
                        raw = this.getPointer() == 0L ? new byte[]{} : this.readObjectData(-1, pdfObject);
                    } else if (id > this.ObjLengthTable.length || this.ObjLengthTable[id] == 0) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog(objectRef + " cannot have offset 0");
                        }
                        raw = new byte[]{};
                    } else {
                        raw = this.readObjectData(this.ObjLengthTable[id], pdfObject);
                    }
                }
            }
            if (raw.length > 1) {
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(pdfObject, 0, raw);
            }
        }
    }

    private void readExternalObject(PdfObject pdfObject) {
        int ref = pdfObject.getObjectRefID();
        int generation = pdfObject.getObjectRefGeneration();
        byte[] pageData = this.readObjectAsByteArray(pdfObject, this.isCompressed(ref, generation), ref, generation);
        pdfObject.setStatus(2);
        pdfObject.setUnresolvedData(pageData, 540096309);
        ObjectDecoder objDecoder = new ObjectDecoder(this);
        objDecoder.resolveFully(pdfObject);
    }

    private byte[] readCompressedObject(PdfObject pdfObject, String objectRef) {
        byte[] raw;
        int objectID = Integer.parseInt(objectRef.substring(0, objectRef.indexOf(32)));
        int compressedID = this.getCompressedStreamObject(objectRef);
        String compressedRef = compressedID + " 0 R";
        String startID = null;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        HashMap offsetStart = this.lastOffsetStart;
        HashMap offsetEnd = this.lastOffsetEnd;
        PdfObject Extends = null;
        if (this.lastOffsetStart != null && compressedID == this.lastCompressedID) {
            startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
        }
        while (startID == null) {
            if (Extends != null) {
                this.compressedObj = Extends;
            } else if (compressedID != this.lastCompressedID) {
                isCached = false;
                this.movePointer(compressedRef);
                raw = this.readObjectData(this.ObjLengthTable[compressedID], null);
                this.compressedObj = new CompressedObject(compressedRef);
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(this.compressedObj, 0, raw);
            }
            offsetStart = new HashMap();
            offsetEnd = new HashMap();
            First2 = this.compressedObj.getInt(960643930);
            compressedStream = this.compressedObj.getDecodedStream();
            this.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID);
            startID = (String)offsetStart.get(String.valueOf(objectID));
            Extends = this.compressedObj.getDictionary(894663815);
            if (Extends != null) continue;
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastCompressedID = compressedID;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = (String)offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    private PdfObject readCompressedStream(int pointer) throws PdfException {
        PdfObject encryptObj = null;
        PdfObject rootObj = null;
        while (pointer != -1) {
            int[] Index2;
            this.movePointer(pointer);
            byte[] raw = this.readObjectData(-1, null);
            StringBuilder objectName = new StringBuilder();
            int last = 32;
            int matched = 0;
            for (int i1 = 0; i1 < raw.length; ++i1) {
                char current1 = (char)raw[i1];
                if (current1 == '\n' || current1 == '\r') {
                    current1 = ' ';
                }
                if (current1 == ' ' && last == 32) {
                    matched = 0;
                } else if (current1 == pattern.charAt(matched)) {
                    ++matched;
                } else {
                    matched = 0;
                    objectName.append(current1);
                }
                if (matched == 3) break;
                last = current1;
            }
            objectName.append('R');
            CompressedObject pdfObject = new CompressedObject(objectName.toString());
            pdfObject.setCompressedStream(true);
            ObjectDecoder objectDecoder = new ObjectDecoder(this);
            objectDecoder.readDictionaryAsObject(pdfObject, 0, raw);
            int[] fieldSizes = ((PdfObject)pdfObject).getIntArray(39);
            byte[] xrefs = pdfObject.getDecodedStream();
            if (xrefs == null) {
                xrefs = this.readStream(pdfObject, true, true, false, false, true, null);
            }
            if ((Index2 = ((PdfObject)pdfObject).getIntArray(1043608929)) == null) {
                this.readCompressedOffsets(0, 0, ((PdfObject)pdfObject).getInt(590957109), fieldSizes, xrefs);
            } else {
                int count = Index2.length;
                int pntr = 0;
                for (int aa = 0; aa < count; aa += 2) {
                    pntr = this.readCompressedOffsets(pntr, Index2[aa], Index2[aa + 1], fieldSizes, xrefs);
                }
            }
            if (rootObj == null) {
                byte[][] IDs;
                rootObj = ((PdfObject)pdfObject).getDictionary(574570308);
                encryptObj = ((PdfObject)pdfObject).getDictionary(1113489015);
                if (encryptObj != null && (IDs = ((PdfObject)pdfObject).getStringArray(6420)) != null) {
                    this.ID = IDs[0];
                }
                this.infoObject = ((PdfObject)pdfObject).getDictionary(423507519);
            }
            if (this.linearObj != null) {
                pointer = -1;
                continue;
            }
            pointer = ((PdfObject)pdfObject).getInt(541209926);
        }
        if (encryptObj != null) {
            this.setupDecryption(encryptObj);
        }
        this.ObjLengthTable = this.calculateObjectLength((int)this.eof);
        return rootObj;
    }

    public final byte[] readStream(PdfObject pdfObject, boolean cacheValue, boolean decompress, boolean keepRaw, boolean isMetaData, boolean isCompressedStream, String cacheName) {
        byte[] stream;
        boolean debugStream = false;
        boolean isCachedOnDisk = pdfObject.isCached();
        byte[] data = null;
        if (!isCachedOnDisk) {
            data = pdfObject.getDecodedStream();
        }
        if (data == null) {
            block34: {
                block33: {
                    stream = pdfObject.stream;
                    if (isCachedOnDisk) {
                        try {
                            if (!(this.decryption == null || isCompressedStream || !this.decryption.getBooleanValue(102) && isMetaData)) {
                                this.decryption.decrypt(null, pdfObject.getObjectRefAsString(), false, cacheName, false, false);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            stream = null;
                            if (!LogWriter.isOutput()) break block33;
                            LogWriter.writeLog("Exception " + e);
                        }
                    }
                }
                if (stream != null) {
                    try {
                        if (!(this.decryption == null || isCompressedStream || !this.decryption.getBooleanValue(102) && isMetaData || pdfObject.getObjectType() == 2087749783 && pdfObject.getObjectRefAsString().startsWith("["))) {
                            stream = this.decryption.decrypt(stream, pdfObject.getObjectRefAsString(), false, null, false, false);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        stream = null;
                        if (!LogWriter.isOutput()) break block34;
                        LogWriter.writeLog("Exception " + e + " with " + pdfObject.getObjectRefAsString());
                    }
                }
            }
            if (keepRaw) {
                pdfObject.stream = null;
            }
            int length = 1;
            if (stream != null || isCachedOnDisk) {
                int newLength;
                int newW;
                int height = 1;
                int width = 1;
                int newH = pdfObject.getInt(959926393);
                if (newH != -1) {
                    height = newH;
                }
                if ((newW = pdfObject.getInt(959726687)) != -1) {
                    width = newW;
                }
                if ((newLength = pdfObject.getInt(1043816557)) != -1) {
                    length = newLength;
                }
                if (height * width == 1) {
                    width = length;
                }
                PdfArrayIterator filters = pdfObject.getMixedArray(1011108731);
                int firstValue = -1;
                if (filters != null && filters.hasMoreTokens()) {
                    firstValue = filters.getNextValueAsConstant(false);
                }
                if (filters != null && firstValue != -1 && firstValue != 1399277700 && firstValue != 1180911742) {
                    try {
                        PdfFilteredReader filter = new PdfFilteredReader();
                        stream = filter.decodeFilters(ObjectUtils.setupDecodeParms(pdfObject, this), stream, filters, width, height, cacheName);
                        pdfObject.setStreamMayBeCorrupt(filter.hasError());
                    }
                    catch (Exception e) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("[PDF] Problem " + e + " decompressing stream ");
                        }
                        stream = null;
                        isCachedOnDisk = false;
                    }
                    length = 1;
                } else if (stream != null && length != -1 && length < stream.length) {
                    if (stream.length != length && length > 0) {
                        byte[] newStream = new byte[length];
                        System.arraycopy(stream, 0, newStream, 0, length);
                        stream = newStream;
                    } else if (stream.length == 1 && length == 0) {
                        stream = new byte[]{};
                    }
                }
            }
            if (stream != null && cacheValue) {
                pdfObject.setDecodedStream(stream);
            }
            if (decompress && isCachedOnDisk) {
                byte[] bytes;
                int streamLength;
                block35: {
                    streamLength = (int)new File(cacheName).length();
                    bytes = new byte[streamLength];
                    try {
                        new BufferedInputStream(new FileInputStream(cacheName)).read(bytes);
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block35;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                if (length != 1 && length < streamLength) {
                    byte[] newStream = new byte[length];
                    System.arraycopy(bytes, 0, newStream, 0, length);
                    bytes = newStream;
                }
                return bytes;
            }
        } else {
            stream = data;
        }
        if (stream == null) {
            return null;
        }
        int len = stream.length;
        byte[] copy = new byte[len];
        System.arraycopy(stream, 0, copy, 0, len);
        return copy;
    }

    private PdfObject readLegacyReferenceTable(int pointer, int eof) throws PdfException {
        int current = 0;
        int bufSize = 1024;
        PdfObject encryptObj = null;
        PdfObject rootObj = null;
        do {
            int i;
            byte[] Bytes2;
            try {
                Bytes2 = this.readTrailer(bufSize, pointer, eof);
            }
            catch (Exception e) {
                block31: {
                    try {
                        this.closeFile();
                    }
                    catch (IOException e1) {
                        if (!LogWriter.isOutput()) break block31;
                        LogWriter.writeLog("Exception " + e + " closing file");
                    }
                }
                throw new PdfException("Exception " + e + " reading trailer");
            }
            if (Bytes2 == null) break;
            int maxLen = Bytes2.length;
            for (i = 0; i < maxLen && (Bytes2[i] != 116 || Bytes2[i + 1] != 114 || Bytes2[i + 2] != 97 || Bytes2[i + 3] != 105 || Bytes2[i + 4] != 108 || Bytes2[i + 5] != 101 || Bytes2[i + 6] != 114); ++i) {
            }
            int endTable = i;
            if (i == Bytes2.length) break;
            while (Bytes2[i] != 60 && Bytes2[i - 1] != 60) {
                ++i;
            }
            CompressedObject pdfObject = new CompressedObject("1 0 R");
            ObjectDecoder objectDecoder = new ObjectDecoder(this);
            objectDecoder.readDictionary(pdfObject, ++i, Bytes2, -1, true);
            int level = 0;
            while (true) {
                if (Bytes2[i] == 60 && Bytes2[i - 1] == 60) {
                    ++level;
                    ++i;
                } else if (Bytes2[i] == 91) {
                    ++i;
                    while (Bytes2[i] != 93 && ++i != Bytes2.length) {
                    }
                } else if (Bytes2[i] == 62 && Bytes2[i - 1] == 62) {
                    --level;
                    ++i;
                }
                if (level == 0) break;
                ++i;
            }
            int XRefStm = ((PdfObject)pdfObject).getInt(910911090);
            if (XRefStm != -1) {
                pointer = XRefStm;
            } else {
                boolean hasRef = true;
                while (Bytes2[i] != 116 && Bytes2[i + 1] != 120 && Bytes2[i + 2] != 114 && Bytes2[i + 3] != 101 && Bytes2[i + 4] != 102) {
                    if (Bytes2[i] == 111 && Bytes2[i + 1] == 98 && Bytes2[i + 2] == 106) {
                        hasRef = false;
                        break;
                    }
                    ++i;
                }
                if (hasRef) {
                    i += 8;
                    while (i < maxLen && (Bytes2[i] == 10 || Bytes2[i] == 32 || Bytes2[i] == 13)) {
                        ++i;
                    }
                    int s = i;
                    while (i < maxLen && Bytes2[i] != 10 && Bytes2[i] != 32 && Bytes2[i] != 13) {
                        ++i;
                    }
                    if (s != i) {
                        pointer = NumberUtils.parseInt(s, i, Bytes2);
                    }
                }
            }
            i = 0;
            while (Bytes2[i] == 13 || Bytes2[i] == 10 || Bytes2[i] == 9) {
                ++i;
            }
            if (pointer == -1) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("No startRef");
                continue;
            }
            if (Bytes2[i] == 120 && Bytes2[i + 1] == 114 && Bytes2[i + 2] == 101 && Bytes2[i + 3] == 102) {
                i = 5;
                while (Bytes2[i] == 10 || Bytes2[i] == 32 || Bytes2[i] == 13) {
                    ++i;
                }
                current = this.readXRefs(this.xref, current, Bytes2, endTable, i);
                if (rootObj == null) {
                    byte[][] IDs;
                    rootObj = ((PdfObject)pdfObject).getDictionary(574570308);
                    encryptObj = ((PdfObject)pdfObject).getDictionary(1113489015);
                    if (encryptObj != null && (IDs = ((PdfObject)pdfObject).getStringArray(6420)) != null) {
                        this.ID = IDs[0];
                    }
                    this.infoObject = ((PdfObject)pdfObject).getDictionary(423507519);
                }
                if ((pointer = ((PdfObject)pdfObject).getInt(541209926)) != -1 && (long)pointer < this.eof) {
                    bufSize = 1024;
                    this.xref.addElement(pointer);
                    continue;
                }
                pointer = -1;
                continue;
            }
            pointer = -1;
            rootObj = new PageObject(this.findOffsets());
            this.readObject(rootObj);
            this.refTableInvalid = true;
        } while (pointer != -1);
        if (encryptObj != null) {
            this.setupDecryption(encryptObj);
        }
        if (!this.refTableInvalid) {
            this.ObjLengthTable = this.calculateObjectLength(eof);
        }
        return rootObj;
    }

    private void setupDecryption(PdfObject encryptObj) throws PdfSecurityException {
        try {
            this.decryption = this.certificate != null ? new DecryptionFactory(this.ID, this.certificate, this.key) : new DecryptionFactory(this.ID, this.encryptionPassword);
            if (this.encyptionObj == null) {
                this.encyptionObj = new EncryptionObject(new String(encryptObj.getUnresolvedData()));
                this.readObject(this.encyptionObj);
            }
            this.decryption.readEncryptionObject(this.encyptionObj);
        }
        catch (Error err) {
            throw new RuntimeException("This PDF file is encrypted and JPedal needs an additional library to \ndecode on the classpath (we recommend bouncycastle library).\nThere is additional explanation at http://www.idrsolutions.com/additional-jars\n");
        }
    }

    public int getPDFflag(Integer flag) {
        if (this.decryption == null) {
            return -1;
        }
        return this.decryption.getPDFflag(flag);
    }

    private int readFirstStartRef() throws PdfException {
        this.refTableInvalid = false;
        int pointer = -1;
        int i = 1019;
        StringBuilder startRef = new StringBuilder(10);
        int block = 1024;
        byte[] lastBytes = new byte[block];
        int[] EndOfFileMarker = new int[]{37, 37, 69, 79};
        int valReached = 3;
        boolean EOFFound = false;
        try {
            long end;
            block21: {
                end = this.eof;
                int bufSize = 255;
                do {
                    byte[] buffer = this.getBytes(end - (long)bufSize, bufSize);
                    int offset = 0;
                    for (int ii = bufSize - 1; ii > -1; --ii) {
                        if (!EOFFound) {
                            valReached = 3;
                        }
                        if (buffer[ii] == EndOfFileMarker[valReached]) {
                            --valReached;
                            EOFFound = true;
                        } else {
                            EOFFound = false;
                        }
                        --offset;
                        if (valReached >= 0) continue;
                        ii = -1;
                    }
                    if (valReached >= 0) continue;
                    end -= (long)offset;
                    break block21;
                } while ((end -= (long)bufSize) >= 0L);
                end = this.eof;
            }
            int count = (int)(end - (long)block);
            if (count < 0) {
                count = 0;
                int size = (int)this.eof;
                lastBytes = new byte[size];
                i = size + 3;
            }
            lastBytes = this.getBytes(count, lastBytes.length);
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e + " reading last 1024 bytes");
            }
            throw new PdfException(e + " reading last 1024 bytes");
        }
        int fileSize = lastBytes.length;
        if (i > fileSize) {
            i = fileSize - 5;
        }
        while (!(i <= -1 || (lastBytes[i] == 116 && lastBytes[i + 1] == 120 || lastBytes[i] == 114 && lastBytes[i + 1] == 116) && lastBytes[i + 2] == 114 && lastBytes[i + 3] == 101 && lastBytes[i + 4] == 102)) {
            --i;
        }
        if (i == -1) {
            block22: {
                try {
                    this.closeFile();
                }
                catch (IOException e1) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + e1 + " closing file");
                }
            }
            throw new PdfException("No Startxref found in last 1024 bytes ");
        }
        i += 5;
        while (i < 1024 && (lastBytes[i] == 10 || lastBytes[i] == 32 || lastBytes[i] == 13)) {
            ++i;
        }
        while (i < 1024 && lastBytes[i] != 10 && lastBytes[i] != 32 && lastBytes[i] != 13) {
            startRef.append((char)lastBytes[i]);
            ++i;
        }
        if (startRef.length() > 0) {
            pointer = Integer.parseInt(startRef.toString());
        }
        if (pointer == -1) {
            block23: {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No Startref found in last 1024 bytes ");
                }
                try {
                    this.closeFile();
                }
                catch (IOException e1) {
                    if (!LogWriter.isOutput()) break block23;
                    LogWriter.writeLog("Exception " + e1 + " closing file");
                }
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return pointer;
    }

    public final PdfObject readReferenceTable(PdfObject linearObj) throws PdfException {
        this.linearObj = linearObj;
        int pointer = -1;
        int eof = (int)this.eof;
        boolean islinearizedCompressed = false;
        if (linearObj == null) {
            pointer = this.readFirstStartRef();
        } else {
            byte[] data = this.getBuffer();
            int count = data.length;
            int ptr = 5;
            for (int i = 0; i < count; ++i) {
                if (data[i] == 101 && data[i + 1] == 110 && data[i + 2] == 100 && data[i + 3] == 111 && data[i + 4] == 98 && data[i + 5] == 106) {
                    ptr = i + 6;
                }
                if (data[i] == 120 && data[i + 1] == 114 && data[i + 2] == 101 && data[i + 3] == 102) {
                    pointer = i;
                    i = count;
                    continue;
                }
                if (data[i] != 88 || data[i + 1] != 82 || data[i + 2] != 101 || data[i + 3] != 102) continue;
                islinearizedCompressed = true;
                pointer = ptr;
                while (data[pointer] == 10 || data[pointer] == 13 || data[pointer] == 32) {
                    ++pointer;
                }
                i = count;
            }
        }
        this.xref.addElement(pointer);
        if (pointer >= eof) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            }
            this.refTableInvalid = true;
            PageObject rootObj = new PageObject(this.findOffsets());
            this.readObject(rootObj);
            return rootObj;
        }
        if (islinearizedCompressed || this.isCompressedStream(pointer, eof)) {
            return this.readCompressedStream(pointer);
        }
        return this.readLegacyReferenceTable(pointer, eof);
    }

    public void spoolStreamDataToDisk(File tmpFile, long start) throws Exception {
        BufferedOutputStream array;
        block19: {
            this.movePointer(start);
            boolean hasValues = false;
            array = new BufferedOutputStream(new FileOutputStream(tmpFile));
            int bufSize = -1;
            int startStreamCount = 0;
            boolean startStreamFound = false;
            int XXX = 0x200000;
            int rawSize = bufSize;
            int realPos = 0;
            boolean debug = false;
            boolean lengthSet = false;
            boolean streamFound = false;
            if (bufSize < 1) {
                bufSize = 128;
            }
            int ptr = 0;
            int maxPtr = bufSize;
            byte[] readData = new byte[maxPtr];
            int charReached = 0;
            int charReached2 = 0;
            int charReached3 = 0;
            byte[] buffer = null;
            boolean inStream = false;
            try {
                int i = bufSize - 1;
                int offset = -bufSize;
                while (true) {
                    if (++i == bufSize) {
                        long pointer = this.getPointer();
                        if (start == -1L) {
                            start = pointer;
                        }
                        if (pointer + (long)bufSize > this.eof) {
                            bufSize = (int)(this.eof - pointer);
                        }
                        buffer = new byte[bufSize += 6];
                        this.read(buffer);
                        offset += i;
                        i = 0;
                    }
                    void currentByte = buffer[i];
                    boolean ignoreByte = false;
                    charReached = currentByte == ObjectDecoder.endPattern[charReached] && !inStream ? ++charReached : 0;
                    charReached2 = streamFound && currentByte == endObj[charReached2] && !inStream ? ++charReached2 : 0;
                    if (startStreamFound && (hasValues || currentByte != 13 && currentByte != 10)) {
                        array.write((int)currentByte);
                        hasValues = true;
                    }
                    startStreamCount = startStreamCount < 6 && currentByte == startStream[startStreamCount] ? ++startStreamCount : 0;
                    if (!startStreamFound && startStreamCount == 6) {
                        startStreamFound = true;
                    }
                    if (!lengthSet && rawSize != -1) {
                        if (!streamFound && currentByte == lengthString[charReached3] && !inStream) {
                            if (++charReached3 == 6) {
                                lengthSet = true;
                            }
                        } else {
                            charReached3 = 0;
                        }
                    }
                    if (charReached == 6 || charReached2 == 4) {
                        if (!lengthSet) break;
                        charReached = 0;
                        charReached2 = 0;
                    }
                    if (!lengthSet || realPos < rawSize) {
                        if (!ignoreByte && !inStream) {
                            readData[ptr] = currentByte;
                            if (++ptr == maxPtr) {
                                maxPtr = maxPtr < 0x200000 ? (maxPtr *= 2) : (maxPtr += 100000);
                                byte[] tmpArray = new byte[maxPtr];
                                System.arraycopy(readData, 0, tmpArray, 0, readData.length);
                                readData = tmpArray;
                            }
                        }
                        ++realPos;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!LogWriter.isOutput()) break block19;
                LogWriter.writeLog("Exception " + e + " reading object");
            }
        }
        if (array != null) {
            array.flush();
            array.close();
        }
    }

    private boolean isCompressedStream(int pointer, int eof) throws PdfException {
        boolean debug = false;
        int bufSize = 50;
        int charReached_legacy = 0;
        int charReached_comp1 = 0;
        int charReached_comp2 = 0;
        int[] objStm = new int[]{79, 98, 106, 83, 116, 109};
        int[] XRef = new int[]{88, 82, 101, 102};
        int type = -1;
        boolean firstRead = true;
        while (true) {
            if (pointer + bufSize > eof) {
                bufSize = eof - pointer;
            }
            if (bufSize < 0) {
                bufSize = 50;
            }
            byte[] buffer = this.getBytes(pointer, bufSize);
            if (firstRead && buffer[0] == 114 && buffer[1] == 101 && buffer[2] == 102) {
                charReached_legacy = 1;
            }
            firstRead = false;
            for (int i = 0; i < bufSize; ++i) {
                byte currentByte = buffer[i];
                if (currentByte == oldPattern[charReached_legacy] && type != 1) {
                    ++charReached_legacy;
                    type = 2;
                } else if (currentByte == objStm[charReached_comp1] && (charReached_comp1 == 0 || type == 1)) {
                    ++charReached_comp1;
                    type = 1;
                } else if (currentByte == XRef[charReached_comp2] && (charReached_comp2 == 0 || type == 1)) {
                    ++charReached_comp2;
                    type = 1;
                } else {
                    charReached_legacy = 0;
                    charReached_comp1 = 0;
                    charReached_comp2 = 0;
                    type = -1;
                }
                if (charReached_legacy == 3 || charReached_comp1 == 4 || charReached_comp2 == 3) break;
            }
            if (charReached_legacy == 3 || charReached_comp1 == 4 || charReached_comp2 == 3) break;
            pointer += bufSize;
        }
        if (type == -1) {
            block14: {
                try {
                    this.closeFile();
                }
                catch (IOException e1) {
                    if (!LogWriter.isOutput()) break block14;
                    LogWriter.writeLog("Exception 1 closing file");
                }
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return type == 1;
    }

    void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    private byte[] readTrailer(int bufSize, int pointer, int eof) throws IOException {
        int charReached = 0;
        int charReached2 = 0;
        int trailerCount = 0;
        int end = 4;
        ByteArrayOutputStream bis = new ByteArrayOutputStream();
        do {
            if (pointer + bufSize > eof) {
                bufSize = eof - pointer;
            }
            if (bufSize == 0) break;
            byte[] buffer = this.getBytes(pointer, bufSize);
            boolean endFound = false;
            for (int i = 0; i < bufSize; ++i) {
                byte currentByte = buffer[i];
                charReached = currentByte == EOFpattern[charReached] ? ++charReached : 0;
                charReached2 = currentByte == trailerpattern[charReached2] ? ++charReached2 : 0;
                if (charReached2 == 7) {
                    ++trailerCount;
                    charReached2 = 0;
                }
                if (charReached != 4 && trailerCount != 2) continue;
                for (int j = 0; j < i + 1; ++j) {
                    bis.write(buffer[j]);
                }
                i = bufSize;
                endFound = true;
            }
            if (!endFound) {
                bis.write(buffer);
            }
            pointer += bufSize;
        } while (charReached != 4 && trailerCount != 2);
        bis.close();
        return bis.toByteArray();
    }

    public byte[] getBuffer() {
        return this.pdf_datafile.getPdfBuffer();
    }

    private static int getWord(byte[] content, int index, int size) {
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result = (result << 8) + (content[index + i] & 0xFF);
        }
        return result;
    }

    private int readXRefs(Vector_Int xref, int current, byte[] Bytes2, int endTable, int i) {
        boolean skipNext = false;
        boolean isFirstValue = true;
        int[] breaks = new int[5];
        int[] starts = new int[5];
        while (i < endTable) {
            int startLine = i;
            int endLine = -1;
            while (Bytes2[i] != 10 && Bytes2[i] != 13) {
                if (endLine == -1 && Bytes2[i] == 37) {
                    endLine = i - 1;
                }
                ++i;
            }
            if (endLine == -1) {
                endLine = i - 1;
            }
            while (Bytes2[startLine] == 32) {
                ++startLine;
            }
            while (Bytes2[endLine] == 32) {
                --endLine;
            }
            ++i;
            int tokenCount = 0;
            int lineLen = endLine - startLine + 1;
            if (lineLen <= 0) continue;
            int lastChar = 1;
            for (int j = 1; j < lineLen; ++j) {
                int currentChar = Bytes2[startLine + j];
                if (currentChar == 32 && lastChar != 32) {
                    breaks[tokenCount] = j;
                    ++tokenCount;
                } else if (currentChar != 32 && lastChar == 32) {
                    starts[tokenCount] = j;
                }
                lastChar = currentChar;
            }
            breaks[tokenCount] = lineLen;
            if (++tokenCount == 1) {
                if (skipNext) {
                    skipNext = false;
                    continue;
                }
                current = NumberUtils.parseInt(startLine, startLine + breaks[0], Bytes2);
                skipNext = true;
                continue;
            }
            if (tokenCount == 2) {
                current = NumberUtils.parseInt(startLine, startLine + breaks[0], Bytes2);
                continue;
            }
            int id = NumberUtils.parseInt(startLine, startLine + breaks[0], Bytes2);
            int generation = NumberUtils.parseInt(startLine + starts[1], startLine + breaks[1], Bytes2);
            char flag = (char)Bytes2[startLine + starts[2]];
            if (flag == 'n') {
                boolean isValid = false;
                int bufSize = 20;
                if ((long)(id + bufSize) > this.eof) {
                    bufSize = (int)(this.eof - (long)id);
                }
                if (bufSize > 0) {
                    byte[] buffer = this.getBytes(id, bufSize);
                    for (int ii = 4; ii < bufSize; ++ii) {
                        if (buffer[ii - 3] != 32 && buffer[ii - 3] != 10 || buffer[ii - 2] != 111 || buffer[ii - 1] != 98 || buffer[ii] != 106) continue;
                        isValid = true;
                        ii = bufSize;
                    }
                    if (isValid && isFirstValue) {
                        isFirstValue = false;
                        if (buffer[0] == 48 && buffer[1] != 48 && current == 1) {
                            current = 0;
                        } else if (buffer[0] == 49 && buffer[1] == 32) {
                            current = 1;
                        }
                    }
                    if (isValid) {
                        this.storeObjectOffset(current, id, generation, false, false);
                        xref.addElement(id);
                    }
                }
                ++current;
                continue;
            }
            if (flag != 'f') continue;
            ++current;
        }
        return current;
    }

    private void extractCompressedObjectOffset(Map offsetStart, Map offsetEnd, int First2, byte[] compressedStream, int compressedID) {
        String lastKey = null;
        for (int ii = 0; ii < First2; ++ii) {
            int i;
            if (compressedStream.length == 0) continue;
            while (compressedStream[ii] == 10 || compressedStream[ii] == 13 || compressedStream[ii] == 32) {
                ++ii;
            }
            int startKey = ii;
            while (compressedStream[ii] != 32 && compressedStream[ii] != 13 && compressedStream[ii] != 10) {
                ++ii;
            }
            int endKey = ii - 1;
            int length = endKey - startKey + 1;
            char[] newCommand = new char[length];
            for (i = 0; i < length; ++i) {
                newCommand[i] = (char)compressedStream[startKey + i];
            }
            String key = new String(newCommand);
            int id = NumberUtils.parseInt(startKey, startKey + length, compressedStream);
            while (compressedStream[ii] == 32 || compressedStream[ii] == 13 || compressedStream[ii] == 10) {
                ++ii;
            }
            int startOff = ii;
            while (compressedStream[ii] != 32 && compressedStream[ii] != 13 && compressedStream[ii] != 10 && ii < First2) {
                ++ii;
            }
            int endOff = ii - 1;
            length = endOff - startOff + 1;
            newCommand = new char[length];
            for (i = 0; i < length; ++i) {
                newCommand[i] = (char)compressedStream[startOff + i];
            }
            String offset = new String(newCommand);
            if ((long)compressedID != this.getOffset(id)) continue;
            offsetStart.put(key, offset);
            if (lastKey != null) {
                offsetEnd.put(lastKey, offset);
            }
            lastKey = key;
        }
    }

    private int readCompressedOffsets(int pntr, int current, int numbEntries, int[] fieldSizes, byte[] xrefs) throws PdfException {
        boolean debug = false;
        int[] defaultValue = new int[]{1, 0, 0};
        boolean hasCase0 = false;
        block5: for (int i = 0; i < numbEntries; ++i) {
            int[] nextValue = new int[3];
            for (int ii = 0; ii < 3; ++ii) {
                if (fieldSizes[ii] == 0) {
                    nextValue[ii] = defaultValue[ii];
                    continue;
                }
                nextValue[ii] = PdfFileReader.getWord(xrefs, pntr, fieldSizes[ii]);
                pntr += fieldSizes[ii];
            }
            switch (nextValue[0]) {
                case 0: {
                    ++current;
                    hasCase0 = nextValue[1] == 0 && nextValue[2] == 0;
                    continue block5;
                }
                case 1: {
                    int id = nextValue[1];
                    int gen = nextValue[2];
                    boolean refIsvalid = true;
                    if (current == id) {
                        int ref;
                        refIsvalid = false;
                        int size = 20;
                        byte[] data = this.getBytes(current, size);
                        int ptr = 0;
                        for (int ii = 0; ii < size; ++ii) {
                            if (data[ii] != 32 && data[ii] != 10 && data[ii] != 13) continue;
                            ptr = ii;
                            ii = size;
                        }
                        if (ptr > 0 && (ref = NumberUtils.parseInt(0, ptr, data)) == current) {
                            refIsvalid = true;
                        }
                    }
                    if (refIsvalid || !hasCase0) {
                        this.storeObjectOffset(current, id, gen, false, false);
                    }
                    ++current;
                    continue block5;
                }
                case 2: {
                    int id = nextValue[1];
                    this.storeObjectOffset(current, id, 0, true, false);
                    ++current;
                    continue block5;
                }
                default: {
                    throw new PdfException("Exception Unsupported Compression mode with value " + nextValue[0]);
                }
            }
        }
        return pntr;
    }

    byte[] readFDFData() throws IOException {
        int eof = (int)this.pdf_datafile.length();
        this.pdf_datafile.readLine();
        int start = (int)this.pdf_datafile.getFilePointer();
        byte[] fileData = new byte[eof -= start];
        this.pdf_datafile.read(fileData);
        return fileData;
    }

    private int[] calculateObjectLength(int eof) {
        int i;
        this.xref.addElement(eof);
        int[] xrefs = this.xref.get();
        int xrefCount = xrefs.length;
        int[] xrefID = new int[xrefCount];
        for (int i2 = 0; i2 < xrefCount; ++i2) {
            xrefID[i2] = i2;
        }
        xrefID = Sorts.quicksort(xrefs, xrefID);
        int objectCount = this.offset.getCapacity();
        int[] id = new int[objectCount];
        int[] offsets = new int[objectCount];
        int[] off = this.offset.get();
        boolean[] isComp = this.isCompressed.get();
        for (i = 0; i < objectCount; ++i) {
            if (isComp[i]) continue;
            offsets[i] = off[i];
            id[i] = i;
        }
        id = Sorts.quicksort(offsets, id);
        i = 0;
        while (offsets[id[i]] == 0) {
            ++i;
        }
        int start = offsets[id[i]];
        int j = 0;
        while (xrefs[xrefID[j]] < start + 1) {
            ++j;
        }
        int[] ObjLengthTable = new int[objectCount];
        while (i < objectCount - 1) {
            int end = offsets[id[i + 1]];
            int objLength = end - start - 1;
            if (xrefs[xrefID[j]] < end) {
                objLength = xrefs[xrefID[j]] - start - 1;
                while (xrefs[xrefID[j]] < end + 1) {
                    ++j;
                }
            }
            ObjLengthTable[id[i]] = objLength;
            start = end;
            while (xrefs[xrefID[j]] < start + 1) {
                ++j;
            }
            ++i;
        }
        ObjLengthTable[id[i]] = xrefs[xrefID[j]] - start - 1;
        return ObjLengthTable;
    }

    private void movePointer(int currentID, int generation) {
        this.movePointer(this.offset.elementAt(currentID));
    }

    public long getOffset(int currentID) {
        return this.offset.elementAt(currentID);
    }

    public byte[] getBytes(long start, int count) {
        byte[] buffer;
        block2: {
            buffer = new byte[count];
            this.movePointer(start);
            try {
                this.pdf_datafile.read(buffer);
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return buffer;
    }

    private String findOffsets() throws PdfSecurityException {
        String root_id;
        block7: {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Corrupt xref table - trying to find objects manually");
            }
            root_id = "";
            String line = null;
            this.movePointer(0L);
            while (true) {
                int pointer;
                int i;
                block6: {
                    i = (int)this.getPointer();
                    try {
                        line = this.pdf_datafile.readLine();
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block6;
                        LogWriter.writeLog("Exception " + e + " reading line");
                    }
                }
                if (line == null) break block7;
                if (line.contains(" obj")) {
                    pointer = line.indexOf(32);
                    if (pointer <= -1) continue;
                    this.storeObjectOffset(Integer.parseInt(line.substring(0, pointer)), i, 1, false, true);
                    continue;
                }
                if (line.contains("/Root")) {
                    int start = line.indexOf("/Root") + 5;
                    pointer = line.indexOf(82, start);
                    if (pointer <= -1) continue;
                    root_id = line.substring(start, pointer + 1).trim();
                    continue;
                }
                if (line.contains("/Encrypt")) break;
            }
            throw new PdfSecurityException("Corrupted, encrypted file");
        }
        return root_id;
    }

    public void storeLinearizedTables(LinearizedHintTable linHintTable) {
        this.linHintTable = linHintTable;
    }

    public void dispose() {
        block6: {
            if (this.decryption != null) {
                this.decryption.flush();
                this.decryption.dispose();
            }
            if (this.decryption != null) {
                this.decryption.cipher = null;
            }
            this.decryption = null;
            this.compressedObj = null;
            if (this.linHintTable != null) {
                this.linHintTable = null;
            }
            this.offset = null;
            this.generation = null;
            this.isCompressed = null;
            try {
                if (this.pdf_datafile != null) {
                    this.pdf_datafile.close();
                }
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.pdf_datafile = null;
        this.xref = null;
    }

    private void movePointer(String pages_id) {
        long pointer = this.getOffset(pages_id);
        this.movePointer(pointer);
    }

    public final String getType() {
        String pdf_type;
        block3: {
            pdf_type = "";
            try {
                this.movePointer(0L);
                pdf_type = this.pdf_datafile.readLine();
                int pos = pdf_type.indexOf("%PDF");
                if (pos != -1) {
                    pdf_type = pdf_type.substring(pos + 5);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception " + e + " in reading type");
            }
        }
        return pdf_type;
    }

    private void movePointer(long pointer) {
        block5: {
            try {
                if (pointer > this.pdf_datafile.length()) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Attempting to access ref outside file");
                    }
                } else {
                    this.pdf_datafile.seek(pointer);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception " + e + " moving pointer to  " + pointer + " in file.");
            }
        }
    }

    private void read(byte[] buffer) throws IOException {
        this.pdf_datafile.read(buffer);
    }

    private long getPointer() {
        long old_pointer;
        block2: {
            old_pointer = 0L;
            try {
                old_pointer = this.pdf_datafile.getFilePointer();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception " + e + " getting pointer in file");
            }
        }
        return old_pointer;
    }

    private void storeObjectOffset(int current_number, int current_offset, int current_generation, boolean isEntryCompressed, boolean isBumData) {
        int existing_generation = 0;
        int offsetNumber = 0;
        if (current_number < this.generation.getCapacity()) {
            existing_generation = this.generation.elementAt(current_number);
            offsetNumber = this.offset.elementAt(current_number);
        }
        if (existing_generation < current_generation || offsetNumber == 0 || isBumData && current_offset > this.offset.elementAt(current_number)) {
            this.offset.setElementAt(current_offset, current_number);
            this.generation.setElementAt(current_generation, current_number);
            this.isCompressed.setElementAt(isEntryCompressed, current_number);
        }
    }

    private int getCompressedStreamObject(int currentID, int gen) {
        return this.offset.elementAt(currentID);
    }

    private int getCompressedStreamObject(String value) {
        int currentID = 0;
        if (value.endsWith("R")) {
            StringTokenizer values = new StringTokenizer(value);
            currentID = Integer.parseInt(values.nextToken());
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("Error with reference ..value=" + value + '<');
        }
        return this.offset.elementAt(currentID);
    }

    private int getOffset(String value) {
        int currentID = 0;
        if (value.endsWith("R")) {
            StringTokenizer values = new StringTokenizer(value);
            currentID = Integer.parseInt(values.nextToken());
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("2. Error with reference .." + value + "<<");
        }
        return this.offset.elementAt(currentID);
    }

    public final boolean isCompressed(int ref, int gen) {
        return this.isCompressed.elementAt(ref);
    }

    private boolean isCompressed(String value) {
        int currentID = 0;
        if (value.endsWith("R")) {
            StringTokenizer values = new StringTokenizer(value);
            currentID = Integer.parseInt(values.nextToken());
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("5.Error with reference .." + value + '<');
        }
        return this.isCompressed.elementAt(currentID);
    }

    public DecryptionFactory getDecryptionObject() {
        return this.decryption;
    }

    public void setPassword(String password) {
        this.encryptionPassword = password.getBytes();
        if (this.decryption != null) {
            this.decryption.reset(this.encryptionPassword);
        }
    }

    byte[] readObjectData(PdfObject pdfObject) {
        byte[] raw;
        byte[] data;
        String objectRef = pdfObject.getObjectRefAsString();
        if (pdfObject.isDataExternal() && (data = this.readObjectAsByteArray(pdfObject, false, pdfObject.getObjectRefID(), 0)) == null) {
            pdfObject.setFullyResolved(false);
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[Linearized] " + pdfObject.getObjectRefAsString() + " not yet available (15)");
            }
            return data;
        }
        boolean debug = false;
        boolean isCompressed = this.isCompressed(objectRef);
        pdfObject.setCompressedStream(isCompressed);
        if (isCompressed) {
            raw = this.readCompressedObjectData(pdfObject, objectRef);
        } else {
            this.movePointer(objectRef);
            if (objectRef.charAt(0) == '<') {
                raw = this.readObjectData(-1, pdfObject);
            } else {
                int pointer = objectRef.indexOf(32);
                int id = Integer.parseInt(objectRef.substring(0, pointer));
                if (this.ObjLengthTable == null || this.refTableInvalid) {
                    raw = this.getPointer() == 0L ? new byte[]{} : this.readObjectData(-1, pdfObject);
                } else if (id > this.ObjLengthTable.length || this.ObjLengthTable[id] == 0) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog(objectRef + " cannot have offset 0");
                    }
                    raw = new byte[]{};
                } else {
                    raw = this.readObjectData(this.ObjLengthTable[id], pdfObject);
                }
            }
        }
        return raw;
    }

    private byte[] readCompressedObjectData(PdfObject pdfObject, String objectRef) {
        byte[] raw;
        int objectID = Integer.parseInt(objectRef.substring(0, objectRef.indexOf(32)));
        int compressedID = this.getCompressedStreamObject(objectRef);
        String compressedRef = compressedID + " 0 R";
        String startID = null;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        HashMap offsetStart = this.lastOffsetStart;
        HashMap offsetEnd = this.lastOffsetEnd;
        PdfObject Extends = null;
        if (this.lastOffsetStart != null) {
            startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
        }
        while (startID == null) {
            if (Extends != null) {
                this.compressedObj = Extends;
            } else if (compressedID != this.lastCompressedID) {
                isCached = false;
                this.movePointer(compressedRef);
                raw = this.readObjectData(this.ObjLengthTable[compressedID], null);
                this.compressedObj = new CompressedObject(compressedRef);
                ObjectDecoder objDecoder = new ObjectDecoder(this);
                objDecoder.readDictionaryAsObject(this.compressedObj, 0, raw);
            }
            offsetStart = new HashMap();
            offsetEnd = new HashMap();
            First2 = this.compressedObj.getInt(960643930);
            compressedStream = this.compressedObj.getDecodedStream();
            this.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID);
            startID = (String)offsetStart.get(String.valueOf(objectID));
            Extends = this.compressedObj.getDictionary(894663815);
            if (Extends != null) continue;
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastCompressedID = compressedID;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = (String)offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    private byte[] readObjectData(int bufSize, PdfObject pdfObject) {
        if (bufSize < 1 || this.newCacheSize != -1) {
            return this.readObjectDataXX(bufSize, pdfObject);
        }
        byte[] dataRead = null;
        if (bufSize > 0) {
            dataRead = new byte[bufSize += 6];
            this.fillBuffer(dataRead);
        }
        return dataRead;
    }

    private void fillBuffer(byte[] buffer) {
        block2: {
            try {
                this.read(buffer);
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    private byte[] readObjectDataXX(int bufSize, PdfObject pdfObject) {
        int newCacheSize = -1;
        int startStreamCount = 0;
        int charReached = 0;
        int charReached3 = 0;
        boolean startStreamFound = false;
        boolean reachedCacheLimit = false;
        boolean inStream = false;
        boolean inLoop = true;
        long start = this.getPointer();
        if (pdfObject != null) {
            newCacheSize = this.newCacheSize;
        }
        int rawSize = bufSize;
        int realPos = 0;
        boolean lengthSet = false;
        if (bufSize < 1) {
            bufSize = 128;
        }
        if (newCacheSize != -1 && bufSize > newCacheSize) {
            bufSize = newCacheSize;
        }
        byte[] dataRead = null;
        int i = bufSize - 1;
        while (inLoop) {
            if (++i == bufSize) {
                long pointer = this.getPointer();
                if (pointer + (long)bufSize > this.eof) {
                    bufSize = (int)(this.eof - pointer);
                }
                if (bufSize == 0) break;
                byte[] buffer = new byte[bufSize += 6];
                this.fillBuffer(buffer);
                if (dataRead == null) {
                    int j = 0;
                    while (buffer[j] == 101 || buffer[j] == 110 || buffer[j] == 100 || buffer[j] == 111 || buffer[j] == 98 || buffer[j] == 106) {
                        ++j;
                    }
                    if (j > 0) {
                        byte[] oldBuffer = buffer;
                        int newLength = buffer.length - j;
                        buffer = new byte[newLength];
                        System.arraycopy(oldBuffer, j, buffer, 0, newLength);
                    }
                    dataRead = buffer;
                } else {
                    dataRead = PdfFileReader.appendDataBlock(buffer.length, buffer, dataRead);
                }
                i = 0;
            }
            byte currentByte = dataRead[realPos];
            if (!inStream) {
                charReached = currentByte == endPattern[charReached] ? ++charReached : 0;
            }
            if (!startStreamFound && newCacheSize != -1 && !reachedCacheLimit) {
                if (startStreamCount < 6 && currentByte == startStream[startStreamCount]) {
                    if (++startStreamCount == 6) {
                        startStreamFound = true;
                    }
                } else {
                    startStreamCount = 0;
                }
            }
            if (startStreamFound && dataRead != null && dataRead.length > newCacheSize) {
                pdfObject.setCache(start, this);
                reachedCacheLimit = true;
            }
            if (!startStreamFound && !lengthSet && rawSize != -1) {
                if (currentByte == lengthString[charReached3] && !inStream) {
                    if (++charReached3 == 6) {
                        lengthSet = true;
                    }
                } else {
                    charReached3 = 0;
                }
            }
            ++realPos;
            if (charReached == 6) {
                if (!lengthSet) {
                    inLoop = false;
                }
                charReached = 0;
            }
            if (!lengthSet || realPos <= rawSize) continue;
            inLoop = false;
        }
        if (!lengthSet) {
            dataRead = ObjectUtils.checkEndObject(dataRead);
        }
        return dataRead;
    }

    private static byte[] appendDataBlock(int newBytes, byte[] buffer, byte[] dataRead) {
        int bytesRead = dataRead.length;
        byte[] tmp = new byte[bytesRead + newBytes];
        System.arraycopy(dataRead, 0, tmp, 0, bytesRead);
        System.arraycopy(buffer, 0, tmp, bytesRead, newBytes);
        return tmp;
    }

    public byte[] readObjectAsByteArray(PdfObject pdfObject, boolean isCompressed, int objectID, int gen) {
        byte[] raw = null;
        if (this.linHintTable != null) {
            raw = this.linHintTable.getObjData(objectID);
        }
        if (raw == null) {
            if (isCompressed) {
                raw = this.readCompressedObjectAsByteArray(pdfObject, objectID, gen);
            } else {
                this.movePointer(objectID, gen);
                if (this.ObjLengthTable == null || this.refTableInvalid) {
                    raw = this.readObjectData(-1, pdfObject);
                } else {
                    if (objectID > this.ObjLengthTable.length) {
                        return null;
                    }
                    raw = this.readObjectData(this.ObjLengthTable[objectID], pdfObject);
                }
            }
        }
        return raw;
    }

    private byte[] readCompressedObjectAsByteArray(PdfObject pdfObject, int objectID, int gen) {
        byte[] raw;
        int compressedID = this.getCompressedStreamObject(objectID, gen);
        String startID = null;
        HashMap offsetStart = this.lastOffsetStart;
        HashMap offsetEnd = this.lastOffsetEnd;
        int First2 = this.lastFirst;
        boolean isCached = true;
        byte[] compressedStream = this.lastCompressedStream;
        if (this.lastOffsetStart != null) {
            startID = (String)this.lastOffsetStart.get(String.valueOf(objectID));
        }
        while (startID == null) {
            isCached = false;
            this.movePointer(compressedID, 0);
            raw = this.readObjectData(this.ObjLengthTable[compressedID], null);
            String compref = compressedID + " " + gen + " R";
            CompressedObject compressedObj = new CompressedObject(compref);
            ObjectDecoder objDecoder = new ObjectDecoder(this);
            objDecoder.readDictionaryAsObject(compressedObj, 0, raw);
            offsetStart = new HashMap();
            offsetEnd = new HashMap();
            First2 = ((PdfObject)compressedObj).getInt(960643930);
            compressedStream = compressedObj.getDecodedStream();
            this.extractCompressedObjectOffset(offsetStart, offsetEnd, First2, compressedStream, compressedID);
            startID = (String)offsetStart.get(String.valueOf(objectID));
            PdfObject Extends = ((PdfObject)compressedObj).getDictionary(894663815);
            String compressedRef = Extends == null ? null : Extends.getObjectRefAsString();
            if (compressedRef == null) continue;
            compressedID = Integer.parseInt(compressedRef.substring(0, compressedRef.indexOf(32)));
        }
        if (!isCached) {
            this.lastCompressedStream = compressedStream;
            this.lastOffsetStart = offsetStart;
            this.lastOffsetEnd = offsetEnd;
            this.lastFirst = First2;
        }
        int start = First2 + Integer.parseInt(startID);
        int end = compressedStream.length;
        String endID = (String)offsetEnd.get(String.valueOf(objectID));
        if (endID != null) {
            end = First2 + Integer.parseInt(endID);
        }
        int streamLength = end - start;
        raw = new byte[streamLength];
        System.arraycopy(compressedStream, start, raw, 0, streamLength);
        pdfObject.setInCompressedStream(true);
        return raw;
    }

    public byte[] readPageIntoStream(PdfObject pdfObject) {
        byte[][] pageContents = pdfObject.getKeyArray(1216184967);
        byte[] binary_data = new byte[]{};
        if (pageContents == null || pageContents != null && pageContents.length > 0 && pageContents[0] == null) {
            return binary_data;
        }
        if (pageContents != null) {
            int count = pageContents.length;
            for (int ii = 0; ii < count; ++ii) {
                StreamObject streamData = new StreamObject(new String(pageContents[ii]));
                streamData.isDataExternal(pdfObject.isDataExternal());
                this.readObject(streamData);
                byte[] decoded_stream_data = streamData.getDecodedStream();
                binary_data = ii == 0 && decoded_stream_data != null ? decoded_stream_data : PdfFileReader.appendData(binary_data, decoded_stream_data);
            }
        }
        return binary_data;
    }

    private static byte[] appendData(byte[] binary_data, byte[] decoded_stream_data) {
        if (decoded_stream_data != null) {
            int current_length = binary_data.length + 1;
            int processed_length = decoded_stream_data.length;
            if (processed_length > 0) {
                while (decoded_stream_data[processed_length - 1] == 0) {
                    --processed_length;
                }
                byte[] temp = new byte[current_length];
                System.arraycopy(binary_data, 0, temp, 0, current_length - 1);
                temp[current_length - 1] = 32;
                binary_data = new byte[current_length + processed_length];
                System.arraycopy(temp, 0, binary_data, 0, current_length);
                System.arraycopy(decoded_stream_data, 0, binary_data, current_length, processed_length);
            }
        }
        return binary_data;
    }

    public void setCertificate(Certificate certificate, PrivateKey key) {
        this.certificate = certificate;
        this.key = key;
    }
}

