/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.LogWriter;

public class RandomAccessFileBuffer
extends RandomAccessFile
implements RandomAccessBuffer {
    private String fileName = "";

    public RandomAccessFileBuffer(File file, String mode) throws FileNotFoundException {
        super(file, mode);
        this.fileName = file.getAbsolutePath();
    }

    public RandomAccessFileBuffer(String file, String mode) throws FileNotFoundException {
        super(file, mode);
        this.fileName = file;
    }

    @Override
    public byte[] getPdfBuffer() {
        byte[] pdfByteArray;
        block3: {
            pdfByteArray = null;
            try {
                int read;
                URL url = new URL("file:///" + this.fileName);
                InputStream is = url.openStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.flush();
                is.close();
                os.close();
                pdfByteArray = os.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("[PDF] Exception " + e + " getting byte[] for " + this.fileName);
            }
        }
        return pdfByteArray;
    }
}

