/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.formData;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_String;

public abstract class ComponentData
implements GUIData {
    protected boolean rasterizeForms = false;
    protected int offset = 0;
    public static final int TEXT_TYPE = 0;
    public static final int BUTTON_TYPE = 1;
    public static final int LIST_TYPE = 2;
    public static final int UNKNOWN_TYPE = -1;
    protected boolean forceRedraw = false;
    protected Map<Rectangle, List> hideObjectsMap = new HashMap<Rectangle, List>();
    protected int userX;
    protected int userY;
    protected int widestPageNR;
    protected int widestPageR;
    protected int displayView;
    PdfObjectReader currentPdfFile = null;
    int formFactoryType = 1;
    protected Map<Comparable, Object> rawFormData = new HashMap<Comparable, Object>();
    protected Map<Comparable, Object> convertFormIDtoRef = new HashMap<Comparable, Object>();
    protected Map<Comparable, Object> nameToRef = new HashMap<Comparable, Object>();
    protected Map<Comparable, Object> duplicateNames = new HashMap<Comparable, Object>();
    protected Map<Comparable, Object> caseInsensitiveNameToFieldName = new HashMap<Comparable, Object>();
    protected Map<Comparable, Object> nameToCompIndex;
    protected Map<Comparable, Object> refToCompIndex;
    private Map<String, String> fullyQualToRef = new HashMap<String, String>();
    private List<String> namesMap = new ArrayList<String>();
    protected Map LastValueByName = new HashMap();
    protected Map LastValueChanged = new HashMap();
    private Map xfaRefToForm;
    protected Map componentsToIgnore = new HashMap();
    protected int insetW;
    protected int insetH;
    protected PdfPageData pageData;
    protected Javascript javascript;
    protected int pageHeight;
    protected int indent;
    protected int[] cropOtherY;
    protected float displayScaling;
    protected int rotation;
    protected float lastScaling = -1.0f;
    protected float oldRotation = 0.0f;
    protected float oldIndent = 0.0f;
    protected int startPage;
    protected int endPage;
    protected int currentPage;
    protected String lastNameAdded = "";
    protected Map<String, String> duplicates = new HashMap<String, String>();
    protected Map<String, Object> lastValidValue = new HashMap<String, Object>();
    protected Map<String, Object> lastUnformattedValue = new HashMap<String, Object>();
    protected Map<String, Integer> typeValues;
    protected int nextFreeField = 0;
    protected float[][] popupBounds = new float[0][4];
    protected int[] xReached;
    protected int[] yReached;
    protected int[] trackPagesRendered;
    protected List[] formsUnordered;
    private int formCount;
    protected PdfLayerList layers;
    protected PdfDecoder pdfDecoder;

    @Override
    public void setRasterizeForms(boolean inlineForms) {
        this.rasterizeForms = inlineForms;
    }

    @Override
    public Object getLastValidValue(String fieldRef) {
        if (!fieldRef.contains(" 0 R") && !fieldRef.contains(" 0 X")) {
            fieldRef = (String)this.nameToRef.get(fieldRef);
        }
        return this.lastValidValue.get(fieldRef);
    }

    @Override
    public void setLayerData(PdfLayerList layers) {
        this.layers = layers;
    }

    @Override
    public List<String> getComponentNameList(int pageNumber) {
        if (this.trackPagesRendered == null) {
            return null;
        }
        if (pageNumber != -1 && this.trackPagesRendered[pageNumber] == -1) {
            return null;
        }
        int currentComp = pageNumber == -1 ? 0 : this.trackPagesRendered[pageNumber];
        ArrayList<String> nameList = new ArrayList<String>();
        FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(currentComp));
        while (pageNumber == -1 || formObject != null && formObject.getPageNumber() == pageNumber) {
            String currentName = null;
            if (formObject != null && (currentName = formObject.getNameUsed()).length() == 0) {
                currentName = null;
            }
            if (currentName != null) {
                if (formObject.testedForDuplicates()) {
                    formObject.testedForDuplicates(true);
                    String previous = this.duplicates.get(currentName);
                    if (previous != null) {
                        this.duplicates.put(currentName, previous + ',' + currentComp);
                    } else {
                        this.duplicates.put(currentName, String.valueOf(currentComp));
                    }
                }
                nameList.add(currentName);
            }
            if (++currentComp == this.nextFreeField + 1) break;
            formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(currentComp));
        }
        return nameList;
    }

    @Override
    public Object getLastUnformattedValue(String fieldRef) {
        if (!fieldRef.contains(" 0 R") && !fieldRef.contains(" 0 X")) {
            fieldRef = (String)this.nameToRef.get(fieldRef);
        }
        return this.lastUnformattedValue.get(fieldRef);
    }

    @Override
    public void reset(String[] aFields) {
        if (aFields != null) {
            for (String aField : aFields) {
                String ref = (String)this.nameToRef.get(aFields[0]);
                this.lastValidValue.remove(ref);
                this.lastUnformattedValue.remove(ref);
            }
        } else {
            this.lastValidValue.clear();
            this.lastUnformattedValue.clear();
        }
    }

    @Override
    public int getPageForFormObject(String formName) {
        FormObject formObj = null;
        if (formName.contains("R")) {
            formObj = (FormObject)this.rawFormData.get(formName);
        } else {
            String ref = (String)this.nameToRef.get(formName);
            if (ref != null) {
                formObj = (FormObject)this.rawFormData.get(ref);
            }
        }
        if (formObj == null) {
            return -1;
        }
        return formObj.getPageNumber();
    }

    @Override
    public Integer getTypeValueByName(String fieldName) {
        Integer key = this.typeValues.get(fieldName);
        if (key == null) {
            return FormFactory.UNKNOWN;
        }
        return this.typeValues.get(fieldName);
    }

    private void setStartForPage(int page) {
        this.trackPagesRendered[page] = this.nextFreeField;
    }

    @Override
    public void setUnsortedListForPage(int page, List unsortedComps) {
        this.formsUnordered[page] = unsortedComps;
    }

    @Override
    public Object getValue(Object objectName) {
        if (objectName == null) {
            return "";
        }
        Object checkObj = ((String)objectName).contains("R") ? this.refToCompIndex.get(objectName) : this.nameToCompIndex.get(objectName);
        return this.getFormValue(checkObj);
    }

    protected Object checkGUIObjectResolved(int formNum) {
        throw new RuntimeException("base method checkGUIObjectResolved(formNum) should not be called");
    }

    public void displayComponent(int currentComp, FormObject formObject, Object comp, int startPage, int page) {
        throw new RuntimeException("base method displayComponent( ) should not be called");
    }

    public void setCompVisible(Object comp, boolean visible) {
        throw new RuntimeException("base method setCompVisible(formNum) should not be called");
    }

    @Override
    public void displayComponents(int startPage, int endPage) {
        if (this.rasterizeForms) {
            return;
        }
        this.startPage = startPage;
        this.endPage = endPage;
        block0: for (int page = startPage; page < endPage; ++page) {
            int currentComp = this.getStartComponentCountForPage(page);
            if (this.nextFreeField + 1 <= currentComp) {
                return;
            }
            if (currentComp == -1 || currentComp == -999 || startPage <= 0 || endPage <= 0) continue;
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(currentComp));
            while (formObject != null && formObject.getPageNumber() >= startPage && formObject.getPageNumber() < endPage) {
                Object comp = this.checkGUIObjectResolved(currentComp);
                if (comp != null) {
                    this.syncKidValues(currentComp);
                    this.displayComponent(currentComp, formObject, comp, startPage, page);
                }
                if (++currentComp == this.nextFreeField + 1) continue block0;
                formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(currentComp));
            }
        }
    }

    @Override
    public void hideComp(String compName, boolean visible) {
        Integer compIndex;
        Object[] checkObj;
        int[] indexs = null;
        if (compName == null) {
            indexs = new int[this.nextFreeField + 1];
            for (int i = 0; i < indexs.length; ++i) {
                indexs[i] = i;
            }
        }
        if ((checkObj = this.getComponentsByName(compName, compIndex = Integer.valueOf(this.getIndexFromName(compName)), true)) != null) {
            for (int j = 0; j < checkObj.length; ++j) {
                if (indexs != null) {
                    FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(indexs[j]));
                    Rectangle rect = formObject.getBoundingRectangle();
                    float rx = rect.x;
                    float ry = rect.y;
                    float rwidth = rect.width;
                    float rheight = rect.height;
                    Rectangle rootRect = new Rectangle((int)rx, (int)ry, (int)rwidth, (int)rheight);
                    ArrayList<Integer> indexsToHide = this.hideObjectsMap.get(rootRect);
                    if (indexsToHide == null) {
                        indexsToHide = new ArrayList<Integer>();
                        for (int i = 0; i < this.nextFreeField + 1; ++i) {
                            FormObject formObject2 = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(i));
                            if (formObject2 == null || !rootRect.contains(formObject2.getBoundingRectangle())) continue;
                            indexsToHide.add(i);
                        }
                        this.hideObjectsMap.put(rootRect, indexsToHide);
                    }
                    if (indexsToHide != null) {
                        for (Object e : indexsToHide) {
                            int index = (Integer)e;
                            FormObject formObject3 = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(index));
                            Object comp = null;
                            if (formObject3 == null || (comp = formObject3.getGUIComponent()) == null) continue;
                            this.setCompVisible(comp, !visible);
                        }
                    }
                }
                this.setCompVisible(checkObj[j], visible);
            }
        }
    }

    public Integer convertRefToID(Object ref) {
        Integer checkObj = ref.toString().contains("R") ? (Integer)this.refToCompIndex.get(ref) : (Integer)this.nameToCompIndex.get(ref);
        return checkObj;
    }

    @Override
    public Object getWidget(Object objectName) {
        if (objectName == null) {
            return null;
        }
        Integer index = this.convertRefToID(objectName);
        if (index == null) {
            return null;
        }
        return this.checkGUIObjectResolved(index);
    }

    public void syncKidValues(int currentComp) {
        throw new RuntimeException("base method syncFormsByName(name) should not be called");
    }

    public Object getFormValue(Object checkObj) {
        throw new RuntimeException("base method getFormValue(checkObj) should not be called");
    }

    @Override
    public int getNextFreeField() {
        return this.nextFreeField;
    }

    public int getMaxFieldSize() {
        return this.formCount;
    }

    @Override
    public int getStartComponentCountForPage(int page) {
        if (this.trackPagesRendered == null) {
            return -999;
        }
        if (this.trackPagesRendered.length > page && page > -1) {
            return this.trackPagesRendered[page];
        }
        return -1;
    }

    @Override
    public void initParametersForPage(PdfPageData pageData, int page, PdfDecoder decoder) {
        int cropTop;
        int mediaHeight;
        if (this.cropOtherY == null || this.cropOtherY.length <= page) {
            this.resetComponents(0, page + 1, false);
        }
        this.cropOtherY[page] = (mediaHeight = pageData.getMediaBoxHeight(page)) != (cropTop = pageData.getCropBoxHeight(page) + pageData.getCropBoxY(page)) ? mediaHeight - cropTop : 0;
        this.pageHeight = mediaHeight;
        this.currentPage = page;
        if (!this.formsRasterizedForDisplay()) {
            this.setStartForPage(page);
        }
        this.pdfDecoder = decoder;
    }

    @Override
    public boolean resetComponents(int formCount, int pageCount, boolean keepValues) {
        if (keepValues && this.formCount > formCount) {
            return false;
        }
        this.formCount = formCount;
        if (!keepValues) {
            this.nextFreeField = 0;
            this.refToCompIndex = new HashMap<Comparable, Object>(formCount + 1);
            this.nameToCompIndex = new HashMap<Comparable, Object>(formCount + 1);
            this.typeValues = new HashMap<String, Integer>(formCount + 1);
            this.popupBounds = new float[0][4];
            this.trackPagesRendered = new int[pageCount + 1];
            for (int i = 0; i < pageCount + 1; ++i) {
                this.trackPagesRendered[i] = -1;
            }
            this.formsUnordered = new List[pageCount + 1];
            this.cropOtherY = new int[pageCount + 1];
            this.yReached = null;
            this.xReached = null;
        }
        return true;
    }

    @Override
    public void setPageValues(float scaling, int rotation, int indent, int userX, int userY, int displayView, int widestPageNR, int widestPageR) {
        this.rotation = rotation;
        this.displayScaling = scaling;
        this.indent = indent;
        this.userX = userX;
        this.userY = userY;
        this.displayView = displayView;
        this.widestPageNR = widestPageNR;
        this.widestPageR = widestPageR;
    }

    @Override
    public void setPageData(PdfPageData pageData, int insetW, int insetH) {
        this.insetW = insetW;
        this.insetH = insetH;
        this.pageData = pageData;
    }

    @Override
    public void setPageDisplacements(int[] xReached, int[] yReached) {
        this.xReached = xReached;
        this.yReached = yReached;
        this.forceRedraw = true;
    }

    @Override
    public void setForceRedraw(boolean forceRedraw) {
        this.forceRedraw = forceRedraw;
    }

    @Override
    public void setJavascript(Javascript javascript) {
        this.javascript = javascript;
    }

    @Override
    public void resetDuplicates() {
        this.duplicates.clear();
    }

    protected boolean isFormNotPrinted(int currentComp) {
        String ref = this.convertIDtoRef(currentComp);
        FormObject form = (FormObject)this.getRawForm(ref)[0];
        if (form != null) {
            return this.componentsToIgnore != null && (this.componentsToIgnore.containsKey(form.getParameterConstant(1147962727)) || this.componentsToIgnore.containsKey(form.getParameterConstant(608780341)));
        }
        return false;
    }

    @Override
    public void storeXFARefToForm(Map xfaRefToFormObject) {
        this.xfaRefToForm = xfaRefToFormObject;
    }

    @Override
    public void storeRawData(FormObject formObject) {
        String duplicate;
        String fieldName = formObject.getTextStreamValue(36);
        if (fieldName != null) {
            this.namesMap.add(fieldName);
            this.caseInsensitiveNameToFieldName.put((Comparable)((Object)fieldName.toLowerCase()), fieldName);
        }
        String ref = formObject.getObjectRefAsString();
        this.nameToRef.put((Comparable)((Object)fieldName), ref);
        this.rawFormData.put((Comparable)((Object)ref), formObject);
        String parent = formObject.getParentRef();
        boolean isMultiple = false;
        String fullyQualName = null;
        while (parent != null && !parent.equals(ref)) {
            FormObject parentObj = new FormObject(parent, false);
            this.pdfDecoder.getIO().readObject(parentObj);
            String newName = null;
            if (parentObj != null) {
                newName = parentObj.getTextStreamValue(36);
            }
            if (newName == null) break;
            if (fieldName != null && !fieldName.contains(newName)) {
                fullyQualName = newName + '.' + fieldName.substring(fieldName.lastIndexOf(46) + 1);
                isMultiple = true;
            }
            parent = parentObj.getParentRef();
        }
        if (isMultiple) {
            this.fullyQualToRef.put(fullyQualName, ref);
        }
        if ((duplicate = (String)this.duplicateNames.get(fieldName)) == null) {
            this.duplicateNames.put((Comparable)((Object)fieldName), ref);
        } else {
            duplicate = duplicate + ',' + ref;
            this.duplicateNames.put((Comparable)((Object)fieldName), duplicate);
        }
    }

    @Override
    public void flushFormData() {
        this.nameToRef.clear();
        this.fullyQualToRef.clear();
        this.rawFormData.clear();
        this.LastValueByName.clear();
        this.duplicateNames.clear();
        this.convertFormIDtoRef.clear();
        this.namesMap.clear();
        this.lastNameAdded = "";
        this.hideObjectsMap.clear();
        this.oldIndent = -this.oldIndent;
    }

    @Override
    public String convertIDtoRef(int objectID) {
        return (String)this.convertFormIDtoRef.get(objectID);
    }

    @Override
    public int getFieldType(Object swingComp) {
        int subtype = ((FormObject)swingComp).getParameterConstant(1147962727);
        switch (subtype) {
            case 9288: {
                return 0;
            }
            case 4920: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public String getnameToRef(String objectName) {
        return (String)this.nameToRef.get(objectName);
    }

    @Override
    public int getIndexFromName(String name) {
        return (Integer)this.nameToCompIndex.get(FormUtils.removeStateToCheck(name, false));
    }

    @Override
    public Object[] getRawForm(String objectName) {
        return this.getRawForm(objectName, true);
    }

    @Override
    public Object[] getRawForm(String objectName, boolean caseSensative) {
        String matches;
        String name;
        if (!caseSensative && (name = (String)this.caseInsensitiveNameToFieldName.get(objectName.toLowerCase())) != null) {
            objectName = name;
        }
        if ((matches = (String)this.duplicateNames.get(objectName)) == null || matches.indexOf(44) == -1) {
            String[] names;
            if (!this.rawFormData.containsKey(objectName = this.getPossRef(objectName)) && (names = this.getChildNames(objectName)) != null && names.length > 0) {
                Object[] values = new Object[names.length];
                for (int i = 0; i < names.length; ++i) {
                    objectName = this.getPossRef(names[i]);
                    values[i] = this.rawFormData.get(objectName);
                }
                return values;
            }
            return new Object[]{this.rawFormData.get(objectName)};
        }
        StringTokenizer comps = new StringTokenizer(matches, ",");
        int count = comps.countTokens();
        Object[] values = new Object[count];
        for (int ii = 0; ii < count; ++ii) {
            values[ii] = this.rawFormData.get(comps.nextToken());
        }
        return values;
    }

    private String getPossRef(String objectName) {
        String possRef = (String)this.nameToRef.get(objectName);
        if (possRef != null) {
            objectName = possRef;
        }
        if ((possRef = this.fullyQualToRef.get(objectName)) != null) {
            objectName = possRef;
        }
        return objectName;
    }

    @Override
    public Map<Comparable, Object> getRawFormData() {
        return this.rawFormData;
    }

    @Override
    public String[] getChildNames(String name) {
        if (name == null) {
            return null;
        }
        if (!this.namesMap.isEmpty() && this.namesMap.toString().contains(name)) {
            Vector_String childNames = new Vector_String();
            for (String aNamesMap : this.namesMap) {
                String val = aNamesMap;
                if (!val.contains(name)) continue;
                childNames.addElement(val);
            }
            childNames.trim();
            return childNames.get();
        }
        return null;
    }

    @Override
    public void completeField(FormObject formObject, int formNum, Integer formType, Object rawField, PdfObjectReader currentPdfFile) {
        boolean isNotLazyReinitCall = true;
        if (formType < 0) {
            formType = -formType.intValue();
            isNotLazyReinitCall = false;
        }
        this.currentPdfFile = currentPdfFile;
        if (rawField == null && this.formFactoryType != 1) {
            return;
        }
        String fieldName = formObject.getTextStreamValue(36);
        this.refToCompIndex.put((Comparable)((Object)formObject.getObjectRefAsString()), formNum);
        this.convertFormIDtoRef.put(Integer.valueOf(formNum), formObject.getObjectRefAsString());
        if (formType.equals(FormFactory.UNKNOWN)) {
            this.typeValues.put(fieldName, FormFactory.ANNOTATION);
        } else {
            this.typeValues.put(fieldName, formType);
        }
        String name = fieldName;
        if (name != null && isNotLazyReinitCall) {
            String curCompName;
            String stateToCheck = formObject.getNormalOnState();
            if (stateToCheck != null && stateToCheck.length() > 0) {
                name = name + "-(" + stateToCheck + ')';
            }
            if ((curCompName = FormUtils.removeStateToCheck(name, false)) != null && !this.lastNameAdded.equals(curCompName)) {
                this.nameToCompIndex.put((Comparable)((Object)curCompName), formNum);
                this.lastNameAdded = curCompName;
            }
            formObject.setNameUsed(curCompName);
        }
        if (isNotLazyReinitCall) {
            ++this.nextFreeField;
        }
        if (rawField != null) {
            formObject.setGUIComponent(rawField);
            this.setGUIComp(formObject, formNum, rawField);
        }
    }

    public void setGUIComp(FormObject formObject, int formNum, Object rawField) {
        throw new RuntimeException("Should never be called");
    }

    @Override
    public Object[] getComponentsByName(String objectName) {
        if (objectName == null) {
            return null;
        }
        Object checkObj = this.nameToCompIndex.get(objectName);
        if (checkObj == null) {
            return null;
        }
        if (checkObj instanceof Integer) {
            return this.getComponentsByName(objectName, checkObj, false);
        }
        LogWriter.writeLog("{stream} ERROR DefaultAcroRenderer.getComponentByName() Object NOT Integer and NOT null");
        return null;
    }

    public Object[] getComponentsByName(String objectName, Object checkObj, boolean collateIndexs) {
        int[] indexs = null;
        HashMap<String, String> valuesCounted = new HashMap<String, String>();
        String duplicateComponents = this.duplicates.get(objectName);
        int index = (Integer)checkObj;
        valuesCounted.put(String.valueOf(index), "x");
        boolean moreToProcess = true;
        int firstIndex = index;
        while (moreToProcess) {
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(index + 1));
            if (index + 1 < this.nextFreeField + 1 && formObject != null) {
                String name = formObject.getNameUsed();
                if (name == null) {
                    moreToProcess = false;
                    continue;
                }
                if (FormUtils.removeStateToCheck(name, false).equals(objectName)) {
                    valuesCounted.put(String.valueOf(index + 1), "x");
                    ++index;
                    continue;
                }
                moreToProcess = false;
                continue;
            }
            moreToProcess = false;
        }
        int size = index + 1 - firstIndex;
        Object[] compsToRet = new Object[size];
        if (collateIndexs) {
            indexs = new int[size];
        }
        int i = 0;
        while (i < size) {
            compsToRet[i] = this.checkGUIObjectResolved(firstIndex);
            if (collateIndexs) {
                indexs[i] = firstIndex;
            }
            if (firstIndex == index) break;
            ++i;
            ++firstIndex;
        }
        if (duplicateComponents != null && duplicateComponents.indexOf(44) != -1) {
            StringTokenizer additionalComponents = new StringTokenizer(duplicateComponents, ",");
            int count = additionalComponents.countTokens();
            int alreadyCounted = 0;
            String[] keys = new String[count];
            for (int ii = 0; ii < count; ++ii) {
                keys[ii] = additionalComponents.nextToken();
                if (!valuesCounted.containsKey(keys[ii])) continue;
                ++alreadyCounted;
                keys[ii] = null;
            }
            Object[] origComponentList = compsToRet;
            compsToRet = new Object[size + (count -= alreadyCounted)];
            System.arraycopy(origComponentList, 0, compsToRet, 0, size);
            if (collateIndexs) {
                int[] tmpind = indexs;
                indexs = new int[compsToRet.length];
                System.arraycopy(tmpind, 0, indexs, 0, size);
            }
            for (int i2 = 0; i2 < count; ++i2) {
                if (keys[i2] == null) continue;
                int ii = Integer.parseInt(keys[i2]);
                if (collateIndexs) {
                    indexs[i2 + size] = ii;
                }
                compsToRet[i2 + size] = this.checkGUIObjectResolved(ii);
            }
        }
        return compsToRet;
    }

    protected static Rectangle checkPopupBoundsOnPage(Rectangle bounds, Rectangle inside) {
        if (bounds.x < inside.x) {
            bounds.x = inside.x;
        }
        if (bounds.y < inside.y) {
            bounds.y = inside.y;
        }
        if (bounds.x + bounds.width > inside.x + inside.width) {
            bounds.x = inside.x + inside.width - bounds.width;
        }
        if (bounds.y + bounds.height > inside.y + inside.height) {
            bounds.y = inside.y + inside.height - bounds.height;
        }
        return bounds;
    }

    @Override
    public void setUnformattedValue(String ref, Object value) {
        if (!ref.contains(" 0 R") && !ref.contains(" 0 X")) {
            ref = (String)this.nameToRef.get(ref);
        }
        this.lastUnformattedValue.put(ref, value);
    }

    @Override
    public void setLastValidValue(String ref, Object value) {
        if (!ref.contains(" 0 R") && !ref.contains(" 0 X")) {
            ref = (String)this.nameToRef.get(ref);
        }
        this.lastValidValue.put(ref, value);
    }

    public Object setValue(String ref, Object value, boolean isValid, boolean isFormatted, Object oldValue) {
        Object checkObj;
        if (isValid) {
            this.setLastValidValue(ref, value);
        }
        if (isFormatted) {
            this.setUnformattedValue(ref, oldValue);
        }
        if ((checkObj = ref.contains("R") ? this.refToCompIndex.get(ref) : this.nameToCompIndex.get(ref)) == null) {
            return null;
        }
        String pdfRef = this.convertIDtoRef((Integer)checkObj);
        FormObject form = (FormObject)this.rawFormData.get(pdfRef);
        form.setValue((String)value);
        return checkObj;
    }

    @Override
    public void resetAfterPrinting() {
        this.forceRedraw = true;
    }

    public void invalidateForms() {
        this.lastScaling = -this.lastScaling;
    }

    @Override
    public String getFieldNameFromRef(String ref) {
        return ((FormObject)this.rawFormData.get(ref)).getTextStreamValue(36);
    }

    public static int calculateFontSize(int height, int width, boolean area, String text) {
        int lineLen = text.length();
        double v1 = (double)height * 0.85;
        if (lineLen == 0) {
            return (int)v1;
        }
        double v2 = width / lineLen;
        if (v1 > v2 * 2.0) {
            return (int)v2;
        }
        return (int)v1;
    }

    @Override
    public boolean formsRasterizedForDisplay() {
        return this.rasterizeForms;
    }

    @Override
    public FormObject getFormObject(int i) {
        return (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(i));
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }
}

