/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.formData.ComponentData;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.StringUtils;

public class ReadOnlyTextIcon
extends CustomImageIcon
implements Icon,
SwingConstants {
    private int alignment = -1;
    private static final long serialVersionUID = 8946195842453749725L;
    private BufferedImage rootImage = null;
    private BufferedImage finalImage = null;
    private PdfObject fakeObj = null;
    private boolean textChanged = false;
    private String preFontStream = "";
    private String betweenFontAndTextStream = "";
    private String afterTextStream = "";
    private String text = "";
    private String fontName = "";
    private String fontSize = "";
    private String fontCommand = "";
    private String fullCommandString;
    private PdfObjectReader currentpdffile = null;
    private int subtype = -1;
    private PdfObject resources;

    public ReadOnlyTextIcon(int iconRot, PdfObjectReader pdfObjectReader, PdfObject res) {
        super(iconRot);
        this.currentpdffile = pdfObjectReader;
        this.resources = res;
    }

    @Override
    public Image getImage() {
        this.checkAndCreateimage();
        BufferedImage image = this.finalImage;
        return image;
    }

    public BufferedImage drawToBufferedImage() {
        BufferedImage bufImg = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics g = bufImg.getGraphics();
        this.paintIcon(null, g, 0, 0);
        g.dispose();
        return bufImg;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = (BufferedImage)this.getImage();
        if (image == null) {
            return;
        }
        if (c != null && c.isEnabled()) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(Color.gray);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int finalRotation;
            int drawWidth = this.iconWidth;
            int drawHeight = this.iconHeight;
            if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                drawWidth = this.iconHeight;
                drawHeight = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float hs;
                float ws = (float)drawWidth / (float)image.getWidth(null);
                if (ws < (hs = (float)drawHeight / (float)image.getHeight(null))) {
                    drawWidth = (int)(ws * (float)image.getWidth(null));
                    drawHeight = (int)(ws * (float)image.getHeight(null));
                } else {
                    drawWidth = (int)(hs * (float)image.getWidth(null));
                    drawHeight = (int)(hs * (float)image.getHeight(null));
                }
            }
            int posX = 0;
            int posY = 0;
            if (this.currentpdffile != null) {
                if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                    posX = (this.iconHeight - drawWidth) / 2;
                    posY = (this.iconWidth - drawHeight) / 2;
                } else {
                    posX = (this.iconWidth - drawWidth) / 2;
                    posY = (this.iconHeight - drawHeight) / 2;
                }
            }
            if (this.alignment == 2) {
                posX = 0;
            }
            if ((finalRotation = this.displaySingle ? ReadOnlyTextIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate) == 270) {
                g2.rotate(-1.5707963267948966);
                g2.translate(-drawWidth, 0);
                g2.drawImage(image, -posX, posY, drawWidth, drawHeight, null);
            } else if (finalRotation == 90) {
                g2.rotate(1.5707963267948966);
                g2.translate(0, -drawHeight);
                g2.drawImage(image, posX, -posY, drawWidth, drawHeight, null);
            } else if (finalRotation == 180) {
                g2.rotate(Math.PI);
                g2.translate(-drawWidth, -drawHeight);
                g2.drawImage(image, -posX, -posY, drawWidth, drawHeight, null);
            } else {
                g2.drawImage(image, posX, posY, drawWidth, drawHeight, null);
            }
        } else {
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.translate(-x, -y);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int newWidth = this.iconWidth;
        int newHeight = this.iconHeight;
        if (this.textChanged || this.rootImage == null || newWidth > this.rootImage.getWidth(null) || newHeight > this.rootImage.getHeight(null) || (float)newWidth < (float)this.rootImage.getWidth(null) / MAXSCALEFACTOR || (float)newHeight < (float)this.rootImage.getHeight(null) / MAXSCALEFACTOR) {
            this.rootImage = FormStream.decode(this.currentpdffile, this.fakeObj, this.subtype, newWidth, newHeight, 0, 1.0f);
            this.finalImage = FormStream.rotate(this.rootImage, this.iconRotation);
            this.textChanged = false;
        }
    }

    public void setFont(String fontName, float fontSize, String fontCommand) {
        this.fontName = fontName;
        this.fontSize = fontName.length() != 0 ? " " + fontSize + ' ' : "";
        this.fontCommand = fontCommand;
    }

    public void setText(String str) {
        if (str == null) {
            str = "";
        }
        if (str.equals(this.text)) {
            return;
        }
        this.textChanged = true;
        this.text = str;
        this.fullCommandString = this.preFontStream + this.fontName + this.fontSize + this.fontCommand + this.betweenFontAndTextStream + '(' + this.text + ")Tj " + this.afterTextStream;
        this.fakeObj.setDecodedStream(StringUtils.toBytes(this.fullCommandString));
    }

    public String getText() {
        return this.text;
    }

    public boolean decipherAppObject(FormObject form) {
        String DA;
        byte[] bytes;
        String fontStr = "";
        PdfObject appObj = form.getDictionary(4384).getDictionary(30);
        if (appObj != null && (bytes = appObj.getDecodedStream()) != null) {
            int startTj;
            int i;
            int startTf = -1;
            int endTf = -1;
            int endTj = -1;
            int end = bytes.length;
            for (i = 0; i < end - 1; ++i) {
                if ((char)bytes[i] != 'T' || (char)bytes[i + 1] != 'f' || i + 2 < end && bytes[i + 2] != 10 && bytes[i + 2] != 13 && bytes[i + 2] != 32) continue;
                endTf = i + 2;
                break;
            }
            if (endTf == -1) {
                startTf = 0;
                endTf = 0;
            } else {
                for (i = endTf - 3; i > startTf; --i) {
                    if (bytes[i] != 47) continue;
                    startTf = i;
                    break;
                }
            }
            for (i = endTf; i < end - 1; ++i) {
                if ((char)bytes[i] != 'T' || (char)bytes[i + 1] != 'j' || i + 2 < end && bytes[i + 2] != 10 && bytes[i + 2] != 13 && bytes[i + 2] != 32) continue;
                endTj = i + 2;
                break;
            }
            if (endTj == -1) {
                startTj = endTf;
                endTj = endTf;
            } else {
                startTj = endTf;
                int brackets = 0;
                boolean strFound = false;
                for (int i2 = endTj - 3; i2 > startTj; --i2) {
                    if (bytes[i2] == 32 || bytes[i2] == 10 || bytes[i2] == 13) {
                        if (!strFound || brackets != 0) continue;
                        startTj = i2 + 1;
                        break;
                    }
                    if (bytes[i2] == 41) {
                        ++brackets;
                        continue;
                    }
                    if (bytes[i2] == 40) {
                        if (--brackets != 0 || !strFound) continue;
                        startTj = i2;
                        break;
                    }
                    strFound = true;
                }
            }
            for (i = endTf; i < startTj; ++i) {
                if (bytes[i] == 32 || bytes[i] == 10 || bytes[i] == 13 || bytes[i] > 47 && bytes[i] < 58) continue;
                if (bytes[i] == 103 && i + 1 < startTj && (bytes[i + 1] == 32 || bytes[i + 1] == 10 || bytes[i + 1] == 13)) {
                    endTf = i + 1;
                    break;
                }
                if (bytes[i] != 114 || i + 2 >= startTj || bytes[i + 1] != 103 || bytes[i + 2] != 32 && bytes[i + 2] != 10 && bytes[i + 2] != 13) break;
                endTf = i + 2;
                break;
            }
            if (endTj != endTf) {
                if (endTf == 0) {
                    this.preFontStream = new String(bytes, 0, startTj);
                    this.betweenFontAndTextStream = " ";
                } else {
                    this.preFontStream = new String(bytes, 0, startTf);
                    fontStr = new String(bytes, startTf, endTf - startTf);
                    this.betweenFontAndTextStream = new String(bytes, endTf, startTj - endTf);
                }
                this.text = new String(bytes, startTj, endTj - 3 - startTj);
                this.afterTextStream = new String(bytes, endTj, bytes.length - endTj);
            } else if (endTf == 0) {
                this.preFontStream = new String(bytes);
            } else {
                this.preFontStream = new String(bytes, 0, startTf);
                fontStr = new String(bytes, startTf, endTf - startTf);
                this.betweenFontAndTextStream = new String(bytes, endTf, bytes.length - endTf);
            }
        }
        if ((DA = form.getTextStreamValue(5137)) == null || DA.length() == 0) {
            if (fontStr.length() != 0) {
                form.setTextStreamValue(5137, StringUtils.toBytes(fontStr));
                FormStream.decodeFontCommandObj(fontStr, form);
            }
            return false;
        }
        if (fontStr.length() == 0) {
            fontStr = DA.trim();
        } else {
            String fontname = DA.substring(0, DA.indexOf(32));
            String fontsize = fontStr.substring(fontStr.indexOf(32), fontStr.length());
            fontStr = fontname + fontsize;
            fontStr.trim();
        }
        this.fakeObj = new XObject(form.getObjectRefAsString());
        if (this.resources != null) {
            this.fakeObj.setDictionary(2004251818, this.resources);
        }
        Rectangle BBox = form.getBoundingRectangle();
        this.fakeObj.setFloatArray(303185736, new float[]{BBox.width, 0.0f, 0.0f, BBox.height, 0.0f, 0.0f});
        this.subtype = -1;
        if (this.preFontStream.length() == 0 || !this.preFontStream.contains("BT")) {
            this.preFontStream = "BT 0 0 0 RG 1 TFS ";
            this.betweenFontAndTextStream = " 1 0 0 1 0 0 Tm ";
            this.afterTextStream = "";
        }
        int sizeSt = fontStr.indexOf(32);
        int sizeEn = -1;
        boolean strFound = false;
        for (int i = sizeSt; i < fontStr.length(); ++i) {
            char chr = fontStr.charAt(i);
            if (chr == ' ' || chr == '\n' || chr == '\r') {
                if (!strFound) continue;
                sizeEn = i;
                break;
            }
            strFound = true;
        }
        float size = 12.0f;
        if (sizeEn != -1) {
            this.fontName = fontStr.substring(0, sizeSt);
            this.fontCommand = fontStr.substring(sizeEn);
            size = Float.parseFloat(fontStr.substring(sizeSt, sizeEn));
        }
        if (this.fontName.length() == 0) {
            Font textFont = form.getTextFont();
            this.fontName = '/' + textFont.getFontName();
            this.fontCommand = "Tf ";
        }
        if (size == 0.0f || size == -1.0f) {
            size = ComponentData.calculateFontSize(BBox.height, BBox.width, false, this.text);
        }
        this.fontSize = " " + size + ' ';
        return true;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setPrinting(boolean print, int multiplier) {
        this.checkAndCreateimage();
    }
}

