/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.rendering;

import com.idrsolutions.pdf.acroforms.xfa.XFAFormStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.exception.PdfException;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.actions.ActionHandler;
import org.jpedal.objects.acroforms.actions.DefaultActionHandler;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.SwingFormFactory;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.formData.SwingData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;
import org.w3c.dom.Node;

public class DefaultAcroRenderer
implements AcroRenderer {
    public static final boolean isLazyInit = true;
    public static final boolean testActions = false;
    private static final boolean showFormsDecoded = false;
    private Map<Object, String> currentItems = new HashMap<Object, String>();
    FormObject[] Fforms;
    FormObject[] Aforms;
    PdfObject AcroRes = null;
    Object[] CO = null;
    PdfArrayIterator fieldList = null;
    PdfArrayIterator[] annotList = null;
    private static final boolean showMethods = false;
    private static final boolean identifyType = false;
    private static final boolean debug = false;
    private boolean ignoreForms = false;
    private FormFactory formFactory;
    private GUIData compData = new SwingData();
    private Map proxyObjects = new HashMap();
    private Set<FormObject> sigObject = null;
    private Map<String, FormObject> cachedObjs = new HashMap<String, FormObject>();
    private PdfPageData pageData;
    private int[] AfieldCount = null;
    private int ATotalCount;
    private int FfieldCount = 0;
    protected int pageCount = 0;
    private PdfObjectReader currentPdfFile;
    private FormStream fDecoder;
    private ActionHandler formsActionHandler;
    private Javascript javascript;
    private int insetH;
    private PdfObject acroObj;
    private boolean hasXFA = false;
    private PdfDecoder decode_pdf;

    @Override
    public void resetHandler(Object userActionHandler, PdfDecoder decode_pdf, int type) {
        this.decode_pdf = decode_pdf;
        if (type == 5) {
            this.formsActionHandler = userActionHandler != null ? (ActionHandler)userActionHandler : new DefaultActionHandler();
            this.formsActionHandler.init(decode_pdf, this.javascript, this);
            if (this.formFactory != null) {
                this.formFactory.reset(this, this.formsActionHandler);
                this.compData.resetDuplicates();
            }
        }
    }

    @Override
    public void removeDisplayComponentsFromScreen() {
        if (this.compData != null) {
            this.compData.removeAllComponentsFromScreen();
        }
    }

    @Override
    public void resetFormData(int insetW, int insetH, PdfPageData pageData, PdfObjectReader currentPdfFile, PdfObject acroObj) {
        this.insetH = insetH;
        this.currentPdfFile = currentPdfFile;
        this.pageData = pageData;
        this.acroObj = acroObj;
        this.sigObject = null;
        this.compData.setPageData(pageData, insetW, insetH);
        if (acroObj == null) {
            this.FfieldCount = 0;
            this.fieldList = null;
        } else {
            PdfArrayIterator XFAasArray = null;
            PdfObject XFAasStream = acroObj.getDictionary(2627089);
            if (XFAasStream == null && (XFAasArray = acroObj.getMixedArray(2627089)) != null && XFAasArray.getTokenCount() == 0) {
                XFAasArray = null;
            }
            this.hasXFA = XFAasStream != null || XFAasArray != null;
            this.fDecoder = this.hasXFA ? new XFAFormStream(acroObj, currentPdfFile) : new FormStream();
            this.fieldList = acroObj.getMixedArray(893143676);
            this.CO = acroObj.getObjectArray(4895);
            if (this.fieldList != null) {
                this.FfieldCount = this.fieldList.getTokenCount();
                this.AcroRes = acroObj.getDictionary(5154);
                if (this.AcroRes != null) {
                    currentPdfFile.checkResolved(this.AcroRes);
                }
            } else {
                this.FfieldCount = 0;
                this.AcroRes = null;
            }
            while (this.FfieldCount == 1) {
                String key = this.fieldList.getNextValueAsString(false);
                FormObject kidObject = new FormObject(key, this.formsActionHandler);
                currentPdfFile.readObject(kidObject);
                byte[][] childList = this.getKid(kidObject);
                if (childList == null) break;
                this.fieldList = new PdfArrayIterator(childList);
                this.FfieldCount = this.fieldList.getTokenCount();
            }
        }
        this.resetContainers(true);
    }

    @Override
    public void resetAnnotData(int insetW, int insetH, PdfPageData pageData, int page, PdfObjectReader currentPdfFile, byte[][] currentAnnotList) {
        this.insetH = insetH;
        this.currentPdfFile = currentPdfFile;
        this.pageData = pageData;
        boolean resetToEmpty = true;
        this.compData.setPageData(pageData, insetW, insetH);
        if (currentAnnotList == null) {
            this.AfieldCount = null;
            this.ATotalCount = 0;
            if (this.annotList != null) {
                this.annotList[page] = null;
            }
            this.annotList = null;
        } else {
            int size;
            int pageCount = pageData.getPageCount() + 1;
            if (pageCount <= page) {
                pageCount = page + 1;
            }
            if (this.annotList == null) {
                this.annotList = new PdfArrayIterator[pageCount];
                this.AfieldCount = new int[pageCount];
            } else if (page >= this.annotList.length) {
                PdfArrayIterator[] tempList = this.annotList;
                int[] tempCount = this.AfieldCount;
                this.AfieldCount = new int[pageCount];
                this.annotList = new PdfArrayIterator[pageCount];
                for (int ii = 0; ii < tempList.length; ++ii) {
                    this.AfieldCount[ii] = tempCount[ii];
                    this.annotList[ii] = tempList[ii];
                }
            } else if (this.AfieldCount == null) {
                this.AfieldCount = new int[pageCount];
            }
            this.annotList[page] = new PdfArrayIterator(currentAnnotList);
            this.AfieldCount[page] = size = this.annotList[page].getTokenCount();
            this.ATotalCount += size;
            resetToEmpty = false;
            if (this.fDecoder == null) {
                this.fDecoder = this.hasXFA ? new XFAFormStream(this.acroObj, currentPdfFile) : new FormStream();
            }
        }
        this.resetContainers(resetToEmpty);
    }

    protected void resetContainers(boolean resetToEmpty) {
        if (resetToEmpty) {
            this.currentItems.clear();
            this.compData.resetComponents(this.ATotalCount + this.FfieldCount, this.pageCount, false);
            this.proxyObjects.clear();
        } else {
            this.compData.resetComponents(this.ATotalCount + this.FfieldCount, this.pageCount, true);
            this.proxyObjects.clear();
        }
        if (this.formFactory == null) {
            this.formFactory = new SwingFormFactory(this, this.formsActionHandler);
        } else {
            this.formFactory.reset(this, this.formsActionHandler);
            this.compData.resetDuplicates();
        }
        this.formsActionHandler.setActionFactory(this.formFactory.getActionFactory());
    }

    @Override
    public void createDisplayComponentsForPage(int page, PdfStreamDecoder current) {
        int id;
        boolean debugNew = false;
        HashMap<String, String> formsCreated = new HashMap<String, String>();
        String s = System.getProperty("org.jpedal.flattenForm");
        if (s != null && s.toLowerCase().equals("true")) {
            this.compData.setRasterizeForms(true);
        }
        if ((id = this.compData.getStartComponentCountForPage(page)) == -1 || id == -999) {
            FormObject formObject;
            int count;
            this.compData.initParametersForPage(this.pageData, page, this.decode_pdf);
            if (this.formsActionHandler != null) {
                this.formsActionHandler.init(this.decode_pdf, this.javascript, this);
                this.formsActionHandler.setPageAccess(this.pageData.getMediaBoxHeight(page), this.insetH);
            }
            if (this.fDecoder != null) {
                this.currentItems.clear();
            }
            HashMap<Object, String> formsProcessed = new HashMap<Object, String>();
            int Acount = 0;
            if (this.AfieldCount != null && this.AfieldCount.length > page) {
                Acount = this.AfieldCount[page];
            }
            this.Fforms = new FormObject[this.FfieldCount];
            FormObject[] xfaFormList = null;
            this.Aforms = new FormObject[Acount];
            int decodeToForm = 2;
            for (int forms = 0; forms < decodeToForm; ++forms) {
                int i = 0;
                if (forms == 0) {
                    count = 0;
                    if (this.fieldList != null) {
                        this.fieldList.resetToStart();
                        count = this.fieldList.getTokenCount() - 1;
                    }
                } else {
                    if (this.annotList != null && this.annotList.length > page && this.annotList[page] != null) {
                        this.annotList[page].resetToStart();
                        if (this.formFactory.getType() == 3) {
                            HashMap<String, String> annotOrder = new HashMap<String, String>();
                            int count2 = this.annotList[page].getTokenCount();
                            for (int ii = 0; ii < count2; ++ii) {
                                String val = this.annotList[page].getNextValueAsString(true);
                                annotOrder.put(val, String.valueOf(ii + 1));
                            }
                            this.formFactory.setAnnotOrder(annotOrder);
                        }
                        this.annotList[page].resetToStart();
                    }
                    count = Acount - 1;
                }
                for (int fieldNum = count; fieldNum > -1; --fieldNum) {
                    byte[][] kids;
                    String objRef = null;
                    if (forms == 0) {
                        if (this.fieldList != null) {
                            objRef = this.fieldList.getNextValueAsString(true);
                        }
                    } else if (this.annotList.length > page && this.annotList[page] != null) {
                        objRef = this.annotList[page].getNextValueAsString(true);
                    }
                    if (objRef == null || objRef != null && (formsProcessed.get(objRef) != null || objRef.length() == 0)) continue;
                    formObject = this.cachedObjs.get(objRef);
                    if (formObject == null) {
                        formObject = new FormObject(objRef, this.formsActionHandler, this.pageData.getRotation(page - 1));
                        if (objRef.charAt(objRef.length() - 1) == 'R') {
                            this.currentPdfFile.readObject(formObject);
                        } else {
                            formObject.setStatus(1);
                            formObject.setUnresolvedData(StringUtils.toBytes(objRef), id);
                            this.currentPdfFile.checkResolved(formObject);
                        }
                        this.cachedObjs.put(objRef, formObject);
                    }
                    i = (kids = formObject.getKeyArray(456733763)) != null ? this.flattenKids(page, debugNew, formsProcessed, formObject, i, forms) : this.processFormObject(page, debugNew, formsProcessed, formObject, objRef, i, forms);
                }
            }
            if (this.hasXFA && this.fDecoder.hasXFADataSet()) {
                this.currentItems.clear();
                int size = this.Fforms.length;
                FormObject[] tmp = new FormObject[size];
                for (int ii = 0; ii < size; ++ii) {
                    tmp[ii] = this.Fforms[size - ii - 1];
                }
                xfaFormList = ((XFAFormStream)this.fDecoder).createAppearanceString(tmp);
                this.compData.storeXFARefToForm(((XFAFormStream)this.fDecoder).getRefToFormArray());
            }
            ArrayList<String> unsortedForms = new ArrayList<String>();
            this.compData.setUnsortedListForPage(page, unsortedForms);
            int readToForm = 3;
            for (int forms = 0; forms < readToForm; ++forms) {
                count = 0;
                if (forms == 0) {
                    if (xfaFormList != null) {
                        count = xfaFormList.length;
                    }
                } else if (forms == 1) {
                    for (FormObject Fform : this.Fforms) {
                        if (Fform == null) continue;
                        unsortedForms.add(Fform.getObjectRefAsString());
                    }
                    this.Fforms = FormUtils.sortGroupLargestFirst(this.Fforms);
                    count = this.Fforms.length;
                } else {
                    for (FormObject Aform : this.Aforms) {
                        if (Aform == null) continue;
                        unsortedForms.add(Aform.getObjectRefAsString());
                    }
                    this.Aforms = FormUtils.sortGroupLargestFirst(this.Aforms);
                    count = this.Aforms.length;
                }
                for (int k = 0; k < count; ++k) {
                    formObject = forms == 0 ? xfaFormList[k] : (forms == 1 ? this.Fforms[k] : this.Aforms[k]);
                    if (formObject == null || formsCreated.get(formObject.getObjectRefAsString()) != null || page != formObject.getPageNumber()) continue;
                    if (this.formsRasterizedForDisplay() && current != null) {
                        try {
                            current.drawFlattenedForm(formObject);
                        }
                        catch (PdfException e) {
                            if (!LogWriter.isOutput()) continue;
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                        continue;
                    }
                    this.createField(formObject, this.compData.getNextFreeField());
                    this.compData.storeRawData(formObject);
                    formsCreated.put(formObject.getObjectRefAsString(), "x");
                }
            }
            if (!this.formsRasterizedForDisplay() && this.formFactory.getType() == 3) {
                this.formFactory.indexAllKids();
            }
        }
    }

    private int flattenKids(int page, boolean debugNew, Map<Object, String> formsProcessed, FormObject formObject, int i, int forms) {
        FormObject[] temp;
        int oldCount;
        byte[][] kidList = formObject.getKeyArray(456733763);
        int kidCount = kidList.length;
        if (forms == 0) {
            oldCount = this.Fforms.length;
            temp = this.Fforms;
            this.Fforms = new FormObject[oldCount + kidCount - 1];
            System.arraycopy(temp, 0, this.Fforms, 0, oldCount);
        } else {
            oldCount = this.Aforms.length;
            temp = this.Aforms;
            this.Aforms = new FormObject[oldCount + kidCount - 1];
            System.arraycopy(temp, 0, this.Aforms, 0, oldCount);
        }
        for (byte[] aKidList : kidList) {
            String key = new String(aKidList);
            FormObject childObj = new FormObject(key, null);
            if (formObject != null) {
                childObj.copyInheritedValuesFromParent(formObject);
            }
            this.currentPdfFile.readObject(childObj);
            childObj.setHandler(this.formsActionHandler);
            childObj.setRef(key);
            childObj.setKid(true);
            if (childObj.getKeyArray(456733763) == null) {
                String rectTocheck = childObj.toString(childObj.getFloatArray(573911876), true);
                if (rectTocheck == null || this.addItem(rectTocheck)) {
                    new FormStream().createAppearanceString(childObj, this.currentPdfFile);
                }
                i = this.processFormObject(page, debugNew, formsProcessed, childObj, key, i, forms);
                continue;
            }
            i = this.flattenKids(page, debugNew, formsProcessed, childObj, i, forms);
        }
        return i;
    }

    private int processFormObject(int page, boolean debugNew, Map<Object, String> formsProcessed, FormObject formObject, Object objRef, int i, int forms) {
        boolean isOnPage = false;
        if (forms == 0) {
            FormObject parentObj;
            String parent;
            PdfObject pageObj = formObject.getDictionary(32);
            byte[] pageRef = null;
            if (pageObj != null) {
                pageRef = pageObj.getUnresolvedData();
            }
            if ((pageRef == null || pageObj == null) && (parent = formObject.getStringKey(1110793845)) != null && (pageObj = ((PdfObject)(parentObj = this.getParent(parent))).getDictionary(32)) != null) {
                pageRef = pageObj.getUnresolvedData();
            }
            if (pageRef == null) {
                boolean hasKids;
                byte[][] kidList = this.getKid(formObject);
                boolean bl = hasKids = kidList != null && kidList.length > 0;
                if (hasKids) {
                    int kidCount = kidList.length;
                    for (int jj = 0; jj < kidCount; ++jj) {
                        String key = new String(kidList[jj]);
                        FormObject kidObject = this.cachedObjs.get(key);
                        if (kidObject == null) {
                            kidObject = new FormObject(key, this.formsActionHandler);
                            this.currentPdfFile.readObject(kidObject);
                            this.cachedObjs.put(key, kidObject);
                        }
                        if ((pageObj = kidObject.getDictionary(32)) != null) {
                            pageRef = pageObj.getUnresolvedData();
                        }
                        if (pageRef == null) continue;
                        jj = kidCount;
                    }
                }
            }
            int objPage = -1;
            if (pageRef != null) {
                objPage = this.currentPdfFile.convertObjectToPageNumber(new String(pageRef));
            }
            boolean bl = isOnPage = objPage == page;
        }
        if (forms == 1 || isOnPage) {
            FormObject parentObj;
            formObject.setPageNumber(page);
            this.cachedObjs.remove(objRef);
            String parent = formObject.getStringKey(1110793845);
            if (parent != null && (parentObj = this.getParent(parent)) != null) {
                formObject.setParent(parent, parentObj, true);
            }
            this.fDecoder.createAppearanceString(formObject, this.currentPdfFile);
            if (formObject != null) {
                if (parent != null) {
                    formObject.setParent(parent);
                }
                if (forms == 0) {
                    this.Fforms[i++] = formObject;
                } else {
                    this.Aforms[i++] = formObject;
                }
                if (objRef != null) {
                    formsProcessed.put(objRef, "x");
                }
            }
        }
        return i;
    }

    private FormObject getParent(String parent) {
        Map objects = this.compData.getRawFormData();
        FormObject parentObj = (FormObject)objects.get(parent);
        if (parentObj == null && parent != null) {
            parentObj = new FormObject(parent, this.formsActionHandler);
            this.currentPdfFile.readObject(parentObj);
            parentObj.setKeyArray(456733763, new byte[][]{{0}});
            objects.put(parent, parentObj);
        }
        return parentObj;
    }

    private byte[][] getKid(FormObject formObject) {
        String parentRef;
        PdfObject parentObj;
        int subtype = formObject.getParameterConstant(1147962727);
        if (subtype == 9288 || subtype == 1197118) {
            return null;
        }
        byte[][] kidList = formObject.getKeyArray(456733763);
        if (kidList != null && (parentObj = (PdfObject)this.compData.getRawForm(parentRef = formObject.getStringKey(1110793845))[0]) != null && parentObj.getKeyArray(456733763) != null) {
            kidList = null;
        }
        return kidList;
    }

    @Override
    public Object[] getFormDataAsObject(String objectName) {
        return this.compData.getRawForm(objectName);
    }

    @Override
    public void displayComponentsOnscreen(int startPage, int endPage) {
        this.compData.displayComponents(startPage, ++endPage);
    }

    private void createField(FormObject formObject, int formNum) {
        Integer widgetType;
        boolean[] flags;
        boolean processFormsNow = false;
        if (this.formFactory.getType() != 1) {
            processFormsNow = true;
        }
        Object retComponent = null;
        int subtype = formObject.getParameterConstant(1147962727);
        if (subtype == 2308407) {
            if (this.sigObject == null) {
                this.sigObject = new HashSet<FormObject>();
            }
            this.sigObject.add(formObject);
        }
        if (formObject.getDictionary(1061176672) != null) {
            formObject.setActionFlag(1);
        }
        if ((flags = formObject.getFieldFlags()) != null) {
            boolean readOnly = flags[1];
            boolean required = flags[2];
            boolean bl = flags[3];
        }
        if (subtype == 1197118) {
            boolean isPushButton = false;
            boolean isRadio = false;
            if (flags != null) {
                isPushButton = flags[17];
                isRadio = flags[16];
            }
            if (isPushButton) {
                widgetType = FormFactory.PUSHBUTTON;
                if (processFormsNow) {
                    retComponent = this.formFactory.pushBut(formObject);
                }
            } else if (isRadio) {
                widgetType = FormFactory.RADIOBUTTON;
                if (processFormsNow) {
                    retComponent = this.formFactory.radioBut(formObject);
                }
            } else {
                widgetType = FormFactory.CHECKBOXBUTTON;
                if (processFormsNow) {
                    retComponent = this.formFactory.checkBoxBut(formObject);
                }
            }
        } else if (subtype == 9288) {
            boolean isMultiline = false;
            boolean hasPassword = false;
            if (flags != null) {
                isMultiline = flags[13];
                hasPassword = flags[14];
            }
            if (isMultiline) {
                if (hasPassword) {
                    widgetType = FormFactory.MULTILINEPASSWORD;
                    if (processFormsNow) {
                        retComponent = this.formFactory.multiLinePassword(formObject);
                    }
                } else {
                    widgetType = FormFactory.MULTILINETEXT;
                    if (processFormsNow) {
                        retComponent = this.formFactory.multiLineText(formObject);
                    }
                }
            } else if (hasPassword) {
                widgetType = FormFactory.SINGLELINEPASSWORD;
                if (processFormsNow) {
                    retComponent = this.formFactory.singleLinePassword(formObject);
                }
            } else {
                widgetType = FormFactory.SINGLELINETEXT;
                if (processFormsNow) {
                    retComponent = this.formFactory.singleLineText(formObject);
                }
            }
        } else if (subtype == 4920) {
            boolean isCombo = false;
            if (flags != null) {
                isCombo = flags[18];
            }
            if (isCombo) {
                widgetType = FormFactory.COMBOBOX;
                if (processFormsNow) {
                    retComponent = this.formFactory.comboBox(formObject);
                }
            } else {
                widgetType = FormFactory.LIST;
                if (processFormsNow) {
                    retComponent = this.formFactory.listField(formObject);
                }
            }
        } else if (subtype == 2308407) {
            widgetType = FormFactory.SIGNATURE;
            if (processFormsNow) {
                retComponent = this.formFactory.signature(formObject);
            }
        } else {
            widgetType = FormFactory.ANNOTATION;
            if (processFormsNow) {
                retComponent = this.formFactory.annotationButton(formObject);
            }
        }
        formObject.setFormType(widgetType);
        this.compData.completeField(formObject, formNum, widgetType, retComponent, this.currentPdfFile);
    }

    @Override
    public Object[] getComponentsByName(String objectName) {
        for (int p = 1; p < this.pageCount + 1; ++p) {
            this.createDisplayComponentsForPage(p, null);
        }
        return this.compData.getComponentsByName(objectName);
    }

    @Override
    public List getComponentNameList() throws PdfException {
        if (this.ATotalCount == 0 && this.FfieldCount == 0) {
            return null;
        }
        boolean rasterizeForms = this.compData.formsRasterizedForDisplay();
        this.compData.setRasterizeForms(false);
        for (int p = 1; p < this.pageCount + 1; ++p) {
            this.createDisplayComponentsForPage(p, null);
        }
        this.compData.setRasterizeForms(rasterizeForms);
        return this.getComponentNameList(-1);
    }

    @Override
    public List getComponentNameList(int pageNumber) throws PdfException {
        int id;
        if (pageNumber != -1 && (id = this.compData.getStartComponentCountForPage(pageNumber)) == -1) {
            this.createDisplayComponentsForPage(pageNumber, null);
        }
        if (this.FfieldCount == 0 && this.ATotalCount == 0) {
            return null;
        }
        return this.compData.getComponentNameList(pageNumber);
    }

    @Override
    public void setFormFactory(FormFactory newFormFactory) {
        this.formFactory = newFormFactory;
        this.formsActionHandler.setActionFactory(this.formFactory.getActionFactory());
        this.compData = this.formFactory.getCustomCompData();
        this.compData.setJavascript(this.javascript);
    }

    @Override
    public void openFile(int pageCount) {
        this.pageCount = pageCount;
        this.compData.reset(null);
        this.proxyObjects.clear();
        this.compData.flushFormData();
        this.cachedObjs.clear();
    }

    @Override
    public GUIData getCompData() {
        return this.compData;
    }

    @Override
    public Iterator<FormObject> getSignatureObjects() {
        if (this.sigObject == null) {
            return null;
        }
        return this.sigObject.iterator();
    }

    @Override
    public ActionHandler getActionHandler() {
        return this.formsActionHandler;
    }

    @Override
    public FormFactory getFormFactory() {
        return this.formFactory;
    }

    @Override
    public Map<String, FormObject> getRawFormData() {
        return this.compData.getRawFormData();
    }

    @Override
    public void setIgnoreForms(boolean ignoreForms) {
        this.ignoreForms = ignoreForms;
    }

    @Override
    public boolean ignoreForms() {
        return this.ignoreForms;
    }

    @Override
    public void dispose() {
        this.pageData = null;
        this.AfieldCount = null;
        this.fDecoder = null;
        this.formsActionHandler = null;
        this.javascript = null;
        this.Fforms = null;
        this.Aforms = null;
        this.fieldList = null;
        this.annotList = null;
        this.formFactory = null;
        this.compData = null;
        this.proxyObjects.clear();
        this.sigObject = null;
        this.cachedObjs = null;
        this.pageData = null;
        this.currentPdfFile = null;
        this.fDecoder = null;
        this.acroObj = null;
    }

    @Override
    public Javascript getJavaScriptObject() {
        return this.javascript;
    }

    @Override
    public PdfArrayIterator getAnnotsOnPage(int page) {
        if (page < 1 || page > this.decode_pdf.getPageCount()) {
            throw new RuntimeException("Page " + page + " out of range (1 - " + this.decode_pdf.getPageCount() + ')');
        }
        this.createDisplayComponentsForPage(page, null);
        if (this.annotList != null && this.annotList.length > page && this.annotList[page] != null) {
            this.annotList[page].resetToStart();
            return this.annotList[page];
        }
        return null;
    }

    private boolean addItem(Object toAdd) {
        if (toAdd == null) {
            return false;
        }
        if (!this.currentItems.containsKey(toAdd)) {
            this.currentItems.put(toAdd, "x");
            return true;
        }
        return false;
    }

    @Override
    public void updateChangedForms() {
        Map forms = this.compData.getRawFormData();
        if (forms.size() > 1) {
            Iterator formsIter = forms.keySet().iterator();
            while (formsIter.hasNext()) {
                FormObject form = (FormObject)forms.get(formsIter.next());
                if (form == null) continue;
                if (form.hasColorChanged()) {
                    this.compData.setTextColor(form.getObjectRefAsString(), form.getTextColor());
                    this.compData.invalidate(form.getTextStreamValue(36));
                    form.resetColorChanged();
                }
                if (form.hasValueChanged()) {
                    String objRef = form.getObjectRefAsString();
                    this.compData.setUnformattedValue(objRef, this.compData.getValue(objRef));
                    this.compData.setValue(form.getObjectRefAsString(), form.getValue(), false, false);
                    this.compData.invalidate(form.getTextStreamValue(36));
                    form.resetFormChanged();
                }
                if (!form.hasDisplayChanged()) continue;
                boolean[] characteristic = form.getCharacteristics();
                if (characteristic[0] || characteristic[1] || characteristic[5]) {
                    this.compData.setCompVisible(form.getObjectRefAsString(), false);
                    continue;
                }
                this.compData.setCompVisible(form.getObjectRefAsString(), true);
            }
        }
    }

    @Override
    public String[] getChildNames(String name) {
        return this.compData.getChildNames(name);
    }

    @Override
    public Object[] getCalculationOrder() {
        return this.CO;
    }

    @Override
    public boolean isXFA() {
        return this.hasXFA;
    }

    @Override
    public Node getXFA(int xfaTemplate) {
        return ((XFAFormStream)this.fDecoder).getXFA(xfaTemplate);
    }

    @Override
    public Object getField(String name) {
        if (name == null) {
            return null;
        }
        return this.compData.getRawForm(name);
    }

    @Override
    public void resetForm() {
        this.resetForm(null);
    }

    @Override
    public void resetForm(String[] aFields) {
        this.formsActionHandler.getActionFactory().reset(aFields);
    }

    public int getPageNum() {
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        if (swingGUI != null) {
            return swingGUI.getCurrentPage();
        }
        return 1;
    }

    public void setPageNum(int page) {
        this.formsActionHandler.changeTo(null, ++page, null, null, true);
    }

    public void setZoomType(String newType) {
        if (newType.equals("FitPage")) {
            this.formsActionHandler.changeTo(null, -1, null, -3, true);
        } else if (newType.equals("FitWidth")) {
            this.formsActionHandler.changeTo(null, -1, null, -1, true);
        } else if (newType.equals("FitHeight")) {
            this.formsActionHandler.changeTo(null, -1, null, -2, true);
        }
    }

    @Override
    public boolean getDirty() {
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        if (swingGUI != null) {
            return swingGUI.getFormsDirtyFlag();
        }
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
        SwingGUI swingGUI = (SwingGUI)this.decode_pdf.getExternalHandler(11);
        if (swingGUI != null) {
            swingGUI.setFormsDirtyFlag(dirty);
        }
    }

    @Override
    public boolean hasFormsOnPage(int page) {
        boolean hasAnnots = this.annotList != null && this.annotList.length > page && this.annotList[page] != null;
        boolean hasForm = this.hasXFA && this.fDecoder.hasXFADataSet() || this.fieldList != null;
        return hasAnnots || hasForm;
    }

    @Override
    public PdfObject getFormResources() {
        return this.AcroRes;
    }

    @Override
    public boolean formsRasterizedForDisplay() {
        return this.compData.formsRasterizedForDisplay();
    }
}

