/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.jpedal.objects.raw.FormObject;

public class FormUtils {
    public static AbstractButton[] sortGroupSmallestFirst(ButtonGroup bg) {
        int items = bg.getButtonCount();
        Component[] buttons = new AbstractButton[items];
        Enumeration<AbstractButton> butGrp = bg.getElements();
        for (int i = 0; i < items; ++i) {
            if (!butGrp.hasMoreElements()) continue;
            buttons[i] = butGrp.nextElement();
        }
        return (AbstractButton[])FormUtils.sortCompsAscending(buttons);
    }

    private static Component[] sortCompsAscending(Component[] primary) {
        int items = primary.length;
        int left = items / 2;
        int right = items - 1;
        while (left > 0) {
            FormUtils.siftCompsAscending(primary, --left, right);
        }
        while (right > 0) {
            Component tempA = primary[0];
            primary[0] = primary[right];
            primary[right] = tempA;
            FormUtils.siftCompsAscending(primary, left, --right);
        }
        return primary;
    }

    private static void siftCompsAscending(Component[] primary, int left, int right) {
        int currentLeft = left;
        Component primaryTMP = primary[currentLeft];
        int childL = 2 * left + 1;
        if (childL < right && FormUtils.shouldSwapControlAscending(primary[childL], primary[childL + 1])) {
            ++childL;
        }
        while (childL <= right && FormUtils.shouldSwapControlAscending(primaryTMP, primary[childL])) {
            primary[currentLeft] = primary[childL];
            currentLeft = childL;
            if ((childL = 2 * childL + 1) >= right || !FormUtils.shouldSwapControlAscending(primary[childL], primary[childL + 1])) continue;
            ++childL;
        }
        primary[currentLeft] = primaryTMP;
    }

    private static boolean shouldSwapControlAscending(Component arg1, Component arg2) {
        Rectangle first = arg1.getBounds();
        Rectangle second = arg2.getBounds();
        return first.width * first.height < second.width * second.height;
    }

    public static String removeStateToCheck(String curCompName, boolean returnState) {
        int ptr;
        if (curCompName != null && (ptr = curCompName.indexOf("-(")) != -1) {
            curCompName = returnState ? curCompName.substring(ptr + 2, curCompName.length() - 1) : curCompName.substring(0, ptr);
        }
        return curCompName;
    }

    public static FormObject[] sortGroupLargestFirst(FormObject[] comps) {
        return FormUtils.sortCompsDesending(comps);
    }

    private static FormObject[] sortCompsDesending(FormObject[] array) {
        int items = array.length;
        int left = items / 2;
        int right = items - 1;
        while (left > 0) {
            FormUtils.siftCompsDesending(array, --left, right);
        }
        while (right > 0) {
            FormObject tempA = array[0];
            array[0] = array[right];
            array[right] = tempA;
            FormUtils.siftCompsDesending(array, left, --right);
        }
        return array;
    }

    private static void siftCompsDesending(FormObject[] array, int left, int right) {
        int currentLeft = left;
        FormObject primaryTMP = array[currentLeft];
        int childL = 2 * left + 1;
        if (childL < right && FormUtils.shouldSwapControlDesending(array[childL], array[childL + 1])) {
            ++childL;
        }
        while (childL <= right && FormUtils.shouldSwapControlDesending(primaryTMP, array[childL])) {
            array[currentLeft] = array[childL];
            currentLeft = childL;
            if ((childL = 2 * childL + 1) >= right || !FormUtils.shouldSwapControlDesending(array[childL], array[childL + 1])) continue;
            ++childL;
        }
        array[currentLeft] = primaryTMP;
    }

    private static boolean shouldSwapControlDesending(FormObject arg1, FormObject arg2) {
        if (arg1 == null) {
            return arg2 != null;
        }
        if (arg2 == null) {
            return false;
        }
        Rectangle first = arg1.getBoundingRectangle();
        Rectangle second = arg2.getBoundingRectangle();
        return first.width * first.height < second.width * second.height;
    }
}

