/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import org.jpedal.DisplayOffsets;
import org.jpedal.PDFtoImageConvertor;
import org.jpedal.constants.JPedalSettings;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.parser.TextDecoder;
import org.jpedal.render.BaseDisplay;
import org.jpedal.utils.LogWriter;

public class DecoderOptions {
    private int pageMode = 1;
    private DisplayOffsets displayOffsets = new DisplayOffsets();
    Javascript javascript = null;
    public static Color highlightColor;
    public static Color backgroundColor;
    Color nonDrawnPageColor = Color.WHITE;
    public Color altPageColor = Color.WHITE;
    public Color altTextColor = null;
    public Color altDisplayBackground = null;
    public int altColorThreshold = 255;
    boolean changeTextAndLine = false;
    private Integer instance_bestQualityMaxScaling = null;
    private int[] instance_formsNoPrint = null;
    private static int[] formsNoPrint;
    private static String[] extactionPageSize;
    private String[] instance_extactionPageSize = null;
    private static Boolean overridePageSize;
    private Boolean instance_overridePageSize = null;
    private Boolean instance_allowPagesSmallerThanPageSize = Boolean.FALSE;
    public static boolean isRunningOnMac;
    public static boolean isRunningOnWindows;
    public static boolean isRunningOnAIX;
    public static boolean isRunningOnLinux;
    private boolean isXMLExtraction = true;
    private boolean useJavascript = true;

    public boolean isXMLExtraction() {
        return this.isXMLExtraction;
    }

    public void setXMLExtraction(boolean XMLExtraction) {
        this.isXMLExtraction = XMLExtraction;
    }

    public DisplayOffsets getDisplayOffsets() {
        return this.displayOffsets;
    }

    public void setDisplayOffsets(DisplayOffsets displayOffsets) {
        this.displayOffsets = displayOffsets;
    }

    public void setPageMode(int mode) {
        this.pageMode = mode;
    }

    public int getPageMode() {
        return this.pageMode;
    }

    public boolean hasJavascript() {
        return false;
    }

    public void setJavaScriptUsed(boolean jsEnabled) {
        this.useJavascript = jsEnabled;
    }

    public void disposeObjects() {
        if (this.javascript != null) {
            this.javascript.dispose();
        }
        this.javascript = null;
    }

    public void useXMLExtraction() {
        this.isXMLExtraction = true;
    }

    public PdfGroupingAlgorithms getGroupingObject(int lastPageDecoded, PdfData textData, PdfPageData pageData) throws PdfException {
        if (lastPageDecoded == -1) {
            throw new RuntimeException("No pages decoded - call decodePage(pageNumber) first");
        }
        if (textData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(textData, pageData, this.isXMLExtraction);
    }

    public PdfGroupingAlgorithms getBackgroundGroupingObject(PdfData pdfBackgroundData, PdfPageData pageData) {
        PdfData textData = pdfBackgroundData;
        if (textData == null) {
            return null;
        }
        return new PdfGroupingAlgorithms(textData, pageData, this.isXMLExtraction);
    }

    public Javascript getJS() {
        return this.javascript;
    }

    public void set(Map values) throws PdfException {
        for (Object nextKey : values.keySet()) {
            if (nextKey instanceof Integer) {
                Integer key = (Integer)nextKey;
                Object rawValue = values.get(key);
                if (key.equals(JPedalSettings.UNDRAWN_PAGE_COLOR)) {
                    if (rawValue instanceof Integer) {
                        this.nonDrawnPageColor = new Color((Integer)rawValue);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.UNDRAWN_PAGE_COLOR expects a Integer value");
                }
                if (key.equals(JPedalSettings.PAGE_COLOR)) {
                    if (rawValue instanceof Integer) {
                        this.altPageColor = new Color((Integer)rawValue);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.PAGE_COLOR expects a Integer value");
                }
                if (key.equals(JPedalSettings.TEXT_COLOR)) {
                    if (rawValue instanceof Integer) {
                        this.altTextColor = new Color((Integer)rawValue);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
                }
                if (key.equals(JPedalSettings.REPLACEMENT_COLOR_THRESHOLD)) {
                    if (rawValue instanceof Integer) {
                        this.altColorThreshold = (Integer)rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
                }
                if (key.equals(JPedalSettings.DISPLAY_BACKGROUND)) {
                    if (rawValue instanceof Integer) {
                        this.altDisplayBackground = new Color((Integer)rawValue);
                        continue;
                    }
                    throw new PdfException("JPedalSettings.TEXT_COLOR expects a Integer value");
                }
                if (key.equals(JPedalSettings.CHANGE_LINEART)) {
                    if (rawValue instanceof Boolean) {
                        this.changeTextAndLine = (Boolean)rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.CHANGE_LINEART expects a Boolean value");
                }
                if (key.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING)) {
                    if (rawValue instanceof Integer) {
                        this.instance_bestQualityMaxScaling = (Integer)rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING expects a Integer value");
                }
                if (key.equals(JPedalSettings.EXTRACT_AT_PAGE_SIZE)) {
                    if (rawValue instanceof String[]) {
                        this.instance_extactionPageSize = (String[])rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a String[] value");
                }
                if (key.equals(JPedalSettings.IGNORE_FORMS_ON_PRINT)) {
                    if (rawValue instanceof int[]) {
                        this.instance_formsNoPrint = (int[])rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.IGNORE_FORMS_ON_PRINT expects a int[] value");
                }
                if (key.equals(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE)) {
                    if (rawValue instanceof Boolean) {
                        this.instance_overridePageSize = (Boolean)rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a Boolean value");
                }
                if (key.equals(JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE)) {
                    if (rawValue instanceof Boolean) {
                        this.instance_allowPagesSmallerThanPageSize = (Boolean)rawValue;
                        continue;
                    }
                    throw new PdfException("JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE expects a Boolean value");
                }
                DecoderOptions.setParameter(values, nextKey);
                continue;
            }
            throw new PdfException("Unknown or unsupported key (not Integer) " + nextKey);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setParameter(Map values, Object nextKey) throws PdfException {
        if (!(nextKey instanceof Integer)) throw new PdfException("Unknown or unsupported key (not Integer) " + nextKey);
        Integer key = (Integer)nextKey;
        Object rawValue = values.get(key);
        if (key.equals(JPedalSettings.INVERT_HIGHLIGHT)) {
            if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.INVERT_HIGHLIGHT expects an Boolean value");
            BaseDisplay.invertHighlight = (Boolean)rawValue;
            return;
        } else if (key.equals(JPedalSettings.TEXT_INVERTED_COLOUR)) {
            if (!(rawValue instanceof Color)) throw new PdfException("JPedalSettings.TEXT_INVERTED_COLOUR expects a Color value");
            backgroundColor = (Color)rawValue;
            return;
        } else if (key.equals(JPedalSettings.TEXT_HIGHLIGHT_COLOUR)) {
            if (!(rawValue instanceof Color)) throw new PdfException("JPedalSettings.TEXT_HIGHLIGHT_COLOUR expects a Color value");
            highlightColor = (Color)rawValue;
            return;
        } else if (key.equals(JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS)) {
            if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.TEXT_PRINT_NON_EMBEDDED_FONTS expects a Boolean value");
            Boolean value = (Boolean)rawValue;
            PdfStreamDecoder.useTextPrintingForNonEmbeddedFonts = value;
            return;
        } else if (key.equals(JPedalSettings.DISPLAY_INVISIBLE_TEXT)) {
            if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.DISPLAY_INVISIBLE_TEXT expects a Boolean value");
            Boolean value = (Boolean)rawValue;
            TextDecoder.showInvisibleText = value;
            return;
        } else if (key.equals(JPedalSettings.CACHE_LARGE_FONTS)) {
            if (!(rawValue instanceof Integer)) throw new PdfException("JPedalSettings.CACHE_LARGE_FONTS expects an Integer value");
            Integer value = (Integer)rawValue;
            FontData.maxSizeAllowedInMemory = value;
            return;
        } else {
            if (key.equals(JPedalSettings.IMAGE_HIRES)) return;
            if (key.equals(JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING)) {
                if (!(rawValue instanceof Integer)) throw new PdfException("JPedalSettings.EXTRACT_AT_BEST_QUALITY_MAXSCALING expects a Integer value");
                PDFtoImageConvertor.bestQualityMaxScaling = (Integer)rawValue;
                return;
            } else if (key.equals(JPedalSettings.EXTRACT_AT_PAGE_SIZE)) {
                if (!(rawValue instanceof String[])) throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a String[] value");
                extactionPageSize = (String[])rawValue;
                return;
            } else if (key.equals(JPedalSettings.PAGE_SIZE_OVERRIDES_IMAGE)) {
                if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.EXTRACT_AT_PAGE_SIZE expects a Boolean value");
                overridePageSize = (Boolean)rawValue;
                return;
            } else if (key.equals(JPedalSettings.IGNORE_FORMS_ON_PRINT)) {
                if (!(rawValue instanceof int[])) throw new PdfException("JPedalSettings.IGNORE_FORMS_ON_PRINT expects a int[] value");
                formsNoPrint = (int[])rawValue;
                return;
            } else {
                if (!key.equals(JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE)) throw new PdfException("Unknown or unsupported key " + key);
                if (!(rawValue instanceof Boolean)) throw new PdfException("JPedalSettings.ALLOW_PAGES_SMALLER_THAN_PAGE_SIZE expects a Boolean value");
                PDFtoImageConvertor.allowPagesSmallerThanPageSize = (Boolean)rawValue;
            }
        }
    }

    public static void modifyJPedalParameters(Map values) throws PdfException {
        for (Object nextKey : values.keySet()) {
            DecoderOptions.setParameter(values, nextKey);
        }
    }

    public Color getPageColor() {
        return this.altPageColor;
    }

    public Color getTextColor() {
        return this.altTextColor;
    }

    public int getReplacementColorThreshold() {
        return this.altColorThreshold;
    }

    public Color getDisplayBackgroundColor() {
        return this.altDisplayBackground;
    }

    public boolean getChangeTextAndLine() {
        return this.changeTextAndLine;
    }

    public Paint getNonDrawnPageColor() {
        return this.nonDrawnPageColor;
    }

    public Boolean getInstance_allowPagesSmallerThanPageSize() {
        return this.instance_allowPagesSmallerThanPageSize;
    }

    public Integer getInstance_bestQualityMaxScaling() {
        return this.instance_bestQualityMaxScaling;
    }

    public static int[] getFormsNoPrint() {
        return formsNoPrint;
    }

    public int[] getInstance_FormsNoPrint() {
        return this.instance_formsNoPrint;
    }

    public Boolean getPageSizeToUse() {
        Boolean overridePageSizeToUse = Boolean.FALSE;
        if (this.instance_overridePageSize != null) {
            overridePageSizeToUse = this.instance_overridePageSize;
        } else if (overridePageSize != null) {
            overridePageSizeToUse = overridePageSize;
        }
        return overridePageSizeToUse;
    }

    public float getImageDimensions(int pageIndex, PdfPageData pageData) {
        float multiplyer;
        block18: {
            String maxScalingJVM;
            multiplyer = -2.0f;
            String overridePageSizeJVM = System.getProperty("org.jpedal.pageSizeOverridesImage");
            if (overridePageSizeJVM != null) {
                if (this.instance_overridePageSize != null) {
                    this.instance_overridePageSize = Boolean.parseBoolean(overridePageSizeJVM);
                } else {
                    overridePageSize = Boolean.parseBoolean(overridePageSizeJVM);
                }
            }
            if ((maxScalingJVM = System.getProperty("org.jpedal.pageMaxScaling")) != null) {
                try {
                    if (this.instance_bestQualityMaxScaling != null) {
                        this.instance_bestQualityMaxScaling = Integer.parseInt(maxScalingJVM);
                    } else {
                        PDFtoImageConvertor.bestQualityMaxScaling = Integer.parseInt(maxScalingJVM);
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block18;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        String[] dims = null;
        String dimsJVM = System.getProperty("org.jpedal.pageSize");
        if (dimsJVM != null) {
            dims = dimsJVM.split("x");
        }
        if (dims == null) {
            dims = this.instance_extactionPageSize != null ? this.instance_extactionPageSize : extactionPageSize;
        }
        float prefWidth = 0.0f;
        float prefHeight = 0.0f;
        if (dims != null) {
            if (dims.length == 2) {
                if (pageData.getRotation(pageIndex) == 90 || pageData.getRotation(pageIndex) == 270) {
                    prefWidth = Float.parseFloat(dims[1]);
                    prefHeight = Float.parseFloat(dims[0]);
                } else {
                    prefWidth = Float.parseFloat(dims[0]);
                    prefHeight = Float.parseFloat(dims[1]);
                }
            } else {
                throw new RuntimeException("Invalid parameters in JVM option -DpageSize ");
            }
        }
        float dScaleW = 0.0f;
        if (dims != null) {
            float crw = pageData.getCropBoxWidth(pageIndex);
            float crh = pageData.getCropBoxHeight(pageIndex);
            float dScaleH = prefHeight / crh;
            if (dScaleH < (dScaleW = prefWidth / crw)) {
                dScaleW = dScaleH;
            }
        }
        Boolean overridePageSizeToUse = this.getPageSizeToUse();
        if (dims != null && overridePageSizeToUse.booleanValue()) {
            multiplyer = dScaleW;
        }
        return multiplyer;
    }

    static {
        block9: {
            highlightColor = new Color(10, 100, 170);
            backgroundColor = null;
            formsNoPrint = null;
            extactionPageSize = null;
            overridePageSize = null;
            try {
                String name = System.getProperty("os.name");
                if (name.equals("Mac OS X")) {
                    isRunningOnMac = true;
                } else if (name.startsWith("Windows")) {
                    isRunningOnWindows = true;
                } else if (name.startsWith("AIX")) {
                    isRunningOnAIX = true;
                } else if (name.equals("Linux")) {
                    isRunningOnLinux = true;
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block9;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }
}

