/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.jpedal.PdfDecoder;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.CustomPrintHintingHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.SwingDisplay;

public class PdfStreamDecoderForPrinting
extends PdfStreamDecoder {
    public PdfStreamDecoderForPrinting(PdfObjectReader currentPdfFile, boolean b, PdfLayerList layers) {
        super(currentPdfFile, b, layers);
        this.isPrinting = true;
    }

    public void print(Graphics2D g2, AffineTransform scaling, int currentPrintPage, Rectangle userAnnot, CustomPrintHintingHandler customPrintHintingHandler, PdfDecoder pdf) {
        if (customPrintHintingHandler != null) {
            this.current.stopG2HintSetting(true);
            customPrintHintingHandler.preprint(g2, pdf);
        }
        this.current.setPrintPage(currentPrintPage);
        this.current.setCustomColorHandler((ColorHandler)pdf.getExternalHandler(19));
        this.current.setG2(g2);
        this.current.paint(null, scaling, userAnnot);
    }

    @Override
    public void setObjectValue(int key, Object obj) {
        if (key == -8) {
            this.objectStoreStreamRef = (ObjectStore)obj;
            this.current = new SwingDisplay(this.pageNum, this.objectStoreStreamRef, true);
            this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
            if (this.customImageHandler != null && this.current != null) {
                this.current.setCustomImageHandler(this.customImageHandler);
            }
        } else {
            super.setObjectValue(key, obj);
        }
    }
}

