/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.exception.PdfException;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;

public class PdfStreamDecoderForSampling
extends PdfStreamDecoder {
    public PdfStreamDecoderForSampling(PdfObjectReader currentPdfFile) {
        super(currentPdfFile);
    }

    public final float decodePageContentForImageSampling(PdfObject pdfObject) throws PdfException {
        try {
            byte[] b_data;
            this.renderDirectly = true;
            this.imagesProcessedFully = true;
            this.imageCount = 0;
            this.gs = new GraphicsState(0, 0);
            byte[][] pageContents = null;
            if (pdfObject != null) {
                pageContents = pdfObject.getKeyArray(1216184967);
                this.isDataValid = pdfObject.streamMayBeCorrupt();
            }
            if ((b_data = pdfObject != null && pageContents == null ? this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader())) : (this.pageStream != null ? this.pageStream : this.currentPdfFile.getObjectReader().readPageIntoStream(pdfObject))) != null && b_data.length > 0) {
                this.getSamplingOnly = true;
                this.decodeStreamIntoObjects(b_data, false);
            }
            this.cache.resetFonts();
            return this.samplingUsed;
        }
        catch (Error err) {
            this.errorTracker.addPageFailureMessage("Problem decoding page " + err);
            if (ExternalHandlers.throwMissingCIDError && err.getMessage().contains("kochi")) {
                throw err;
            }
            return -1.0f;
        }
    }
}

