/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import org.jpedal.color.ColorSpaces;
import org.jpedal.io.JAIHelper;
import org.jpedal.utils.LogWriter;

public class RenderUtils {
    public static boolean isInverted(float[][] CTM) {
        return CTM[0][0] < 0.0f || CTM[1][1] < 0.0f;
    }

    public static boolean isRotated(float[][] CTM) {
        return CTM[0][0] == 0.0f && CTM[1][1] == 0.0f || CTM[0][1] > 0.0f && CTM[1][0] < 0.0f || CTM[0][1] < 0.0f && CTM[1][0] > 0.0f;
    }

    static BufferedImage invertImage(float[][] CTM, BufferedImage image) {
        AffineTransform image_at2 = new AffineTransform();
        image_at2.scale(1.0, -1.0);
        image_at2.translate(0.0, -image.getHeight());
        AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
        boolean imageProcessed = false;
        if (JAIHelper.isJAIused()) {
            block14: {
                imageProcessed = true;
                try {
                    image = JAI.create((String)"affine", (RenderedImage)image, (Object)image_at2, (Object)new InterpolationNearest()).getAsBufferedImage();
                }
                catch (Exception e) {
                    imageProcessed = false;
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                catch (Error err) {
                    imageProcessed = false;
                    if (!LogWriter.isOutput()) break block14;
                    LogWriter.writeLog("Error: " + err.getMessage());
                }
            }
            if (!imageProcessed && LogWriter.isOutput()) {
                LogWriter.writeLog("Unable to use JAI for image inversion");
            }
        }
        if (!imageProcessed) {
            if (image.getType() == 12) {
                BufferedImage source = image;
                image = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
                invert3.filter(source, image);
            } else {
                boolean failed = false;
                try {
                    image = invert3.filter(image, null);
                }
                catch (Exception e) {
                    failed = true;
                }
                if (failed) {
                    try {
                        invert3 = new AffineTransformOp(image_at2, null);
                        image = invert3.filter(image, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return image;
    }

    static BufferedImage invertImageBeforeSave(BufferedImage image, boolean horizontal) {
        AffineTransform image_at2 = new AffineTransform();
        if (horizontal) {
            image_at2.scale(-1.0, 1.0);
            image_at2.translate(-image.getWidth(), 0.0);
        } else {
            image_at2.scale(1.0, -1.0);
            image_at2.translate(0.0, -image.getHeight());
        }
        AffineTransformOp invert3 = new AffineTransformOp(image_at2, ColorSpaces.hints);
        boolean imageProcessed = false;
        if (JAIHelper.isJAIused()) {
            block11: {
                imageProcessed = true;
                try {
                    image = JAI.create((String)"affine", (RenderedImage)image, (Object)image_at2, (Object)new InterpolationNearest()).getAsBufferedImage();
                }
                catch (Exception e) {
                    imageProcessed = false;
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                catch (Error err) {
                    imageProcessed = false;
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Error: " + err.getMessage());
                }
            }
            if (!imageProcessed && LogWriter.isOutput()) {
                LogWriter.writeLog("Unable to use JAI for image inversion");
            }
        }
        if (!imageProcessed) {
            if (image.getType() == 12) {
                BufferedImage source = image;
                image = new BufferedImage(source.getWidth(), source.getHeight(), source.getType());
                invert3.filter(source, image);
            } else {
                image = invert3.filter(image, null);
            }
        }
        return image;
    }

    static float[] checkSize(float[] array, int currentItem) {
        int size = array.length;
        if (size <= currentItem) {
            int newSize = size * 2;
            float[] newArray = new float[newSize];
            System.arraycopy(array, 0, newArray, 0, size);
            array = newArray;
        }
        return array;
    }

    public static void renderClip(Area clip, Rectangle dirtyRegion, Shape defaultClip, Graphics2D g2) {
        if (clip != null) {
            g2.setClip(clip);
            if (dirtyRegion != null) {
                g2.clip(dirtyRegion);
            }
        } else {
            g2.setClip(defaultClip);
        }
    }

    static Rectangle getAreaForGlyph(float[][] trm) {
        int w = (int)Math.sqrt(trm[0][0] * trm[0][0] + trm[1][0] * trm[1][0]);
        int h = (int)Math.sqrt(trm[1][1] * trm[1][1] + trm[0][1] * trm[0][1]);
        float xDiff = 0.0f;
        float yDiff = 0.0f;
        if (trm[0][0] < 0.0f) {
            xDiff = trm[0][0];
        } else if (trm[1][0] < 0.0f) {
            xDiff = trm[1][0];
        }
        if (trm[1][1] < 0.0f) {
            yDiff = trm[1][1];
        } else if (trm[0][1] < 0.0f) {
            yDiff = trm[0][1];
        }
        return new Rectangle((int)(trm[2][0] + xDiff), (int)(trm[2][1] + yDiff), w, h);
    }

    public static boolean rectangleContains(Rectangle area, int x, int y, int i) {
        int temp;
        int lowX = area.x;
        int hiX = area.x + area.width;
        int lowY = area.y;
        int hiY = area.y + area.height;
        boolean containsPoint = false;
        if (lowX > hiX) {
            temp = lowX;
            lowX = hiX;
            hiX = temp;
        }
        if (lowY > hiY) {
            temp = lowY;
            lowY = hiY;
            hiY = temp;
        }
        if (lowY < y && y < hiY && lowX < x && x < hiX) {
            containsPoint = true;
        }
        return containsPoint;
    }

    public static Object restoreFromStream(ByteArrayInputStream bis) throws IOException, ClassNotFoundException {
        ObjectInputStream os = new ObjectInputStream(bis);
        return os.readObject();
    }

    public static void writeToStream(ByteArrayOutputStream bos, Object obj, String string2) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(obj);
        os.close();
    }
}

