/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.HTMLFontUtils;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.OutputHelper;
import org.jpedal.render.output.OutputImageController;
import org.jpedal.render.output.TextBlock;
import org.jpedal.render.output.TextPosition;
import org.jpedal.render.output.io.CustomIO;
import org.jpedal.render.output.io.DefaultIO;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.StringUtils;
import org.jpedal.utils.repositories.Vector_Rectangle;
import sun.misc.BASE64Encoder;

public class OutputDisplay
extends BaseDisplay {
    protected String firstPageName;
    public static boolean convertT1Fonts = true;
    protected String packageName = "";
    protected String javaFxFileName = "";
    protected HashMap<String, Object[]> fontsToConvert = new HashMap();
    protected HashMap<String, HashMap<String, Integer>> widths = new HashMap();
    protected static boolean enableOTFConversion = false;
    protected boolean hasEmbeddedFonts = false;
    protected Map embeddedFonts = new HashMap();
    protected Map baseFontNames = new HashMap();
    protected boolean hasEmbededFonts = false;
    private Map imagesAlreadyWritten = new HashMap();
    protected AcroRenderer acroRenderer;
    protected int startPage;
    protected int endPage;
    protected int pageGap = 50;
    String lastGlyf = "";
    boolean keepOriginalImage = false;
    protected String isOnlineConverter;
    protected boolean requiresTransform = false;
    protected boolean requiresTransformGlobal = false;
    protected boolean requiresTextGlobal = false;
    public static final int TEXT_AS_TEXT = -1;
    public static final int TEXT_AS_SHAPE = 1;
    public static final int TEXT_INVISIBLE_ON_IMAGE = 2;
    public static final int TEXT_VISIBLE_ON_IMAGE = 3;
    public static final int HTML_VIEW_MULTIFILE = 1;
    public static final int SVG_VIEW_MULTIFILE = 2;
    public static final int HTML_VIEW_MULTIFILE_SPLITSPREADS = 3;
    public static final int SVG_VIEW_MULTIFILE_SPLITSPREADS = 4;
    public static final int HTML_VIEW_SINGLEFILE = 5;
    public static final int SVG_VIEW_SINGLEFILE = 6;
    public static final int HTML_VIEW_SINGLEFILE_SPLITSPREADS = 7;
    public static final int SVG_VIEW_SINGLEFILE_SPLITSPREADS = 8;
    public static final int HTML_VIEW_SINGLEFILE_HORIZONTAL = 9;
    public static final int SVG_VIEW_SINGLEFILE_HORIZONTAL = 10;
    protected String clip = null;
    protected static OutputHelper Helper = null;
    FontMapper fontMapper = null;
    String lastFontUsed = "";
    private Map usedFontIDs = new HashMap();
    protected boolean includeClip = false;
    protected int textMode = -1;
    protected Map embeddedFontsByFontID = new HashMap();
    private Map glyfsRasterized = new HashMap();
    public static final int MaxNumberOfDecimalPlaces = 0;
    public static final int FontMode = 1;
    public static final int PercentageScaling = 2;
    public static final int IncludeJSFontResizingCode = 4;
    public static final int ExcludeMetadata = 6;
    public static final int EmbedImageAsBase64Stream = 7;
    public static final int AddNavBar = 8;
    public static final int UseCharSpacing = 10;
    public static final int UseWordSpacing = 11;
    public static final int UseFontResizing = 12;
    public static final int HasJavascript = 13;
    public static final int ConvertSpacesTonbsp = 14;
    public static final int EncloseContentInDiv = 15;
    public static final int IncludeClip = 16;
    public static final int UseImagesOnNavBar = 17;
    public static final int TextMode = 18;
    public static final int DisplayMode = 19;
    public static final int CustomIO = 21;
    public static final int StartOfDecode = 22;
    public static final int EndOfDecode = 23;
    public static final int EmulateEvenOdd = 24;
    public static final int HTMLImageMode = 26;
    public static final int UseThumbnailNavbar = 27;
    public static final int AcroRenderer = 28;
    public static final int AddTwitterButton = 30;
    public static final int AddFacebookButton = 31;
    public static final int AddGooglePlusButton = 32;
    public static final int AddRedditButton = 33;
    public static final int AddLinkedInButton = 34;
    public static final int AddDiggButton = 35;
    public static final int AddStumbleUponButton = 36;
    public static final int AddTumblrButton = 37;
    public static final int ConvertPDFExternalFileToOutputType = 38;
    public static final int GetIsSinglePage = 39;
    public static final int AddBorder = 40;
    public static final int IsSVGMode = 44;
    public static final int IsTextSelectable = 45;
    public static final int IsRealText = 46;
    public static final int DisableImageFallback = 47;
    public static final int PageTurning = 55;
    public static final int AddJavaScript = 56;
    public static final int EmbedImagesAsBase64 = 58;
    public static final int Base64Background = 59;
    public static final int DrawInvisibleText = 61;
    public static final int FontsToRasterizeInTextMode = 62;
    public static final int IsIDRViewer = 63;
    protected int defaultMode = 3;
    protected int fontMode = 3;
    protected boolean isSingleFileOutput = false;
    protected boolean htmlImageMode = false;
    protected boolean embedImageAsBase64 = false;
    private boolean groupGlyphsInTJ = true;
    protected boolean writeEveryGlyf = false;
    public boolean inlineCSS = false;
    public static final boolean debugForms = false;
    private static final boolean DISABLE_IMAGES = false;
    private static final boolean DISABLE_SHAPE = false;
    private static final boolean DISABLE_TEXT = false;
    protected static final boolean DEBUG_TEXT_AREA = false;
    protected static final boolean DEBUG_DRAW_PAGE_BORDER = false;
    public static final int TOFILE = 0;
    public static final int TOP_SECTION = 1;
    public static final int SCRIPT = 2;
    public static final int FORM = 3;
    public static final int CSS = 4;
    public static final int TEXT = 6;
    public static final int KEEP_GLYFS_SEPARATE = 7;
    public static final int SET_ENCODING_USED = 8;
    public static final int JSIMAGESPECIAL = 9;
    public static final int SAVE_EMBEDDED_FONT = 10;
    public static final int PAGEDATA = 11;
    public static final int IMAGE_CONTROLLER = 12;
    public static final int FXMLPDFSTAGE = 13;
    public static final int FONT_AS_SHAPE = 14;
    public static final int FXMLTEXT = 15;
    public static final int FORMJS = 16;
    public static final int FORMJS_ONLOAD = 17;
    public static final int NAVBAR = 18;
    public static final int EXTERNAL_JS = 19;
    public static final int TEXTJS = 20;
    public static final int CALCULATION_ORDER = 21;
    public static final int SVGINHTML = 22;
    public static final int SVGCLIPS = 23;
    public static final int SVGBUFFER = 25;
    public static final int DVR = 26;
    public static final int LEGACY_CSS = 28;
    public static final int BOOKMARK = 29;
    public static final int HasJavaScript = 32;
    public static final int THUMBNAIL_DISPLAY = 35;
    public static final int IMAGE_DISPLAY = 37;
    public static final int COMPATABILITY_DISPLAY = 38;
    protected OutputImageController imageController = null;
    protected StringBuilder script = new StringBuilder(10000);
    protected ArrayList<String> fxScript = new ArrayList();
    protected ArrayList<String> fxmlText = new ArrayList();
    protected HashMap<Integer, String> base64Images = new HashMap();
    protected HashMap<Integer, String> base64Shades = new HashMap();
    protected StringBuilder fonts_as_shapes = new StringBuilder(10000);
    protected StringBuilder formJS = new StringBuilder(10000);
    protected StringBuilder formJSOnLoad = new StringBuilder(10000);
    protected StringBuilder form = new StringBuilder(10000);
    protected StringBuilder testDivs = new StringBuilder(10000);
    protected StringBuilder css = new StringBuilder(10000);
    protected StringBuilder topSection = new StringBuilder(10000);
    protected StringBuilder fxmlPDFStage = new StringBuilder(10000);
    protected StringBuilder navbarSection = new StringBuilder(10000);
    protected StringBuilder externalJSFile = new StringBuilder(10000);
    protected StringBuilder textJS = new StringBuilder(3000);
    protected boolean userControlledImageScaling = false;
    protected boolean emulateEvenOdd = false;
    protected int textID = 1;
    protected int shadeId = 0;
    protected int imageId = 0;
    protected int dpCount = 0;
    public String rootDir = null;
    public String fileName = null;
    protected int dx;
    protected int dy;
    protected int dr;
    protected boolean excludeMetadata = false;
    private boolean convertSpacesTonbsp = false;
    protected boolean addNavBar = false;
    protected boolean useImagesOnNavBar = false;
    protected boolean useThumbnailNavbar = false;
    protected TextBlock currentTextBlock;
    protected TextBlock previousTextBlock;
    protected TextPosition currentTextPosition;
    protected Rectangle2D cropBox;
    protected Point2D midPoint;
    protected int currentColor = 0;
    protected String[] encodingType = new String[]{"UTF-8", "utf-8"};
    protected static final int JAVA_TYPE = 0;
    protected static final int OUTPUT_TYPE = 1;
    public static final int FORM_TAG = 0;
    protected float scaling = 1.0f;
    protected int fontChangeNeeded = -1;
    protected boolean addBorder = true;
    float w;
    protected float h;
    protected String[] tag = new String[]{"<form>"};
    protected boolean jsImagesAdded = false;
    protected String pageNumberAsString = null;
    protected PdfPageData pageData;
    private int currentTokenNumber = -1;
    private int lastTokenNumber = 496;
    protected boolean includeJSFontResizingCode = true;
    protected String imageName;
    protected float iw;
    protected float ih;
    protected double[] coords;
    protected float[][] lastTrm;
    protected CustomIO customIO = new DefaultIO();
    protected String imageArray = null;
    protected int[] currentImage;
    protected int[] currentPatternedShape;
    protected String currentPatternedShapeName;
    protected Color stageColor = new Color(55, 55, 65);
    protected String[] jsCalculationOrder;
    protected boolean addTwitter = false;
    protected String viaTwitter = "";
    protected boolean addFacebook = false;
    protected boolean addGooglePlus = false;
    protected boolean addReddit = false;
    protected boolean addLinkedIn = false;
    protected boolean addDigg = false;
    protected boolean addStumbleUpon = false;
    protected boolean addTumblr = false;
    protected boolean enableMagazineSplitSpreads = false;
    protected boolean enableSinglePageHorizontal = false;
    private boolean convertPDFExternalFileToOutputType = true;
    protected boolean useExternalJS = true;
    protected boolean enableTouchEvents = false;
    protected boolean usingCachedImage = false;
    protected int cachedImageId = 0;
    static final int[] indices = new int[]{1, 10, 100, 1000};

    public OutputDisplay(int pageNumber, Point2D midPoint, Rectangle2D cropBox, boolean addBackground, int defaultSize, ObjectStore newObjectRef, Map params) {
        this.setParameters(params);
        this.fontMode = this.defaultMode;
        this.type = 4;
        this.pageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.cropBox = cropBox;
        this.midPoint = midPoint;
        this.areas = new Vector_Rectangle(defaultSize);
    }

    private void setParameters(Map params) {
        if (params == null) {
            String mode = System.getProperty("org.jpedal.pdf2html.fontMode");
            if (mode != null) {
                if ((mode = mode.toLowerCase()).equals("embed_all")) {
                    this.defaultMode = 6;
                } else if (mode.equals("embed_all_except_base_families")) {
                    this.defaultMode = 7;
                } else {
                    throw new RuntimeException("Mode " + mode + " not recognised");
                }
            }
            if (System.getProperty("org.jpedal.pdf2html.keepOriginalImage") != null && System.getProperty("org.jpedal.pdf2html.keepOriginalImage").toLowerCase().equals("true")) {
                this.keepOriginalImage = true;
            }
            if (System.getProperty("org.jpedal.pdf2html.convertOTFFonts") != null && System.getProperty("org.jpedal.pdf2html.convertOTFFonts").toLowerCase().equals("true")) {
                enableOTFConversion = true;
            }
            this.isOnlineConverter = System.getProperty("IsOnlineConverter");
            this.firstPageName = System.getProperty("org.jpedal.pdf2html.firstPageName");
            if (System.getProperty("org.jpedal.pdf2html.stageColor") != null) {
                this.stageColor = Color.decode(System.getProperty("org.jpedal.pdf2html.stageColor"));
            }
        } else {
            String mode = (String)params.get("org.jpedal.pdf2html.fontMode");
            if (mode != null) {
                if (mode.equals("embed_all")) {
                    this.defaultMode = 6;
                } else if (mode.equals("embed_all_except_base_families")) {
                    this.defaultMode = 7;
                } else {
                    throw new RuntimeException("Mode " + mode + " not recognised");
                }
            }
            if ((String)params.get("org.jpedal.pdf2html.keepOriginalImage") != null && ((String)params.get("org.jpedal.pdf2html.keepOriginalImage")).equals("true")) {
                this.keepOriginalImage = true;
            }
            if ((String)params.get("org.jpedal.pdf2html.convertOTFFonts") != null && ((String)params.get("org.jpedal.pdf2html.convertOTFFonts")).equals("true")) {
                enableOTFConversion = true;
            }
            this.isOnlineConverter = (String)params.get("IsOnlineConverter");
            this.firstPageName = (String)params.get("org.jpedal.pdf2html.firstPageName");
            if ((String)params.get("org.jpedal.pdf2html.stageColor") != null) {
                this.stageColor = Color.decode((String)params.get("org.jpedal.pdf2html.stageColor"));
            }
        }
    }

    @Override
    public void setValue(int key, int value) {
        switch (key) {
            case 19: {
                switch (value) {
                    case 1: 
                    case 2: {
                        this.isSingleFileOutput = false;
                        this.enableMagazineSplitSpreads = false;
                        this.enableSinglePageHorizontal = false;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.isSingleFileOutput = false;
                        this.enableMagazineSplitSpreads = true;
                        this.enableSinglePageHorizontal = false;
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.isSingleFileOutput = true;
                        this.enableMagazineSplitSpreads = false;
                        this.enableSinglePageHorizontal = false;
                        break;
                    }
                    case 7: 
                    case 8: {
                        this.isSingleFileOutput = true;
                        this.enableMagazineSplitSpreads = true;
                        this.enableSinglePageHorizontal = false;
                        break;
                    }
                    case 9: 
                    case 10: {
                        this.isSingleFileOutput = true;
                        this.enableMagazineSplitSpreads = false;
                        this.enableSinglePageHorizontal = true;
                    }
                }
                break;
            }
            case 23: {
                this.endPage = value;
                break;
            }
            case 1: {
                this.fontMode = value;
                break;
            }
            case 0: {
                this.dpCount = value;
                break;
            }
            case 2: {
                this.scaling = (float)value / 100.0f;
                break;
            }
            case 22: {
                this.startPage = value;
                break;
            }
            case 18: {
                this.textMode = value;
                break;
            }
            case 12: {
                this.fontChangeNeeded = value;
            }
        }
    }

    @Override
    public boolean getBooleanValue(int key) {
        switch (key) {
            case 38: {
                return this.convertPDFExternalFileToOutputType;
            }
            case 39: {
                return this.isSingleFileOutput;
            }
        }
        return super.getBooleanValue(key);
    }

    @Override
    public void setBooleanValue(int key, boolean value) {
        switch (key) {
            case 8: {
                this.addNavBar = value;
                break;
            }
            case 38: {
                this.convertPDFExternalFileToOutputType = value;
                break;
            }
            case 14: {
                this.convertSpacesTonbsp = value;
                break;
            }
            case 6: {
                this.excludeMetadata = value;
                break;
            }
            case 16: {
                this.includeClip = value;
                break;
            }
            case 17: {
                this.useImagesOnNavBar = value;
                break;
            }
            case 27: {
                this.useThumbnailNavbar = value;
                break;
            }
            case 26: {
                this.htmlImageMode = value;
                break;
            }
            case 30: {
                this.addTwitter = value;
                break;
            }
            case 31: {
                this.addFacebook = value;
                break;
            }
            case 32: {
                this.addGooglePlus = value;
                break;
            }
            case 33: {
                this.addReddit = value;
                break;
            }
            case 34: {
                this.addLinkedIn = value;
                break;
            }
            case 35: {
                this.addDigg = value;
                break;
            }
            case 36: {
                this.addStumbleUpon = value;
                break;
            }
            case 37: {
                this.addTumblr = value;
                break;
            }
            case 40: {
                this.addBorder = value;
            }
        }
    }

    @Override
    public int getValue(int key) {
        int value = -1;
        switch (key) {
            case 1: {
                value = this.fontMode;
                break;
            }
            case 2: {
                value = (int)(this.scaling * 100.0f);
                break;
            }
            case 18: {
                value = this.textMode;
            }
        }
        return value;
    }

    @Override
    public void setTag(int type, String value) {
        throw new RuntimeException("Unknown tag value " + type);
    }

    @Override
    public void init(int width, int height, int rawRotation, Color backgroundColor) {
        if (rawRotation == 90 || rawRotation == 270) {
            this.h = (float)width * this.scaling;
            this.w = (float)height * this.scaling;
        } else {
            this.w = (float)width * this.scaling;
            this.h = (float)height * this.scaling;
        }
        this.pageRotation = rawRotation;
        this.backgroundColor = backgroundColor;
        this.shadeId = 0;
        this.currentTextBlock = new TextBlock();
        this.previousTextBlock = new TextBlock();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void writeCustom(int section, Object str) {
        switch (section) {
            case 11: {
                this.pageData = (PdfPageData)str;
                this.dx = this.pageData.getCropBoxX(this.pageNumber);
                this.dy = this.pageData.getCropBoxY(this.pageNumber);
                this.dr = this.pageData.getRotation(this.pageNumber);
                break;
            }
            case 12: {
                this.imageController = (OutputImageController)str;
                this.userControlledImageScaling = this.imageController != null;
                break;
            }
            case 28: {
                this.acroRenderer = (AcroRenderer)str;
                break;
            }
            case 21: {
                this.customIO = (CustomIO)str;
                break;
            }
            case 10: {
                fontData = (Object[])str;
                pdfFont = (PdfFont)fontData[0];
                fontName = pdfFont.getFontName();
                fileType = (String)fontData[2];
                fontID = (String)fontData[3];
                fontPath = this.rootDir + this.fileName + "/fonts/";
                cssDir = new File(fontPath);
                if (!cssDir.exists()) {
                    cssDir.mkdirs();
                }
                rawFontData = (byte[])fontData[1];
                fontName = fontName.replaceAll("[.,*#]", "-");
                if (!fileType.equals("ttf") || fontName.contains(",")) ** GOTO lbl53
                if (this.embeddedFonts.containsKey(fontName) && !this.baseFontNames.containsKey(pdfFont.getBaseFontName())) {
                    this.baseFontNames.put(pdfFont.getBaseFontName(), "x");
                    fontName = fontName + '_' + fontID + '_' + rawFontData.length;
                    pdfFont.resetNameForHTML(fontName);
                }
                try {
                    rawFontData = HTMLFontUtils.convertTTForHTML(pdfFont, fontName, rawFontData);
                    if (OutputDisplay.enableOTFConversion) {
                        rawFontData = HTMLFontUtils.convertPSForHTMLOTF(pdfFont, fontName, rawFontData, fileType, this.widths.get(fontName));
                        fileType = "otf";
                    } else {
                        rawFontData = HTMLFontUtils.convertPSForHTMLWOFF(pdfFont, fontName, rawFontData, fileType, this.widths.get(fontName));
                        fileType = "woff";
                    }
                    if (rawFontData != null) {
                        this.customIO.writeFont(fontPath + fontName + '.' + fileType, rawFontData);
                    }
                    ** GOTO lbl62
                }
                catch (Exception e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                ** GOTO lbl62
lbl53:
                // 1 sources

                if (fileType.equals("t1") && OutputDisplay.convertT1Fonts || fileType.equals("cff") || fileType.equals("ttf") && !fontName.contains(",")) {
                    fontName = fileType.equals("ttf") != false ? pdfFont.getBaseFontName().substring(7) : pdfFont.getBaseFontName().replace('+', '-');
                    if (this.embeddedFonts.containsKey(fontName)) {
                        fontName = fontName + '_' + fontID + '_' + rawFontData.length;
                        pdfFont.resetNameForHTML(fontName);
                    }
                    this.hasEmbeddedFonts = true;
                    this.fontsToConvert.put(fontName, fontData);
                    fileType = OutputDisplay.enableOTFConversion != false ? "otf" : "woff";
                }
lbl62:
                // 6 sources

                if (rawFontData == null) break;
                fontTag = new StringBuilder();
                replacedFontName = fontName.replaceAll("[.,*#]", "-");
                if (this.type == 6) {
                    fontTag.append("Font.loadFont(");
                    fontTag.append(this.javaFxFileName + ".class.getResource(\"").append(this.fileName).append("/fonts/").append(replacedFontName).append('.').append(fileType).append("\").toExternalForm(),10);\n");
                } else {
                    fontTag.append("@font-face {\n");
                    fontTag.append("\tfont-family: ").append(replacedFontName).append(";\n");
                    fontTag.append("\tsrc: url(\"").append(this.fileName).append("/fonts/").append(replacedFontName).append('.').append(fileType).append("\");\n");
                    fontTag.append("}\n");
                }
                this.embeddedFonts.put(fontName, fontTag);
                this.hasEmbededFonts = true;
                value = (String)this.embeddedFontsByFontID.get(fontName);
                if (value == null) {
                    this.embeddedFontsByFontID.put(fontName, fontID);
                    break;
                }
                this.embeddedFontsByFontID.put(fontName, value + ',' + fontID);
                break;
            }
            default: {
                throw new RuntimeException("Option " + section + " not recognised");
            }
        }
    }

    @Override
    public synchronized void flagDecodingFinished() {
        Object[] fontNames;
        if (this.customIO != null && this.customIO.isOutputOpen()) {
            this.completeOutput();
        }
        for (Object fontName1 : fontNames = this.fontsToConvert.keySet().toArray()) {
            String fontName;
            byte[] rawFontData;
            String fontPath;
            String fontID;
            String fileType;
            block9: {
                Object[] fontData = this.fontsToConvert.get(fontName1);
                PdfFont pdfFont = (PdfFont)fontData[0];
                fileType = (String)fontData[2];
                fontID = (String)fontData[3];
                fontPath = this.rootDir + this.fileName + "/fonts/";
                File cssDir = new File(fontPath);
                if (!cssDir.exists()) {
                    cssDir.mkdirs();
                }
                rawFontData = (byte[])fontData[1];
                fontName = fileType.equals("ttf") ? pdfFont.getBaseFontName().replace('+', '-').substring(7) : pdfFont.getBaseFontName().replace('+', '-');
                this.hasEmbeddedFonts = true;
                boolean saveRawFonts = false;
                if (saveRawFonts) {
                    this.customIO.writeFont(fontPath + fontName + ".cff", rawFontData);
                }
                try {
                    if (enableOTFConversion) {
                        rawFontData = HTMLFontUtils.convertPSForHTMLOTF(pdfFont, fontName, rawFontData, fileType, this.widths.get(fontName));
                        fileType = "otf";
                    } else {
                        rawFontData = HTMLFontUtils.convertPSForHTMLWOFF(pdfFont, fontName, rawFontData, fileType, this.widths.get(fontName));
                        fileType = "woff";
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            fontName = fontName.replaceAll("[.,*#]", "-");
            if (rawFontData == null) continue;
            this.customIO.writeFont(fontPath + fontName + '.' + fileType, rawFontData);
            StringBuilder fontTag = new StringBuilder();
            fontTag.append("@font-face {\n");
            fontTag.append("\tfont-family: ").append(fontName).append(";\n");
            fontTag.append("\tsrc: url(\"").append(this.fileName).append("/fonts/").append(fontName).append('.').append(fileType).append("\");\n");
            fontTag.append("}\n");
            this.embeddedFonts.put(fontName, fontTag);
            this.embeddedFonts.put(fontID, fontName);
            this.hasEmbededFonts = true;
            String value = (String)this.embeddedFontsByFontID.get(fontName);
            if (value == null) {
                this.embeddedFontsByFontID.put(fontName, fontID);
                continue;
            }
            this.embeddedFontsByFontID.put(fontName, value + ',' + fontID);
        }
    }

    protected String roundUp(double d) {
        return "" + (int)(d + 0.99);
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState gs, boolean alreadyCached, String name, int optionsApplied, int previousUse) {
        boolean imagesWritten;
        String cacheKey = pageNumber + 45 + name;
        this.usingCachedImage = false;
        boolean bl = imagesWritten = gs.getClippingShape() == null && this.imagesAlreadyWritten.get(cacheKey) != null;
        if (!imagesWritten) {
            this.imagesAlreadyWritten.put(cacheKey, this.imageId + 1);
        } else if (!this.embedImageAsBase64) {
            this.usingCachedImage = true;
            this.cachedImageId = (Integer)this.imagesAlreadyWritten.get(cacheKey);
            image = null;
        }
        this.flushText();
        boolean needsflipping = false;
        float x = gs.CTM[2][0] * this.scaling;
        float y = gs.CTM[2][1] * this.scaling;
        this.iw = (gs.CTM[0][0] + Math.abs(gs.CTM[1][0])) * this.scaling;
        this.ih = (gs.CTM[1][1] + Math.abs(gs.CTM[0][1])) * this.scaling;
        if (this.iw == 0.0f) {
            this.iw = gs.CTM[1][0] * this.scaling;
            if (this.iw < 0.0f) {
                this.iw = -this.iw;
            }
        }
        if (this.ih == 0.0f) {
            this.ih = gs.CTM[0][1] * this.scaling;
        }
        if (this.iw < 0.0f) {
            this.iw *= -1.0f;
        }
        if (this.iw < 1.0f) {
            this.iw = 1.0f;
        }
        if (this.ih == 0.0f) {
            this.ih = 1.0f;
        }
        if (this.ih < 1.0f) {
            y += this.ih;
            this.ih = Math.abs(this.ih);
        }
        if (gs.CTM[0][0] < 0.0f) {
            x -= this.iw;
        }
        if (gs.CTM[0][0] > 0.0f && gs.CTM[1][1] < 0.0f && gs.CTM[0][1] == 0.0f && gs.CTM[1][0] == 0.0f) {
            needsflipping = true;
        }
        if (gs.CTM[0][0] == 0.0f && gs.CTM[1][1] == 0.0f && gs.CTM[0][1] > 0.0f && gs.CTM[1][0] > 0.0f) {
            x -= this.pageData.getCropBoxX2D(pageNumber) / 2.0f;
            y -= this.pageData.getCropBoxY2D(pageNumber);
        }
        Graphics2D g2savedImage = null;
        BufferedImage savedImage = image;
        boolean isXSet = false;
        boolean isYSet = false;
        if (gs.getClippingShape() != null) {
            Rectangle2D clipBounds = gs.getClippingShape().getBounds2D();
            float clipW = (float)(clipBounds.getWidth() * (double)this.scaling);
            float clipH = (float)(clipBounds.getHeight() * (double)this.scaling);
            if (clipW < this.iw) {
                this.iw = clipW;
                x = (float)(clipBounds.getMinX() * (double)this.scaling);
                isXSet = true;
            }
            if (clipH < this.ih) {
                this.ih = clipH;
                y = (float)(clipBounds.getMinY() * (double)this.scaling);
                isYSet = true;
            }
        }
        if (!isXSet) {
            if (gs.CTM[1][0] < 0.0f && gs.CTM[0][0] != 0.0f) {
                x += gs.CTM[1][0] * this.scaling;
            }
            if (gs.CTM[1][0] < 0.0f && gs.CTM[0][0] == 0.0f) {
                x -= this.iw;
            }
        }
        if (!isYSet) {
            if (gs.CTM[0][1] < 0.0f && gs.CTM[1][1] != 0.0f) {
                y += gs.CTM[0][1] * this.scaling;
            }
            if (gs.CTM[0][1] < 0.0f && gs.CTM[1][1] == 0.0f) {
                y -= this.ih;
            }
        }
        if (this.htmlImageMode) {
            this.coords = this.pageRotation == 90 || this.pageRotation == 270 ? new double[]{y, x} : new double[]{x, y};
        } else {
            switch (this.pageRotation) {
                case 180: {
                    this.coords = new double[]{this.cropBox.getWidth() - (double)((this.iw + x) / this.scaling), this.cropBox.getHeight() - (double)((this.ih + y) / this.scaling)};
                    break;
                }
                case 270: {
                    if (gs.CTM[0][0] > 0.0f && gs.CTM[1][1] > 0.0f && gs.CTM[1][0] == 0.0f && gs.CTM[0][1] == 0.0f) {
                        this.coords = new double[]{this.cropBox.getWidth() - (double)((x + this.iw) / this.scaling), y / this.scaling};
                        break;
                    }
                    this.coords = new double[]{x / this.scaling, y / this.scaling};
                    break;
                }
                default: {
                    this.coords = new double[]{x / this.scaling, y / this.scaling};
                }
            }
        }
        this.correctCoords(this.coords);
        this.coords[0] = this.coords[0] * (double)this.scaling;
        this.coords[1] = this.coords[1] * (double)this.scaling;
        this.coords[1] = this.coords[1] - (double)this.ih;
        Rectangle2D.Double rect = new Rectangle2D.Double(this.coords[0], this.coords[1], this.iw, this.ih);
        Rectangle2D.Double cropBoxScaled = new Rectangle2D.Double(this.cropBox.getX() * (double)this.scaling, this.cropBox.getY() * (double)this.scaling, this.cropBox.getWidth() * (double)this.scaling, this.cropBox.getHeight() * (double)this.scaling);
        if (cropBoxScaled.intersects(rect)) {
            if (!this.usingCachedImage) {
                ++this.imageId;
            }
            if (!this.userControlledImageScaling && !this.htmlImageMode && image != null) {
                if (this.pageRotation != 0) {
                    image = this.rotateImage(image, this.pageRotation);
                }
                if (image.getHeight() == 1 || !needsflipping && this.iw == (float)image.getWidth() && this.ih == (float)image.getHeight()) {
                    savedImage = image;
                } else {
                    if (g2savedImage == null) {
                        savedImage = new BufferedImage((int)this.iw == 0 ? 1 : (int)this.iw, (int)this.ih == 0 ? 1 : (int)this.ih, image.getType());
                        g2savedImage = (Graphics2D)savedImage.getGraphics();
                        AffineTransform aff = new AffineTransform();
                        if (needsflipping) {
                            aff.scale(1.0, -1.0);
                            aff.translate(0.0, -this.ih);
                        }
                        g2savedImage.setTransform(aff);
                    }
                    g2savedImage.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2savedImage.drawImage(image, 0, 0, (int)this.iw, (int)this.ih, null);
                }
            }
            if (this.embedImageAsBase64) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)savedImage, "PNG", bos);
                    bos.close();
                    BASE64Encoder b64 = new BASE64Encoder();
                    this.imageArray = new BASE64Encoder().encode(bos.toByteArray());
                    this.imageArray = this.imageArray.replace("\r\n", "\\\r\n");
                }
                catch (IOException e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            } else {
                String imageDir = this.fileName + "/img/";
                if (!imagesWritten) {
                    File imgDir = new File(this.rootDir + imageDir);
                    if (!imgDir.exists()) {
                        imgDir.mkdirs();
                    }
                    this.customIO.writeImage(this.rootDir, imageDir + this.imageId, savedImage);
                    this.imageName = imageDir + this.imageId + this.customIO.getImageTypeUsed();
                } else {
                    this.imageName = imageDir + this.cachedImageId + this.customIO.getImageTypeUsed();
                }
            }
            if (this.htmlImageMode) {
                this.currentImage = new int[]{0, 0, (int)this.iw, (int)this.ih};
            } else {
                int finalY;
                int finalX;
                int finalHeight;
                int finalWidth;
                switch (this.pageRotation) {
                    case 90: {
                        double tmpX = (double)(this.pageData.getCropBoxHeight2D(pageNumber) * this.scaling) - this.coords[1] - (double)this.iw;
                        double tmpY = this.coords[0];
                        finalWidth = (int)(tmpX - (double)((int)tmpX) + (double)this.iw + 0.99);
                        finalHeight = (int)(tmpY - (double)((int)tmpY) + (double)this.ih + 0.99);
                        finalX = (int)tmpX;
                        finalY = (int)tmpY;
                        break;
                    }
                    case 270: {
                        finalWidth = (int)(this.coords[1] - (double)((int)this.coords[1]) + (double)this.iw + 0.99);
                        finalHeight = (int)(this.coords[0] - (double)((int)this.coords[0]) + (double)this.ih + 0.99);
                        finalX = (int)this.coords[1];
                        finalY = (int)this.coords[0];
                        break;
                    }
                    default: {
                        finalWidth = (int)(this.coords[0] - (double)((int)this.coords[0]) + (double)this.iw + 0.99);
                        finalHeight = (int)(this.coords[1] - (double)((int)this.coords[1]) + (double)this.ih + 0.99);
                        finalX = (int)this.coords[0];
                        finalY = (int)this.coords[1];
                    }
                }
                this.currentImage = new int[]{finalX, finalY, finalWidth, finalHeight};
            }
            return -2;
        }
        return -1;
    }

    protected BufferedImage rotateImage(BufferedImage savedImage, int angle) {
        BufferedImage rotatedImage;
        if (angle == 180) {
            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, -1.0);
            tx.translate(-savedImage.getWidth(null), -savedImage.getHeight(null));
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            rotatedImage = op.filter(savedImage, null);
        } else {
            int w = savedImage.getWidth();
            int h = savedImage.getHeight();
            rotatedImage = new BufferedImage(h, w, savedImage.getType());
            Graphics2D g2 = rotatedImage.createGraphics();
            g2.rotate(Math.toRadians(this.pageRotation), w / 2, h / 2);
            int diff = (w - h) / 2;
            if (angle == 90) {
                g2.drawImage((Image)savedImage, diff, diff, null);
            } else if (angle == 270) {
                g2.drawImage((Image)savedImage, -diff, -diff, null);
            }
            float a = this.iw;
            this.iw = this.ih;
            this.ih = a;
        }
        return rotatedImage;
    }

    protected String setPrecision(double i) {
        String value = String.valueOf(i);
        int ptr = value.indexOf(46);
        int len = value.length();
        int decimals = len - ptr - 1;
        if (ptr > 0 && decimals > this.dpCount) {
            value = this.dpCount == 0 ? value.substring(0, ptr + this.dpCount) : value.substring(0, ptr + this.dpCount + 1);
        }
        return OutputDisplay.removeEmptyDecimals(value);
    }

    protected static String setPrecision(double i, int dpCount) {
        if (dpCount > 3) {
            throw new RuntimeException("dp count must be less than 4");
        }
        double roundedValue = (double)((int)(i * (double)indices[dpCount])) / (double)indices[dpCount];
        if (roundedValue > 0.98 && roundedValue < 1.01) {
            return "1";
        }
        if (roundedValue == 0.0) {
            return "0";
        }
        if (roundedValue == 0.0) {
            return "0";
        }
        if (roundedValue < -0.98 && roundedValue > -1.01) {
            return "-1";
        }
        return String.valueOf((double)((int)(i * (double)indices[dpCount])) / (double)indices[dpCount]);
    }

    @Override
    public void drawClip(GraphicsState currentGraphicsState, Shape defaultClip, boolean canBeCached) {
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, AffineTransform at, String glyf, PdfFont currentFontData, float glyfWidth) {
        int textFillType;
        int color;
        Area clip;
        float[][] rawTrm = new float[3][3];
        rawTrm[0][0] = Trm[0][0];
        rawTrm[0][1] = Trm[0][1];
        rawTrm[0][2] = Trm[0][2];
        rawTrm[1][0] = Trm[1][0];
        rawTrm[1][1] = Trm[1][1];
        rawTrm[1][2] = Trm[1][2];
        rawTrm[2][0] = Trm[2][0];
        rawTrm[2][1] = Trm[2][1];
        rawTrm[2][2] = Trm[2][2];
        if (this.currentTokenNumber == this.lastTokenNumber && glyf.equals(" ") && this.lastGlyf.equals(" ")) {
            this.flushText();
            return;
        }
        if (Helper != null && glyf.length() > 3 && !StandardFonts.isValidGlyphName(glyf)) {
            glyf = Helper.mapNonstandardGlyfName(glyf, currentFontData);
        }
        if ((clip = gs.getClippingShape()) != null && !clip.getBounds().contains(new Point((int)Trm[2][0] + 1, (int)Trm[2][1] + 1)) && !clip.getBounds().contains(new Point((int)Trm[2][0] + fontSize / 2, (int)Trm[2][1] + fontSize / 2))) {
            return;
        }
        double[] coords = new double[]{Trm[2][0], Trm[2][1]};
        this.correctCoords(coords);
        if (this.textMode == 1 || this.textMode == 2 && this.getType() == 5) {
            this.currentTextPosition = new TextPosition(coords, new float[]{rawTrm[0][0], rawTrm[0][1], rawTrm[1][0], rawTrm[1][1], rawTrm[2][0], rawTrm[2][1]});
            this.rasterizeTextAsShape(embeddedGlyph, gs, currentFontData, glyf);
            return;
        }
        switch (this.pageRotation) {
            case 90: {
                float x = Trm[2][0];
                float y = Trm[2][1];
                Trm = Matrix.multiply(Trm, new float[][]{{0.0f, -1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                if (Trm[0][0] == 0.0f && Trm[1][1] == 0.0f && Trm[0][1] * Trm[1][0] < 0.0f && gs.CTM[0][0] > 0.0f && gs.CTM[1][1] > 0.0f) {
                    Trm[2][0] = y;
                    Trm[2][1] = (float)(this.cropBox.getHeight() - (double)x);
                    break;
                }
                Trm[2][0] = x;
                Trm[2][1] = y;
                break;
            }
            case 270: {
                float x = Trm[2][0];
                float y = Trm[2][1];
                if (Trm[0][0] > 0.0f && Trm[1][1] > 0.0f && Trm[0][1] == 0.0f && Trm[1][0] == 0.0f) break;
                Trm = Matrix.multiply(Trm, new float[][]{{0.0f, 1.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                break;
            }
        }
        if (glyfWidth == -100.0f) {
            glyfWidth = currentFontData.getWidth(-1);
        }
        int altFontSize = -1;
        int fontCondition = -1;
        TextState currentTextState = gs.getTextState();
        if (currentTextState != null) {
            float rawFontSize = Trm[0][0];
            float tc = currentTextState.getCharacterSpacing();
            float tw = currentTextState.getWordSpacing();
            float diff = rawFontSize - (float)((int)rawFontSize);
            if (rawFontSize > 1.0f) {
                if (fontSize == 9 && diff == 0.5f && (double)tc > -0.2 && tw == 0.0f && fontSize != (int)rawFontSize) {
                    altFontSize = (int)rawFontSize;
                    fontCondition = 1;
                } else if (fontSize == 8 && rawFontSize > 8.0f && tc > 0.0f && diff < 0.3f && tw == 0.0f) {
                    altFontSize = fontSize + 1;
                    fontCondition = 2;
                }
            }
        }
        if (Trm[0][0] != Trm[1][1] && Trm[1][0] == 0.0f && Trm[0][1] == 0.0f) {
            fontSize = (int)Trm[0][0];
        }
        if (glyf.length() == 0 || TextBlock.ignoreGlyf(glyf)) {
            return;
        }
        if (fontSize < 0) {
            fontSize = -fontSize;
        }
        float charWidth = (float)fontSize * glyfWidth;
        if (!currentFontData.getBaseFontName().equals(this.lastFontUsed)) {
            this.fontMapper = this.getFontMapper(currentFontData);
            this.lastFontUsed = currentFontData.getBaseFontName();
            String value = (String)this.embeddedFontsByFontID.get(this.lastFontUsed);
            if (value == null) {
                this.embeddedFontsByFontID.put(this.lastFontUsed, "browser");
            } else if (!value.contains("browser")) {
                this.embeddedFontsByFontID.put(this.lastFontUsed, value + ',' + "browser");
            }
        }
        int n = color = (textFillType = gs.getTextRenderType()) == 1 ? gs.getStrokeColor().getRGB() : gs.getNonstrokeColor().getRGB();
        if (this.lastTrm != null && Trm[0][0] == this.lastTrm[0][0] && Trm[0][1] == this.lastTrm[0][1] && Trm[1][0] == this.lastTrm[1][0] && Trm[1][1] == this.lastTrm[1][1] && glyf.equals(this.lastGlyf)) {
            float xDiff = Math.abs(Trm[2][0] - this.lastTrm[2][0]);
            float yDiff = Math.abs(Trm[2][1] - this.lastTrm[2][1]);
            float fontDiffAllowed = 1.0f;
            if (xDiff < fontDiffAllowed && yDiff < fontDiffAllowed) {
                return;
            }
        }
        float x = (float)coords[0];
        float y = (float)coords[1];
        float rotX = x;
        float rotY = y;
        if (this.pageRotation == 90) {
            rotX = Trm[2][1];
            rotY = Trm[2][0];
        }
        if (this.writeEveryGlyf || !this.currentTextBlock.isSameFont(fontSize, this.fontMapper, Trm, color) || !this.currentTextBlock.appendText(glyf, charWidth, rotX, rotY, this.groupGlyphsInTJ, !this.groupGlyphsInTJ || this.currentTokenNumber != this.lastTokenNumber, x, y)) {
            this.flushText();
            this.currentTextPosition = new TextPosition(coords, new float[]{rawTrm[0][0], rawTrm[0][1], rawTrm[1][0], rawTrm[1][1], rawTrm[2][0], rawTrm[2][1]});
            if (!glyf.equals(" ")) {
                float spaceWidth = (float)fontSize * currentFontData.getCurrentFontSpaceWidth();
                this.currentTextBlock = new TextBlock(glyf, fontSize, this.fontMapper, Trm, x, y, charWidth, color, spaceWidth, this.cropBox.getBounds(), Trm, altFontSize, fontCondition, rotX, rotY, this.pageRotation);
                if (this.convertSpacesTonbsp) {
                    this.currentTextBlock.convertSpacesTonbsp(true);
                }
                if (this.currentTextBlock.getRotationAngle() == 0.0f) {
                    this.currentTextBlock.adjustY(-fontSize);
                }
            } else {
                this.currentTextBlock = new TextBlock();
            }
        }
        this.lastTokenNumber = this.currentTokenNumber;
        this.lastGlyf = glyf;
        this.lastTrm = Trm;
    }

    private void rasterizeTextAsShape(PdfGlyph embeddedGlyph, GraphicsState gs, PdfFont currentFontData, String glyf) {
        if (embeddedGlyph != null && embeddedGlyph.getShape() != null && !glyf.equals(" ")) {
            GraphicsState TextGs = gs;
            boolean isInvalid = false;
            for (int aa = 0; aa < glyf.length(); ++aa) {
                if (!Character.isLetterOrDigit(glyf.charAt(aa))) {
                    isInvalid = true;
                }
                if (isInvalid) break;
            }
            String safeFontID = (String)currentFontData.getFontID();
            if (this.usedFontIDs.containsKey(safeFontID = StringUtils.makeMethodSafe(safeFontID)) && this.usedFontIDs.get(safeFontID) != currentFontData.getBaseFontName()) {
                safeFontID = safeFontID + StringUtils.makeMethodSafe(currentFontData.getBaseFontName());
            } else {
                this.usedFontIDs.put(safeFontID, currentFontData.getBaseFontName());
            }
            String JSRoutineName = isInvalid ? safeFontID + Integer.toHexString(glyf.charAt(0)) : (glyf.length() == 0 ? safeFontID + '_' + embeddedGlyph.getID() : safeFontID + glyf);
            if (!Character.isLetter(JSRoutineName.charAt(0))) {
                JSRoutineName = 's' + JSRoutineName;
            }
            String cacheKey = currentFontData.getBaseFontName() + '.' + JSRoutineName;
            boolean isAlreadyDecoded = this.glyfsRasterized.containsKey(cacheKey);
            Area textGlyf = (Area)embeddedGlyph.getShape().clone();
            TextGs.setClippingShape(null);
            TextGs.setFillType(gs.getTextRenderType());
            float d = (float)(1.0 / currentFontData.FontMatrix[0]);
            if (textGlyf.getBounds().height > 2000) {
                d *= 100.0f;
            }
            this.writeCustom(2, "pdf.save();");
            this.writePosition(JSRoutineName, true, d);
            this.completeTextShape(gs, JSRoutineName);
            if (!isAlreadyDecoded) {
                this.drawNonPatternedShape(textGlyf, TextGs, 21610, JSRoutineName, null, null);
                this.glyfsRasterized.put(cacheKey, "x");
            }
            this.completeRasterizedText();
        }
    }

    protected void completeTextShape(GraphicsState gs, String jsRoutineName) {
        throw new RuntimeException("method root completeTextShape(GraphicsState gs, String JSRoutineName) should not be called");
    }

    protected FontMapper getFontMapper(PdfFont currentFontData) {
        return null;
    }

    @Override
    public void drawShape(Shape currentShape, GraphicsState gs, int cmd) {
        if (gs.getFillType() == 2) {
            double x = currentShape.getBounds2D().getX();
            double y = currentShape.getBounds2D().getY();
            double width = currentShape.getBounds2D().getWidth();
            double height = currentShape.getBounds2D().getHeight();
            float lineWidth = gs.getCTMAdjustedLineWidth();
            if (height <= 1.0 && lineWidth <= 1.0f) {
                gs.setFillType(1);
                gs.setStrokeColor(gs.getNonstrokeColor());
                gs.setCTMAdjustedLineWidth(0.1f);
                currentShape = new Line2D.Double(x, y, x + width, y);
            }
            if (width <= 1.0 && lineWidth <= 1.0f) {
                gs.setFillType(1);
                gs.setStrokeColor(gs.getNonstrokeColor());
                gs.setCTMAdjustedLineWidth(0.1f);
                currentShape = new Line2D.Double(x, y, x, y + height);
            }
        }
        if (!this.isObjectVisible(currentShape.getBounds(), gs.getClippingShape())) {
            return;
        }
        this.flushText();
        if (this.emulateEvenOdd || gs.getNonstrokeColor().isPattern() || gs.nonstrokeColorSpace.getID() == 1146450818) {
            this.drawPatternedShape(currentShape, gs);
        } else {
            this.drawNonPatternedShape(currentShape, gs, cmd, null, this.cropBox, this.midPoint);
        }
    }

    protected void drawNonPatternedShape(Shape currentShape, GraphicsState gs, int cmd, String name, Rectangle2D cropBox, Point2D midPoint) {
    }

    protected void drawPatternedShape(Shape currentShape, GraphicsState gs) {
        double iw = currentShape.getBounds2D().getWidth();
        double ih = currentShape.getBounds2D().getHeight();
        double ix = currentShape.getBounds2D().getX();
        double iy = currentShape.getBounds2D().getY();
        this.coords = new double[]{ix, iy};
        this.correctCoords(this.coords);
        int ixScaled = (int)(this.coords[0] * (double)this.scaling);
        int iwScaled = (int)((this.coords[0] + iw - (double)((int)this.coords[0])) * (double)this.scaling + 1.0);
        int iyScaled = (int)((this.coords[1] - ih) * (double)this.scaling);
        int ihScaled = (int)((this.coords[1] + ih - (double)((int)this.coords[1])) * (double)this.scaling + 1.0);
        if (iwScaled < 1 || ihScaled < 1) {
            return;
        }
        BufferedImage img = new BufferedImage(iwScaled, ihScaled, 2);
        Graphics2D g2 = img.createGraphics();
        AffineTransform aff = new AffineTransform();
        PdfPaint col = this.emulateEvenOdd ? gs.nonstrokeColorSpace.getColor() : gs.getNonstrokeColor();
        aff.scale(this.scaling, this.scaling);
        aff.scale(1.0, -1.0);
        aff.translate(0.0, -ih);
        aff.translate(-ix, -iy);
        int pageH = this.pageData.getCropBoxHeight(this.pageNumber);
        boolean pageY = false;
        col.setScaling(0.0, pageH, this.scaling, 0.0f, (float)pageY);
        col.setRenderingType(4);
        g2.setTransform(aff);
        g2.setPaint(col);
        if (this.emulateEvenOdd) {
            Area clipShape = gs.getClippingShape();
            if (clipShape != null) {
                g2.clip(clipShape);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.fill(currentShape);
        if (!this.emulateEvenOdd) {
            g2.draw(currentShape);
        }
        Rectangle shading = new Rectangle(ixScaled, iyScaled, iwScaled, ihScaled);
        Rectangle2D.Double cropBoxScaled = new Rectangle2D.Double(this.cropBox.getX() * (double)this.scaling, this.cropBox.getY() * (double)this.scaling, this.cropBox.getWidth() * (double)this.scaling, this.cropBox.getHeight() * (double)this.scaling);
        if (cropBoxScaled.intersects(shading)) {
            ++this.shadeId;
            if (this.pageRotation == 90 || this.pageRotation == 270) {
                iyScaled = (int)(((RectangularShape)cropBoxScaled).getHeight() - (double)iyScaled - (double)ihScaled);
                int tmp = iwScaled;
                iwScaled = ihScaled;
                ihScaled = tmp;
                tmp = ixScaled;
                ixScaled = iyScaled;
                iyScaled = tmp;
                img = this.rotateImage(img, this.pageRotation);
            }
            if (this.embedImageAsBase64) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)img, "PNG", bos);
                    bos.close();
                    this.imageArray = new BASE64Encoder().encode(bos.toByteArray());
                    this.imageArray = this.imageArray.replace("\r\n", "\\\r\n");
                }
                catch (IOException e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
            } else {
                String imageDir = this.fileName + "/shade/";
                File imgDir = new File(this.rootDir + imageDir);
                if (!imgDir.exists()) {
                    imgDir.mkdirs();
                }
                this.currentPatternedShapeName = this.customIO.writeImage(this.rootDir, imageDir + this.shadeId, img);
            }
            this.currentPatternedShape = new int[]{ixScaled, iyScaled, iwScaled, ihScaled};
        } else {
            this.currentPatternedShape = new int[]{-1, -1, -1, -1};
        }
    }

    private boolean isObjectVisible(Rectangle bounds, Area clip) {
        if (!this.emulateEvenOdd && this.dx == 0 && this.dy == 0 && this.dr == 0) {
            Rectangle clipBox = clip != null ? clip.getBounds() : null;
            int boundsStartX = bounds.x;
            int boundsStartY = bounds.y;
            int boundsEndX = bounds.width + boundsStartX;
            int boundsEndY = bounds.height + boundsStartY;
            if (this.cropBox != null) {
                double cropStartX = this.cropBox.getBounds2D().getX();
                double cropStartY = this.cropBox.getBounds2D().getY();
                double cropEndX = this.cropBox.getBounds2D().getWidth() + cropStartX;
                double cropEndY = this.cropBox.getBounds2D().getHeight() + cropStartY;
                if ((double)boundsEndX < cropStartX || (double)boundsStartX > cropEndX || (double)boundsEndY < cropStartY || (double)boundsStartY > cropEndY) {
                    return false;
                }
            }
            if (clipBox != null) {
                int clipStartX = clipBox.x;
                int clipStartY = clipBox.y;
                int clipEndX = clipBox.width + clipStartX;
                int clipEndY = clipBox.height + clipStartY;
                if (boundsEndX < clipStartX || boundsStartX > clipEndX || boundsEndY < clipStartY || boundsStartY > clipEndY) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public final void drawXForm(DynamicVectorRenderer dvr, GraphicsState gs) {
        this.flushText();
        this.renderXForm(dvr, gs.getAlpha(1));
    }

    protected void completeOutput() {
    }

    @Override
    public void setOutputDir(String outputDir, String outputFilename, String pageNumberAsString) {
        this.rootDir = outputDir;
        this.fileName = outputFilename;
        this.pageNumberAsString = pageNumberAsString;
    }

    protected String coordsToStringParam(double[] coords, int count) {
        String result = "";
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                result = result + ",";
            }
            result = result + this.setPrecision(coords[i]);
        }
        return result;
    }

    protected void correctCoords(double[] coords) {
        coords[0] = coords[0] - this.midPoint.getX();
        coords[0] = coords[0] + this.cropBox.getWidth() / 2.0;
        coords[1] = coords[1] - this.midPoint.getY();
        coords[1] = 0.0 - coords[1];
        coords[1] = coords[1] + this.cropBox.getHeight() / 2.0;
    }

    protected static String rgbToColor(int raw) {
        int r = raw >> 16 & 0xFF;
        int g = raw >> 8 & 0xFF;
        int b = raw & 0xFF;
        return "rgb(" + r + ',' + g + ',' + b + ')';
    }

    public static String hexColor(int rgb) {
        String hexColor = Integer.toHexString(rgb);
        hexColor = hexColor.substring(2, 8);
        hexColor = '#' + hexColor;
        return hexColor;
    }

    public static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd - MMMMM - yyyy");
        Date date = new Date();
        return dateFormat.format(date);
    }

    protected void drawTextArea() {
    }

    protected void drawPageBorder() {
    }

    @Override
    public void flagCommand(int commandID, int tokenNumber) {
        switch (commandID) {
            case 16980: {
                break;
            }
            case 21610: {
                this.currentTokenNumber = tokenNumber;
            }
        }
    }

    protected String replaceTokenValues(String name) {
        String nameOfPDF = this.rootDir.substring(0, this.rootDir.length() - 1);
        int pt = nameOfPDF.lastIndexOf(92);
        int fowardSlash = nameOfPDF.lastIndexOf(47);
        if (fowardSlash > pt) {
            pt = fowardSlash;
        }
        nameOfPDF = nameOfPDF.substring(pt + 1);
        if (name != null && name.contains("$")) {
            String fileName = nameOfPDF;
            String pageCount = String.valueOf(this.pageData.getPageCount());
            name = name.replace("$filename$", fileName);
            name = name.replace("$pagecount$", pageCount);
        }
        return name;
    }

    @Override
    public boolean isScalingControlledByUser() {
        return this.userControlledImageScaling;
    }

    protected static String setJavaFxWeight(String weight) {
        String javaFxWeight = "";
        if (weight.equals("normal")) {
            javaFxWeight = "NORMAL";
        } else if (weight.equals("bold")) {
            javaFxWeight = "BOLD";
        } else if (weight.equals("bolder")) {
            javaFxWeight = "BLACK";
        } else if (weight.equals("lighter")) {
            javaFxWeight = "EXTRA_LIGHT";
        } else if (weight.equals("100")) {
            javaFxWeight = "THIN";
        } else if (weight.equals("900")) {
            javaFxWeight = "BLACK";
        }
        return javaFxWeight;
    }

    protected void flushText() {
        if (this.currentTextBlock == null || this.currentTextBlock.isEmpty()) {
            return;
        }
        this.writeoutTextAsDiv(this.getFontScaling());
        if (!this.currentTextBlock.isEmpty()) {
            this.previousTextBlock = this.currentTextBlock;
        }
        this.currentTextBlock = new TextBlock();
    }

    private float getFontScaling() {
        float fontScaling = 0.0f;
        float[] aff = this.currentTextPosition.getRawAffine();
        fontScaling = aff[2] == 0.0f ? aff[3] : (aff[3] == 0.0f ? aff[2] : (float)Math.sqrt(aff[2] * aff[2] + aff[3] * aff[3]));
        fontScaling = Math.abs(fontScaling);
        return fontScaling;
    }

    private float getFontScalingMarksNewVersion() {
        float fontScaling = 0.0f;
        float[] aff = this.currentTextPosition.getRawAffine();
        if (aff[0] == 0.0f) {
            System.out.println("1");
            fontScaling = aff[1];
        } else if (aff[1] == 0.0f) {
            System.out.println("2");
            fontScaling = aff[0];
        } else {
            System.out.println("3");
            fontScaling = (float)Math.sqrt(aff[2] * aff[2] + aff[3] * aff[3]);
        }
        fontScaling = Math.abs(fontScaling);
        return fontScaling;
    }

    protected void writeoutTextAsDiv(float fontScaling) {
    }

    protected void writePosition(String JSRoutineName, boolean isShape, float fontScaling) {
        double ty;
        double tx;
        float[] aff = new float[4];
        double[] coords = this.currentTextPosition.getCoords();
        float[][] rotatedTrm = new float[3][3];
        switch (this.pageRotation) {
            default: {
                rotatedTrm = this.currentTextPosition.getTrm();
                tx = coords[0] * (double)this.scaling;
                ty = coords[1] * (double)this.scaling;
                aff[0] = rotatedTrm[0][0];
                aff[1] = rotatedTrm[0][1];
                aff[2] = rotatedTrm[1][0];
                aff[3] = rotatedTrm[1][1];
                if (isShape) {
                    if (aff[3] != 0.0f) {
                        aff[3] = -aff[3];
                    }
                } else {
                    if (this.type != 5 && this.type != 6) {
                        tx -= (double)(aff[1] * this.scaling);
                        ty -= (double)(aff[3] * this.scaling);
                    }
                    if (aff[2] != 0.0f) {
                        aff[2] = -aff[2];
                    }
                }
                if (aff[1] == 1.0f) break;
                aff[1] = -aff[1];
                break;
            }
            case 90: {
                ty = coords[0] * (double)this.scaling;
                tx = (this.cropBox.getHeight() - coords[1]) * (double)this.scaling;
                float[][] rotated = isShape ? Matrix.multiply(this.currentTextPosition.getTrm(), new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}) : Matrix.multiply(new float[][]{{0.0f, 1.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}, this.currentTextPosition.getTrm());
                aff[0] = rotated[0][0];
                aff[1] = rotated[0][1];
                aff[2] = rotated[1][0];
                aff[3] = rotated[1][1];
                if (isShape) break;
                if (aff[0] < 0.0f && aff[3] < 0.0f) {
                    aff[0] = -aff[0];
                    aff[3] = -aff[3];
                }
                tx += (double)(aff[1] * this.scaling);
                ty -= (double)(aff[3] * this.scaling);
                break;
            }
            case 180: {
                tx = (this.cropBox.getWidth() - coords[0]) * (double)this.scaling;
                ty = (this.cropBox.getHeight() - coords[1]) * (double)this.scaling;
                rotatedTrm = Matrix.multiply(this.currentTextPosition.getTrm(), new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                aff[0] = rotatedTrm[0][0];
                aff[1] = rotatedTrm[0][1];
                aff[2] = rotatedTrm[1][0];
                aff[3] = rotatedTrm[1][1];
                if (isShape) break;
                aff[0] = -aff[0];
                ty -= (double)(aff[3] * this.scaling);
                break;
            }
            case 270: {
                ty = (this.cropBox.getWidth() - coords[0]) * (double)this.scaling;
                tx = coords[1] * (double)this.scaling;
                float[][] rotated = isShape ? Matrix.multiply(this.currentTextPosition.getTrm(), new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}) : Matrix.multiply(this.currentTextPosition.getTrm(), new float[][]{{0.0f, -1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                aff[0] = rotated[0][0];
                aff[1] = rotated[0][1];
                aff[2] = rotated[1][0];
                aff[3] = rotated[1][1];
                if (isShape) break;
                if (aff[0] < 0.0f && aff[3] < 0.0f) {
                    aff[0] = -aff[0];
                    aff[3] = -aff[3];
                }
                tx += (double)(aff[1] * this.scaling);
            }
        }
        for (int ii = 0; ii < 4; ++ii) {
            if ((double)aff[ii] != -0.0) continue;
            aff[ii] = 0.0f;
        }
        if (isShape) {
            this.writeRasterizedTextPosition(JSRoutineName, aff, (int)tx, (int)ty, fontScaling);
        } else {
            this.writeTextPosition(aff, (int)tx, (int)ty, fontScaling);
        }
    }

    protected void writeTextPosition(float[] aff, int tx, int ty, float scaling) {
        throw new RuntimeException("writeTextPosition(float[] aff, int tx, int ty, int scaling)");
    }

    protected void writeRasterizedTextPosition(String JSRoutineName, float[] aff, int tx, int ty, float fontScaling) {
        throw new RuntimeException("method root writeRasterizedTextPosition(String JSRoutineName, float[] aff, int tx, int ty) should not be called");
    }

    protected void completeRasterizedText() {
        throw new RuntimeException("completeRasterizedText");
    }

    protected static String tidy(float val) {
        return OutputDisplay.removeEmptyDecimals(String.valueOf(val));
    }

    private static String removeEmptyDecimals(String numberValue) {
        int ptr = numberValue.indexOf(46);
        if (ptr > -1) {
            boolean onlyZeros = true;
            int len = numberValue.length();
            for (int ii = ptr + 1; ii < len; ++ii) {
                if (numberValue.charAt(ii) == '0') continue;
                onlyZeros = false;
                ii = len;
            }
            if (onlyZeros) {
                numberValue = numberValue.substring(0, ptr);
            }
        }
        return numberValue;
    }

    @Override
    public void saveAdvanceWidth(String fontName, String glyphName, int width) {
        HashMap<String, Integer> font = this.widths.get(fontName = fontName.replace('+', '-'));
        if (font == null) {
            font = new HashMap();
            this.widths.put(fontName, font);
        }
        font.put(glyphName, width);
    }

    public String getPageAsHTMLRef(int pageNumber) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageNumber > this.endPage) {
            pageNumber = this.endPage;
        }
        String pageAsString = String.valueOf(pageNumber);
        if (this.firstPageName != null && pageNumber == 1) {
            pageAsString = this.firstPageName;
        } else {
            String maxNumberOfPages = String.valueOf(this.endPage);
            int padding = maxNumberOfPages.length() - pageAsString.length();
            for (int ii = 0; ii < padding; ++ii) {
                pageAsString = '0' + pageAsString;
            }
        }
        return pageAsString;
    }

    protected String getMagazinePageAsHTMLRef(int pageNumber) {
        if (pageNumber == 1) {
            return this.getPageAsHTMLRef(pageNumber);
        }
        if (pageNumber % 2 == 0) {
            if (pageNumber == this.endPage) {
                return this.getPageAsHTMLRef(pageNumber);
            }
            return this.getPageAsHTMLRef(pageNumber) + "-" + this.getPageAsHTMLRef(pageNumber + 1);
        }
        return this.getPageAsHTMLRef(pageNumber - 1) + "-" + this.getPageAsHTMLRef(pageNumber);
    }

    @Override
    public boolean avoidDownSamplingImage() {
        return this.keepOriginalImage;
    }
}

