/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.awt.Rectangle;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.OutputDisplay;

public class TextBlock {
    private float rotatedXCoord;
    private float rawXCoord;
    private float rotatedYCoord;
    private float rawYCoord;
    private float yAdjust;
    private float lastXCoord;
    private float stringWidth;
    private Rectangle cropBox;
    private int fontSize;
    private String font = "";
    private String realFont = "";
    private String weight = "normal";
    private String style = "normal";
    private float spaceWidth;
    private int fontAdjust = 0;
    private String text;
    private int textColRGB;
    private float[][] matrix;
    private float[][] Trm;
    private float lastYUsed;
    private float lastX = 0.0f;
    private int maxSpacesAllowed = 3;
    boolean convertSpacesTonbsp;
    int altFontSize;
    int fontCondition = -1;
    int pageRotation;

    public TextBlock() {
        this.text = "";
        this.textColRGB = -1;
        this.stringWidth = 0.0f;
    }

    public int getAltFontSize() {
        return this.altFontSize;
    }

    public TextBlock(String glyf, int fontSize, FontMapper fontMapper, float[][] matrix, float x, float y, float charWidth, int color, float spaceWidth, Rectangle cropBox, float[][] trm, int altFontSize, int fontCondition, float rotX, float rotY, int pageRotation) {
        this.text = glyf;
        this.matrix = matrix;
        this.lastXCoord = rotX + charWidth;
        this.rawXCoord = x;
        this.rotatedXCoord = rotX;
        this.rawYCoord = y;
        this.rotatedYCoord = rotY;
        this.stringWidth = charWidth;
        this.fontSize = fontSize;
        this.font = fontMapper.getFont(false);
        this.realFont = fontMapper.getFont(true);
        this.weight = fontMapper.getWeight();
        this.style = fontMapper.getStyle();
        this.fontAdjust = fontMapper.getFontSizeAdjustment();
        this.textColRGB = color;
        this.spaceWidth = spaceWidth;
        this.cropBox = cropBox;
        this.Trm = trm;
        this.altFontSize = altFontSize;
        this.fontCondition = fontCondition;
        this.pageRotation = pageRotation;
        this.lastX = trm[2][0];
        if (!cropBox.contains(x + charWidth, y)) {
            this.text = "";
        }
    }

    public boolean isEmpty() {
        return this.text.length() == 0;
    }

    public float getX() {
        return this.rawXCoord;
    }

    public float getY() {
        return this.rawYCoord + this.yAdjust;
    }

    public void adjustY(float y) {
        this.yAdjust = y;
    }

    public float getWidth() {
        return this.stringWidth;
    }

    public int getFontSize() {
        if (this.matrix != null && this.matrix[0][0] * this.matrix[0][1] != 0.0f) {
            float sum2;
            float sum1;
            float x2;
            float x1 = this.matrix[0][0];
            if (x1 < 0.0f) {
                x1 = -x1;
            }
            if ((x2 = this.matrix[0][1]) < 0.0f) {
                x2 = -x2;
            }
            float result = (sum1 = x1 + (float)this.fontSize * x2) > (sum2 = (float)this.fontSize * x1 + x2) ? sum1 : sum2;
            return (int)Math.ceil(Math.abs(result) / (float)this.fontSize);
        }
        return this.fontSize;
    }

    public String getFont() {
        return this.realFont;
    }

    public String getWeight() {
        return this.weight;
    }

    public int getColor() {
        return this.textColRGB;
    }

    private boolean compareTrm(float[][] newTrm) {
        if (this.matrix == null) {
            return false;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 2; ++x) {
                if (newTrm[x][y] == this.matrix[x][y]) continue;
                return false;
            }
        }
        return true;
    }

    public float getRotationAngle() {
        float sum = Math.abs(this.matrix[0][0]) + Math.abs(this.matrix[0][1]);
        float angle = (float)Math.acos(this.matrix[0][0] / sum);
        if (angle != 0.0f && this.matrix[1][0] < 0.0f && this.matrix[0][1] > 0.0f) {
            angle = -angle;
        }
        return angle;
    }

    public int getRotationAngleInDegrees() {
        int angle;
        for (angle = (int)((double)(this.getRotationAngle() * 180.0f) / Math.PI); angle < 0; angle += 360) {
        }
        return angle;
    }

    private void concat(String s) {
        this.text = this.text + s;
    }

    public String getOutputString(boolean isOutput) {
        String result = this.text;
        if (isOutput && OutputDisplay.Helper != null) {
            result = OutputDisplay.Helper.tidyText(result);
            if (this.convertSpacesTonbsp) {
                result = result.replaceAll(" ", "&nbsp;");
            }
        }
        return result;
    }

    public boolean isSameFont(int otherfontSize, FontMapper otherMapper, float[][] newTrm, int color) {
        float ratio = this.fontSize < 18 || otherfontSize < 18 ? 0.0f : (this.fontSize < otherfontSize ? (float)this.fontSize / (float)otherfontSize : (float)otherfontSize / (float)this.fontSize);
        return (this.compareTrm(newTrm) && this.fontSize == otherfontSize || ratio > 0.8f) && this.compareFontMapper(otherMapper) && this.textColRGB == color;
    }

    private boolean compareFontMapper(FontMapper mapper) {
        return mapper.getFont(false).equals(this.font) && mapper.getWeight().equals(this.weight);
    }

    public boolean appendText(String glyf, float charWidth, float x, float y, boolean groupTJGlyphs, boolean checkGaps, float realX, float realY) {
        if (!this.cropBox.contains(realX, realY)) {
            return false;
        }
        float lineYChange = this.rotatedYCoord - y;
        if (Math.abs(lineYChange) < 0.01f) {
            lineYChange = 0.0f;
            this.rotatedYCoord = y;
        }
        float lineXChange = x - this.lastXCoord;
        if (this.getRotationAngleInDegrees() == 180) {
            lineXChange -= charWidth;
        }
        if (!groupTJGlyphs && glyf.equals(" ") && lineYChange == 0.0f && lineXChange < -charWidth) {
            return true;
        }
        if (!groupTJGlyphs && glyf.equals(" ")) {
            return false;
        }
        if (lineXChange < 0.0f && lineXChange > -charWidth) {
            lineXChange = 0.0f;
        }
        if (this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][0] < 0.0f) {
            float estimatedCharDiff = (this.lastYUsed - y) / (float)this.fontSize;
            if ((double)estimatedCharDiff > 1.5) {
                return false;
            }
            if (!(this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.lastX == x || lineYChange == 0.0f && !(lineXChange < -1.5f))) {
                return false;
            }
        } else if (lineYChange != 0.0f || lineXChange < -1.5f) {
            return false;
        }
        String spaces = "";
        int spaceCount = (int)(lineXChange / this.spaceWidth);
        float percentageOfSpaceSize = lineXChange % this.spaceWidth;
        if ((percentageOfSpaceSize /= this.spaceWidth) > PdfStreamDecoder.currentThreshold) {
            ++spaceCount;
        }
        if ((checkGaps || spaceCount > this.maxSpacesAllowed) && (spaceCount > 2 || spaceCount > 0 && this.matrix[0][0] == 0.0f && this.matrix[1][1] == 0.0f)) {
            return false;
        }
        while (spaceCount-- > 0) {
            spaces = spaces + " ";
        }
        spaces = spaces + glyf;
        this.concat(spaces);
        if (this.Trm[0][0] == 0.0f && this.Trm[1][1] == 0.0f && this.Trm[0][1] > 0.0f && this.Trm[1][0] < 0.0f && this.pageRotation == 0) {
            this.stringWidth = this.rotatedYCoord - y + charWidth;
        } else {
            this.stringWidth = x - this.rotatedXCoord + charWidth;
            this.lastXCoord = x + charWidth;
        }
        this.lastYUsed = y;
        return true;
    }

    public boolean hasSameFont(TextBlock otherBlock) {
        return this.font.equals(otherBlock.font) && this.weight.equals(otherBlock.weight) && this.getFontSize() == otherBlock.getFontSize();
    }

    public String getStyle() {
        return this.style;
    }

    public String toString() {
        String result = "text[" + this.text + "]\tfontSize[" + this.fontSize + "]\tspaceWidth[" + this.spaceWidth + "]\tcoord[" + this.rawXCoord + ", " + this.rawYCoord + ']';
        return result;
    }

    public int getFontAdjustment() {
        return this.fontAdjust;
    }

    public static boolean ignoreGlyf(String glfy) {
        return glfy.codePointAt(0) == 65533;
    }

    public void convertSpacesTonbsp(boolean convertSpacesTonbsp) {
        this.convertSpacesTonbsp = convertSpacesTonbsp;
    }

    public int getFontCondition() {
        return this.fontCondition;
    }
}

