/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.GenericFontMapper;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.javafx.FXMLShape;
import org.jpedal.render.output.javafx.JavaFXHelper;
import org.jpedal.utils.LogWriter;

public class FXMLDisplay
extends OutputDisplay {
    String packageName = "";
    private int lastFontTextLength;
    private int fontTextLength;
    private int lastFontSizeAsString;
    private String textWithSpaces;
    private int shapeCount = 0;
    private String divName;
    private String javaFxFileName = "";
    private int textX;
    private int textY;
    private String currentAffine = "";
    private boolean simpleText;

    public FXMLDisplay(int pageNumber, Point2D midPoint, Rectangle cropBox, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        super(pageNumber, midPoint, cropBox, addBackground, defaultSize, newObjectRef, null);
        this.type = 6;
        Helper = new JavaFXHelper();
        this.firstPageName = System.getProperty("org.jpedal.pdf2javafx.firstPageName");
        Pattern p = Pattern.compile("[^a-zA-Z]");
        if (this.firstPageName != null && (this.firstPageName.length() == 0 || p.matcher(this.firstPageName.substring(0, 1)).find())) {
            throw new RuntimeException("org.jpedal.pdf2javafx.firstPageName must begin with a character A-Z or a-z.");
        }
    }

    public static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd - MMMMM - yyyy");
        Date date = new Date();
        return dateFormat.format(date);
    }

    @Override
    protected void completeOutput() {
        boolean onePageFile;
        block5: {
            this.flushText();
            onePageFile = false;
            if (this.endPage == 1 || this.endPage - this.startPage == 0) {
                onePageFile = true;
            }
            this.writeCustom(0, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writeCustom(0, "");
            this.writeCustom(0, "<?import java.lang.*?>");
            this.writeCustom(0, "<?import javafx.scene.*?>");
            this.writeCustom(0, "<?import javafx.scene.control.*?>");
            this.writeCustom(0, "<?import javafx.scene.layout.*?>");
            this.writeCustom(0, "<?import javafx.scene.image.*?>");
            this.writeCustom(0, "<?import javafx.scene.shape.*?>");
            this.writeCustom(0, "<?import javafx.scene.text.*?>");
            this.writeCustom(0, "");
            this.writeCustom(0, "<BorderPane prefHeight=\"" + (this.pageData.getCropBoxHeight(this.pageNumber) + 50) + "\" prefWidth=\"" + this.pageData.getCropBoxWidth(this.pageNumber) + "\" xmlns:fx=\"http://javafx.com/fxml\" fx:controller=\"" + this.packageName + "." + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + "\">");
            this.writeCustom(0, "\t");
            this.writeCustom(0, "\t<center>");
            this.writeCustom(0, "\t");
            this.writeCustom(0, "\t\t<Pane fx:id=\"PDFContent\">");
            this.writeCustom(0, "");
            this.writeCustom(0, "");
            try {
                this.writeCustom(0, this.script.toString());
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.writeCustom(0, "\t\t</Pane>");
        this.writeCustom(0, "\t");
        this.writeCustom(0, "\t</center>");
        if (!onePageFile) {
            this.writeCustom(0, "\n\t<bottom>");
            this.writeCustom(0, "\t\t<HBox id=\"navBar\" alignment=\"center\" spacing=\"5\" style=\"-fx-background-color: #F0F8FF\" prefHeight=\"50\" prefWidth=\"" + this.pageData.getCropBoxWidth(this.pageNumber) + "\" layoutY=\"" + (this.pageData.getCropBoxHeight(this.pageNumber) + 10) + '\"' + '>');
            this.writeCustom(0, "\t\t\t<children>");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\t<Button id=\"start\" onAction=\"#firstPage\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"First page\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smstart.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Button id=\"back10Pages\" onAction=\"#previous10Pages\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Previous 10 pages\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smfback.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Button id=\"backOnePage\" onAction=\"#previousPage\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Previous page\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smback.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<TextField alignment=\"center\" text= \"" + this.pageNumber + "\" maxHeight=\"25\" prefWidth=\"50\" editable= \"NO\"/>");
            this.writeCustom(0, "\t\t\t\t<Label text=\":\" style=\"-fx-font: DARK 26 Arial;\"/>");
            this.writeCustom(0, "\t\t\t\t<TextField alignment=\"center\" text= \"" + this.endPage + "\" maxHeight=\"25\" prefWidth=\"50\" editable= \"NO\"/>");
            this.writeCustom(0, "\t\t\t\t<Button id=\"forward\" onAction=\"#nextPage\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Next page\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smforward.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Button id=\"next10Pages\" onAction=\"#next10Pages\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Next 10 pages\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smfforward.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Button  id=\"end\" onAction=\"#endPage\" >");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Last page\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/smend.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t</Button>");
            this.writeCustom(0, "\t\t\t\t<Hyperlink onAction=\"#ourWebSite\">");
            this.writeCustom(0, "\t\t\t\t\t<graphic>");
            this.writeCustom(0, "\t\t\t\t\t\t<ImageView>");
            this.writeCustom(0, "\t\t\t\t\t\t\t<image>");
            this.writeCustom(0, "\t\t\t\t\t\t\t\t<Image url=\"@icons/logo.gif\"/>");
            this.writeCustom(0, "\t\t\t\t\t\t\t</image>");
            this.writeCustom(0, "\t\t\t\t\t\t</ImageView>");
            this.writeCustom(0, "\t\t\t\t\t</graphic>");
            this.writeCustom(0, "\t\t\t\t\t<tooltip>");
            this.writeCustom(0, "\t\t\t\t\t\t<Tooltip text=\"Visit our website\" />");
            this.writeCustom(0, "\t\t\t\t\t</tooltip>");
            this.writeCustom(0, "\t\t\t\t</Hyperlink>");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t</children>");
            this.writeCustom(0, "\t\t</HBox>");
            this.writeCustom(0, "\t</bottom>");
        }
        this.writeCustom(0, "</BorderPane>");
        this.createMainClassContent(onePageFile);
        if (!onePageFile) {
            this.createFXMLPDFStage();
        }
        this.customIO.flush();
    }

    private String createFXMLPDFStage() {
        String fxmlPDFStagePath;
        block3: {
            this.writeCustom(13, "/**");
            this.writeCustom(13, "* ===========================================");
            this.writeCustom(13, "* Java Pdf Extraction Decoding Access Library");
            this.writeCustom(13, "* ===========================================");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* Project Info:  http://www.idrsolutions.com");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* generated by JPedal PDF to FXML");
            this.writeCustom(13, "*");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* PDFStage.java");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "* " + FXMLDisplay.getDate());
            this.writeCustom(13, "* --------------------------------------------");
            this.writeCustom(13, "*/");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "package " + this.packageName + ';');
            this.writeCustom(13, "");
            this.writeCustom(13, "import javafx.stage.Stage;");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "public class PDFStage {");
            this.writeCustom(13, "");
            this.writeCustom(13, "");
            this.writeCustom(13, "\tprivate static Stage stage = null;");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\tpublic static Stage getInstance(){");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t\tif(stage == null){");
            this.writeCustom(13, "\t\t\tstage = new Stage();");
            this.writeCustom(13, "\t\t}");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t\tstage.centerOnScreen();");
            this.writeCustom(13, "\t\tstage.resizableProperty().set(false);");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t\treturn stage;");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "\t}");
            this.writeCustom(13, "\t");
            this.writeCustom(13, "}");
            fxmlPDFStagePath = this.rootDir;
            File fxmlPDFStageDir = new File(fxmlPDFStagePath);
            if (!fxmlPDFStageDir.exists()) {
                fxmlPDFStageDir.mkdirs();
            }
            try {
                PrintWriter fxmlPDFStageOutput = new PrintWriter(new FileOutputStream(fxmlPDFStagePath + "PDFStage.java"));
                fxmlPDFStageOutput.println(this.fxmlPDFStage.toString());
                fxmlPDFStageOutput.flush();
                fxmlPDFStageOutput.close();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return fxmlPDFStagePath;
    }

    private String createMainClassContent(Boolean onePageFile) {
        String cssPath;
        block19: {
            this.writeCustom(4, "/**");
            this.writeCustom(4, "* ===========================================");
            this.writeCustom(4, "* Java Pdf Extraction Decoding Access Library");
            this.writeCustom(4, "* ===========================================");
            this.writeCustom(4, "*");
            this.writeCustom(4, "* Project Info:  http://www.idrsolutions.com");
            this.writeCustom(4, "*");
            this.writeCustom(4, "* generated by JPedal PDF to FXML");
            this.writeCustom(4, "*");
            this.writeCustom(4, "* --------------------------------------------");
            this.writeCustom(4, "* " + this.packageName + ".pdf");
            this.writeCustom(4, "* --------------------------------------------");
            this.writeCustom(4, "* --------------------------------------------");
            this.writeCustom(4, "* " + FXMLDisplay.getDate());
            this.writeCustom(4, "* --------------------------------------------");
            this.writeCustom(4, "*/");
            this.writeCustom(4, "");
            this.writeCustom(4, "");
            this.writeCustom(4, " package " + this.packageName + ';');
            this.writeCustom(4, "");
            this.writeCustom(4, "");
            this.writeCustom(4, " import java.io.IOException;");
            this.writeCustom(4, " import java.net.URI;");
            this.writeCustom(4, " import java.net.URISyntaxException;");
            this.writeCustom(4, " import javafx.application.Application;");
            this.writeCustom(4, " import java.net.URL;");
            this.writeCustom(4, " import java.util.ResourceBundle;");
            this.writeCustom(4, " import javafx.fxml.Initializable;");
            this.writeCustom(4, " import javafx.fxml.FXMLLoader;");
            this.writeCustom(4, " import javafx.scene.Parent;");
            this.writeCustom(4, " import javafx.scene.Scene;");
            this.writeCustom(4, " import javafx.stage.Stage;");
            this.writeCustom(4, " import javafx.fxml.FXML;");
            this.writeCustom(4, " import javafx.event.ActionEvent;");
            this.writeCustom(4, " import javafx.scene.text.Text;");
            this.writeCustom(4, " import javafx.scene.text.Font;");
            this.writeCustom(4, " import javafx.scene.text.FontPosture;");
            this.writeCustom(4, " import javafx.scene.text.FontWeight;");
            if (!onePageFile.booleanValue()) {
                this.writeCustom(4, " import javafx.scene.layout.Pane;");
                this.writeCustom(4, " import javafx.util.Duration;");
                this.writeCustom(4, " import javafx.animation.FadeTransition;");
                this.writeCustom(4, " import javafx.scene.Node;");
                this.writeCustom(4, " import java.lang.reflect.Method;");
            }
            this.writeCustom(4, " ");
            this.writeCustom(4, "");
            this.writeCustom(4, "");
            this.writeCustom(4, "public class " + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + " extends Application implements Initializable{");
            this.writeCustom(4, "");
            if (!onePageFile.booleanValue()) {
                this.writeCustom(4, "\t@FXML private Pane PDFContent;");
            }
            for (int i = 1; i <= this.textID - 1; ++i) {
                this.writeCustom(4, "\t@FXML private Text tb_" + i + ';');
            }
            this.writeCustom(4, "");
            this.writeCustom(4, "\tpublic static void main(String[] args) {");
            this.writeCustom(4, "\t\tApplication.launch(" + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".class, args);");
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "\t");
            this.writeCustom(4, "\t@Override");
            this.writeCustom(4, "\tpublic void start(Stage stage) throws Exception {");
            if (!onePageFile.booleanValue()) {
                this.writeCustom(4, "\t\tstage = PDFStage.getInstance();");
            }
            this.writeCustom(4, "\t\tloadPage(stage);");
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "");
            this.writeCustom(4, "\t@Override");
            this.writeCustom(4, "\tpublic void initialize(URL url, ResourceBundle rb) {");
            if (!onePageFile.booleanValue()) {
                this.writeCustom(4, "\t\tcreateTransition(PDFContent);");
            }
            if (this.fxmlText.size() != 0) {
                this.writeCustom(4, "\t\tdrawPage0();");
                this.writeCustom(4, "\t}\n");
                int methodNum = 0;
                int lineNum = 0;
                int lineLimit = 50;
                while (true) {
                    StringBuilder sb = new StringBuilder(lineLimit);
                    for (int ii = 0; ii < lineLimit && this.fxmlText.size() > lineNum; ++lineNum, ++ii) {
                        sb.append((String)this.fxmlText.get(lineNum) + '\n');
                    }
                    this.writeCustom(4, "\tprivate void drawPage" + methodNum + "() {");
                    this.writeCustom(4, sb.toString());
                    if (this.fxmlText.size() <= lineNum) break;
                    this.writeCustom(4, "\t\tdrawPage" + ++methodNum + "();// Chain to prevent methods being over 64KB so that the class will not refuse to compile. \n\t}\n");
                }
            }
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "\t");
            if (!onePageFile.booleanValue()) {
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void firstPage(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 0 , false , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void previous10Pages(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 10 , false , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void previousPage(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 1 , false , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void nextPage(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 1 , true , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void next10Pages(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 10 , true , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void endPage(ActionEvent event) {");
                this.writeCustom(4, "\t\tnewPage( 9999 , false , PDFStage.getInstance());");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t@FXML");
                this.writeCustom(4, "\tprivate void ourWebSite(ActionEvent event) throws IOException, URISyntaxException {");
                this.writeCustom(4, "\t\tjava.awt.Desktop.getDesktop().browse(new URI(\"http://www.idrsolutions.com/\"));");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
            }
            this.writeCustom(4, "\tpublic void loadPage(Stage stage) throws IOException {");
            this.writeCustom(4, "\t");
            this.writeCustom(4, "\t\tParent root = FXMLLoader.load(getClass().getResource(\"" + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".fxml\"));");
            this.writeCustom(4, "\t\t");
            if (onePageFile.booleanValue()) {
                this.writeCustom(4, "\t\tstage.setTitle(\"" + this.packageName + "\");");
            } else {
                this.writeCustom(4, "\t\tstage.setTitle(\"" + this.packageName + " - Page " + this.pageNumber + "\");");
            }
            this.writeCustom(4, "\t\tstage.setScene(new Scene(root));");
            this.writeCustom(4, "\t\tstage.show();");
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "\t");
            this.writeCustom(4, "\tprivate static void setTextsize(Text textBox, float requiredWidth) {");
            this.writeCustom(4, "\t\tfloat actualWidth=(int) textBox.getLayoutBounds().getWidth();");
            this.writeCustom(4, "\t\tfloat dx=requiredWidth-actualWidth;");
            this.writeCustom(4, "\t\tfloat scalingNeeded=requiredWidth/actualWidth;");
            this.writeCustom(4, "\t\ttextBox.setScaleX(scalingNeeded);");
            this.writeCustom(4, "\t\ttextBox.setScaleY(scalingNeeded);");
            this.writeCustom(4, "\t\ttextBox.setTranslateX(dx/2);");
            this.writeCustom(4, "\t}");
            this.writeCustom(4, "\t");
            if (!onePageFile.booleanValue()) {
                this.writeCustom(4, "\tprivate static void createTransition(Node i){");
                this.writeCustom(4, "\t\tFadeTransition fadeOutTransition = new FadeTransition(Duration.seconds(2), i);");
                this.writeCustom(4, "\t\tfadeOutTransition.setFromValue(0.0);");
                this.writeCustom(4, "\t\tfadeOutTransition.setToValue(3.0);");
                this.writeCustom(4, "\t\tfadeOutTransition.play();");
                this.writeCustom(4, "\t}");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\tprivate static void newPage(int change, boolean forward, final Stage stage) {");
                this.writeCustom(4, "\t");
                this.writeCustom(4, "\t\tfinal int currentPageNo = " + this.pageNumber + ", pageCount = " + this.endPage + " ;");
                this.writeCustom(4, "\t\tint newPageNo = 0;");
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t\tif (change == 0) { //special case 1st page");
                this.writeCustom(4, "\t\t\tnewPageNo = 1;");
                this.writeCustom(4, "\t\t} else if (change == 9999) { //special case last page");
                this.writeCustom(4, "\t\t\tnewPageNo = pageCount;");
                this.writeCustom(4, "\t\t} else {");
                this.writeCustom(4, "\t\t\tif (forward) {");
                this.writeCustom(4, "\t\t\t\tnewPageNo = currentPageNo + change;");
                this.writeCustom(4, "\t\t\t} else {");
                this.writeCustom(4, "\t\t\t\tnewPageNo = currentPageNo - change;");
                this.writeCustom(4, "\t\t\t}");
                this.writeCustom(4, "\t\t}");
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t\t//error check for bounds");
                this.writeCustom(4, "\t\tif (newPageNo < 1) {");
                this.writeCustom(4, "\t\t\tnewPageNo = 1;");
                this.writeCustom(4, "\t\t} else if (newPageNo > pageCount) {");
                this.writeCustom(4, "\t\t\tnewPageNo = pageCount;");
                this.writeCustom(4, "\t\t}");
                this.writeCustom(4, "\t\t");
                if (this.firstPageName != null && this.firstPageName.length() > 0) {
                    this.writeCustom(4, "\t\tString customClassName = \"" + this.packageName + '.' + this.firstPageName + "\";");
                    this.writeCustom(4, "\t\tboolean customFirstPage = false;");
                }
                this.writeCustom(4, "\t\t//Add zero when required as prefix of the new pages.");
                this.writeCustom(4, "\t\tString newPageNoAsString = String.valueOf(newPageNo);");
                if (this.firstPageName != null && this.firstPageName.length() > 0) {
                    this.writeCustom(4, "");
                    this.writeCustom(4, "\t\tif(newPageNoAsString.equals(\"1\"))");
                    this.writeCustom(4, "\t\t\tcustomFirstPage=true;");
                    this.writeCustom(4, "");
                }
                this.writeCustom(4, "\t\tString maxNumberOfPages = String.valueOf(pageCount);");
                this.writeCustom(4, "\t\tint padding = maxNumberOfPages.length() - newPageNoAsString.length();");
                this.writeCustom(4, "\t\tfor (int ii = 0; ii < padding; ii++) {");
                this.writeCustom(4, "\t\t\tnewPageNoAsString = '0' + newPageNoAsString;");
                this.writeCustom(4, "\t\t}");
                this.writeCustom(4, "\t\t");
                if (this.firstPageName != null && this.firstPageName.length() > 0) {
                    this.writeCustom(4, "\t\t//workout new class from pageNumber");
                    this.writeCustom(4, "\t\tString newClass=\"\";");
                    this.writeCustom(4, "\t\t");
                    this.writeCustom(4, "\t\tif(customFirstPage)");
                    this.writeCustom(4, "\t\t\tnewClass=customClassName;");
                    this.writeCustom(4, "\t\telse");
                    this.writeCustom(4, "\t\t\tnewClass=\"" + this.packageName + ".page\"+newPageNoAsString;");
                } else {
                    this.writeCustom(4, "\t\t//workout new class from pageNumber");
                    this.writeCustom(4, "\t\tString newClass=\"" + this.packageName + ".page\"+newPageNoAsString;");
                }
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t\t//create an instance");
                this.writeCustom(4, "\t\ttry {");
                this.writeCustom(4, "\t\t\tClass c = Class.forName(newClass);");
                this.writeCustom(4, "\t\t\tApplication nextPage = (javafx.application.Application) c.newInstance();");
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t\t\tMethod m = c.getMethod(\"loadPage\", new Class[]{Stage.class});");
                this.writeCustom(4, "\t\t\tm.invoke(nextPage, new Object[]{stage});");
                this.writeCustom(4, "\t\t\t");
                this.writeCustom(4, "\t\t} catch (Exception e) {");
                this.writeCustom(4, "\t\t\te.printStackTrace();");
                this.writeCustom(4, "\t\t}");
                this.writeCustom(4, "\t\t");
                this.writeCustom(4, "\t}");
            }
            this.writeCustom(4, "}");
            cssPath = this.rootDir;
            File cssDir = new File(cssPath);
            if (!cssDir.exists()) {
                cssDir.mkdirs();
            }
            try {
                PrintWriter CSSOutput = new PrintWriter(new FileOutputStream(cssPath + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".java"));
                CSSOutput.println(this.css.toString());
                CSSOutput.flush();
                CSSOutput.close();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block19;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return cssPath;
    }

    @Override
    protected void writeoutTextAsDiv(float fontScaling) {
        if (this.currentTextBlock.isEmpty()) {
            throw new RuntimeException("writeoutTextAsDiv() called incorrectly.  Attempted to write out text with empty text block use flushText.");
        }
        this.divName = "tb_" + this.textID;
        String text = this.currentTextBlock.getOutputString(true);
        int adjustedFontSize = this.currentTextBlock.getFontSize() + this.currentTextBlock.getFontAdjustment();
        int altFontSize = this.currentTextBlock.getAltFontSize();
        int fontCondition = this.currentTextBlock.getFontCondition();
        if (altFontSize > 0) {
            switch (fontCondition) {
                case 1: {
                    if (text.length() <= 32) break;
                    adjustedFontSize = altFontSize;
                    break;
                }
                case 2: {
                    adjustedFontSize = altFontSize;
                }
            }
        }
        int fontSizeAsString = (int)((float)adjustedFontSize * this.scaling);
        if (adjustedFontSize < 1) {
            return;
        }
        this.textWithSpaces = this.currentTextBlock.getOutputString(false);
        this.fontTextLength = this.textWithSpaces.length();
        this.writePosition("", false, fontScaling);
        String position = this.simpleText ? "layoutX=\"" + this.textX + "\" layoutY=\"" + this.textY + "\" " : "";
        String weight = this.currentTextBlock.getWeight();
        String fxmlWeight = FXMLDisplay.setJavaFxWeight(weight);
        String style = this.currentTextBlock.getStyle().equals("normal") ? "REGULAR" : "ITALIC";
        this.writeCustom(15, "\t" + this.divName + ".setFont(Font.font(\"" + this.currentTextBlock.getFont() + "\", FontWeight." + fxmlWeight + ", FontPosture." + style + ", " + fontSizeAsString + "));");
        String color = "";
        if (this.currentTextBlock.getColor() != -14475232) {
            color = "fill=\"" + FXMLDisplay.hexColor(this.currentTextBlock.getColor()) + "\"";
        }
        if (text.startsWith("$")) {
            text = "\u200b$" + text.substring(1);
        }
        this.writeCustom(2, "\n\t<Text fx:id=\"" + this.divName + "\" text=\"" + FXMLDisplay.tidyQuotes(text) + "\" " + position + color + ">" + this.currentAffine + "</Text>");
        ++this.textID;
    }

    @Override
    protected void writeTextPosition(float[] aff, int tx, int ty, float fontScaling) {
        if (aff[0] > 0.0f && aff[3] > 0.0f && aff[1] == 0.0f && aff[2] == 0.0f) {
            this.simpleText = true;
            this.currentAffine = "";
            this.textX = tx;
            this.textY = ty;
        } else {
            this.simpleText = false;
            this.currentAffine = "\n\t\t<transforms>\n\t\t\t<javafx.scene.transform.Affine mxx=\"" + FXMLDisplay.setPrecision(aff[0] / fontScaling, 2) + "\" myx=\"" + FXMLDisplay.setPrecision(aff[1] / fontScaling, 2) + "\" mxy=\"" + FXMLDisplay.setPrecision(aff[2] / fontScaling, 2) + "\" myy=\"" + FXMLDisplay.setPrecision(aff[3] / fontScaling, 2) + "\" tx=\"" + tx + "\" ty=\"" + ty + "\" />\n\t\t</transforms>\n\t";
        }
    }

    private static String tidyQuotes(String outputString) {
        char[] character = new char[]{'\"', '&', '<', '>', '\'', '\u00a3'};
        String[] replacement = new String[]{"&quot;", "&amp;", "&lt;", "&gt;", "&apos;", "&#163;"};
        String newOutput = "";
        for (int pos = 0; pos < outputString.length(); ++pos) {
            boolean replaced = false;
            for (int i = 0; i < character.length; ++i) {
                if (outputString.charAt(pos) != character[i]) continue;
                newOutput = newOutput + replacement[i];
                replaced = true;
                break;
            }
            if (replaced) continue;
            newOutput = newOutput + outputString.charAt(pos);
        }
        return newOutput;
    }

    @Override
    public void setBooleanValue(int key, boolean value) {
        switch (key) {
            case 4: {
                this.includeJSFontResizingCode = value;
                break;
            }
            default: {
                super.setBooleanValue(key, value);
            }
        }
    }

    @Override
    public void setTag(int type, String value) {
        switch (type) {
            case 0: {
                this.tag[0] = value;
                break;
            }
            default: {
                super.setTag(type, value);
            }
        }
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, AffineTransform at, String glyf, PdfFont currentFontData, float glyfWidth) {
        super.drawEmbeddedText(Trm, fontSize, embeddedGlyph, javaGlyph, type, gs, at, glyf, currentFontData, glyfWidth);
    }

    @Override
    public void drawShape(Shape currentShape, GraphicsState gs, int cmd) {
        super.drawShape(currentShape, gs, cmd);
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState gs, boolean alreadyCached, String name, int optionsApplied, int previousUse) {
        int flag = super.drawImage(pageNumber, image, gs, alreadyCached, name, optionsApplied, previousUse);
        if (flag == -2) {
            float opacity = gs.getAlpha(2);
            String opacityAsString = "";
            if (opacity < 1.0f) {
                opacityAsString = " opacity=\"" + opacity + "\"";
            }
            this.writeCustom(2, "\n\t<ImageView id=\"" + name + "\" layoutX=\"" + this.currentImage[0] + "\" layoutY=\"" + this.currentImage[1] + "\" fitWidth=\"" + this.currentImage[2] + "\" fitHeight=\"" + this.currentImage[3] + "\"" + opacityAsString + ">");
            this.writeCustom(2, "\t<image>");
            this.writeCustom(2, "\t\t<Image url=\"@" + this.imageName + "\"/>");
            this.writeCustom(2, "\t</image>");
            this.writeCustom(2, "</ImageView>");
        }
        return -1;
    }

    @Override
    public void setOutputDir(String outputDir, String outputFilename, String pageNumberAsString) {
        super.setOutputDir(outputDir, outputFilename, pageNumberAsString);
        if (this.pageNumber == 1 && this.firstPageName != null && this.firstPageName.length() > 0) {
            this.javaFxFileName = this.firstPageName;
            this.fileName = pageNumberAsString;
        } else {
            this.javaFxFileName = "page" + pageNumberAsString;
            this.fileName = pageNumberAsString;
        }
        this.packageName = outputFilename;
        if (this.packageName.contains(" ")) {
            this.packageName = this.packageName.replaceAll(" ", "_");
        }
    }

    @Override
    public void init(int width, int height, int rawRotation, Color backgroundColor) {
        block3: {
            super.init(width, height, rawRotation, backgroundColor);
            if (this.rootDir == null) {
                throw new RuntimeException("Please pass in output_dir (second param if running ExtractpageAsJavaFX");
            }
            try {
                this.customIO.setupOutput(this.rootDir + this.javaFxFileName + ".fxml", false, this.encodingType[0]);
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void writeCustom(int section, Object str) {
        switch (section) {
            case 0: {
                this.customIO.writeString(str.toString());
                break;
            }
            case 1: {
                this.topSection.append('\t');
                this.topSection.append(str.toString());
                this.topSection.append('\n');
                break;
            }
            case 2: {
                this.script.append('\t');
                this.script.append(str.toString());
                this.script.append('\n');
                break;
            }
            case 15: {
                this.fxmlText.add("\t" + str.toString());
                break;
            }
            case 3: {
                this.form.append(str.toString());
                break;
            }
            case 6: {
                this.testDivs.append(str.toString());
                break;
            }
            case 4: {
                this.css.append(str.toString());
                this.css.append('\n');
                break;
            }
            case 13: {
                this.fxmlPDFStage.append(str.toString());
                this.fxmlPDFStage.append('\n');
                break;
            }
            case 7: {
                try {
                    this.writeEveryGlyf = (Boolean)str;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                break;
            }
            case 8: {
                try {
                    this.encodingType = (String[])str;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                break;
            }
            case 9: {
                if (this.jsImagesAdded) break;
                this.writeCustom(1, str);
                this.jsImagesAdded = true;
                break;
            }
            case 10: {
                fontData = (Object[])str;
                pdfFont = (PdfFont)fontData[0];
                fontName = pdfFont.getFontName();
                fileType = (String)fontData[2];
                fontPath = this.rootDir + this.javaFxFileName + '/';
                cssDir = new File(fontPath);
                if (!cssDir.exists()) {
                    cssDir.mkdirs();
                }
                try {
                    fontOutput = new BufferedOutputStream(new FileOutputStream(fontPath + fontName + '.' + fileType));
                    fontOutput.write((byte[])fontData[1]);
                    fontOutput.flush();
                    fontOutput.close();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) ** GOTO lbl85
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
lbl85:
                // 3 sources

                fontTag = new StringBuffer();
                fontTag.append("@font-face {\n");
                fontTag.append("\tfont-family: ").append(fontName).append(";\n");
                fontTag.append("\tsrc: url(\"").append(this.javaFxFileName).append('/').append(fontName).append('.').append(fileType).append("\");\n");
                fontTag.append("}\n");
                this.writeCustom(4, fontTag);
                break;
            }
            default: {
                super.writeCustom(section, str);
            }
        }
    }

    @Override
    protected void drawPatternedShape(Shape currentShape, GraphicsState gs) {
        super.drawPatternedShape(currentShape, gs);
        if (this.currentPatternedShape[0] != -1) {
            this.writeCustom(2, "\n\t<ImageView layoutX=\"" + this.currentPatternedShape[0] + "\" layoutY=\"" + this.currentPatternedShape[1] + "\" fitWidth=\"" + this.currentPatternedShape[2] + "\" fitHeight=\"" + this.currentPatternedShape[3] + "\">");
            this.writeCustom(2, "\t<image>");
            this.writeCustom(2, "\t\t<Image url=\"@" + this.currentPatternedShapeName + "\"/>");
            this.writeCustom(2, "\t</image>");
            this.writeCustom(2, "</ImageView>");
        }
    }

    @Override
    protected void drawNonPatternedShape(Shape currentShape, GraphicsState gs, int cmd, String name, Rectangle2D cropBox, Point2D midPoint) {
        FXMLShape shape = new FXMLShape(cmd, this.shapeCount, this.scaling, currentShape, gs, new AffineTransform(), midPoint, cropBox.getBounds(), this.currentColor, this.dpCount, this.pageRotation, this.pageData, this.pageNumber, this.includeClip);
        shape.setShapeNumber(this.shapeCount);
        ++this.shapeCount;
        if (!shape.isEmpty()) {
            this.writeCustom(2, shape.getContent());
            this.currentColor = shape.getShapeColor();
        }
    }

    @Override
    protected void drawTextArea() {
        if (this.currentTextBlock.isEmpty()) {
            return;
        }
    }

    @Override
    protected void drawPageBorder() {
        double[] coords = new double[]{this.cropBox.getX(), this.cropBox.getY()};
        this.writeCustom(2, "pdf.moveTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[0] = coords[0] + this.cropBox.getWidth();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[1] = coords[1] + this.cropBox.getHeight();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[0] = coords[0] - this.cropBox.getWidth();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        this.writeCustom(2, "pdf.closePath();");
        this.writeCustom(2, "pdf.strokeStyle = '" + FXMLDisplay.rgbToColor(0) + "';");
        this.writeCustom(2, "pdf.lineWidth = '1'");
        this.writeCustom(2, "pdf.stroke();");
    }

    @Override
    protected FontMapper getFontMapper(PdfFont currentFontData) {
        return new GenericFontMapper(currentFontData.getFontName(), this.fontMode, currentFontData.isFontEmbedded);
    }
}

