/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output.javafx;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.regex.Pattern;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.GenericFontMapper;
import org.jpedal.render.output.OutputDisplay;
import org.jpedal.render.output.javafx.JavaFXHelper;
import org.jpedal.render.output.javafx.JavaFXShape;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class JavaFXDisplay
extends OutputDisplay {
    final boolean setFontInCSS = false;
    private int lastFontTextLength;
    private int fontTextLength;
    private int lastFontSizeAsString;
    private String textWithSpaces;
    private String lastTextWithSpaces;
    private int shapeCount = 0;
    private String divName;

    public JavaFXDisplay(int pageNumber, Point2D midPoint, Rectangle cropBox, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        super(pageNumber, midPoint, cropBox, addBackground, defaultSize, newObjectRef, null);
        this.type = 6;
        Helper = new JavaFXHelper();
        this.firstPageName = System.getProperty("org.jpedal.pdf2javafx.firstPageName");
        Pattern p = Pattern.compile("[^a-zA-Z]");
        if (this.firstPageName != null && (this.firstPageName.length() == 0 || p.matcher(this.firstPageName.substring(0, 1)).find())) {
            throw new RuntimeException("org.jpedal.pdf2javafx.firstPageName must begin with a character A-Z or a-z.");
        }
    }

    @Override
    protected void completeOutput() {
        this.flushText();
        boolean onePageFile = false;
        if (this.endPage == 1) {
            onePageFile = true;
        }
        int pageWidth = this.pageData.getCropBoxWidth(this.pageNumber);
        int pageHeight = this.pageData.getCropBoxHeight(this.pageNumber);
        this.writeCustom(0, "/**");
        this.writeCustom(0, "* ===========================================");
        this.writeCustom(0, "* Java Pdf Extraction Decoding Access Library");
        this.writeCustom(0, "* ===========================================");
        this.writeCustom(0, "*");
        this.writeCustom(0, "* Project Info:  http://www.idrsolutions.com");
        this.writeCustom(0, "*");
        this.writeCustom(0, "* generated by JPedal PDF to JavaFX 2.2");
        this.writeCustom(0, "*");
        this.writeCustom(0, "* --------------------------------------------");
        this.writeCustom(0, "* page" + this.pageNumberAsString + ".java");
        this.writeCustom(0, "* --------------------------------------------");
        this.writeCustom(0, "* --------------------------------------------");
        this.writeCustom(0, "* " + JavaFXDisplay.getDate());
        this.writeCustom(0, "* --------------------------------------------");
        this.writeCustom(0, "*/");
        this.writeCustom(0, "");
        this.writeCustom(0, "package " + this.packageName + ';');
        this.writeCustom(0, "");
        this.writeCustom(0, "");
        this.writeCustom(0, "import java.io.File;");
        this.writeCustom(0, "import javafx.application.Application;");
        this.writeCustom(0, "import javafx.scene.layout.Pane;");
        this.writeCustom(0, "import javafx.scene.Scene;");
        this.writeCustom(0, "import javafx.scene.Node;");
        this.writeCustom(0, "import javafx.scene.paint.Color;");
        this.writeCustom(0, "import javafx.scene.shape.*;");
        this.writeCustom(0, "import javafx.stage.Stage;");
        this.writeCustom(0, "import javafx.collections.ObservableList;");
        this.writeCustom(0, "import javafx.scene.text.*;");
        this.writeCustom(0, "import javafx.scene.layout.BorderPane;");
        this.writeCustom(0, "import javafx.scene.image.Image;");
        this.writeCustom(0, "import javafx.scene.image.ImageView;");
        this.writeCustom(0, "import javafx.scene.transform.Transform;");
        this.writeCustom(0, "import javafx.geometry.VPos;");
        this.writeCustom(0, "import javafx.animation.*;");
        this.writeCustom(0, "import javafx.util.Duration;");
        if (!onePageFile) {
            this.writeCustom(0, "import javafx.scene.input.MouseEvent;");
            this.writeCustom(0, "import javafx.scene.layout.HBox;");
            this.writeCustom(0, "import javafx.scene.effect.*;");
            this.writeCustom(0, "import javafx.geometry.Pos;");
            this.writeCustom(0, "import javafx.event.EventHandler;");
            this.writeCustom(0, "import javafx.event.ActionEvent;");
            this.writeCustom(0, "import javafx.scene.control.*;");
            this.writeCustom(0, "import java.lang.reflect.Method;");
            this.writeCustom(0, "import java.net.URI;");
            this.writeCustom(0, "import java.net.URISyntaxException;");
            this.writeCustom(0, "import java.util.logging.Level;");
            this.writeCustom(0, "import java.util.logging.Logger;");
            this.writeCustom(0, "import java.io.IOException;");
        }
        this.writeCustom(0, " ");
        this.writeCustom(0, " ");
        this.writeCustom(0, "public class " + this.javaFxFileName + " extends Application {");
        this.writeCustom(0, " ");
        this.writeCustom(0, "\tprivate BorderPane root;");
        this.writeCustom(0, "\tprivate Stage primaryStage;");
        this.writeCustom(0, "\tprivate Scene scene;");
        this.writeCustom(0, " ");
        this.writeCustom(0, " ");
        this.writeCustom(0, "\tpublic static void main(String[] args) {");
        this.writeCustom(0, "\t\tApplication.launch(args);");
        this.writeCustom(0, "\t}");
        this.writeCustom(0, " ");
        this.writeCustom(0, "\tpublic void start(Stage primaryStage) { ");
        this.writeCustom(0, "\t\tthis.primaryStage = primaryStage;");
        this.writeCustom(0, "\t\t");
        this.writeCustom(0, "\t\troot = new BorderPane();");
        this.writeCustom(0, "\t\tscene = new Scene(root, " + pageWidth + ", " + (pageHeight + 50) + ");");
        this.getClass();
        this.writeCustom(0, "\t\t//draw first page");
        this.writeCustom(0, "\t\tdrawPage(primaryStage, root, scene); //actual execution of commands");
        this.writeCustom(0, "");
        this.writeCustom(0, "\t}");
        this.writeCustom(0, "\n\tpublic static void drawPage(Stage primaryStage, BorderPane root, Scene scene) {");
        this.writeCustom(0, "\t\t");
        this.writeCustom(0, "\t\troot.getChildren().clear();");
        this.writeCustom(0, "\t\t");
        this.writeCustom(0, "\t\tObservableList<Node> addToGroup;");
        this.writeCustom(0, "\t\t");
        this.writeCustom(0, "\t\tPane pdfContent = new Pane();");
        this.writeCustom(0, "\t\troot.setCenter(pdfContent);");
        this.writeCustom(0, "\t\taddToGroup = pdfContent.getChildren();");
        this.writeCustom(0, "\t\tcreateTransition(pdfContent);");
        this.writeCustom(0, "\t\tdrawPage0(addToGroup);");
        if (!onePageFile) {
            this.writeCustom(0, "\t\tprimaryStage.setTitle(\"" + this.packageName + " page - " + this.pageNumber + "\");");
            this.writeCustom(0, "\t\taddNav(root, primaryStage, scene);");
        } else {
            this.writeCustom(0, "\t\tprimaryStage.setTitle(\"" + this.packageName + "\");");
            this.writeCustom(0, "\t\tprimaryStage.setScene(scene);");
            this.writeCustom(0, "\t\tprimaryStage.show();");
        }
        this.writeCustom(0, "\t}\n");
        int methodNum = 0;
        int lineNum = 0;
        while (true) {
            StringBuilder sb = new StringBuilder(50);
            boolean now = false;
            for (int ii = 0; ii < 50 && !now && this.fxScript.size() > lineNum; ++lineNum, ++ii) {
                String line = (String)this.fxScript.get(lineNum);
                if (line.trim().equals("**CHOP**")) {
                    now = true;
                    continue;
                }
                now = false;
                sb.append((String)this.fxScript.get(lineNum));
            }
            this.writeCustom(0, "\tprivate static void drawPage" + methodNum + "(ObservableList<Node> addToGroup) {");
            this.writeCustom(0, sb.toString());
            if (this.fxScript.size() <= lineNum) break;
            this.writeCustom(0, "\t\tdrawPage" + ++methodNum + "(addToGroup);\n\t}\n");
        }
        this.writeCustom(0, "\t}");
        this.writeCustom(0, "\tprivate static void setTextsize(Text textBox, float requiredWidth) {");
        this.writeCustom(0, "\t\tfloat actualWidth=(int) textBox.getLayoutBounds().getWidth();");
        this.writeCustom(0, "\t\tfloat dx=requiredWidth-actualWidth;");
        this.writeCustom(0, "\t\tfloat scalingNeeded=requiredWidth/actualWidth;");
        this.writeCustom(0, "\t\ttextBox.setScaleX(scalingNeeded);");
        this.writeCustom(0, "\t\ttextBox.setScaleY(scalingNeeded);");
        this.writeCustom(0, "\t\ttextBox.setTranslateX(dx/2);");
        this.writeCustom(0, "\t}\n");
        this.writeCustom(0, "\tprivate static void createTransition(Node i){");
        this.writeCustom(0, "\t\tFadeTransition fadeOutTransition = new FadeTransition(Duration.seconds(2), i);");
        this.writeCustom(0, "\t\tfadeOutTransition.setFromValue(0.0);");
        this.writeCustom(0, "\t\tfadeOutTransition.setToValue(3.0);");
        this.writeCustom(0, "\t\tfadeOutTransition.play();");
        this.writeCustom(0, "\t}\n");
        if (!onePageFile) {
            String pageName = "page" + this.pageNumberAsString;
            if (this.firstPageName != null && this.firstPageName.length() > 0 && this.pageNumber == 1) {
                pageName = this.firstPageName;
            }
            this.writeCustom(0, "\tprivate static void addNav(BorderPane root, Stage primaryStage, Scene scene) {");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\t//----- naviBar -----");
            this.writeCustom(0, "\t\tHBox naviBar = new HBox();");
            this.writeCustom(0, "\t\tnaviBar.setStyle(\"-fx-background-color: #F0F8FF; -fx-text-fill: white;\");");
            this.writeCustom(0, "\t\tButton start = makeButtons(\"smstart.gif\",\"Go to first Page\",0, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tButton back = makeButtons(\"smback.gif\",\"Go back 1 page\",-1, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tButton fback = makeButtons(\"smfback.gif\",\"Go back 10 pages\",-10, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tString currentPageAsString = String.valueOf(" + this.pageNumber + ");");
            this.writeCustom(0, "\t\tTextField currentPage = makeTextField(false, currentPageAsString);");
            this.writeCustom(0, "\t\tLabel colon = makeLabel(\":\");");
            this.writeCustom(0, "\t\tString numberOfPagesAsString = String.valueOf(" + this.endPage + ");");
            this.writeCustom(0, "\t\tTextField numberOfPages = makeTextField(false, numberOfPagesAsString);");
            this.writeCustom(0, "\t\tButton forward = makeButtons(\"smforward.gif\",\"Go forward 1 page\",1, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tButton fforward = makeButtons(\"smfforward.gif\",\"Go forward 10 pages\",10, root, primaryStage, scene);");
            this.writeCustom(0, "\t\tButton end = makeButtons(\"smend.gif\",\"Go to last page\",9999, root, primaryStage, scene);");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\t//Logo with hyperlink to website");
            this.writeCustom(0, "\t\tImage logo= new Image(" + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".class.getResourceAsStream(\"" + '/' + this.packageName + "/icons/logo.gif\"));");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\tHyperlink hyperLinkLogo = new Hyperlink(\"\",new ImageView(logo));");
            this.writeCustom(0, "\t\thyperLinkLogo.tooltipProperty().set(new Tooltip(\"Visit our website\"));");
            this.writeCustom(0, "\t\thyperLinkLogo.setOnAction(new EventHandler<ActionEvent>() {");
            this.writeCustom(0, "\t\t\tpublic void handle(ActionEvent event) {");
            this.writeCustom(0, "\t\t\t\ttry {");
            this.writeCustom(0, "\t\t\t\t\tjava.awt.Desktop.getDesktop().browse(new URI(\"http://www.idrsolutions.com\"));");
            this.writeCustom(0, "\t\t\t\t} catch (Exception ex) {");
            this.writeCustom(0, "\t\t\t\t\tLogger.getLogger(" + pageName + ".class.getName()).log(Level.SEVERE, null, ex);");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t}");
            this.writeCustom(0, "\t\t});");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\tnaviBar.getChildren().addAll(start, fback, back, currentPage, colon, numberOfPages, forward, fforward, end, hyperLinkLogo);");
            this.writeCustom(0, "\t\tnaviBar.setSpacing(5);");
            this.writeCustom(0, "\t\tnaviBar.setPrefWidth(" + this.pageData.getCropBoxWidth(this.pageNumber) + ");");
            this.writeCustom(0, "\t\tnaviBar.setPrefHeight(50);");
            this.writeCustom(0, "\t\tnaviBar.setAlignment(Pos.CENTER);");
            this.writeCustom(0, "\t\troot.setBottom(naviBar);");
            this.writeCustom(0, "\t\tprimaryStage.setScene(scene); ");
            this.writeCustom(0, "\t\tprimaryStage.show(); ");
            this.writeCustom(0, "\t} ");
            this.writeCustom(0, "\n\tprivate static Label makeLabel(String text) {");
            this.writeCustom(0, "\t\tLabel label = new Label();");
            this.writeCustom(0, "\t\tlabel.setText(text);");
            this.writeCustom(0, "\t\treturn label;");
            this.writeCustom(0, "\t}");
            this.writeCustom(0, "\n\tprivate static TextField makeTextField(boolean check, String text) {");
            this.writeCustom(0, "\t\tTextField textfield = new TextField();");
            this.writeCustom(0, "\t\ttextfield.setEditable(check);");
            this.writeCustom(0, "\t\ttextfield.setAlignment(Pos.CENTER);");
            this.writeCustom(0, "\t\ttextfield.setText(text);");
            this.writeCustom(0, "\t\ttextfield.setPrefHeight(25);");
            this.writeCustom(0, "\t\ttextfield.setPrefWidth(50);");
            this.writeCustom(0, "\t\ttextfield.setPromptText(text);");
            this.writeCustom(0, "\t\treturn textfield;");
            this.writeCustom(0, "\t}");
            this.writeCustom(0, "\n\tprivate static Button makeButtons(String iconName, String toolTip, final int change, final BorderPane root, final Stage primaryStage, final Scene scene) {");
            this.writeCustom(0, "\t\tfinal int currentPageNo = " + this.pageNumber + ",pageCount = " + this.endPage + ';');
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\tButton button = new Button();");
            this.writeCustom(0, "\t\tbutton.setTooltip(new Tooltip(toolTip));");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\tImage image= new Image(" + (this.firstPageName != null && this.pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".class.getResourceAsStream(\"" + '/' + this.packageName + "/icons/\"+iconName));");
            this.writeCustom(0, "\t\tif (image != null) ");
            this.writeCustom(0, "\t\t\tbutton.setGraphic(new ImageView(image));");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\tcreatePressedLook(button);");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t//event handler");
            this.writeCustom(0, "\t\tbutton.setOnAction(new EventHandler<ActionEvent>() {");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t\tpublic void handle(ActionEvent event) {");
            this.writeCustom(0, "\t\t\t\tint newPageNo = 0;");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\tif (change == 0){ //special case 1st page");
            this.writeCustom(0, "\t\t\t\t\tnewPageNo = 1;");
            this.writeCustom(0, "\t\t\t\t} else if (change == 9999) {");
            this.writeCustom(0, "\t\t\t\t\tnewPageNo = pageCount;");
            this.writeCustom(0, "\t\t\t\t} else {");
            this.writeCustom(0, "\t\t\t\t\tnewPageNo = currentPageNo + change;");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\t//error check for bounds");
            this.writeCustom(0, "\t\t\t\tif (newPageNo < 1) {");
            this.writeCustom(0, "\t\t\t\t\tnewPageNo = 1;");
            this.writeCustom(0, "\t\t\t\t}else if (newPageNo > pageCount) {");
            this.writeCustom(0, "\t\t\t\t\tnewPageNo = pageCount;");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t\t");
            if (this.firstPageName != null && this.firstPageName.length() > 0) {
                this.writeCustom(0, "\t\t\t\tString customClassName = \"" + this.packageName + '.' + this.firstPageName + "\";");
                this.writeCustom(0, "\t\t\t\tboolean customFirstPage = false;");
            }
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\tString newPageNoAsString = String.valueOf(newPageNo);");
            if (this.firstPageName != null && this.firstPageName.length() > 0) {
                this.writeCustom(0, "\t\t\t\t");
                this.writeCustom(0, "\t\t\t\tif(newPageNoAsString.equals(\"1\"))");
                this.writeCustom(0, "\t\t\t\t\tcustomFirstPage=true;");
                this.writeCustom(0, "\t\t\t\t");
            }
            this.writeCustom(0, "\t\t\t\tString maxNumberOfPages = String.valueOf(pageCount);");
            this.writeCustom(0, "\t\t\t\tint padding = maxNumberOfPages.length() - newPageNoAsString.length();");
            this.writeCustom(0, "\t\t\t\tfor (int ii = 0; ii < padding; ii++) {");
            this.writeCustom(0, "\t\t\t\t\tnewPageNoAsString = '0' + newPageNoAsString;");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t\t");
            if (this.firstPageName != null && this.firstPageName.length() > 0) {
                this.writeCustom(0, "\t\t\t\t//workout new class from pageNumber");
                this.writeCustom(0, "\t\t\t\tString newClass=\"\";");
                this.writeCustom(0, "\t\t\t\t");
                this.writeCustom(0, "\t\t\t\tif(customFirstPage)");
                this.writeCustom(0, "\t\t\t\t\tnewClass=customClassName;");
                this.writeCustom(0, "\t\t\t\telse");
                this.writeCustom(0, "\t\t\t\t\tnewClass=\"" + this.packageName + ".page\"+newPageNoAsString;");
            } else {
                this.writeCustom(0, "\t\t\t\t//workout new class from pageNumber");
                this.writeCustom(0, "\t\t\t\tString newClass=\"" + this.packageName + ".page\"+newPageNoAsString;");
            }
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\t\t\t//create an instance");
            this.writeCustom(0, "\t\t\t\ttry {");
            this.writeCustom(0, "\t\t\t\t\tClass c = Class.forName(newClass);");
            this.writeCustom(0, "\t\t\t\t\tApplication nextPage=(javafx.application.Application)c.newInstance();");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\t\t\t\tMethod m = c.getMethod(\"drawPage\", new Class[]{Stage.class, BorderPane.class, Scene.class});");
            this.writeCustom(0, "\t\t\t\t\tm.invoke(nextPage, new Object[]{primaryStage, root, scene});");
            this.writeCustom(0, "");
            this.writeCustom(0, "\t\t\t\t} catch (Exception e) {");
            this.writeCustom(0, "\t\t\t\t\te.printStackTrace();");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t}");
            this.writeCustom(0, "\t\t});");
            this.writeCustom(0, "\t\t\t\t");
            this.writeCustom(0, "\t\treturn button;");
            this.writeCustom(0, "\t}");
            this.writeCustom(0, "\n\tprivate static void createPressedLook(final Button button) {");
            this.writeCustom(0, "\t\tfinal DropShadow shadow = new DropShadow();");
            this.writeCustom(0, "\t\tshadow.setColor(Color.rgb(41, 36, 33));");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t//Adding the shadow when the button is clicked");
            this.writeCustom(0, "\t\tbutton.addEventHandler(MouseEvent.MOUSE_PRESSED,");
            this.writeCustom(0, "\t\t\tnew EventHandler<MouseEvent>() {");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t\t\t@Override");
            this.writeCustom(0, "\t\t\t\tpublic void handle(MouseEvent e) {");
            this.writeCustom(0, "\t\t\t\t\tbutton.setEffect(shadow);");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t});");
            this.writeCustom(0, "\t\t//Removing the shadow when the button is released");
            this.writeCustom(0, "\t\tbutton.addEventHandler(MouseEvent.MOUSE_RELEASED,");
            this.writeCustom(0, "\t\t\tnew EventHandler<MouseEvent>() {");
            this.writeCustom(0, "\t\t");
            this.writeCustom(0, "\t\t\t\t@Override");
            this.writeCustom(0, "\t\t\t\tpublic void handle(MouseEvent e) {");
            this.writeCustom(0, "\t\t\t\t\tbutton.setEffect(null);");
            this.writeCustom(0, "\t\t\t\t}");
            this.writeCustom(0, "\t\t\t});");
            this.writeCustom(0, "\t}");
        }
        this.writeCustom(0, "}");
        this.writeCustom(0, "");
        if (this.css.length() > 0) {
            this.customIO.writeCSS(this.rootDir, this.fileName, this.css);
        }
        this.customIO.flush();
    }

    @Override
    protected void writeTextPosition(float[] aff, int tx, int ty, float fontScaling) {
        if (aff[0] > 0.0f && aff[3] > 0.0f && aff[1] == 0.0f && aff[2] == 0.0f) {
            this.writeCustom(2, '\t' + this.divName + ".setX(" + tx + ");");
            this.writeCustom(2, '\t' + this.divName + ".setY(" + ty + ");");
        } else {
            this.writeCustom(2, '\t' + this.divName + ".getTransforms().add(Transform.affine(" + JavaFXDisplay.setPrecision(aff[0] / fontScaling, 2) + ',' + JavaFXDisplay.setPrecision(aff[1] / fontScaling, 2) + ',' + JavaFXDisplay.setPrecision(aff[2] / fontScaling, 2) + ',' + JavaFXDisplay.setPrecision(aff[3] / fontScaling, 2) + ',' + tx + ", " + ty + "));");
        }
    }

    @Override
    protected void writeoutTextAsDiv(float fontScaling) {
        if (this.currentTextBlock.isEmpty()) {
            throw new RuntimeException("writeoutTextAsDiv() called incorrectly.  Attempted to write out text with empty text block use flushText.");
        }
        this.divName = "textBox_" + this.textID + '_' + this.pageNumber;
        String text = this.currentTextBlock.getOutputString(true);
        int adjustedFontSize = this.currentTextBlock.getFontSize() + this.currentTextBlock.getFontAdjustment();
        int altFontSize = this.currentTextBlock.getAltFontSize();
        int fontCondition = this.currentTextBlock.getFontCondition();
        if (altFontSize > 0) {
            switch (fontCondition) {
                case 1: {
                    if (text.length() <= 32) break;
                    adjustedFontSize = altFontSize;
                    break;
                }
                case 2: {
                    adjustedFontSize = altFontSize;
                }
            }
        }
        int fontSizeAsString = (int)((float)adjustedFontSize * this.scaling);
        if (adjustedFontSize < 1) {
            return;
        }
        this.textWithSpaces = this.currentTextBlock.getOutputString(false);
        this.fontTextLength = this.textWithSpaces.length();
        this.writeCustom(2, "\n\t\tText " + this.divName + " = new Text(\"" + JavaFXDisplay.tidyQuotes(text) + "\");");
        this.writePosition("", false, fontScaling);
        this.writeCustom(2, "\taddToGroup.add(" + this.divName + ");");
        this.getClass();
        String weight = this.currentTextBlock.getWeight();
        String javaFxWeight = JavaFXDisplay.setJavaFxWeight(weight);
        String style = this.currentTextBlock.getStyle();
        if (style.equals("normal")) {
            this.writeCustom(2, '\t' + this.divName + ".setFont(Font.font(\"" + this.currentTextBlock.getFont() + "\", FontWeight." + javaFxWeight + ", FontPosture.REGULAR," + fontSizeAsString + "));");
        } else {
            this.writeCustom(2, '\t' + this.divName + ".setFont(Font.font(\"" + this.currentTextBlock.getFont() + "\", FontWeight." + javaFxWeight + ", FontPosture.ITALIC," + fontSizeAsString + "));");
        }
        this.getClass();
        if (this.currentTextBlock.getColor() != -14475232) {
            this.writeCustom(2, '\t' + this.divName + ".setFill(Color." + JavaFXDisplay.rgbToColor(this.currentTextBlock.getColor()) + ");");
        }
        ++this.textID;
        this.writeCustom(2, "**CHOP**");
    }

    private static String tidyQuotes(String outputString) {
        String newString = "";
        for (int i = 0; i < outputString.length(); ++i) {
            char ch = outputString.charAt(i);
            if (i + 1 < outputString.length()) {
                char nextCh = outputString.charAt(i + 1);
                if (ch == '\\' && nextCh != '\\') {
                    newString = newString + '\\';
                } else if (ch == '\\' && nextCh == '\\') {
                    newString = newString + '\\';
                }
            } else if (ch == '\\') {
                newString = newString + '\\';
            }
            newString = ch == '\r' ? newString + "\\r" : (ch == '\n' ? newString + "\\n" : (ch == '\"' ? newString + "\\\"" : newString + ch));
        }
        return newString;
    }

    @Override
    public void setBooleanValue(int key, boolean value) {
        switch (key) {
            case 4: {
                this.includeJSFontResizingCode = value;
                break;
            }
            default: {
                super.setBooleanValue(key, value);
            }
        }
    }

    @Override
    public void setTag(int type, String value) {
        switch (type) {
            case 0: {
                this.tag[0] = value;
                break;
            }
            default: {
                super.setTag(type, value);
            }
        }
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, AffineTransform at, String glyf, PdfFont currentFontData, float glyfWidth) {
        super.drawEmbeddedText(Trm, fontSize, embeddedGlyph, javaGlyph, type, gs, at, glyf, currentFontData, glyfWidth);
    }

    @Override
    public void drawShape(Shape currentShape, GraphicsState gs, int cmd) {
        super.drawShape(currentShape, gs, cmd);
        this.writeCustom(2, "**CHOP**");
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState gs, boolean alreadyCached, String name, int optionsApplied, int previousUse) {
        int flag = super.drawImage(pageNumber, image, gs, alreadyCached, name, optionsApplied, previousUse);
        name = StringUtils.makeMethodSafe(name.toLowerCase());
        if (flag == -2) {
            float opacity = gs.getAlpha(2);
            String imName = name + "View";
            this.writeCustom(2, "\n");
            this.writeCustom(2, "\tImage " + name + " = new Image(" + (this.firstPageName != null && pageNumber == 1 ? this.firstPageName : "page" + this.pageNumberAsString) + ".class.getResourceAsStream(\"" + '/' + this.packageName + '/' + this.imageName + "\"));");
            this.writeCustom(2, "\tImageView " + imName + " = new ImageView(" + name + ");");
            this.writeCustom(2, '\t' + imName + ".setImage(" + name + ");");
            this.writeCustom(2, '\t' + imName + ".setFitWidth(" + this.currentImage[2] + ");");
            this.writeCustom(2, '\t' + imName + ".setFitHeight(" + this.currentImage[3] + ");");
            this.writeCustom(2, '\t' + imName + ".setX(" + this.currentImage[0] + ");");
            this.writeCustom(2, '\t' + imName + ".setY(" + this.currentImage[1] + ");");
            if (opacity < 1.0f) {
                this.writeCustom(2, '\t' + imName + ".setOpacity(" + opacity + ");");
            }
            this.writeCustom(2, "\taddToGroup.add(" + imName + ");");
            this.writeCustom(2, "**CHOP**");
        }
        return -1;
    }

    @Override
    public void setOutputDir(String outputDir, String outputFilename, String pageNumberAsString) {
        super.setOutputDir(outputDir, outputFilename, pageNumberAsString);
        if (this.pageNumber == 1 && this.firstPageName != null && this.firstPageName.length() > 0) {
            this.javaFxFileName = this.firstPageName;
            this.fileName = pageNumberAsString;
        } else {
            this.javaFxFileName = "page" + pageNumberAsString;
            this.fileName = pageNumberAsString;
        }
        this.packageName = outputFilename;
        if (this.packageName.contains(" ")) {
            this.packageName = this.packageName.replaceAll(" ", "_");
        }
    }

    @Override
    public void init(int width, int height, int rawRotation, Color backgroundColor) {
        block3: {
            super.init(width, height, rawRotation, backgroundColor);
            if (this.rootDir == null) {
                throw new RuntimeException("Please pass in output_dir (second param if running ExtractpageAsJavaFX");
            }
            try {
                this.customIO.setupOutput(this.rootDir + this.javaFxFileName + ".java", false, this.encodingType[0]);
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public synchronized void writeCustom(int section, Object str) {
        switch (section) {
            case 0: {
                this.customIO.writeString(str.toString());
                break;
            }
            case 1: {
                this.topSection.append('\t');
                this.topSection.append(str.toString());
                this.topSection.append('\n');
                break;
            }
            case 2: {
                this.fxScript.add("\t" + str.toString() + "\n");
                break;
            }
            case 3: {
                this.form.append(str.toString());
                break;
            }
            case 6: {
                this.testDivs.append(str.toString());
                break;
            }
            case 4: {
                this.css.append(str.toString());
                this.css.append('\n');
                break;
            }
            case 7: {
                try {
                    this.writeEveryGlyf = (Boolean)str;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                break;
            }
            case 8: {
                try {
                    this.encodingType = (String[])str;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                break;
            }
            case 9: {
                if (this.jsImagesAdded) break;
                this.writeCustom(1, str);
                this.jsImagesAdded = true;
                break;
            }
            default: {
                super.writeCustom(section, str);
            }
        }
    }

    @Override
    protected void drawPatternedShape(Shape currentShape, GraphicsState gs) {
        super.drawPatternedShape(currentShape, gs);
        if (this.currentPatternedShape[0] != -1) {
            this.writeCustom(2, "\n");
            this.writeCustom(2, "\tImage " + this.shadeId + " = new Image(page" + this.pageNumberAsString + ".class.getResourceAsStream(\"" + '/' + this.packageName + '/' + this.currentPatternedShapeName + "\"));");
            this.writeCustom(2, "\tImageView " + this.shadeId + "ImageView = new ImageView(" + this.shadeId + ");");
            this.writeCustom(2, 9 + this.shadeId + "ImageView.setImage(" + this.shadeId + ");");
            this.writeCustom(2, 9 + this.shadeId + "ImageView.setFitWidth(" + this.currentPatternedShape[2] + ");");
            this.writeCustom(2, 9 + this.shadeId + "ImageView.setFitHeight(" + this.currentPatternedShape[3] + ");");
            this.writeCustom(2, 9 + this.shadeId + "ImageView.setX(" + this.currentPatternedShape[0] + ");");
            this.writeCustom(2, 9 + this.shadeId + "ImageView.setY(" + this.currentPatternedShape[1] + ");");
            this.writeCustom(2, "\taddToGroup.add(" + this.shadeId + "ImageView);");
            this.writeCustom(2, "**CHOP**");
        }
    }

    @Override
    protected void drawNonPatternedShape(Shape currentShape, GraphicsState gs, int cmd, String name, Rectangle2D cropBox, Point2D midPoint) {
        JavaFXShape shape = new JavaFXShape(cmd, this.shapeCount, this.scaling, currentShape, gs, new AffineTransform(), midPoint, cropBox.getBounds(), this.currentColor, this.dpCount, this.pageRotation, this.pageData, this.pageNumber, this.includeClip);
        shape.setShapeNumber(this.shapeCount);
        ++this.shapeCount;
        if (!shape.isEmpty()) {
            this.writeCustom(2, shape.getContent());
            this.writeCustom(2, "**CHOP**");
            this.currentColor = shape.getShapeColor();
        }
    }

    @Override
    protected void drawTextArea() {
        if (this.currentTextBlock.isEmpty()) {
            return;
        }
        int yAdjust = this.currentTextBlock.getFontSize();
        double[] coords = new double[]{this.currentTextBlock.getX(), (int)this.currentTextBlock.getY() + yAdjust};
        this.writeCustom(2, "pdf.moveTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[0] = this.currentTextBlock.getX() + this.currentTextBlock.getWidth();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[1] = this.currentTextBlock.getY() - (float)this.currentTextBlock.getFontSize() + (float)yAdjust;
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[0] = this.currentTextBlock.getX();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        this.writeCustom(2, "pdf.closePath();");
        this.writeCustom(2, "pdf.strokeStyle = '" + JavaFXDisplay.rgbToColor(200) + "';");
        this.writeCustom(2, "pdf.lineWidth = '1'");
        this.writeCustom(2, "pdf.stroke();");
        this.writeCustom(2, "**CHOP**");
    }

    @Override
    protected void drawPageBorder() {
        double[] coords = new double[]{this.cropBox.getX(), this.cropBox.getY()};
        this.writeCustom(2, "pdf.moveTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[0] = coords[0] + this.cropBox.getWidth();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[1] = coords[1] + this.cropBox.getHeight();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        coords[0] = coords[0] - this.cropBox.getWidth();
        this.writeCustom(2, "pdf.lineTo(" + this.coordsToStringParam(coords, 2) + ");");
        this.writeCustom(2, "pdf.closePath();");
        this.writeCustom(2, "pdf.strokeStyle = '" + JavaFXDisplay.rgbToColor(0) + "';");
        this.writeCustom(2, "pdf.lineWidth = '1'");
        this.writeCustom(2, "pdf.stroke();");
        this.writeCustom(2, "**CHOP**");
    }

    @Override
    protected FontMapper getFontMapper(PdfFont currentFontData) {
        return new GenericFontMapper(currentFontData.getFontName(), this.fontMode, currentFontData.isFontEmbedded);
    }
}

